/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.formplugin.extdata;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.v2.fah.constant.FAHCommonConstant;
import kd.fi.v2.fah.dao.datamodel.DataModelDaoImpl;
import kd.fi.v2.fah.utils.LicenseUtil;
import kd.fi.v2.fah.utils.StringUtils;

public class FahExtDataModelRelationList
extends AbstractListPlugin {
    private static final String PAGEID = "pageid";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        LicenseUtil.checkFahLicenseWithTips((IFormView)this.getView());
    }

    private Map<Object, String> getPageId() {
        Map<Object, String> pageIdMap;
        if (!StringUtils.isEmpty((String)this.getPageCache().get(PAGEID))) {
            pageIdMap = (Map)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get(PAGEID));
        } else {
            pageIdMap = new HashMap<Object, String>();
            this.cachePageId(pageIdMap);
        }
        return pageIdMap;
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        if (null != args.getFieldName() && args.getFieldName().contains("datamodel.number")) {
            QFilter qf = new QFilter("appversion", "=", (Object)"1").and("latestversion", "=", (Object)"1").and("status", "=", (Object)"C");
            args.addCustomQFilter(qf);
        }
    }

    private void cachePageId(Map<Object, String> pageIdMap) {
        this.getPageCache().put(PAGEID, SerializationUtils.serializeToBase64(pageIdMap));
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        Long dataModelId;
        super.billListHyperLinkClick(args);
        HyperLinkClickEvent hyperClick = args.getHyperLinkClickEvent();
        args.setCancel(true);
        Long dataModelMasterId = 0L;
        BillList list = (BillList)hyperClick.getSource();
        Object focusRowPkId = list.getFocusRowPkId();
        DataSet row = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)FAHCommonConstant.AI, (SqlBuilder)new SqlBuilder().append("select fid,fpreeventclass from t_ai_preevent where fentryid = ?", new Object[]{focusRowPkId}));
        if ("datamodel_number".equals(hyperClick.getFieldName())) {
            dataModelMasterId = row.next().getLong("fid");
        } else if ("predatamodel_number".equals(hyperClick.getFieldName())) {
            dataModelMasterId = row.next().getLong("fpreeventclass");
        }
        DynamicObjectCollection dataModels = QueryServiceHelper.query((String)"fah_ext_datamodel", (String)"id", (QFilter[])new QFilter[]{new QFilter("masterid", "=", (Object)dataModelMasterId)}, (String)"status desc,versionnum desc", (int)1);
        if (dataModels == null || dataModels.isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6a21\u578b\u4e0d\u5b58\u5728\u3002", (String)"FahExtDataModelRelationList_0", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return;
        }
        BillShowParameter showParameter = new BillShowParameter();
        Map<Object, String> pageIdMap = this.getPageId();
        String pageId = pageIdMap.get(dataModelId = Long.valueOf(((DynamicObject)dataModels.get(0)).getLong("id")));
        if (!StringUtils.isEmpty((String)pageId) && this.getView().getViewNoPlugin(pageId) != null) {
            showParameter.setPageId(pageId);
        }
        showParameter.setFormId("fah_ext_datamodel");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("id", (Object)dataModelId);
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.setHasRight(true);
        this.getView().showForm((FormShowParameter)showParameter);
        pageIdMap.put(dataModelId, showParameter.getPageId());
        this.cachePageId(pageIdMap);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String key = operate.getOperateKey();
        if ("delete".equals(key)) {
            DynamicObject[] relations;
            Object[] ids = this.getSelectedRows().getPrimaryKeyValues();
            for (DynamicObject relation : relations = BusinessDataServiceHelper.load((String)"fah_ext_datamodel_rat", (String)"datamodel,predatamodel,predatafield,prestatus", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids)})) {
                DataModelDaoImpl.deleteEventBlock((Long)relation.getLong("predatamodel.masterid"), (Long)relation.getLong("datamodel.masterid"), (String)relation.getString("prestatus"));
            }
        } else if ("modify".equals(key) && this.getSelectedRows().size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u8fdb\u884c\u4fee\u6539\u3002", (String)"FahExtDataModelRelationList_1", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilters = e.getQFilters();
        for (QFilter qFilter : qFilters) {
            List nests = qFilter.getNests(true);
            for (QFilter.QFilterNest next : nests) {
                QFilter filter1 = next.getFilter();
                if ("datamodel.id".equals(filter1.getProperty())) {
                    filter1.__setProperty("datamodel.number");
                    filter1.__setCP(this.transCP(filter1.getCP()));
                    filter1.__setValue(this.transValue(filter1.getValue()));
                    continue;
                }
                if (!"predatamodel.id".equals(filter1.getProperty())) continue;
                filter1.__setProperty("predatamodel.number");
                filter1.__setCP(this.transCP(filter1.getCP()));
                filter1.__setValue(this.transValue(filter1.getValue()));
            }
            if ("datamodel.id".equals(qFilter.getProperty())) {
                qFilter.__setProperty("datamodel.number");
                qFilter.__setCP(this.transCP(qFilter.getCP()));
                qFilter.__setValue(this.transValue(qFilter.getValue()));
                continue;
            }
            if (!"predatamodel.id".equals(qFilter.getProperty())) continue;
            qFilter.__setProperty("predatamodel.number");
            qFilter.__setCP(this.transCP(qFilter.getCP()));
            qFilter.__setValue(this.transValue(qFilter.getValue()));
        }
        e.getQFilters().add(new QFilter("datamodel.appversion", "=", (Object)"1"));
    }

    private String transCP(String cp) {
        String newCp;
        switch (cp) {
            case "=": {
                newCp = "in";
                break;
            }
            case "!=": 
            case "<>": {
                newCp = "not in";
                break;
            }
            default: {
                newCp = cp;
            }
        }
        return newCp;
    }

    private Object transValue(Object value) {
        if (value instanceof Long) {
            return DataModelDaoImpl.queryDataModelNumberCommon(Collections.singletonList(value));
        }
        if (value instanceof Collection) {
            return DataModelDaoImpl.queryDataModelNumberCommon((Collection)((Collection)value));
        }
        if (value.getClass().isArray()) {
            return DataModelDaoImpl.queryDataModelNumberCommon(Arrays.asList((Long[])value));
        }
        return value;
    }
}

