/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.formplugin.mapping;

import java.util.EventObject;
import java.util.LinkedList;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.v2.fah.constant.enums.DataValueTypeEnum;
import kd.fi.v2.fah.utils.FahMappingUtils;
import kd.fi.v2.fah.utils.LicenseUtil;
import kd.fi.v2.fah.utils.StringUtils;

public class FahFlexStrucTypeEdit
extends AbstractFormPlugin {
    private boolean isQuote() {
        if (!this.isEdit()) {
            return false;
        }
        return QueryServiceHelper.exists((String)"fah_valueset_type", (QFilter[])new QFilter[]{new QFilter("struc", "=", this.getModel().getValue("id"))});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("save".equals(key)) {
            LicenseUtil.checkFahLicenseWithTips((IFormView)this.getView());
            String number = (String)this.getModel().getValue("number");
            if (FahMappingUtils.isNumberRepeat((String)"fah_flex_struc_type", (String)number, (Object)this.getModel().getValue("id"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"FahFlexStrucTypeEdit_0", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        } else if ("deleteentry".equals(key) && this.isEdit() && this.isQuote()) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
            int[] selectRows = entryGrid.getSelectRows();
            if (!StringUtils.isEmpty((String)this.getPageCache().get("seqList"))) {
                LinkedList seqList = (LinkedList)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("seqList"));
                LinkedList<String> messageSeq = new LinkedList<String>();
                LinkedList<Integer> needDeleteRows = new LinkedList<Integer>();
                int[] nArray = selectRows;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    Integer seq = nArray[i];
                    if (seqList.contains(seq)) {
                        messageSeq.add(String.valueOf(seq + 1));
                        continue;
                    }
                    needDeleteRows.add(seq);
                }
                if (!messageSeq.isEmpty()) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\u5df2\u4fdd\u5b58\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"FahFlexStrucTypeEdit_1", (String)"fi-ai-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", messageSeq)));
                    int[] rows = new int[needDeleteRows.size()];
                    for (int i = 0; i < needDeleteRows.size(); ++i) {
                        rows[i] = (Integer)needDeleteRows.get(i);
                    }
                    this.getModel().deleteEntryRows("entryentity", rows);
                    args.setCancel(true);
                }
            }
        }
    }

    private boolean isEdit() {
        return OperationStatus.EDIT.equals((Object)this.getView().getFormShowParameter().getStatus());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.isEdit()) {
            DynamicObjectCollection entrys = this.getModel().getEntryEntity("entryentity");
            int rowIndex = 0;
            LinkedList<Integer> seqList = new LinkedList<Integer>();
            for (DynamicObject entry : entrys) {
                DynamicObject temp;
                String fieldType = entry.getString("attdatatype");
                if (DataValueTypeEnum.getEnum((String)fieldType) == DataValueTypeEnum.FahValueSet && (temp = QueryServiceHelper.queryOne((String)"fah_valueset_type", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)entry.getLong("reftypeid"))})) != null) {
                    this.getModel().setValue("refentityname", (Object)temp.getString("name"), rowIndex);
                }
                if (this.isQuote()) {
                    this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"attdatatype"});
                    this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"refentityname"});
                }
                seqList.add(rowIndex);
                ++rowIndex;
            }
            this.getPageCache().put("seqList", SerializationUtils.serializeToBase64(seqList));
        }
        this.getModel().setDataChanged(false);
    }

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"refentityname"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        String key = ctlSource.getKey();
        if ("refentityname".equals(key)) {
            FormShowParameter dynamicValueImput = new FormShowParameter();
            dynamicValueImput.setFormId("fah_flex_struc_imput");
            dynamicValueImput.getOpenStyle().setShowType(ShowType.Modal);
            dynamicValueImput.setStatus(OperationStatus.EDIT);
            dynamicValueImput.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "fah_flex_struc_imput"));
            dynamicValueImput.setCustomParam("fieldtype", this.getModel().getValue("attdatatype"));
            this.getView().showForm(dynamicValueImput);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String returnData;
        super.closedCallBack(evt);
        if ("fah_flex_struc_imput".equals(evt.getActionId()) && (returnData = (String)evt.getReturnData()) != null && !returnData.isEmpty()) {
            Map valueMap = (Map)SerializationUtils.fromJsonString((String)((String)evt.getReturnData()), Map.class);
            String attDataType = (String)valueMap.get("attDataType");
            switch (DataValueTypeEnum.getEnum((String)attDataType)) {
                case FahValueSet: {
                    this.getModel().setValue("refentity", (Object)"fah_valueset_type");
                    this.getModel().setValue("reftypeid", valueMap.get("fahValueSetId"));
                    this.getModel().setValue("refentityname", valueMap.get("fahValueSetName"));
                    break;
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if ("save".equals(((AbstractOperate)args.getSource()).getOperateKey()) && this.isQuote()) {
            int count = this.getModel().getEntryRowCount("entryentity");
            LinkedList<Integer> seqList = new LinkedList<Integer>();
            for (int i = 0; i < count; ++i) {
                seqList.add(i);
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"attdatatype"});
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"refentityname"});
            }
            this.getPageCache().put("seqList", SerializationUtils.serializeToBase64(seqList));
        }
    }
}

