/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.formplugin.mapping;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.v2.fah.constant.enums.DataValueTypeEnum;
import kd.fi.v2.fah.constant.enums.MappingValueType;
import kd.fi.v2.fah.element.DateElement;
import kd.fi.v2.fah.element.Element;
import kd.fi.v2.fah.element.EntryElement;
import kd.fi.v2.fah.element.MulComboElement;
import kd.fi.v2.fah.element.MulbasedataElement;
import kd.fi.v2.fah.element.TextElement;
import kd.fi.v2.fah.formplugin.mapping.FahValMapEdit;
import kd.fi.v2.fah.formplugin.mapping.FahValMapFilterUtil;
import kd.fi.v2.fah.sqlbuilder.filter.SimpleQFilterInfo1;
import kd.fi.v2.fah.utils.StringUtils;

public class FahMapEntrySearch
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String ENTRYENTITY = "entryentity";

    public void initialize() {
        super.initialize();
        this.getView().addCustomControls(new String[]{ENTRYENTITY});
        DynamicObjectCollection fields = QueryServiceHelper.query((String)"fah_flex_struc", (String)"dseq,attnum,attname,attdatatype,refentity,fieldusagetype,reftypeid,reffieldnum,flexfieldnum", (QFilter[])new QFilter[]{new QFilter("parentid", "=", (Object)Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("strucid")))}, (String)"fieldusagetype desc,dseq asc");
        LinkedList<Element> elementList = this.getElementList(fields);
        this.cacheEntryElement(elementList);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.entryBuild();
        this.getView().updateView(ENTRYENTITY);
        String message = ResManager.loadKDString((String)"\u82f1\u6587\u9017\u53f7\u4ee3\u8868\u3010\u6216\u3011\u5173\u7cfb\uff0c\u652f\u6301\u591a\u503c\u67e5\u8be2\uff1b%\u8868\u793a\u4efb\u610f\u5b57\u7b26\uff0c\u652f\u6301\u6a21\u7cca\u67e5\u8be2\u3002", (String)"FahMapEntrySearch_1", (String)"fi-ai-formplugin", (Object[])new Object[0]);
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        FahValMapEdit.setTips(entryGrid, "serialnumber", ResManager.loadKDString((String)"\u82f1\u6587\u9017\u53f7\u4ee3\u8868\u3010\u6216\u3011\u5173\u7cfb\uff0c\u652f\u6301\u591a\u503c\u67e5\u8be2\u3002", (String)"FahMapEntrySearch_2", (String)"fi-ai-formplugin", (Object[])new Object[0]));
        LinkedList stringControlList = (LinkedList)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("stringControlList"));
        for (String control : stringControlList) {
            FahValMapEdit.setTips(entryGrid, control, message);
        }
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType newMainType;
        MainEntityType oldMainType = e.getOriginalEntityType();
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException var5) {
            throw new KDException((Throwable)var5, new ErrorCode("LoadCustomControlMetasSample", var5.getMessage()), new Object[0]);
        }
        EntryType entryType = (EntryType)newMainType.getAllEntities().get(ENTRYENTITY);
        this.getEntryElement().registerEntryProp(entryType);
        e.setNewEntityType(newMainType);
    }

    public void onGetControl(OnGetControlArgs e) {
        EntryElement entryElement = this.getEntryElement();
        ArrayList<EntryElement> items = new ArrayList<EntryElement>(entryElement.getItems());
        items.add(entryElement);
        Optional<Element> first = items.stream().filter(x -> x.getName().equals(e.getKey())).findFirst();
        Control control = null;
        if (first.isPresent()) {
            Element element = first.get();
            control = element.getControl(this.getView());
            e.setControl(control);
        }
    }

    private LinkedList<Element> getElementList(DynamicObjectCollection collection) {
        LinkedList<Element> entryElementList = new LinkedList<Element>();
        HashMap<Integer, LinkedList> fieldNumberMap = new HashMap<Integer, LinkedList>(2);
        HashMap<String, Long> assistMap = new HashMap<String, Long>(4);
        HashMap<String, String> basedataForF7Map = new HashMap<String, String>(4);
        HashMap<String, Long> accountMap = new HashMap<String, Long>(4);
        HashMap<String, Long> fahValueSetMap = new HashMap<String, Long>(4);
        HashMap[] flexFieldNumMap = new HashMap[]{new HashMap(8), new HashMap(8)};
        LinkedList<String> controlList = new LinkedList<String>();
        LinkedList<String> stringControlList = new LinkedList<String>();
        DynamicObjectType mulBasedataProp = ((MulBasedataProp)((EntryProp)EntityMetadataCache.getDataEntityType((String)"fah_getmulbasedata").getProperty(ENTRYENTITY)).getDynamicCollectionItemPropertyType().getProperty("mulbasedatafield")).getDynamicCollectionItemPropertyType();
        entryElementList.add((Element)new TextElement("serialnumber", ResManager.loadKDString((String)"\u6d41\u6c34\u53f7", (String)"FahMapEntrySearch_3", (String)"fi-ai-formplugin", (Object[])new Object[0]), ENTRYENTITY, true));
        MulbasedataElement mulEorgElement = new MulbasedataElement("eorg", ResManager.loadKDString((String)"\u9002\u7528\u7ec4\u7ec7", (String)"FahMapEntrySearch_4", (String)"fi-ai-formplugin", (Object[])new Object[0]), "bos_org", ENTRYENTITY, mulBasedataProp);
        if (this.isSelectAllNode()) {
            mulEorgElement.setEnable(true);
        } else {
            mulEorgElement.setEnable(false);
        }
        entryElementList.add((Element)mulEorgElement);
        for (DynamicObject field : collection) {
            String flexfieldnum = field.getString("flexfieldnum");
            String fieldNumber = field.getString("attnum").toLowerCase();
            String fieldName = field.getString("attname");
            String refEntity = field.getString("refentity");
            Long reftypeid = field.getLong("reftypeid");
            String attdatatype = field.getString("attdatatype");
            DataValueTypeEnum type = DataValueTypeEnum.getEnum((String)attdatatype);
            String flexFieldType = field.getString("fieldusagetype");
            switch (type) {
                case String: {
                    TextElement textElement = new TextElement(fieldNumber, fieldName, ENTRYENTITY);
                    textElement.setFlexFieldType(flexFieldType);
                    entryElementList.add((Element)textElement);
                    stringControlList.add(fieldNumber);
                    break;
                }
                case BaseProp: {
                    MulbasedataElement mulbasedataElement = new MulbasedataElement("basedata_" + fieldNumber, fieldName, refEntity, ENTRYENTITY, mulBasedataProp);
                    mulbasedataElement.setFlexFieldType(flexFieldType);
                    entryElementList.add((Element)mulbasedataElement);
                    fieldNumber = "basedata_" + fieldNumber;
                    basedataForF7Map.put(fieldNumber, refEntity);
                    break;
                }
                case AssistProp: {
                    MulbasedataElement mulAssistPropElement = new MulbasedataElement("assistant_" + fieldNumber, fieldName, "bos_assistantdata_detail", ENTRYENTITY, mulBasedataProp);
                    mulAssistPropElement.setFlexFieldType(flexFieldType);
                    entryElementList.add((Element)mulAssistPropElement);
                    fieldNumber = "assistant_" + fieldNumber;
                    assistMap.put(fieldNumber, reftypeid);
                    break;
                }
                case FahValueSet: {
                    MulbasedataElement mulFahValueSetElement = new MulbasedataElement("valueset_" + fieldNumber, fieldName, "fah_flex_valueset", ENTRYENTITY, mulBasedataProp);
                    mulFahValueSetElement.setFlexFieldType(flexFieldType);
                    entryElementList.add((Element)mulFahValueSetElement);
                    fieldNumber = "valueset_" + fieldNumber;
                    fahValueSetMap.put(fieldNumber, reftypeid);
                    controlList.add(fieldNumber);
                    break;
                }
                case Kingdee_AccountTable: {
                    MulbasedataElement mulAccountTableElement = new MulbasedataElement("accounttable_" + fieldNumber, fieldName, "bd_accountview", ENTRYENTITY, mulBasedataProp);
                    mulAccountTableElement.setFlexFieldType(flexFieldType);
                    entryElementList.add((Element)mulAccountTableElement);
                    fieldNumber = "accounttable_" + fieldNumber;
                    accountMap.put(fieldNumber, reftypeid);
                    break;
                }
                case Kingdee_AcctAssistDim: {
                    DynamicObject temp = BusinessDataServiceHelper.loadSingle((String)"bd_asstacttype", (String)"valuetype,valuesource,assistanttype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)reftypeid)});
                    if (temp != null && "1".equals(temp.getString("valuetype"))) {
                        String basedataTypeId = temp.getString("valuesource_id");
                        MulbasedataElement mulAcctAssistDimElement = new MulbasedataElement("acctassistdim_" + fieldNumber, fieldName, basedataTypeId, ENTRYENTITY, mulBasedataProp);
                        mulAcctAssistDimElement.setFlexFieldType(flexFieldType);
                        entryElementList.add((Element)mulAcctAssistDimElement);
                        fieldNumber = "acctassistdim_" + fieldNumber;
                        basedataForF7Map.put(fieldNumber, basedataTypeId);
                        break;
                    }
                    if (temp == null || !"2".equals(temp.getString("valuetype"))) break;
                    MulbasedataElement mulAcctAssistDimElement = new MulbasedataElement("acctassistdim_" + fieldNumber, fieldName, "bos_assistantdata_detail", ENTRYENTITY, mulBasedataProp);
                    mulAcctAssistDimElement.setFlexFieldType(flexFieldType);
                    entryElementList.add((Element)mulAcctAssistDimElement);
                    fieldNumber = "acctassistdim_" + fieldNumber;
                    assistMap.put(fieldNumber, temp.getLong("assistanttype_id"));
                    break;
                }
                case Kingdee_CashFlow: {
                    MulbasedataElement mulCashFlowElement = new MulbasedataElement("cashflow_" + fieldNumber, fieldName, "gl_cashflowitem", ENTRYENTITY, mulBasedataProp);
                    mulCashFlowElement.setFlexFieldType(flexFieldType);
                    entryElementList.add((Element)mulCashFlowElement);
                    fieldNumber = "cashflow_" + fieldNumber;
                    break;
                }
                case Kingdee_BillDropDownList: {
                    String refFieldNum = field.getString("reffieldnum");
                    MulComboElement mulComboElement = new MulComboElement("billdropdownlist_" + fieldNumber, fieldName, ENTRYENTITY, refEntity, refFieldNum, false);
                    mulComboElement.setFlexFieldType(flexFieldType);
                    entryElementList.add((Element)mulComboElement);
                    fieldNumber = "billdropdownlist_" + fieldNumber;
                }
            }
            controlList.add(fieldNumber);
            fieldNumberMap.computeIfAbsent(field.getInt("fieldusagetype"), v -> new LinkedList()).add(new Object[]{fieldNumber, type});
            flexFieldNumMap[field.getInt("fieldusagetype")].put(fieldNumber, flexfieldnum);
        }
        entryElementList.add((Element)new DateElement("effectdate", ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f", (String)"FahMapEntrySearch_5", (String)"fi-ai-formplugin", (Object[])new Object[0]), ENTRYENTITY));
        entryElementList.add((Element)new DateElement("expiredate", ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f", (String)"FahMapEntrySearch_6", (String)"fi-ai-formplugin", (Object[])new Object[0]), ENTRYENTITY));
        this.getPageCache().put("assistMap", SerializationUtils.serializeToBase64(assistMap));
        this.getPageCache().put("accountMap", SerializationUtils.serializeToBase64(accountMap));
        this.getPageCache().put("fahValueSetMap", SerializationUtils.serializeToBase64(fahValueSetMap));
        this.getPageCache().put("basedataForF7Map", SerializationUtils.serializeToBase64(basedataForF7Map));
        this.getPageCache().put("controlList", SerializationUtils.toJsonString(controlList));
        this.getPageCache().put("flexFieldNumMap", SerializationUtils.toJsonString((Object)flexFieldNumMap));
        this.getPageCache().put("fieldNumberMap", SerializationUtils.serializeToBase64(fieldNumberMap));
        this.getPageCache().put("stringControlList", SerializationUtils.serializeToBase64(stringControlList));
        return entryElementList;
    }

    private EntryElement cacheEntryElement(LinkedList<Element> elementList) {
        EntryElement entryElement = new EntryElement(ENTRYENTITY);
        entryElement.setItems(elementList);
        this.getPageCache().put("entryentity_element", SerializationUtils.serializeToBase64((Object)entryElement));
        return entryElement;
    }

    public void entryBuild() {
        this.getEntryElement().build(this.getView());
    }

    private EntryElement getEntryElement() {
        String elements = this.getPageCache().get("entryentity_element");
        if (elements == null) {
            LinkedList<Element> elementList = new LinkedList<Element>();
            return this.cacheEntryElement(elementList);
        }
        return (EntryElement)SerializationUtils.deSerializeFromBase64((String)elements);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FahValMapFilterUtil.registerListener(this.getView(), this.getPageCache(), this);
        MulBasedataEdit mulBasedataEdit = (MulBasedataEdit)this.getControl("eorg");
        mulBasedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"btnok"});
        MulBasedataEdit orgBaseEdit = (MulBasedataEdit)this.getView().getControl("eorg");
        orgBaseEdit.setOrgFuncId("10");
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        Object eorgId = this.getView().getFormShowParameter().getCustomParam("eorg_id");
        if ("eorg".equals(evt.getProperty().getName())) {
            ListShowParameter list = (ListShowParameter)evt.getFormShowParameter();
            List qFilters = list.getListFilterParameter().getQFilters();
            QFilter qFilter = new QFilter("id", "in", SerializationUtils.deSerializeFromBase64((String)((String)this.getView().getFormShowParameter().getCustomParam("permorg"))));
            qFilters.add(qFilter);
        } else if (!"root".equals(eorgId)) {
            FahValMapFilterUtil.beforeF7Select(evt, Long.parseLong(String.valueOf(eorgId)), this.getPageCache(), !this.isSelectAllNode());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if ("ok".equals(((FormOperate)args.getSource()).getOperateKey()) && args.getOperationResult().isSuccess()) {
            this.getView().returnDataToParent((Object)this.getFilterGroupCollection(this.getModel().getEntryEntity(ENTRYENTITY)));
            this.getView().close();
        }
    }

    private String getFilterGroupCollection(DynamicObjectCollection entryentity) {
        LinkedList filterGroupCollection = new LinkedList();
        List controlList = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("controlList"), List.class);
        HashMap[] flexFieldNumMap = (HashMap[])SerializationUtils.fromJsonString((String)this.getPageCache().get("flexFieldNumMap"), HashMap[].class);
        HashMap<String, Integer> columnTypeMap = new HashMap<String, Integer>(controlList.size());
        for (String controlColumn : controlList) {
            HashMap outputMap = flexFieldNumMap[MappingValueType.OUTPUT.getCode()];
            HashMap inputMap = flexFieldNumMap[MappingValueType.INPUT.getCode()];
            if (outputMap.containsKey(controlColumn)) {
                columnTypeMap.put(controlColumn, MappingValueType.OUTPUT.getCode());
                continue;
            }
            if (!inputMap.containsKey(controlColumn)) continue;
            columnTypeMap.put(controlColumn, MappingValueType.INPUT.getCode());
        }
        for (DynamicObject row : entryentity) {
            DynamicObjectCollection orgs;
            LinkedList<SimpleQFilterInfo1> currGroup = new LinkedList<SimpleQFilterInfo1>();
            filterGroupCollection.add(currGroup);
            for (String controlNumber : controlList) {
                SimpleQFilterInfo1 filterInfo;
                SimpleQFilterInfo1 filterInfo2;
                String flexFieldNum = (String)flexFieldNumMap[(Integer)columnTypeMap.get(controlNumber)].get(controlNumber);
                Object value = row.get(controlNumber);
                if (controlNumber.startsWith("billdropdownlist_")) {
                    List collect;
                    if (StringUtils.isEmpty((Object)value)) continue;
                    filterInfo2 = new SimpleQFilterInfo1(flexFieldNum, controlNumber, (Integer)columnTypeMap.get(controlNumber), SimpleQFilterInfo1.mapColumnType_Downlist, "in");
                    String[] split = value.toString().split(",");
                    if (split == null || split.length == 0 || CollectionUtils.isEmpty(collect = Arrays.stream(split).filter(e -> !StringUtils.isEmpty((String)e)).collect(Collectors.toList()))) continue;
                    filterInfo2.setValue(String.join((CharSequence)",", collect));
                    currGroup.add(filterInfo2);
                    continue;
                }
                if (controlNumber.startsWith("valueset_") || controlNumber.startsWith("accounttable_") || controlNumber.startsWith("cashflow_")) {
                    if (value instanceof DynamicObjectCollection) {
                        if (((DynamicObjectCollection)value).size() <= 0) continue;
                        List numberList = ((DynamicObjectCollection)value).stream().map(e -> e.getDynamicObject("fbasedataid").getString("number")).collect(Collectors.toList());
                        List idList = ((DynamicObjectCollection)value).stream().map(e -> e.getDynamicObject("fbasedataid").getString("id")).collect(Collectors.toList());
                        String numJoinStr = String.join((CharSequence)",", numberList);
                        String idJoinStr = String.join((CharSequence)",", idList);
                        SimpleQFilterInfo1 filterInfo3 = new SimpleQFilterInfo1(flexFieldNum, controlNumber, (Integer)columnTypeMap.get(controlNumber), SimpleQFilterInfo1.mapColumnType_Number, "in");
                        filterInfo3.setNumbers(numJoinStr);
                        filterInfo3.setIds(idJoinStr);
                        currGroup.add(filterInfo3);
                        continue;
                    }
                    if (!(value instanceof DynamicObject)) continue;
                    String number = ((DynamicObject)value).getString("number");
                    String id = ((DynamicObject)value).getString("id");
                    filterInfo = new SimpleQFilterInfo1(flexFieldNum, controlNumber, (Integer)columnTypeMap.get(controlNumber), SimpleQFilterInfo1.mapColumnType_Number, "in");
                    filterInfo.setNumbers(number);
                    filterInfo.setIds(id);
                    currGroup.add(filterInfo);
                    continue;
                }
                if (controlNumber.startsWith("basedata_") || controlNumber.startsWith("assistant_") || controlNumber.startsWith("acctassistdim_")) {
                    if (value instanceof DynamicObjectCollection) {
                        if (((DynamicObjectCollection)value).size() <= 0) continue;
                        List idList = ((DynamicObjectCollection)value).stream().map(e -> e.getDynamicObject("fbasedataid").getString("id")).collect(Collectors.toList());
                        String idJoinStr = String.join((CharSequence)",", idList);
                        filterInfo = new SimpleQFilterInfo1(flexFieldNum, controlNumber, (Integer)columnTypeMap.get(controlNumber), SimpleQFilterInfo1.mapColumnType_Id, "in");
                        filterInfo.setIds(idJoinStr);
                        currGroup.add(filterInfo);
                        continue;
                    }
                    if (!(value instanceof DynamicObject)) continue;
                    String id = ((DynamicObject)value).getString("id");
                    SimpleQFilterInfo1 filterInfo4 = new SimpleQFilterInfo1(flexFieldNum, controlNumber, (Integer)columnTypeMap.get(controlNumber), SimpleQFilterInfo1.mapColumnType_Id, "in");
                    filterInfo4.setIds(id);
                    currGroup.add(filterInfo4);
                    continue;
                }
                if (!(value instanceof String) || StringUtils.isEmpty((Object)value)) continue;
                filterInfo2 = new SimpleQFilterInfo1(flexFieldNum, controlNumber, (Integer)columnTypeMap.get(controlNumber), SimpleQFilterInfo1.mapColumnType_String, this.checkIfLikeCP((String)value));
                filterInfo2.setValue((String)value);
                currGroup.add(filterInfo2);
            }
            String serialnumber = row.getString("serialnumber");
            if (!StringUtils.isEmpty((String)serialnumber)) {
                SimpleQFilterInfo1 filterInfoSN = new SimpleQFilterInfo1("fserialnumber", "serialnumber", Integer.valueOf(MappingValueType.INPUT.getCode()), SimpleQFilterInfo1.mapColumnType_String, "in");
                filterInfoSN.setValue(serialnumber);
                currGroup.add(filterInfoSN);
            }
            if (null != (orgs = row.getDynamicObjectCollection("eorg")) && orgs.size() > 0) {
                List idList = orgs.stream().map(e -> e.getDynamicObject("fbasedataid").getString("id")).collect(Collectors.toList());
                String idJoinStr = String.join((CharSequence)",", idList);
                SimpleQFilterInfo1 filterInfoOrg = new SimpleQFilterInfo1("fownorgid", "eorg", Integer.valueOf(MappingValueType.INPUT.getCode()), SimpleQFilterInfo1.mapColumnType_Id, "in");
                filterInfoOrg.setIds(idJoinStr);
                currGroup.add(filterInfoOrg);
            }
            Date effectdate = row.getDate("effectdate");
            Date expiredate = row.getDate("expiredate");
            if (effectdate == null && expiredate == null) continue;
            if (effectdate != null) {
                SimpleQFilterInfo1 filterInfoStart = new SimpleQFilterInfo1("fexpiredate", "effectdate", Integer.valueOf(MappingValueType.INPUT.getCode()), SimpleQFilterInfo1.mapColumnType_Date, ">=");
                filterInfoStart.setDate(effectdate);
                currGroup.add(filterInfoStart);
            }
            if (expiredate == null) continue;
            SimpleQFilterInfo1 filterInfoEnd = new SimpleQFilterInfo1("feffectdate", "expiredate", Integer.valueOf(MappingValueType.INPUT.getCode()), SimpleQFilterInfo1.mapColumnType_Date, "<=");
            filterInfoEnd.setDate(expiredate);
            currGroup.add(filterInfoEnd);
        }
        return SerializationUtils.serializeToBase64(filterGroupCollection);
    }

    private String checkIfLikeCP(String value) {
        if (value.startsWith("%") || value.endsWith("%")) {
            return "like";
        }
        return "in";
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String orgId = (String)this.getView().getFormShowParameter().getCustomParam("eorg_id");
        if (!StringUtils.isEmpty((String)orgId) && !"root".equals(orgId)) {
            this.getModel().setValue("eorg", (Object)new Long[]{Long.parseLong(orgId)}, e.getRowDataEntities()[0].getRowIndex());
        }
    }

    public void afterCreateNewData(EventObject e) {
        String searchInfo;
        super.afterCreateNewData(e);
        String orgId = (String)this.getView().getFormShowParameter().getCustomParam("eorg_id");
        if (!StringUtils.isEmpty((String)orgId) && !"root".equals(orgId)) {
            this.getModel().setValue("eorg", (Object)new Long[]{Long.parseLong(orgId)}, 0);
        }
        if (StringUtils.isEmpty((String)(searchInfo = (String)this.getView().getFormShowParameter().getCustomParam("searchCache")))) {
            return;
        }
        List qfilters = (List)SerializationUtils.deSerializeFromBase64((String)searchInfo);
        int i = 0;
        for (List qfilter : qfilters) {
            if (i != 0) {
                this.getModel().batchCreateNewEntryRow(ENTRYENTITY, 1);
            }
            for (SimpleQFilterInfo1 simpleQFilterInfolf : qfilter) {
                if (SimpleQFilterInfo1.mapColumnType_String.equals(simpleQFilterInfolf.getMapColumnType())) {
                    this.getModel().setValue(simpleQFilterInfolf.getControlNumber(), (Object)simpleQFilterInfolf.getValue(), i);
                    continue;
                }
                if (SimpleQFilterInfo1.mapColumnType_Id.equals(simpleQFilterInfolf.getMapColumnType())) {
                    String[] values = simpleQFilterInfolf.getIds().split(",");
                    Long[] Id = new Long[values.length];
                    for (int j = 0; j < values.length; ++j) {
                        Id[j] = Long.parseLong(values[j]);
                    }
                    this.getModel().setValue(simpleQFilterInfolf.getControlNumber(), (Object)Id, i);
                    continue;
                }
                if (SimpleQFilterInfo1.mapColumnType_Downlist.equals(simpleQFilterInfolf.getMapColumnType())) {
                    this.getModel().setValue(simpleQFilterInfolf.getControlNumber(), (Object)simpleQFilterInfolf.getValue(), i);
                    continue;
                }
                if (!SimpleQFilterInfo1.mapColumnType_Date.equals(simpleQFilterInfolf.getMapColumnType())) continue;
                this.getModel().setValue(simpleQFilterInfolf.getControlNumber(), (Object)simpleQFilterInfolf.getDate(), i);
            }
            ++i;
        }
    }

    private boolean isSelectAllNode() {
        String nodeId = (String)this.getView().getFormShowParameter().getCustomParam("eorg_id");
        return "root".equals(nodeId);
    }
}

