/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.formplugin.mapping;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.fi.v2.fah.converters.common.ObjectConverterFactory;
import kd.fi.v2.fah.dao.flex.MappingValueDaoImpl;
import kd.fi.v2.fah.models.MappingValueTypeOrg;
import kd.fi.v2.fah.utils.StringUtils;

public class FahValMapOrgEdit
extends AbstractFormPlugin
implements ClickListener,
RowClickEventListener {
    private static String ORGTYPE = "10";
    private static String ENTRYENTITY = "entryentity";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        LinkedList<MappingValueTypeOrg> orglist;
        super.afterCreateNewData(e);
        String orgcache = (String)this.getView().getFormShowParameter().getCustomParam("orgcache");
        if (StringUtils.isNotEmpty((String)orgcache)) {
            orglist = (LinkedList<MappingValueTypeOrg>)SerializationUtils.deSerializeFromBase64((String)orgcache);
        } else {
            MappingValueDaoImpl dao = new MappingValueDaoImpl();
            orglist = dao.queryOrgRecordsByTypeId(this.getTypeId());
        }
        if (this.isSelectCustom().booleanValue()) {
            this.getView().setFormTitle(new LocaleString(ResManager.loadKDString((String)"\u4e2a\u6027\u5316\u7ec4\u7ec7\u8bbe\u7f6e", (String)"FahValMapOrgEdit_0", (String)"fi-ai-formplugin", (Object[])new Object[0])));
            this.getView().setVisible(Boolean.FALSE, new String[]{"repeat", "add_row", "delete_row"});
            Set orgs = (Set)SerializationUtils.deSerializeFromBase64((String)((String)this.getView().getFormShowParameter().getCustomParam("permorg")));
            LinkedList<MappingValueTypeOrg> orgList2 = new LinkedList<MappingValueTypeOrg>();
            for (MappingValueTypeOrg org : orglist) {
                if (!orgs.contains(org.getId())) continue;
                orgList2.add(org);
            }
            orglist = orgList2;
            Label lblTip = (Label)this.getControl("labelap");
            lblTip.setText(ResManager.loadKDString((String)"\u4e2a\u6027\u5316\u7ec4\u7ec7\u6570\u636e\u8303\u56f4\u4e3a\u4ee5\u4e0b\u6761\u4ef6\u7684\u4ea4\u96c6\uff1a1\u3001\u5728\u3010\u9002\u7528\u7ec4\u7ec7\u3011\u91cc\u7ef4\u62a4\u7684\u7ec4\u7ec7\u30022\u3001\u64cd\u4f5c\u4eba\u6709\u6743\u9650\u7684\u7ec4\u7ec7\u3002", (String)"FahValMapOrgEdit_3", (String)"fi-ai-formplugin", (Object[])new Object[0]));
        } else {
            Label lblTip = (Label)this.getControl("labelap");
            Object sourcePage = this.getView().getFormShowParameter().getCustomParam("sourcePage");
            if ("fah_evt_dispatch_scheme".equals(sourcePage)) {
                lblTip.setText(ResManager.loadKDString((String)"\u4e00\u4e2a\u5355\u636e\u7c7b\u578b\u4e0b\u9002\u7528\u7ec4\u7ec7\u4e0d\u80fd\u91cd\u590d\u3002", (String)"FahValMapOrgEdit_5", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            } else {
                String grouptype = (String)this.getView().getFormShowParameter().getCustomParam("grouptype");
                if ("accounting_purposes".equals(grouptype.trim())) {
                    lblTip.setText(ResManager.loadKDString((String)"\u4e00\u4e2a\u5206\u7ec4\u4e0b\u9002\u7528\u7ec4\u7ec7\u4e0d\u80fd\u91cd\u590d\u3002", (String)"FahValMapOrgEdit_4", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                } else {
                    lblTip.setText("");
                }
            }
        }
        this.setValueByOrgList((List<MappingValueTypeOrg>)orglist);
    }

    private void setValueByOrgList(List<MappingValueTypeOrg> orglist) {
        if (orglist.isEmpty()) {
            return;
        }
        this.getModel().batchCreateNewEntryRow(ENTRYENTITY, orglist.size());
        int index = 0;
        for (MappingValueTypeOrg org : orglist) {
            this.getModel().setValue("number", (Object)org.getNumber(), index);
            this.getModel().setValue("name", (Object)org.getName(), index);
            this.getModel().setValue("orgid", org.getId(), index);
            this.getModel().setValue("iscustom", (Object)org.isCustom(), index);
            this.getModel().setValue("description", (Object)org.getDescription(), index);
            this.setDuplicateMessage((Long)org.getId(), index);
            this.setDisable(index, this.isSelectCustom() == Boolean.TRUE ? true : ((Long)org.getId()).longValue() == this.getCreateOrg().longValue());
            ++index;
        }
    }

    private void setDuplicateMessage(Long orgId, int i) {
        String dispatchDupcheck;
        Map dupMap;
        String checkstatus = (String)this.getView().getFormShowParameter().getCustomParam("checkstatus");
        if ("0".equals(checkstatus)) {
            this.getModel().setValue("repeat", (Object)"1", i);
            this.setCellStyle(i, "1");
            return;
        }
        String dupcheck = (String)this.getView().getFormShowParameter().getCustomParam("dupcheck");
        if (StringUtils.isNotEmpty((String)dupcheck) && !(dupMap = (Map)SerializationUtils.deSerializeFromBase64((String)dupcheck)).isEmpty()) {
            List list = (List)dupMap.get(orgId);
            if (list == null || list.isEmpty() || this.isChildAllEmpty(list)) {
                this.getModel().setValue("repeat", (Object)"1", i);
                this.setCellStyle(i, "1");
            } else {
                this.getModel().setValue("repeat", (Object)"0", i);
                this.setCellStyle(i, "0");
            }
        }
        if (StringUtils.isNotEmpty((String)(dispatchDupcheck = (String)this.getView().getFormShowParameter().getCustomParam("dispatchDupcheck")))) {
            Map dispatchDupMap = (Map)SerializationUtils.deSerializeFromBase64((String)dispatchDupcheck);
            Set orgIdSet = dispatchDupMap.keySet().stream().map(o -> ObjectConverterFactory.getLong((Object)o.split("\\$")[0])).collect(Collectors.toSet());
            if (orgIdSet.contains(orgId)) {
                this.getModel().setValue("repeat", (Object)"0", i);
                this.setCellStyle(i, "0");
            } else {
                this.getModel().setValue("repeat", (Object)"1", i);
                this.setCellStyle(i, "1");
            }
        }
    }

    private boolean isChildAllEmpty(List<Set<Integer>> serialNumsList) {
        boolean flag = true;
        for (Set<Integer> integers : serialNumsList) {
            if (integers.isEmpty()) continue;
            flag = false;
            break;
        }
        return flag;
    }

    private void setCellStyle(int rownum, String status) {
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        CellStyle item = new CellStyle();
        item.setFieldKey("repeat");
        item.setRow(rownum);
        item.setForeColor("0".equals(status) ? "red" : "green");
        ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>();
        cellStyles.add(item);
        grid.setCellStyle(cellStyles);
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "add_row": {
                this.showOrgTreeForm();
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        if (key.equals("deleteentry")) {
            EntryGrid control = (EntryGrid)this.getView().getControl(ENTRYENTITY);
            int[] selectedData = control.getSelectRows();
            DynamicObjectCollection rows = this.getModel().getEntryEntity(ENTRYENTITY);
            for (int index : selectedData) {
                DynamicObject row = (DynamicObject)rows.get(index);
                if (!row.getBoolean("iscustom")) continue;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7ec4\u7ec7\u5df2\u5b58\u5728\u4e2a\u6027\u5316\u8bbe\u7f6e\uff0c\u8bf7\u5220\u9664\u4e2a\u6027\u5316\u6570\u636e\u518d\u5c1d\u8bd5\u5220\u9664\u3002", (String)"FahValMapOrgEdit_2", (String)"fi-ai-formplugin", (Object[])new Object[0]), row.getString("name") + '(' + row.getString("number") + ')'));
                args.setCancel(true);
                break;
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnok": {
                DynamicObjectCollection rows = this.getModel().getEntryEntity(ENTRYENTITY);
                if (this.isSelectCustom().booleanValue()) {
                    EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
                    int[] selectRows = entryGrid.getSelectRows();
                    ArrayList<MappingValueTypeOrg> result = new ArrayList<MappingValueTypeOrg>(selectRows.length);
                    for (int selectRow : selectRows) {
                        DynamicObject row = (DynamicObject)rows.get(selectRow);
                        MappingValueTypeOrg org = new MappingValueTypeOrg(Long.valueOf(row.getLong("orgid")), row.getString("number"), row.getString("name"), row.getString("description"), row.getString("orgtype"), Boolean.valueOf(row.getBoolean("iscustom")));
                        result.add(org);
                    }
                    this.getView().returnDataToParent((Object)SerializationUtils.serializeToBase64(result));
                } else {
                    ArrayList<MappingValueTypeOrg> result = new ArrayList<MappingValueTypeOrg>(rows.size());
                    for (DynamicObject row : rows) {
                        MappingValueTypeOrg org = new MappingValueTypeOrg(Long.valueOf(row.getLong("orgid")), row.getString("number"), row.getString("name"), row.getString("description"), row.getString("orgtype"), Boolean.valueOf(row.getBoolean("iscustom")));
                        result.add(org);
                    }
                    this.getView().returnDataToParent((Object)SerializationUtils.serializeToBase64(result));
                }
                this.getView().close();
            }
        }
    }

    private void showOrgTreeForm() {
        ListShowParameter para = new ListShowParameter();
        para.setHasRight(true);
        para.setLookUp(true);
        para.setBillFormId("bos_org");
        para.setCustomParam("orgFuncId", (Object)ORGTYPE);
        para.setShowTitle(false);
        para.setFormId("bos_orgtreelistf7");
        StyleCss css = new StyleCss();
        css.setWidth("960");
        css.setHeight("580");
        para.getOpenStyle().setInlineStyleCss(css);
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setSelectedRows((Object[])this.getEntryOrgIDs().toArray(new Long[0]));
        para.setMultiSelect(true);
        para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "orgrangeSelected"));
        this.getView().showForm((FormShowParameter)para);
    }

    private Set<Long> getEntryOrgIDs() {
        HashSet<Long> result = new HashSet<Long>();
        DynamicObjectCollection rows = this.getModel().getEntryEntity(ENTRYENTITY);
        for (DynamicObject row : rows) {
            result.add(row.getLong("orgid"));
        }
        return result;
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if ("orgrangeSelected".equals(actionId)) {
            ListSelectedRowCollection returnData = (ListSelectedRowCollection)evt.getReturnData();
            if (returnData == null || returnData.isEmpty()) {
                return;
            }
            Set<Long> selectedIds = this.getSelectedIds();
            Set ids = returnData.stream().map(o -> (Long)o.getPrimaryKeyValue()).collect(Collectors.toSet());
            ids.removeAll(selectedIds);
            if (!ids.isEmpty()) {
                for (ListSelectedRow row : returnData) {
                    if (!ids.contains((Long)row.getPrimaryKeyValue())) continue;
                    int i = this.getModel().createNewEntryRow(ENTRYENTITY);
                    this.getModel().setValue("number", (Object)row.getNumber(), i);
                    this.getModel().setValue("name", (Object)row.getName(), i);
                    this.getModel().setValue("orgid", row.getPrimaryKeyValue(), i);
                    this.getModel().setValue("iscustom", (Object)Boolean.FALSE, i);
                    this.setDisable(i, this.isSelectCustom());
                }
            }
        }
    }

    private Set<Long> getSelectedIds() {
        DynamicObjectCollection rows = this.getModel().getEntryEntity(ENTRYENTITY);
        return rows.stream().map(o -> o.getLong("orgid")).collect(Collectors.toSet());
    }

    private void setDisable(int index, boolean isRemarkDisabled) {
        this.getView().setEnable(Boolean.FALSE, index, new String[]{"number"});
        this.getView().setEnable(Boolean.FALSE, index, new String[]{"name"});
        if (isRemarkDisabled) {
            this.getView().setEnable(Boolean.FALSE, index, new String[]{"description"});
        }
    }

    private Long getCreateOrg() {
        return ObjectConverterFactory.getLong((Object)this.getView().getFormShowParameter().getCustomParam("createorg"));
    }

    private Long getTypeId() {
        return ObjectConverterFactory.getLong((Object)this.getView().getFormShowParameter().getCustomParam("typeid"));
    }

    private Boolean isSelectCustom() {
        if ("selectCustom".equals(this.getView().getFormShowParameter().getCustomParam("mode"))) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

