/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.bizvoucher.opplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.ai.BusVoucher;

public class BizGlVoucherGenerateValidator
extends AbstractValidator {
    private static final String QUERY_SQL = "SELECT FID,FSOURCEBILL,FSOURCEBILLID,FGLVOUCHERID FROM T_AI_BIZVOUCHER WHERE ";

    public void validate() {
        int length = this.dataEntities.length;
        ArrayList<Long> bizVoucherIdList = new ArrayList<Long>(length);
        HashMap<Long, ExtendedDataEntity> entityMap = new HashMap<Long, ExtendedDataEntity>(length);
        for (ExtendedDataEntity entity : this.dataEntities) {
            DynamicObject v = entity.getDataEntity();
            long bizId = v.getLong("id");
            bizVoucherIdList.add(bizId);
            entityMap.put(bizId, entity);
        }
        List<BusVoucher> bizVoucherList = this.getBizVoucherBill(bizVoucherIdList);
        int size = bizVoucherList.size();
        ArrayList<String> bills = new ArrayList<String>(size);
        ArrayList<Long> sourcebillIds = new ArrayList<Long>(size);
        HashMap<Long, ExtendedDataEntity> sourcebillMap = new HashMap<Long, ExtendedDataEntity>(length);
        Set<Long> normalIds = this.loadNormalIds(bizVoucherIdList);
        for (BusVoucher busVoucher : bizVoucherList) {
            bills.add(busVoucher.getSourcebill());
            Long glvoucherid = busVoucher.getGlvoucherid();
            if (glvoucherid.compareTo(0L) != 0) {
                this.addErrorMessage((ExtendedDataEntity)entityMap.get(busVoucher.getId()), ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u5bf9\u5e94\u51ed\u8bc1\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"BizGlVoucherGenerateValidator_0", (String)"fi-ai-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (!normalIds.contains(busVoucher.getId())) {
                this.addErrorMessage((ExtendedDataEntity)entityMap.get(busVoucher.getId()), ResManager.loadKDString((String)"\u4e1a\u52a1\u51ed\u8bc1\u672a\u4fdd\u5b58\u5206\u5f55\u6570\u636e\uff0c\u8bf7\u5220\u9664\u540e\u7531\u5355\u636e\u91cd\u65b0\u751f\u6210\u3002", (String)"BizGlVoucherGenerateValidator_2", (String)"fi-ai-opplugin", (Object[])new Object[0]));
                continue;
            }
            sourcebillIds.add(busVoucher.getSourcebillid());
            sourcebillMap.put(busVoucher.getSourcebillid(), (ExtendedDataEntity)entityMap.get(busVoucher.getId()));
        }
        if (new HashSet(bills).size() > 1) {
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u751f\u6210\u51ed\u8bc1\u4e0d\u5141\u8bb8\u5b58\u5728\u591a\u79cd\u5355\u636e\u7c7b\u578b\u3002", (String)"BizGlVoucherGenerateValidator_1", (String)"fi-ai-opplugin", (Object[])new Object[0]));
            }
            return;
        }
        this.generateVoucher(sourcebillIds, (String)bills.get(0), sourcebillMap);
    }

    private void generateVoucher(List<Long> sourcebillIds, String entityName, Map<Long, ExtendedDataEntity> sourcebillMap) {
        if (sourcebillIds.isEmpty()) {
            return;
        }
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("isBizGenerateVoucher", "true");
        OperationResult result = OperationServiceHelper.executeOperate((String)"generatevoucher", (String)entityName, (Object[])sourcebillIds.toArray(), (OperateOption)operateOption);
        if (!result.isSuccess()) {
            List allInfo = result.getAllErrorOrValidateInfo();
            for (IOperateInfo info : allInfo) {
                Long sourceId = (Long)info.getPkValue();
                this.addErrorMessage(sourcebillMap.get(sourceId), info.getMessage());
            }
        }
    }

    private List<BusVoucher> getBizVoucherBill(List<Long> billIds) {
        ArrayList<BusVoucher> busVoucherList = new ArrayList<BusVoucher>(billIds.size());
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append(QUERY_SQL, new Object[0]).appendIn("FID", new ArrayList<Long>(billIds));
        try (DataSet qd = DB.queryDataSet((String)BizGlVoucherGenerateValidator.class.getName(), (DBRoute)DBRoute.of((String)"ai"), (SqlBuilder)sqlBuilder);){
            for (Row row : qd) {
                BusVoucher busVoucher = new BusVoucher();
                busVoucher.setId(row.getLong("FID"));
                busVoucher.setGlvoucherid(row.getLong("FGLVOUCHERID"));
                busVoucher.setSourcebill(row.getString("FSOURCEBILL"));
                busVoucher.setSourcebillid(row.getLong("FSOURCEBILLID"));
                busVoucherList.add(busVoucher);
            }
        }
        return busVoucherList;
    }

    private Set<Long> loadNormalIds(List<Long> bizVoucherIdList) {
        HashSet<Long> normalIds = new HashSet<Long>(16);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select b.fid as id from t_ai_bizvoucher as b where ", new Object[0]).appendIn(" b.fid", new ArrayList<Long>(bizVoucherIdList)).append(" and exists ( select 1 from t_ai_bizvoucherentry as e where e.fid=b.fid )", new Object[0]);
        try (DataSet qd = DB.queryDataSet((String)BizGlVoucherGenerateValidator.class.getName(), (DBRoute)DBRoute.of((String)"ai"), (SqlBuilder)sqlBuilder);){
            for (Row row : qd) {
                normalIds.add(row.getLong("id"));
            }
        }
        return normalIds;
    }
}

