/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.bizvoucher.opplugin;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ai.BizCurAccountBalance;
import kd.fi.ai.EntryAccountInfo;
import kd.fi.ai.accsys.AccSysUtil;
import kd.fi.ai.util.GLUtil;
import kd.fi.bd.service.balance.BalanceQueryExecutor;
import kd.fi.bd.service.balance.QueryParam;

public class BizVoucherDeficitValidator
extends AbstractValidator {
    private List<ValidationErrorInfo> errorInfoList;
    private static final String FIELD = "id,sourcetype,bizdate,period,localcur,localcur.amtprecision,vouchertype.islimitmultdc,entryentity.account,entryentity.id,entryentity.seq,entryentity.creditlocal,entryentity.creditori,entryentity.debitlocal,entryentity.debitori,entryentity.maincfitem,entryentity.maincfassgrp,entryentity.maincfamount,entryentity.supcfitem,entryentity.supfamount,entryentity.quantity,entryentity.businessnum,entryentity.expiredate,entryentity.price,entryentity.entrydc,entryentity.assgrp,entryentity.measureunit,entryentity.currency,entryentity.edescription,entryentity.currency.priceprecision,entryentity.localrate";
    private Map<String, BizCurAccountBalance> allCurAccountBalanceMap = new HashMap<String, BizCurAccountBalance>(16);

    public BizVoucherDeficitValidator(List<ValidationErrorInfo> errorInfos) {
        this.errorInfoList = errorInfos;
    }

    public void validate() {
        Serializable orgId;
        HashSet errorDataIndexs = this.getValidateContext().getValidateResults().getErrorDataIndexs();
        LinkedHashMap<Long, LinkedHashMap<String, BizCurAccountBalance>> loadedVch = new LinkedHashMap<Long, LinkedHashMap<String, BizCurAccountBalance>>(16);
        HashMap<Long, ExtendedDataEntity> idAndIndex = new HashMap<Long, ExtendedDataEntity>(this.dataEntities.length);
        ArrayList<Long> ids = new ArrayList<Long>(this.dataEntities.length);
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject v;
            if (errorDataIndexs.contains(i) || !this.dataEntities[i].getDataEntity().getDataEntityState().getFromDatabase() || !this.doCashCheck((Long)(orgId = Long.valueOf((v = this.dataEntities[i].getDataEntity()).getLong("org_id")))) && !this.doCurrentCheck((Long)orgId)) continue;
            ids.add(v.getLong("id"));
            idAndIndex.put(v.getLong("id"), this.dataEntities[i]);
        }
        if (ids.size() > 0) {
            if (this.dataEntities[0].getDataEntity().getDynamicObjectType().getProperty("entryentity") != null) {
                this.voucherFormPage(errorDataIndexs);
            } else {
                QFilter[] filters = new QFilter[]{new QFilter("id", "in", ids)};
                DataSet ds = QueryServiceHelper.queryDataSet((String)"BizVoucherDeficitValidator.validate", (String)"ai_bizvoucher", (String)FIELD, (QFilter[])filters, (String)"id,entryentity.seq");
                orgId = null;
                try {
                    int index = 1;
                    for (Row row : ds) {
                        Long id = row.getLong("id");
                        ExtendedDataEntity entity = (ExtendedDataEntity)idAndIndex.get(id);
                        long acctId = row.getLong("entryentity.account");
                        EntryAccountInfo acct = EntryAccountInfo.load((Long)acctId);
                        boolean isCash = false;
                        boolean isRec = false;
                        if (acct.isCash()) {
                            isCash = true;
                        }
                        if (acct.isAccheck()) {
                            isRec = true;
                        }
                        if (loadedVch.containsKey(id)) {
                            this.setAccountInfo(row.getLong("entryentity.assgrp"), row.getBigDecimal("entryentity.debitlocal"), row.getBigDecimal("entryentity.creditori"), acct.getNumber(), acct.getDc(), row.getLong("entryentity.currency"), entity, isCash, isRec, (Map)loadedVch.get(id), index);
                        } else {
                            index = 1;
                            LinkedHashMap<String, BizCurAccountBalance> curAccountBalanceMap = new LinkedHashMap<String, BizCurAccountBalance>(16);
                            this.setAccountInfo(row.getLong("entryentity.assgrp"), row.getBigDecimal("entryentity.debitlocal"), row.getBigDecimal("entryentity.creditori"), acct.getNumber(), acct.getDc(), row.getLong("entryentity.currency"), entity, isCash, isRec, curAccountBalanceMap, index);
                            loadedVch.put(id, curAccountBalanceMap);
                        }
                        ++index;
                    }
                }
                catch (Throwable index) {
                    orgId = index;
                    throw index;
                }
                finally {
                    if (ds != null) {
                        if (orgId != null) {
                            try {
                                ds.close();
                            }
                            catch (Throwable index) {
                                ((Throwable)orgId).addSuppressed(index);
                            }
                        } else {
                            ds.close();
                        }
                    }
                }
                for (Map.Entry entry : loadedVch.entrySet()) {
                    Map curAccountBalanceMap = (Map)entry.getValue();
                    if (!this.check(curAccountBalanceMap, false)) continue;
                    for (Map.Entry cabMap : curAccountBalanceMap.entrySet()) {
                        if (this.allCurAccountBalanceMap.containsKey(cabMap.getKey())) {
                            BizCurAccountBalance cab = this.allCurAccountBalanceMap.get(cabMap.getKey());
                            BigDecimal ampunt = cab.getAmount().add(((BizCurAccountBalance)cabMap.getValue()).getAmount());
                            cab.setAmount(ampunt);
                            continue;
                        }
                        this.allCurAccountBalanceMap.put((String)cabMap.getKey(), (BizCurAccountBalance)cabMap.getValue());
                    }
                }
            }
        } else {
            this.voucherFormPage(errorDataIndexs);
        }
    }

    private void voucherFormPage(HashSet<Integer> errorDataIndexs) {
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject dynamicObject;
            Long orgId;
            if (errorDataIndexs.contains(i) || !this.doCashCheck(orgId = Long.valueOf((dynamicObject = this.dataEntities[i].getDataEntity()).getLong("org_id"))) && !this.doCurrentCheck(orgId)) continue;
            DynamicObjectCollection entries = dynamicObject.getDynamicObjectCollection("entryentity");
            HashMap<String, BizCurAccountBalance> curAccountBalanceMap = new HashMap<String, BizCurAccountBalance>();
            for (int j = 0; j < entries.size(); ++j) {
                DynamicObject dyn = (DynamicObject)entries.get(j);
                boolean isCash = false;
                boolean isRec = false;
                DynamicObject acct = (DynamicObject)dyn.get("account");
                if (GLUtil.isCashAcct((DynamicObject)acct)) {
                    isCash = true;
                }
                if (acct.getBoolean("accheck")) {
                    isRec = true;
                }
                this.setAccountInfo(dyn.getLong("assgrp.id"), (BigDecimal)dyn.get("debitlocal"), (BigDecimal)dyn.get("creditlocal"), acct.getString("number"), acct.getString("dc"), dyn.getLong("currency.id"), this.dataEntities[i], isCash, isRec, curAccountBalanceMap, j + 1);
            }
            if (!this.check(curAccountBalanceMap, true)) continue;
            this.allCurAccountBalanceMap.putAll(curAccountBalanceMap);
        }
    }

    private boolean check(Map<String, BizCurAccountBalance> curAccountBalanceMap, boolean isFromPage) {
        boolean result = true;
        HashSet<String> accountNumbers = new HashSet<String>();
        HashSet<Long> assgrps = new HashSet<Long>();
        HashSet<Long> currencyIds = new HashSet<Long>();
        BizCurAccountBalance curAccountBalance = curAccountBalanceMap.values().iterator().next();
        DynamicObject dyn = curAccountBalance.getEntity().getDataEntity();
        long orgId = dyn.getLong("org_id");
        long bookTypeId = dyn.getLong("booktype.id");
        DynamicObject period = dyn.getDynamicObject("period");
        long periodId = period.getLong("id");
        long curAccountTableId = AccSysUtil.getCurPeriodAccountTableId((long)orgId, (long)bookTypeId, (long)periodId);
        this.checkDifcit(curAccountBalance.getEntity(), curAccountBalanceMap);
        for (Map.Entry<String, BizCurAccountBalance> cabMap : curAccountBalanceMap.entrySet()) {
            BizCurAccountBalance cab = cabMap.getValue();
            if (this.doCashCheck(orgId) && cab.getType().contains("checkdeficit")) {
                accountNumbers.add(cab.getAccNumber());
                currencyIds.add(cab.getCurrency());
                if (!cab.getAssgrp().equals(0L)) {
                    assgrps.add(cab.getAssgrp());
                }
            }
            if (!this.doCurrentCheck(orgId) || !cab.getType().contains("currentdeficit")) continue;
            accountNumbers.add(cab.getAccNumber());
            currencyIds.add(cab.getCurrency());
            if (cab.getAssgrp().equals(0L)) continue;
            assgrps.add(cab.getAssgrp());
        }
        if (accountNumbers.size() > 0) {
            result = this.checkCashDificit(orgId, bookTypeId, periodId, curAccountTableId, accountNumbers, assgrps, currencyIds, curAccountBalanceMap, isFromPage);
        }
        return result;
    }

    private void setAccountInfo(Long assgrp, BigDecimal debitlocal, BigDecimal creditlocal, String acctNumber, String dc, Long currency, ExtendedDataEntity entity, boolean isCash, boolean isRec, Map<String, BizCurAccountBalance> curAccountBalanceMap, int index) {
        BizCurAccountBalance curAccountBalance = new BizCurAccountBalance();
        String key = acctNumber + "&" + assgrp + "&" + currency;
        BigDecimal amount = debitlocal.compareTo(BigDecimal.ZERO) != 0 ? ("1".equals(dc) ? debitlocal : debitlocal.negate()) : ("-1".equals(dc) ? creditlocal : creditlocal.negate());
        BizCurAccountBalance old = curAccountBalanceMap.get(key);
        if (old == null) {
            curAccountBalance.setOrg(Long.valueOf(entity.getDataEntity().getLong("org_id")));
            curAccountBalance.setAccNumber(acctNumber);
            curAccountBalance.setAssgrp(assgrp);
            curAccountBalance.setCurrency(currency);
            curAccountBalance.setEntity(entity);
            curAccountBalance.setAmount(amount);
            ArrayList<Integer> list = new ArrayList<Integer>();
            list.add(index);
            curAccountBalance.setIndexs(list);
            HashSet<String> set = new HashSet<String>(1);
            if (isCash) {
                set.add("checkdeficit");
            }
            if (isRec) {
                set.add("currentdeficit");
            }
            curAccountBalance.setType(set);
            curAccountBalanceMap.put(key, curAccountBalance);
        } else {
            BizCurAccountBalance oldAmount = curAccountBalanceMap.get(key);
            oldAmount.setAmount(oldAmount.getAmount().add(amount));
            oldAmount.getIndexs().add(index);
            curAccountBalanceMap.put(key, oldAmount);
        }
    }

    private void checkDifcit(ExtendedDataEntity dataEntity, Map<String, BizCurAccountBalance> curAccountBalanceMap) {
        DynamicObject v = dataEntity.getDataEntity();
        String billstatus = v.getString("billstatus");
        if (billstatus.equals("B")) {
            DynamicObject dbVoucher = BusinessDataServiceHelper.loadSingle((String)"ai_bizvoucher", (String)"entryentity.account,entryentity.assgrp,entryentity.debitlocal,entryentity.creditlocal,entryentity.currency,vouchertype,book.accounttable,booktype,localcur", (QFilter[])new QFilter[]{new QFilter("id", "=", v.getPkValue())});
            DynamicObjectCollection dbEntry = dbVoucher.getDynamicObjectCollection("entryentity");
            for (DynamicObject dbEntryRow : dbEntry) {
                BigDecimal newAmount;
                String dbAccount = dbEntryRow.getString("account.number");
                long dbAssgrop = dbEntryRow.getLong("assgrp.id");
                long dbCurrency = dbEntryRow.getLong("currency.id");
                String dc = dbEntryRow.getString("account.dc");
                String dbKey = dbAccount + "&" + dbAssgrop + "&" + dbCurrency;
                BizCurAccountBalance cab = curAccountBalanceMap.get(dbKey);
                if (cab == null || (newAmount = cab.getAmount()) == null) continue;
                BigDecimal debitlocal = dbEntryRow.getBigDecimal("debitlocal");
                BigDecimal creditlocal = dbEntryRow.getBigDecimal("creditlocal");
                BigDecimal dbAmount = dbEntryRow.getBigDecimal("debitlocal").compareTo(BigDecimal.ZERO) != 0 ? ("1".equals(dc) ? debitlocal : debitlocal.negate()) : ("-1".equals(dc) ? creditlocal : creditlocal.negate());
                cab.setAmount(newAmount.subtract(dbAmount));
            }
        }
    }

    private boolean checkCashDificit(long orgId, long bookTypeId, long periodId, long curAccountTableId, Set<String> acctNumbers, Set<Long> assgrps, Set<Long> currencyIds, Map<String, BizCurAccountBalance> curAccountBalanceMap, boolean isFromPage) {
        BizCurAccountBalance cab;
        QueryParam param = new QueryParam();
        param.setOnlyLeafAcctBal(true);
        param.setAccountFilter(new QFilter("number", "in", acctNumbers));
        param.setCurrencyIds(currencyIds.toArray(new Long[currencyIds.size()]));
        param.setAssGrpIds(assgrps);
        BalanceQueryExecutor bq = BalanceQueryExecutor.getInstance();
        HashMap<String, BigDecimal> dbBalanceMap = new HashMap<String, BigDecimal>();
        try (DataSet ds = bq.getBalance("account.number,account.dc,assgrp,endlocal,currency", new Long[]{orgId}, bookTypeId, curAccountTableId, periodId, periodId, param);){
            for (Row r : ds) {
                BigDecimal endfor;
                String key = r.getString("account.number") + "&" + r.getLong("assgrp") + "&" + r.getLong("currency");
                BigDecimal bigDecimal = endfor = "-1".equals(r.getString("account.dc")) ? r.getBigDecimal("endlocal").negate() : r.getBigDecimal("endlocal");
                if (this.allCurAccountBalanceMap.containsKey(key)) {
                    dbBalanceMap.put(key, endfor.add(this.allCurAccountBalanceMap.get(key).getAmount()));
                    continue;
                }
                dbBalanceMap.put(key, endfor);
            }
        }
        ArrayList<ValidationErrorInfo> validationErrorInfos = new ArrayList<ValidationErrorInfo>(16);
        ArrayList<String> failEntries = new ArrayList<String>(16);
        Boolean result = true;
        for (Map.Entry<String, BizCurAccountBalance> entry : curAccountBalanceMap.entrySet()) {
            String currentDeficit;
            cab = entry.getValue();
            BigDecimal dbBalance = (BigDecimal)dbBalanceMap.get(entry.getKey());
            if (this.doCashCheck(orgId) && cab.getType().contains("checkdeficit") && cab.getAmount().compareTo(BigDecimal.ZERO) < 0 && (dbBalance == null || dbBalance.add(cab.getAmount()).compareTo(BigDecimal.ZERO) < 0)) {
                this.addMessage(cab.getEntity(), String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\uff0c\u79d1\u76ee\u201c%2$s\u201d\uff1a\u73b0\u91d1\u7c7b\u79d1\u76ee\u5bf9\u5e94\u6838\u7b97\u7ef4\u5ea6\u4f59\u989d <0\u3002", (String)"BizVoucherDeficitValidator_0", (String)"fi-ai-opplugin", (Object[])new Object[0]), cab.getIndexs().get(0), cab.getAccNumber()), ErrorLevel.Error);
                result = false;
            }
            if (!this.doCurrentCheck(orgId) || !cab.getType().contains("currentdeficit") || cab.getAmount().compareTo(BigDecimal.ZERO) >= 0 || dbBalance != null && dbBalance.add(cab.getAmount()).compareTo(BigDecimal.ZERO) >= 0) continue;
            switch (currentDeficit = (String)GLUtil.getObjectParam((String)"currentdeficit", (long)orgId)) {
                case "1": {
                    if (isFromPage) {
                        failEntries.add(entry.getKey());
                        break;
                    }
                    if (!result.booleanValue()) break;
                    ExtendedDataEntity entity = cab.getEntity();
                    Object pkId = entity.getBillPkId();
                    int dataIndex = entity.getDataEntityIndex();
                    String content = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u4fdd\u5b58\u6210\u529f\u3002\u4f46\u662f\u7b2c%2$s\u884c\uff0c\u79d1\u76ee%3$s\u7684\u5f80\u6765\u7c7b\u79d1\u76ee\u5bf9\u5e94\u6838\u7b97\u7ef4\u5ea6\u4f59\u989d\u5c0f\u4e8e0", (String)"BizVoucherDeficitValidator_5", (String)"fi-ai-opplugin", (Object[])new Object[0]), entity.getBillNo(), cab.getIndexs().get(0), cab.getAccNumber());
                    ValidationErrorInfo info = new ValidationErrorInfo("", pkId, dataIndex, entity.getRowIndex(), "errorcode_001", ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"BizVoucherDeficitValidator_4", (String)"fi-ai-opplugin", (Object[])new Object[0]), content, ErrorLevel.Error);
                    info.setEntityKey(this.getEntityKey());
                    info.setSubRowIndex(entity.getSubRowIndex());
                    validationErrorInfos.add(info);
                    break;
                }
                case "2": {
                    this.addMessage(cab.getEntity(), String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\uff0c\u79d1\u76ee\u201c%2$s\u201d\uff1a\u5f80\u6765\u7c7b\u79d1\u76ee\u5bf9\u5e94\u6838\u7b97\u7ef4\u5ea6\u4f59\u989d <0\u3002", (String)"BizVoucherDeficitValidator_2", (String)"fi-ai-opplugin", (Object[])new Object[0]), cab.getIndexs().get(0), cab.getAccNumber()), ErrorLevel.Error);
                    result = false;
                }
            }
        }
        if (result.booleanValue()) {
            if (isFromPage) {
                for (String failEntrieKey : failEntries) {
                    cab = curAccountBalanceMap.get(failEntrieKey);
                    this.addMessage(cab.getEntity(), "dificit", String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\uff0c\u79d1\u76ee\u201c%2$s\u201d\uff1a\u5f80\u6765\u7c7b\u79d1\u76ee\u5bf9\u5e94\u6838\u7b97\u7ef4\u5ea6\u4f59\u989d <0\u3002", (String)"BizVoucherDeficitValidator_2", (String)"fi-ai-opplugin", (Object[])new Object[0]), cab.getIndexs().get(0), cab.getAccNumber()), ErrorLevel.Warning);
                }
            } else {
                this.errorInfoList.addAll(validationErrorInfos);
            }
        }
        return result;
    }

    private boolean doCashCheck(Long orgId) {
        return (Boolean)ThreadCache.get((Object)("doCashCheck" + orgId), () -> GLUtil.getBooleanParam((String)"checkdeficit", (long)orgId, (boolean)false));
    }

    private boolean doCurrentCheck(Long orgId) {
        return (Boolean)ThreadCache.get((Object)("doCurrentCheck" + orgId), () -> {
            Object currentControl = GLUtil.getObjectParam((String)"currentdeficit", (long)orgId);
            return currentControl != null && !"0".equals(currentControl);
        });
    }
}

