/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.bizvoucher.opplugin;

import java.math.BigDecimal;
import java.util.Optional;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.ai.util.GLUtil;

public class BizVoucherEntryQtyAndPriceValidator {
    private BizVoucherEntryQtyAndPriceValidator() {
    }

    protected static Optional<String> validate(long orgId, DynamicObject voucherEntryDO) {
        return BizVoucherEntryQtyAndPriceValidator.validate(BizVoucherEntryQtyAndPriceValidator.getQtyAndPriceZeroSubmitable(orgId, voucherEntryDO), voucherEntryDO.getInt("seq"));
    }

    protected static Optional<String> validate(long orgId, Row entryRow, boolean isQty) {
        return BizVoucherEntryQtyAndPriceValidator.validate(isQty ? BizVoucherEntryQtyAndPriceValidator.getQtyAndPriceZeroSubmitable(orgId, entryRow) : true, entryRow.getInteger("entryentity.seq"));
    }

    private static Optional<String> validate(boolean qtyAndPriceZeroSubmitable, int seq) {
        if (!qtyAndPriceZeroSubmitable) {
            return Optional.of(String.format(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u7b2c\u201c%s\u201d\u6761\u7684\u6570\u91cf\u548c\u5355\u4ef7\u3002", (String)"BizVoucherEntryQtyAndPriceValidator_0", (String)"fi-ai-opplugin", (Object[])new Object[0]), seq));
        }
        return Optional.empty();
    }

    private static boolean getQtyAndPriceZeroSubmitable(long orgId, DynamicObject voucherEntryDO) {
        DynamicObject accountDynObj = voucherEntryDO.getDynamicObject("account");
        if (null == accountDynObj) {
            return true;
        }
        if (accountDynObj.getBoolean("isqty")) {
            return BizVoucherEntryQtyAndPriceValidator.getQtyAndPriceZeroSubmitable(orgId, voucherEntryDO.getBigDecimal("quantity"), voucherEntryDO.getBigDecimal("price"));
        }
        return true;
    }

    private static boolean getQtyAndPriceZeroSubmitable(long orgId, Row entryRow) {
        return BizVoucherEntryQtyAndPriceValidator.getQtyAndPriceZeroSubmitable(orgId, entryRow.getBigDecimal("entryentity.quantity"), entryRow.getBigDecimal("entryentity.price"));
    }

    private static boolean getQtyAndPriceZeroSubmitable(long orgId, BigDecimal qty, BigDecimal price) {
        return !GLUtil.getBooleanParam((String)"qtymustinput", (long)orgId, (boolean)false) || qty.signum() != 0 && price.signum() != 0;
    }

    protected static void appendEntryMsg(StringBuffer entryMsg, Optional<String> msg) {
        if (msg.isPresent()) {
            entryMsg.append(msg.get());
        }
    }
}

