/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.validate;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ObjectConverter;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.ORM;
import kd.fi.ai.VCHTemplate;
import kd.fi.ai.builder.IBuildVchContext;
import kd.fi.ai.builder.ISingleTaskContext;
import kd.fi.ai.event.AiEventData;
import kd.fi.ai.event.DataSourceFactory;
import kd.fi.ai.mservice.builder.compiler.AiEventMustInputCompiler;
import kd.fi.ai.mservice.builder.compiler.SelectedSourceEntity;
import kd.fi.ai.mservice.builder.context.BuildVchContext;
import kd.fi.ai.mservice.builder.context.SingleTaskContext;
import kd.fi.ai.mservice.builder.getvaluehandle.ConditionGetHandle;
import kd.fi.ai.mservice.builder.getvaluemode.IVariableMode;
import kd.fi.ai.mservice.builder.getvaluemode.SourceBillFieldMode;
import kd.fi.ai.util.AiEventMetaUtil;

public class AiEventClassMustInputValidator {
    private List<AiEventData> eventData;
    private Long eventClassPK;
    private MainEntityType eventType;
    private AiEventMustInputCompiler compiler;
    private Map<String, String> numberAndName;

    public AiEventClassMustInputValidator(Map<String, String> fieldFilterMap, Long eventClassPK, List<AiEventData> eventData, Map<String, String> numberAndName) {
        this.eventData = eventData;
        this.numberAndName = numberAndName;
        this.eventClassPK = eventClassPK;
        this.eventType = AiEventMetaUtil.getEntityType((Object)eventClassPK);
        SingleTaskContext simulateTaskContext = new SingleTaskContext();
        VCHTemplate simulateTemplate = new VCHTemplate();
        simulateTemplate.setEvent(true);
        simulateTemplate.setEventClassId(eventClassPK.longValue());
        simulateTaskContext.setTemplate(simulateTemplate);
        simulateTaskContext.setSrcEntityType(this.eventType);
        simulateTaskContext.setBuildVchContext((IBuildVchContext)new BuildVchContext());
        this.compiler = new AiEventMustInputCompiler((ISingleTaskContext)simulateTaskContext, fieldFilterMap);
        this.compiler.Compolier();
    }

    public Map<String, String> validateMustInput() {
        HashMap<String, String> validateResult = new HashMap<String, String>(16);
        this.doMustInputValidation((extDataNum, checkResult) -> validateResult.put((String)extDataNum, String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d\u548c\u5b57\u6bb5\u201c%2$s\u201d\u4e3a\u5fc5\u5f55\u5b57\u6bb5\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u5f55\u5165\u6216\u5f55\u5165\u7684\u6570\u636e\u662f\u5426\u5408\u6cd5\u3002", (String)"AiEventClassMustInputValidator_1", (String)"fi-ai-opplugin", (Object[])new Object[0]), checkResult[0], checkResult[1])));
        return validateResult;
    }

    public boolean doMustInputValidation(BiConsumer<String, String[]> consumer, boolean continueOnValidationFailed) {
        DynamicObjectCollection rows;
        SelectedSourceEntity selectedSourceEntity = AiEventClassMustInputValidator.buildSelectedSourceEntity((EntityType)this.eventType, this.compiler.getSelectedFields());
        try (DataSet ds = DataSourceFactory.getDataSource().getEventData((Object)this.eventClassPK, selectedSourceEntity.getSelectString(), this.eventData);){
            rows = ORM.create().toPlainDynamicObjectCollection(ds);
        }
        boolean validateResult = true;
        if (rows != null && rows.size() > 0) {
            DynamicObjectType dType = rows.getDynamicObjectType();
            for (Map.Entry fldAliasItem : selectedSourceEntity.getFldAlias().entrySet()) {
                selectedSourceEntity.getFldProperties().put(fldAliasItem.getKey(), dType.getProperty((String)fldAliasItem.getValue()));
            }
            for (DynamicObject sourceRow : rows) {
                if (this.doFieldMustInputConditionCheck(selectedSourceEntity, sourceRow, (num, name) -> consumer.accept(sourceRow.getString((IDataEntityProperty)selectedSourceEntity.getFldProperties().get("number")), new String[]{num, name}))) continue;
                if (!continueOnValidationFailed) {
                    return false;
                }
                if (!validateResult) continue;
                validateResult = false;
            }
        }
        return validateResult;
    }

    public boolean doMustInputValidation(BiConsumer<String, String[]> consumer) {
        return this.doMustInputValidation(consumer, false);
    }

    private boolean doFieldMustInputConditionCheck(SelectedSourceEntity selectedSourceEntity, DynamicObject sourceRow, BiConsumer<String, String> consumer) {
        for (Map.Entry fieldConditionEntry : this.compiler.getFieldConditionMap().entrySet()) {
            Boolean bool = ((ConditionGetHandle)fieldConditionEntry.getValue()).GetVchFldValue(selectedSourceEntity.getFldProperties(), sourceRow, null);
            if (bool == null || !bool.booleanValue()) continue;
            String field = (String)fieldConditionEntry.getKey();
            DynamicProperty prop = (DynamicProperty)selectedSourceEntity.getFldProperties().get(field);
            Object value = prop.getValueFast((Object)sourceRow);
            if (BigDecimal.class == prop.getPropertyType()) {
                if (!StringUtils.isBlank((Object)value)) continue;
                consumer.accept(field, this.numberAndName.get(field));
                return false;
            }
            if (Boolean.class == prop.getPropertyType() || !StringUtils.isBlank((Object)value) && !value.equals(ObjectConverter.convert(null, (Class)prop.getPropertyType(), (boolean)prop.isEnableNull()))) continue;
            consumer.accept(field, this.numberAndName.get(field));
            return false;
        }
        return true;
    }

    private static SelectedSourceEntity buildSelectedSourceEntity(EntityType mainEntityType, Map<String, IVariableMode> selectedFields) {
        SelectedSourceEntity result = new SelectedSourceEntity();
        result.setEntityType(mainEntityType);
        if (mainEntityType == null) {
            return result;
        }
        LinkedList<String> selectFldStrings = new LinkedList<String>();
        Map _fieldAliasMap = result.getFldAlias();
        Map _selectedFields = result.getSelectedFields();
        int fldIndex = 0;
        String pkPropName = mainEntityType.getPrimaryKey().getName();
        result.getFldAlias().put(pkPropName, pkPropName);
        selectFldStrings.add(pkPropName);
        ++fldIndex;
        for (Map.Entry<String, IVariableMode> fldItem : selectedFields.entrySet()) {
            if (!(fldItem.getValue() instanceof SourceBillFieldMode)) continue;
            SourceBillFieldMode fldMode = (SourceBillFieldMode)fldItem.getValue();
            _selectedFields.put(fldItem.getKey(), fldMode);
            String fieldVar = fldMode.getVar();
            if (_fieldAliasMap.containsKey(fieldVar)) continue;
            String fldAlias = "f" + fldIndex;
            _fieldAliasMap.put(fieldVar, fldAlias);
            selectFldStrings.add(fldMode.getFullPropName() + " " + fldAlias);
            ++fldIndex;
        }
        String selectString = StringUtils.join((Object[])selectFldStrings.toArray(new Object[fldIndex]), (String)",");
        result.setSelectString(selectString);
        return result;
    }
}

