/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.event.opplugin;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.v2.fah.event.mservice.service.BuildEventBizDataService;

public class FahEvtGenBizDimGrpOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new FahEvtGenBizDimGrpValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("id");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
    }

    private static class FahEvtGenBizDimGrpValidator
    extends AbstractValidator {
        private FahEvtGenBizDimGrpValidator() {
        }

        public void validate() {
            Set evtIds = Arrays.stream(this.getDataEntities()).map(a -> (Long)a.getDataEntity().getPkValue()).collect(Collectors.toSet());
            OperationResult or = new OperationResult();
            new BuildEventBizDataService(or).buildEventBizDimData(evtIds);
            if (or.isSuccess()) {
                return;
            }
            HashMap<Long, String> errMsgMap = new HashMap<Long, String>(evtIds.size());
            for (OperateErrorInfo err : or.getAllErrorInfo()) {
                Long evtId = (Long)err.getPkValue();
                String message = err.getMessage();
                errMsgMap.put(evtId, message);
            }
            for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
                Long evtId = (Long)dataEntity.getDataEntity().getPkValue();
                String msg = (String)errMsgMap.get(evtId);
                if (null == msg) continue;
                this.addErrorMessage(dataEntity, msg);
            }
        }
    }
}

