/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.validate;

import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import kd.bos.dataentity.Tuple;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.v2.fah.validate.ExtDataValidateUtils;

public class ExtDataBeinvalidValidator {
    private static Log logger = LogFactory.getLog(ExtDataBeinvalidValidator.class);
    private Map<String, List<ExtendedDataEntity>> modelGroup;
    private BiConsumer<ExtendedDataEntity, String> addErrorMessageConsumer;

    public ExtDataBeinvalidValidator(Map<String, List<ExtendedDataEntity>> modelGroup, BiConsumer<ExtendedDataEntity, String> addErrorMessageConsumer) {
        this.modelGroup = modelGroup;
        this.addErrorMessageConsumer = addErrorMessageConsumer;
    }

    public void validate() {
        logger.info("ExtDataBeinvalidValidator.validate start");
        List<Tuple<ExtendedDataEntity, String>> errorMessageList = ExtDataValidateUtils.checkPreModelData(this.modelGroup);
        this.addErrorMsgBack(errorMessageList);
    }

    private void addErrorMsgBack(List<Tuple<ExtendedDataEntity, String>> errorMessageList) {
        for (Tuple<ExtendedDataEntity, String> errorMessage : errorMessageList) {
            this.addErrorMessage((ExtendedDataEntity)errorMessage.item1, (String)errorMessage.item2);
        }
    }

    public void addErrorMessage(ExtendedDataEntity entity, String content) {
        this.addErrorMessageConsumer.accept(entity, content);
    }
}

