/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.validate;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.v2.fah.dao.DaoFactory;
import kd.fi.v2.fah.dao.event.FahBizDimComDao;

public class FahBizDimCombineDeleteOp
extends AbstractOperationServicePlugIn {
    private final FahBizDimComDao instance = (FahBizDimComDao)DaoFactory.getInstance(FahBizDimComDao.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        List validators = e.getValidators();
        validators.remove(4);
        e.getValidators().add(new FahValMapDeleteValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("id");
        e.getFieldKeys().add("issysreserved");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        HashSet<Long> deleteIdSet = new HashSet<Long>(8);
        for (DynamicObject deleteDate : e.getDataEntities()) {
            deleteIdSet.add((Long)deleteDate.getPkValue());
        }
        DeleteServiceHelper.delete((String)"fah_biz_dimgrp_en", (QFilter[])new QFilter[]{new QFilter("fid", "in", deleteIdSet)});
        this.instance.deleteGroupDataByDimGrpId(deleteIdSet);
        DeleteServiceHelper.delete((String)"fah_biz_dimgroup", (QFilter[])new QFilter[]{new QFilter("dimgrpid", "in", deleteIdSet)});
    }

    public static class FahValMapDeleteValidator
    extends AbstractValidator {
        private final FahBizDimComDao instance = (FahBizDimComDao)DaoFactory.getInstance(FahBizDimComDao.class);

        public void validate() {
            ExtendedDataEntity[] entities;
            for (ExtendedDataEntity entity : entities = this.getDataEntities()) {
                List quoteEventRuleArray = this.instance.getQuoteEventRuleValueById((Long)entity.getValue("id"));
                if (((Boolean)entity.getValue("issysreserved")).booleanValue()) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u8be5\u4e1a\u52a1\u7ef4\u5ea6\u7ec4\u5408\u4e3a\u7cfb\u7edf\u9884\u7f6e\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"FahBizDimCombineDeleteOp_1", (String)"fi-ai-opplugin", (Object[])new Object[0]), new Object[0]));
                    continue;
                }
                LinkedList<String> message = new LinkedList<String>();
                for (String[] valueArr : quoteEventRuleArray) {
                    message.add(valueArr[0] + "\uff0c" + valueArr[1]);
                }
                if (message.isEmpty()) continue;
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u4e8b\u4ef6\u89c4\u5219\u3010%1$s\u3011\u5f15\u7528\u4e86\u8be5\u4e1a\u52a1\u7ef4\u5ea6\u7ec4\u5408\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"FahBizDimCombineDeleteOp_2", (String)"fi-ai-opplugin", (Object[])new Object[0]), String.join((CharSequence)",", message)));
            }
        }
    }
}

