/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.validate;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.fi.ai.event.AiEventData;
import kd.fi.ai.event.AiEventUtil;
import kd.fi.ai.util.AiEventMetaUtil;
import kd.fi.ai.validate.AiEventClassMustInputValidator;
import kd.fi.bd.util.DebugTrace;
import kd.fi.v2.fah.models.modeling.impl.DataModelFieldCfg;

public class FieldRequiredValidatorHepler {
    private static Log logger = LogFactory.getLog(FieldRequiredValidatorHepler.class);

    public static Map<String, Tuple<String, String>> validateRequired(long modelId, List<AiEventData> aiEventDataList, Map<String, DataModelFieldCfg> fieldCfgMap, Set<String> requiredFields) {
        if (DebugTrace.enable()) {
            logger.info("FieldRequiredValidatorHepler.validateRequired, modelId: {}, requiredFields: {}, aiEventDataList.size: {}", new Object[]{modelId, requiredFields, aiEventDataList.size()});
        }
        if (CollectionUtils.isEmpty(requiredFields)) {
            return null;
        }
        if (CollectionUtils.isEmpty(aiEventDataList)) {
            return null;
        }
        MainEntityType modelType = AiEventMetaUtil.getEntityType((Object)modelId);
        HashMap<String, String> fieldNumberAndNameMap = new HashMap<String, String>(requiredFields.size());
        HashMap<String, String> FieldAndConditionMap = new HashMap<String, String>(requiredFields.size());
        for (String fieldNumber : requiredFields) {
            fieldNumberAndNameMap.put(fieldNumber, fieldCfgMap.get(fieldNumber).getName());
            String desc = fieldCfgMap.get(fieldNumber).getRequiredCondition();
            String expression = AiEventUtil.getFilterExpression((String)desc, (MainEntityType)modelType);
            FieldAndConditionMap.put(fieldNumber, expression);
        }
        AiEventClassMustInputValidator validator = new AiEventClassMustInputValidator(FieldAndConditionMap, modelId, aiEventDataList, fieldNumberAndNameMap);
        HashMap<String, Tuple<String, String>> msgMap = new HashMap<String, Tuple<String, String>>(2);
        BiConsumer<String, String[]> consumer = (extDataNum, fieldNumAndName) -> {
            String msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e3a\u5fc5\u5f55\u5b57\u6bb5\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u5f55\u5165\u6216\u5f55\u5165\u7684\u6570\u636e\u662f\u5426\u5408\u6cd5", (String)"FieldRequiredValidatorHepler_0", (String)"fi-ai-opplugin", (Object[])new Object[0]), fieldNumAndName[0]);
            msgMap.put((String)extDataNum, (Tuple<String, String>)Tuple.create((Object)fieldNumAndName[0], (Object)msg));
        };
        validator.doMustInputValidation(consumer, true);
        if (DebugTrace.enable()) {
            logger.info("FieldRequiredValidatorHepler.validateRequired, modelId: {}, requiredFields: {}, aiEventDataList.size: {}, msgMap: {}", new Object[]{modelId, requiredFields, aiEventDataList.size(), msgMap});
        }
        return msgMap;
    }
}

