/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.formula.excel;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.formula.excel.BinaryExpr;
import kd.bos.formula.excel.CompoundId;
import kd.bos.formula.excel.Expr;
import kd.bos.formula.excel.ExprList;
import kd.bos.formula.excel.FunCall;
import kd.bos.formula.excel.Literal;
import kd.bos.formula.excel.Macro;
import kd.bos.formula.excel.NamedExpr;
import kd.bos.formula.excel.Paren;
import kd.bos.formula.excel.UnaryExpr;

public class ExprUtil {
    public static Expr cloneExpr(Expr src) {
        if (src instanceof BinaryExpr) {
            BinaryExpr bepr = (BinaryExpr)src;
            return new BinaryExpr(bepr.getOperator(), ExprUtil.cloneExpr(bepr.getLeft()), ExprUtil.cloneExpr(bepr.getRight()));
        }
        if (src instanceof CompoundId) {
            return src;
        }
        if (src instanceof ExprList) {
            ExprList el = (ExprList)src;
            boolean paren = el.toString().startsWith("(");
            Expr[] elist = el.list;
            elist = Stream.of(elist).map(e -> ExprUtil.cloneExpr(e)).collect(Collectors.toList()).toArray(new Expr[0]);
            return new ExprList(elist, paren);
        }
        if (src instanceof FunCall) {
            FunCall fc = (FunCall)src;
            String fcStr = fc.toString();
            Expr[] elist = fc.getParams();
            elist = Stream.of(elist).map(e -> ExprUtil.cloneExpr(e)).collect(Collectors.toList()).toArray(new Expr[0]);
            int type = 0;
            type = fcStr.startsWith(fc.getName() + "(") ? 0 : (fcStr.endsWith("." + fc.getName()) ? 2 : 1);
            return new FunCall(fc.getName(), elist, type);
        }
        if (src instanceof Literal) {
            return (Literal)((Literal)src).clone();
        }
        if (src instanceof Macro) {
            Macro m = (Macro)src;
            return new Macro(m.toString());
        }
        if (src instanceof NamedExpr) {
            NamedExpr ne = (NamedExpr)src;
            String neStr = ne.toString();
            return new NamedExpr(ExprUtil.cloneExpr(ne.getExpr()), ne.getName(), neStr.endsWith(" AS " + ne.getName()));
        }
        if (src instanceof Paren) {
            Paren p = (Paren)src;
            return new Paren(ExprUtil.cloneExpr(p.getExpr()));
        }
        if (src instanceof UnaryExpr) {
            UnaryExpr ue = (UnaryExpr)src;
            return new UnaryExpr(ue.oper, ExprUtil.cloneExpr(ue.expr));
        }
        return null;
    }
}

