/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DBRoute;
import kd.bos.orm.sequence.SequenceReader;
import kd.fi.ai.builder.ISingleTaskContext;
import kd.fi.ai.mservice.builder.buildresult.GLVoucher;
import kd.fi.ai.mservice.builder.buildresult.GLVoucherEntry;
import kd.fi.ai.mservice.builder.buildresult.IVoucher;
import kd.fi.ai.mservice.builder.buildresult.IVoucherEntry;
import kd.fi.ai.util.VoucherSaveHelper;

public class GenVoucherMemoryMergeTask
implements Serializable {
    private static final long serialVersionUID = 5457581315270171371L;
    private String GenerateVoucherTaskProcess;
    private String billtype;
    private List<GLVoucher> curr_task_needMergeVoucher = new ArrayList<GLVoucher>();
    private int need_mergeVoucher_headerSize = 0;
    private int need_mergeVoucher_entrySize = 0;
    private Set<Long> progressTaskHasDone = new HashSet<Long>();
    private int curr_progress = 1;
    private Set<Long> curr_task_billids = new HashSet<Long>();
    private String vch_tpl_entry_sort = null;
    private Set<Long> need_del_gl_id = new HashSet<Long>();
    private List<DynamicObject> trackersNotToSave = new ArrayList<DynamicObject>();
    private boolean oneBill = false;
    private Map<Long, Integer> glVoucher_seq_entry = new HashMap<Long, Integer>(16);
    private boolean isSingleTask = false;
    private int single_currAcctBookSize = 0;
    private int single_currAcctBookHasDone = 0;
    private int single_currTaskSize = 0;
    private int single_currTaskHasDone = 0;
    private String buildVchTask_contextData = "";
    private Map<Long, Set<Long>> insertedEntryIdMap = new HashMap<Long, Set<Long>>(16);

    public GenVoucherMemoryMergeTask(String GenerateVoucherTaskProcess, Set<Long> curr_task_billids, String billtype) {
        this.GenerateVoucherTaskProcess = GenerateVoucherTaskProcess;
        this.curr_task_billids = curr_task_billids;
        this.billtype = billtype;
        if (curr_task_billids.size() <= 1000) {
            this.isSingleTask = true;
        }
        if (curr_task_billids.size() == 1) {
            this.oneBill = true;
        }
    }

    public boolean currAcctBookToDone(int endSize) {
        this.single_currAcctBookHasDone = endSize;
        this.currProgress();
        return true;
    }

    public boolean currTaskToDone(int endSize) {
        this.single_currTaskHasDone = endSize;
        this.currProgress();
        return true;
    }

    public boolean currTaskToDone(Set<Long> ids) {
        this.progressTaskHasDone.addAll(ids);
        this.currProgress();
        return true;
    }

    private void currProgress() {
        if (this.isSingleTask) {
            if (this.single_currAcctBookSize == 0) {
                this.curr_progress = 90;
                return;
            }
            int singleAcctBookProgress = 90 / this.single_currAcctBookSize;
            int curr_all_acctBook_progress = this.single_currAcctBookHasDone * singleAcctBookProgress;
            this.curr_progress = this.single_currAcctBookHasDone >= this.single_currAcctBookSize && this.single_currTaskHasDone >= this.single_currTaskSize ? 90 : (this.single_currTaskSize != 0 ? this.single_currTaskHasDone * singleAcctBookProgress / this.single_currTaskSize + curr_all_acctBook_progress : curr_all_acctBook_progress);
        } else {
            int allTask;
            int currHasDone = this.progressTaskHasDone.size();
            this.curr_progress = currHasDone >= (allTask = this.curr_task_billids.size()) ? 90 : currHasDone * 90 / allTask;
        }
    }

    public int getCurr_progress() {
        return this.curr_progress;
    }

    public List<GLVoucher> addCurrTaskVoucher(List<GLVoucher> currVoucher, ISingleTaskContext taskContext) {
        if (currVoucher.isEmpty() || this.need_mergeVoucher_headerSize >= 100000) {
            return currVoucher;
        }
        ArrayList<GLVoucher> result = new ArrayList<GLVoucher>();
        this.curr_task_needMergeVoucher.addAll(currVoucher);
        this.calculationGlvoucherSize();
        if (this.need_mergeVoucher_entrySize >= 200000) {
            this.curr_task_needMergeVoucher.sort(new Comparator<GLVoucher>(){

                @Override
                public int compare(GLVoucher a, GLVoucher b) {
                    int bs;
                    int as = a.getEntryRows().size();
                    if (as > (bs = b.getEntryRows().size())) {
                        return -1;
                    }
                    if (bs > as) {
                        return 1;
                    }
                    return 0;
                }
            });
            int i = 0;
            do {
                GLVoucher glVoucher = this.curr_task_needMergeVoucher.get(i);
                this.calculation_voucher_entrySeq_and_entryId(glVoucher, glVoucher.getId(), true, "fi", "t_gl_voucher");
                DynamicObject glD = glVoucher.toDynamicObjectVoucher(taskContext);
                VoucherSaveHelper.saveGLVoucherEntries(glVoucher.getOrgId(), glVoucher.getPeriodId(), (List<DynamicObject>)glD.getDynamicObjectCollection("entries"));
                if (taskContext.getBookInfo().isBudget()) {
                    List<GLVoucherEntry> entryRows = glVoucher.getEntryRows();
                    HashSet<Long> entryIdSet = new HashSet<Long>(entryRows.size());
                    for (GLVoucherEntry entry : entryRows) {
                        entryIdSet.add(entry.getEntryId());
                    }
                    this.addInsertedEntryIdMap(glVoucher.getId(), entryIdSet);
                }
                this.curr_task_needMergeVoucher.get(i).getEntryRows().clear();
                glVoucher.setPreSaveEntry(true);
                this.calculationGlvoucherSize();
                ++i;
            } while (this.need_mergeVoucher_entrySize >= 100000);
        }
        return result;
    }

    public boolean checkCanMerge() {
        return !this.curr_task_needMergeVoucher.isEmpty();
    }

    public String toMerge() {
        if (this.checkCanMerge()) {
            // empty if block
        }
        return null;
    }

    public String getGenerateVoucherTaskProcess() {
        return this.GenerateVoucherTaskProcess;
    }

    private boolean calculationGlvoucherSize() {
        List<GLVoucher> ctVoucher = this.curr_task_needMergeVoucher;
        this.need_mergeVoucher_headerSize = ctVoucher.size();
        this.need_mergeVoucher_entrySize = 0;
        for (GLVoucher g : ctVoucher) {
            this.need_mergeVoucher_entrySize += g.getEntryRows().size();
        }
        return true;
    }

    public String getVch_tpl_entry_sort() {
        return this.vch_tpl_entry_sort;
    }

    public void setVch_tpl_entry_sort(String vch_tpl_entry_sort) {
        this.vch_tpl_entry_sort = vch_tpl_entry_sort;
    }

    public Set<Long> getProgressTaskHasDone() {
        return this.progressTaskHasDone;
    }

    public List<GLVoucher> getCurr_task_needMergeVoucher() {
        return this.curr_task_needMergeVoucher;
    }

    public int getNeed_mergeVoucher_headerSize() {
        return this.need_mergeVoucher_headerSize;
    }

    public String getBilltype() {
        return this.billtype;
    }

    public void setBilltype(String billtype) {
        this.billtype = billtype;
    }

    public int getSingle_currAcctBookSize() {
        return this.single_currAcctBookSize;
    }

    public void setSingle_currAcctBookSize(int single_currAcctBookSize) {
        this.single_currAcctBookSize = single_currAcctBookSize;
    }

    public int getSingle_currTaskSize() {
        return this.single_currTaskSize;
    }

    public void setSingle_currTaskSize(int single_currTaskSize) {
        this.single_currTaskSize = single_currTaskSize;
    }

    public boolean isSingleTask() {
        return this.isSingleTask;
    }

    public int getSingle_currAcctBookHasDone() {
        return this.single_currAcctBookHasDone;
    }

    public int getSingle_currTaskHasDone() {
        return this.single_currTaskHasDone;
    }

    public Set<Long> getNeed_del_gl_id() {
        return this.need_del_gl_id;
    }

    public void addNeed_del_gl_id(Set<Long> need_del_gl_id) {
        this.need_del_gl_id.addAll(need_del_gl_id);
        if (need_del_gl_id.size() > 0) {
            this.curr_task_needMergeVoucher = this.curr_task_needMergeVoucher.stream().filter(f -> !need_del_gl_id.contains(f.getId())).collect(Collectors.toList());
            this.calculationGlvoucherSize();
        }
    }

    public List<DynamicObject> getTrackersNotToSave() {
        return this.trackersNotToSave;
    }

    public void setTrackersNotToSave(List<DynamicObject> trackersNotToSave) {
        this.trackersNotToSave.addAll(trackersNotToSave);
    }

    public boolean isOneBill() {
        return this.oneBill;
    }

    public void setOneBill(boolean oneBill) {
        this.oneBill = oneBill;
    }

    public Map<Long, Integer> getGlVoucher_seq_entry() {
        return this.glVoucher_seq_entry;
    }

    public Map<Long, Set<Long>> getInsertedEntryIdMap() {
        return this.insertedEntryIdMap;
    }

    public Set<Long> getInsertedEntryIdSet(Long id) {
        return this.insertedEntryIdMap.computeIfAbsent(id, k -> new HashSet());
    }

    public void calculation_voucher_entrySeq_and_entryId(IVoucher<?> voucher, Long voucherId, boolean onlySeq, String dbRouteKey, String entryTableName) {
        Integer integer = this.glVoucher_seq_entry.get(voucherId);
        int seq = integer != null ? integer : 1;
        for (IVoucherEntry row : voucher.getEntryRows()) {
            row.setSeq(seq);
            row.setId(voucherId);
            ++seq;
        }
        this.glVoucher_seq_entry.put(voucherId, seq);
        if (onlySeq) {
            return;
        }
        ArrayList allRows = new ArrayList();
        allRows.addAll(voucher.getEntryRows());
        if (allRows.size() == 0) {
            return;
        }
        SequenceReader sReader = new SequenceReader(new DBRoute(dbRouteKey));
        Long[] entryIds = (Long[])sReader.getSequences((Object[])new Long[allRows.size()], entryTableName, allRows.size());
        for (int i = 0; i < entryIds.length; ++i) {
            ((IVoucherEntry)allRows.get(i)).setEntryId(entryIds[i]);
        }
    }

    public String getBuildVchTask_contextData() {
        return this.buildVchTask_contextData;
    }

    public void setBuildVchTask_contextData(String buildVchTask_contextData) {
        this.buildVchTask_contextData = buildVchTask_contextData;
    }

    public void addInsertedEntryIdMap(Long id, Set<Long> entryIdSet) {
        Set set = this.insertedEntryIdMap.computeIfAbsent(id, k -> new HashSet());
        set.addAll(entryIdSet);
    }
}

