/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.lang.Lang;
import kd.fi.ai.VchTplAcctFactorMap;
import kd.fi.ai.VchTplAcctFilterCheckResult;
import kd.fi.ai.VchTplAcctFilterRow;

public class VchTplAcctFilter {
    private List<VchTplAcctFilterRow> filterRows = new ArrayList<VchTplAcctFilterRow>();
    private LocaleString description = new LocaleString();

    @CollectionPropertyAttribute(collectionItemPropertyType=VchTplAcctFilterRow.class)
    public List<VchTplAcctFilterRow> getFilterRows() {
        return this.filterRows;
    }

    public void setFilterRows(List<VchTplAcctFilterRow> filterRows) {
        this.filterRows = filterRows;
    }

    @SimplePropertyAttribute
    public LocaleString getDescription() {
        String defLangDesc = (String)this.description.getItem(Lang.defaultLang().toString());
        if (StringUtils.isBlank((CharSequence)defLangDesc)) {
            int seq = 1;
            StringBuilder sBuilder = new StringBuilder();
            for (VchTplAcctFilterRow row : this.filterRows) {
                sBuilder.append(row.getDescription());
                if (seq < this.filterRows.size()) {
                    sBuilder.append(' ').append(row.getLogic()).append(' ');
                }
                ++seq;
            }
            this.description.setItem(Lang.defaultLang().toString(), (Object)defLangDesc);
        }
        return this.description;
    }

    public void setDescription(LocaleString description) {
        this.description = description;
    }

    public VchTplAcctFilterCheckResult check() {
        VchTplAcctFilterRow row;
        int rowIndex;
        VchTplAcctFilterCheckResult checkResult = new VchTplAcctFilterCheckResult();
        StringBuilder sb = new StringBuilder();
        int leftBracketCount = 0;
        for (rowIndex = 1; rowIndex <= this.filterRows.size(); ++rowIndex) {
            row = this.filterRows.get(rowIndex - 1);
            if (!StringUtils.isBlank((CharSequence)row.getLeft())) {
                leftBracketCount += row.getLeft().length();
            }
            if (!StringUtils.isBlank((CharSequence)row.getRight())) {
                leftBracketCount -= row.getRight().length();
            }
            if (leftBracketCount >= 0) continue;
            checkResult.setPass(false);
            sb.append(String.format(ResManager.loadKDString((String)"\u5de6\u62ec\u53f7\u4e0e\u53f3\u62ec\u53f7\u4e0d\u5339\u914d\uff0c\u7b2c\u201c%1$s\u201d\u884c\u5b58\u5728\u591a\u4f59\u7684\u53f3\u62ec\u53f7\u201c)\u201d\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"VchTplAcctFilter_0", (String)"fi-ai-common", (Object[])new Object[0]), row.getSeq()));
            sb.append("\r\n");
        }
        if (leftBracketCount > 0) {
            checkResult.setPass(false);
            sb.append(String.format(ResManager.loadKDString((String)"\u5de6\u62ec\u53f7\u4e0e\u53f3\u62ec\u53f7\u4e0d\u5339\u914d\uff0c\u5b58\u5728%1$s\u4e2a\u591a\u4f59\u7684\u5de6\u62ec\u53f7\u201c(\u201d\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"VchTplAcctFilter_1", (String)"fi-ai-common", (Object[])new Object[0]), leftBracketCount));
            sb.append("\r\n");
        }
        for (rowIndex = 1; rowIndex < this.filterRows.size(); ++rowIndex) {
            row = this.filterRows.get(rowIndex - 1);
            if (!StringUtils.isBlank((CharSequence)row.getLogic())) continue;
            checkResult.setPass(false);
            sb.append(String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\uff0c\u7f3a\u5c11\u903b\u8f91\u7b26\u53f7\u3002", (String)"VchTplAcctFilter_2", (String)"fi-ai-common", (Object[])new Object[0]), row.getSeq()));
            sb.append("\r\n");
        }
        for (rowIndex = 1; rowIndex <= this.filterRows.size(); ++rowIndex) {
            row = this.filterRows.get(rowIndex - 1);
            if (StringUtils.isBlank((CharSequence)row.getSrcEntityNumber())) {
                checkResult.setPass(false);
                sb.append(String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\uff0c\u672a\u8bbe\u7f6e\u5f71\u54cd\u56e0\u7d20\u3002", (String)"VchTplAcctFilter_3", (String)"fi-ai-common", (Object[])new Object[0]), row.getSeq()));
                sb.append("\r\n");
                continue;
            }
            if (StringUtils.isBlank((CharSequence)row.getCompare())) {
                checkResult.setPass(false);
                sb.append(String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\uff0c\u672a\u9009\u62e9\u6bd4\u8f83\u7b26\u53f7\u3002", (String)"VchTplAcctFilter_4", (String)"fi-ai-common", (Object[])new Object[0]), row.getSeq()));
                sb.append("\r\n");
                continue;
            }
            if (!StringUtils.isBlank((CharSequence)row.getValue()) || row.getCompare().equalsIgnoreCase("@null") || row.getCompare().equalsIgnoreCase("@notnull")) continue;
            checkResult.setPass(false);
            sb.append(String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\uff0c\u672a\u8bbe\u7f6e\u6bd4\u8f83\u503c\u3002", (String)"VchTplAcctFilter_5", (String)"fi-ai-common", (Object[])new Object[0]), row.getSeq()));
            sb.append("\r\n");
        }
        checkResult.setMessage(sb.toString());
        return checkResult;
    }

    public String getExpression(List<VchTplAcctFactorMap> factorMaps) {
        HashMap<String, VchTplAcctFactorMap> maps = new HashMap<String, VchTplAcctFactorMap>(factorMaps.size());
        for (VchTplAcctFactorMap map : factorMaps) {
            maps.put(map.getFactor(), map);
        }
        int seq = 1;
        StringBuilder sBuilder = new StringBuilder();
        for (VchTplAcctFilterRow row : this.filterRows) {
            sBuilder.append(row.getExpression(maps));
            if (seq < this.filterRows.size()) {
                sBuilder.append(' ').append(row.getLogic()).append(' ');
            }
            ++seq;
        }
        return sBuilder.toString();
    }
}

