/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.accountversion;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.ext.fi.accountref.AccountTableRef;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ai.VCHTemplate;
import kd.fi.ai.VchTplAccount;
import kd.fi.ai.VchTplAccts;
import kd.fi.ai.VchTplBizGroup;
import kd.fi.ai.VchTplEntry;
import kd.fi.ai.accountversion.AccountVersionBackup;
import kd.fi.ai.accountversion.VersionBackupUtil;

public class VchTemplateVersion {
    private static Log logger = LogFactory.getLog(VchTemplateVersion.class);

    public static void enable(long orgId, Date enableDate, AccountTableRef accountIdRef) {
        QFilter orgQF = new QFilter("createorg", "=", (Object)orgId);
        QFilter accountTableQF = new QFilter("faccttableid", "=", (Object)accountIdRef.getOldAccountTableId());
        String select = "id,number,fxml,faccttableid";
        DynamicObject[] vchTpls = BusinessDataServiceHelper.load((String)"ai_vchtemplate", (String)select, (QFilter[])new QFilter[]{orgQF, accountTableQF});
        ArrayList<AccountVersionBackup> list = new ArrayList<AccountVersionBackup>();
        Map<Long, List<String>> nameAndNmuber = VchTemplateVersion.getNewAcctNameAndNmuber(accountIdRef.getNewAccountIdSet());
        for (DynamicObject vchTpl : vchTpls) {
            logger.info("\u5f00\u59cb\u66ff\u6362\u51ed\u8bc1\u6a21\u677f\u56fa\u5b9a\u503c\u79d1\u76ee\uff1a" + vchTpl.getString("number"));
            vchTpl.set("number", (Object)vchTpl.getString("number"));
            String xml = vchTpl.getString("fxml");
            VCHTemplate template = VCHTemplate.deserializeFromString(xml, null);
            template.setAcctTableId(accountIdRef.getNewAccountTableId());
            for (VchTplBizGroup group : template.getBizGroups()) {
                for (VchTplEntry entry : group.getVchEntrys()) {
                    if (!Objects.equals(entry.getAcctsSet().getSourcetype(), "conditionexp")) continue;
                    boolean isModify = false;
                    VchTplAccts acctsSet = entry.getAcctsSet();
                    StringBuilder strB = new StringBuilder();
                    for (VchTplAccount account : acctsSet.getVchTplAcccounts().getItems()) {
                        long oldAcct = account.getAccountid();
                        Long newAcc = accountIdRef.getNewAccountId(Long.valueOf(oldAcct));
                        logger.info("\u65e7\u79d1\u76eeID\uff1a" + oldAcct);
                        logger.info("\u65b0\u79d1\u76eeID\uff1a" + newAcc);
                        if (newAcc != null && newAcc != 0L) {
                            List<String> namelist = nameAndNmuber.get(newAcc);
                            account.setAccountid(newAcc);
                            String name = "";
                            String number = "";
                            if (namelist != null) {
                                name = namelist.get(0);
                                number = namelist.get(1);
                            } else {
                                DynamicObject accountName = QueryServiceHelper.queryOne((String)"bd_accountview", (String)"name,number", (QFilter[])new QFilter("id", "=", (Object)newAcc).toArray());
                                name = accountName.getString("name");
                                number = accountName.getString("number");
                            }
                            account.setAccountNumber(number);
                            account.setAcctName(name);
                            strB.append(number);
                            strB.append(name);
                            strB.append('/');
                            list.add(VersionBackupUtil.genVchTemplateBackUp(orgId, oldAcct, enableDate, accountIdRef, vchTpl.getLong("id")));
                            isModify = true;
                            continue;
                        }
                        strB.append(account.getAccountNumber());
                        strB.append(account.getAcctName());
                        strB.append('/');
                    }
                    if (!isModify || strB.length() <= 0) continue;
                    acctsSet.setAcctName(strB.substring(0, strB.length() - 1));
                }
            }
            vchTpl.set("faccttableid", (Object)accountIdRef.getNewAccountTableId());
            list.add(VersionBackupUtil.genVchTemplateTableBackUp(orgId, enableDate, accountIdRef, vchTpl.getLong("id")));
            Map<String, String> jsonDatas = template.serializeToString();
            vchTpl.set("fxml", (Object)jsonDatas.get("json"));
        }
        VchTemplateVersion.saveInfo(vchTpls, list);
    }

    public static void disable(long orgId, Date disableDate, AccountTableRef accountIdRef) {
        QFilter metaQF = new QFilter("metadata", "=", (Object)"ai_vchtemplateedit");
        QFilter orgQF = new QFilter("org", "=", (Object)orgId);
        QFilter dateQF = new QFilter("versiondate", "=", (Object)disableDate);
        if (accountIdRef.getOldAccountTableId() != accountIdRef.getNewAccountTableId()) {
            dateQF.and(new QFilter("reaccountid", "in", (Object)accountIdRef.getOldAccountIdSet()));
        } else {
            dateQF.and(new QFilter("afaccountid", "in", (Object)accountIdRef.getNewAccountIdSet()));
        }
        String select = "id,afaccountid,reaccountid,dataid";
        DynamicObjectCollection records = QueryServiceHelper.query((String)"bd_account_updaterecord", (String)select, (QFilter[])new QFilter[]{metaQF, orgQF, dateQF});
        if (records.isEmpty()) {
            return;
        }
        HashSet<Long> ids = new HashSet<Long>();
        HashMap<Long, Long> map = new HashMap<Long, Long>();
        for (DynamicObject record : records) {
            ids.add(record.getLong("dataid"));
            map.put(record.getLong("afaccountid"), record.getLong("reaccountid"));
        }
        if (!ids.isEmpty() && !map.isEmpty()) {
            DynamicObject[] replyRecord;
            if (accountIdRef.getOldAccountTableId() != accountIdRef.getNewAccountTableId()) {
                replyRecord = VchTemplateVersion.replyRecord(ids, map, accountIdRef.getOldAccountTableId());
                SaveServiceHelper.save((DynamicObject[])replyRecord);
            } else {
                replyRecord = VchTemplateVersion.replyRecordBySingle(ids, map, accountIdRef);
                SaveServiceHelper.save((DynamicObject[])replyRecord);
            }
        }
        QFilter tableQF = new QFilter("fieldtype", "=", (Object)"accttable");
        DynamicObjectCollection tableRecords = QueryServiceHelper.query((String)"bd_account_updaterecord", (String)select, (QFilter[])new QFilter[]{metaQF, orgQF, dateQF, tableQF});
        HashSet<Long> tableids = new HashSet<Long>();
        for (DynamicObject tableRecord : tableRecords) {
            tableids.add(tableRecord.getLong("dataid"));
        }
        VchTemplateVersion.getVchInfo(orgId, disableDate, accountIdRef, tableids);
        if (!tableids.isEmpty()) {
            DynamicObject[] replyRecord = VchTemplateVersion.replyTableRecord(tableids, accountIdRef.getOldAccountTableId());
            SaveServiceHelper.save((DynamicObject[])replyRecord);
        }
        HashSet<Long> allIds = new HashSet<Long>();
        allIds.addAll(tableids);
        allIds.addAll(ids);
        if (!allIds.isEmpty()) {
            DeleteServiceHelper.delete((String)"bd_account_updaterecord", (QFilter[])new QFilter("dataid", "in", allIds).toArray());
        }
    }

    private static DynamicObject[] replyRecord(Set<Long> ids, Map<Long, Long> map, long oldAccountTableId) {
        DynamicObject[] vchTpls = BusinessDataServiceHelper.load((String)"ai_vchtemplate", (String)"id,fxml,faccttableid", (QFilter[])new QFilter("id", "in", ids).toArray());
        Map<Long, List<String>> nameAndNmuber = VchTemplateVersion.getNewAcctNameAndNmuber(map.keySet());
        for (DynamicObject vchTpl : vchTpls) {
            String xml = vchTpl.getString("fxml");
            vchTpl.set("faccttableid", (Object)oldAccountTableId);
            VCHTemplate template = VCHTemplate.deserializeFromString(xml, null);
            template.setAcctTableId(oldAccountTableId);
            template.setAcctTableId(oldAccountTableId);
            for (VchTplBizGroup group : template.getBizGroups()) {
                for (VchTplEntry entry : group.getVchEntrys()) {
                    if (!Objects.equals(entry.getAcctsSet().getSourcetype(), "conditionexp")) continue;
                    VchTplAccts acctsSet = entry.getAcctsSet();
                    StringBuilder strB = new StringBuilder();
                    for (VchTplAccount account : acctsSet.getVchTplAcccounts().getItems()) {
                        long acct = account.getAccountid();
                        if (map.containsKey(acct)) {
                            List<String> namelist = nameAndNmuber.get(map.get(acct));
                            account.setAccountid(map.get(acct));
                            String name = "";
                            String number = "";
                            if (namelist != null) {
                                name = namelist.get(0);
                                number = namelist.get(1);
                            } else {
                                DynamicObject accountName = QueryServiceHelper.queryOne((String)"bd_accountview", (String)"name,number", (QFilter[])new QFilter("id", "=", (Object)map.get(acct)).toArray());
                                name = accountName.getString("name");
                                number = accountName.getString("number");
                            }
                            account.setAccountNumber(number);
                            account.setAcctName(name);
                            strB.append(number);
                            strB.append(name);
                            strB.append('/');
                            continue;
                        }
                        strB.append(account.getAccountNumber());
                        strB.append(account.getAcctName());
                        strB.append('/');
                    }
                    acctsSet.setAcctName(strB.substring(0, strB.length() - 1));
                }
            }
            Map<String, String> jsonDatas = template.serializeToString();
            vchTpl.set("fxml", (Object)jsonDatas.get("json"));
        }
        return vchTpls;
    }

    private static DynamicObject[] replyTableRecord(Set<Long> ids, long oldAccountTableId) {
        DynamicObject[] vchTpls;
        for (DynamicObject vchTpl : vchTpls = BusinessDataServiceHelper.load((String)"ai_vchtemplate", (String)"id,fxml,faccttableid", (QFilter[])new QFilter("id", "in", ids).toArray())) {
            String xml = vchTpl.getString("fxml");
            vchTpl.set("faccttableid", (Object)oldAccountTableId);
            VCHTemplate template = VCHTemplate.deserializeFromString(xml, null);
            template.setAcctTableId(oldAccountTableId);
            Map<String, String> jsonDatas = template.serializeToString();
            vchTpl.set("fxml", (Object)jsonDatas.get("json"));
        }
        return vchTpls;
    }

    private static void saveInfo(DynamicObject[] accountInfo, List<AccountVersionBackup> backups) {
        try (TXHandle h = TX.required((String)"accountmappingversion");){
            try {
                SaveServiceHelper.save((DynamicObject[])accountInfo);
                VersionBackupUtil.saveVersionBackup(backups);
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
    }

    private static Map<Long, List<String>> getNewAcctNameAndNmuber(Collection<Long> accountIds) {
        DynamicObjectCollection accounts = QueryServiceHelper.query((String)"bd_accountview", (String)"id,name,number", (QFilter[])new QFilter("id", "in", accountIds).toArray());
        HashMap<Long, List<String>> map = new HashMap<Long, List<String>>(accounts.size());
        for (DynamicObject account : accounts) {
            map.put(account.getLong("id"), Arrays.asList(account.getString("name"), account.getString("number")));
        }
        return map;
    }

    private static void getVchInfo(long orgId, Date enableDate, AccountTableRef accountIdRef, Set<Long> tableids) {
        QFilter orgQF = new QFilter("createorg", "=", (Object)orgId);
        QFilter accountTableQF = new QFilter("faccttableid", "=", (Object)accountIdRef.getNewAccountTableId());
        DynamicObjectCollection vchs = QueryServiceHelper.query((String)"ai_vchtemplate", (String)"id", (QFilter[])new QFilter[]{orgQF, accountTableQF});
        for (DynamicObject vch : vchs) {
            tableids.add(vch.getLong("id"));
        }
    }

    private static DynamicObject[] replyRecordBySingle(Set<Long> ids, Map<Long, Long> map, AccountTableRef accountIdRef) {
        DynamicObject[] vchTpls = BusinessDataServiceHelper.load((String)"ai_vchtemplate", (String)"id,fxml,faccttableid", (QFilter[])new QFilter("id", "in", ids).toArray());
        Map oldAndNewAccountRef = accountIdRef.getAccountRef().getOldAndNewAccountRef();
        Map<Long, List<String>> nameAndNmuber = VchTemplateVersion.getNewAcctNameAndNmuber(oldAndNewAccountRef.keySet());
        for (DynamicObject vchTpl : vchTpls) {
            String xml = vchTpl.getString("fxml");
            VCHTemplate template = VCHTemplate.deserializeFromString(xml, null);
            for (VchTplBizGroup group : template.getBizGroups()) {
                for (VchTplEntry entry : group.getVchEntrys()) {
                    if (!Objects.equals(entry.getAcctsSet().getSourcetype(), "conditionexp")) continue;
                    VchTplAccts acctsSet = entry.getAcctsSet();
                    StringBuilder strB = new StringBuilder();
                    for (VchTplAccount account : acctsSet.getVchTplAcccounts().getItems()) {
                        long acct = account.getAccountid();
                        for (Map.Entry oldAndNewEntry : oldAndNewAccountRef.entrySet()) {
                            if ((Long)oldAndNewEntry.getValue() == acct) {
                                List<String> namelist = nameAndNmuber.get(map.get(acct));
                                account.setAccountid(map.get(acct));
                                String name = "";
                                String number = "";
                                if (namelist != null) {
                                    name = namelist.get(0);
                                    number = namelist.get(1);
                                } else {
                                    DynamicObject accountName = QueryServiceHelper.queryOne((String)"bd_accountview", (String)"name,number", (QFilter[])new QFilter("id", "=", (Object)map.get(acct)).toArray());
                                    name = accountName.getString("name");
                                    number = accountName.getString("number");
                                }
                                account.setAccountNumber(number);
                                account.setAcctName(name);
                                strB.append(number);
                                strB.append(name);
                                strB.append('/');
                                continue;
                            }
                            strB.append(account.getAccountNumber());
                            strB.append(account.getAcctName());
                            strB.append('/');
                        }
                    }
                    acctsSet.setAcctName(strB.substring(0, strB.length() - 1));
                }
            }
            Map<String, String> jsonDatas = template.serializeToString();
            vchTpl.set("fxml", (Object)jsonDatas.get("json"));
        }
        return vchTpls;
    }
}

