/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.accountversion;

import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.ext.fi.accountref.AccountTableRef;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ai.accountversion.AccountVersionBackup;

public class VersionBackupUtil {
    public static final String VERSION = "bd_account_updaterecord";
    public static final String RECORD_DATAID = "dataid";
    public static final String RECORD_DATAENTRYID = "dataentryid";
    public static final String RECORD_REACCOUNTID = "reaccountid";
    public static final String RECORD_AFACCOUNTID = "afaccountid";
    public static final String RECORD_VERSIONDATE = "versiondate";
    public static final String RECORD_ORG = "org";
    public static final String RECORD_METADATA = "metadata";
    public static final String RECORD_FIELDNAME = "fieldname";
    public static final String RECORD_FIELDTYPE = "fieldtype";

    public static AccountVersionBackup genAccountMappingAcctBackUp(long orgId, long oldAccountId, Date enableDate, AccountTableRef accountIdRef, long id, long entryid, String fieldName) {
        AccountVersionBackup acctBackup = new AccountVersionBackup();
        acctBackup.setReaccountid(oldAccountId);
        acctBackup.setAfaccountid(accountIdRef.getNewAccountId(Long.valueOf(oldAccountId)));
        acctBackup.setDataentryid(entryid);
        acctBackup.setDataid(id);
        acctBackup.setEntryname("entryentity");
        acctBackup.setFieldname(fieldName);
        acctBackup.setFieldtype("acct");
        acctBackup.setMetadata("ai_accountmaptype");
        acctBackup.setOrg(orgId);
        acctBackup.setVersiondate(enableDate);
        return acctBackup;
    }

    public static AccountVersionBackup genAccountMappingTableBackUp(long orgId, Date enableDate, AccountTableRef accountIdRef, long id, long entryid) {
        AccountVersionBackup acctBackup = new AccountVersionBackup();
        acctBackup.setReaccountid(accountIdRef.getOldAccountTableId());
        acctBackup.setAfaccountid(accountIdRef.getNewAccountTableId());
        acctBackup.setDataentryid(entryid);
        acctBackup.setDataid(id);
        acctBackup.setEntryname("acctmapentry");
        acctBackup.setFieldname("entryaccttable");
        acctBackup.setFieldtype("accttable");
        acctBackup.setMetadata("ai_accountmaptype");
        acctBackup.setOrg(orgId);
        acctBackup.setVersiondate(enableDate);
        return acctBackup;
    }

    public static AccountVersionBackup genVchTemplateBackUp(long orgId, long oldAccountId, Date enableDate, AccountTableRef accountIdRef, long id) {
        AccountVersionBackup acctBackup = new AccountVersionBackup();
        acctBackup.setReaccountid(oldAccountId);
        acctBackup.setAfaccountid(accountIdRef.getNewAccountId(Long.valueOf(oldAccountId)));
        acctBackup.setDataentryid(0L);
        acctBackup.setDataid(id);
        acctBackup.setEntryname("entryentity");
        acctBackup.setFieldname("faccountdesc");
        String type = accountIdRef.getNewAccountTableId() == accountIdRef.getOldAccountTableId() ? "acct" : "accttable";
        acctBackup.setFieldtype(type);
        acctBackup.setMetadata("ai_vchtemplateedit");
        acctBackup.setOrg(orgId);
        acctBackup.setVersiondate(enableDate);
        return acctBackup;
    }

    public static AccountVersionBackup genVchTemplateTableBackUp(long orgId, Date enableDate, AccountTableRef accountIdRef, long id) {
        AccountVersionBackup acctBackup = new AccountVersionBackup();
        acctBackup.setReaccountid(accountIdRef.getOldAccountTableId());
        acctBackup.setAfaccountid(accountIdRef.getNewAccountTableId());
        acctBackup.setDataentryid(0L);
        acctBackup.setDataid(id);
        acctBackup.setFieldtype("accttable");
        acctBackup.setMetadata("ai_vchtemplateedit");
        acctBackup.setOrg(orgId);
        acctBackup.setVersiondate(enableDate);
        return acctBackup;
    }

    public static void saveVersionBackup(List<AccountVersionBackup> backups) {
        DynamicObject[] dyos = new DynamicObject[backups.size()];
        int index = 0;
        DynamicObject versionBackup = null;
        for (AccountVersionBackup backup : backups) {
            versionBackup = BusinessDataServiceHelper.newDynamicObject((String)VERSION);
            versionBackup.set(RECORD_METADATA, (Object)backup.getMetadata());
            versionBackup.set(RECORD_FIELDTYPE, (Object)backup.getFieldtype());
            versionBackup.set(RECORD_FIELDNAME, (Object)backup.getFieldname());
            versionBackup.set("entryname", (Object)backup.getEntryname());
            versionBackup.set(RECORD_ORG, (Object)backup.getOrg());
            versionBackup.set(RECORD_REACCOUNTID, (Object)backup.getReaccountid());
            versionBackup.set(RECORD_AFACCOUNTID, (Object)backup.getAfaccountid());
            versionBackup.set(RECORD_DATAID, (Object)backup.getDataid());
            versionBackup.set(RECORD_DATAENTRYID, (Object)backup.getDataentryid());
            versionBackup.set(RECORD_VERSIONDATE, (Object)backup.getVersiondate());
            versionBackup.set("creater", (Object)Long.valueOf(RequestContext.get().getUserId()));
            versionBackup.set("createdate", (Object)new Date());
            dyos[index++] = versionBackup;
        }
        SaveServiceHelper.save((DynamicObject[])dyos);
    }
}

