/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.accsys;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.AppMetadataCache;
import kd.bos.ext.fi.accountref.AccountRefUtils;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.ai.accsys.AccountBookInfo;
import kd.fi.ai.cache.CacheHelper;
import kd.fi.ai.cache.CacheKey;
import kd.fi.ai.cache.CacheModule;
import kd.fi.ai.cache.DistributeCache;
import kd.fi.ai.cache.ThreadCacheKey;
import kd.fi.ai.enums.PermissonType;
import kd.fi.ai.util.ContextUtil;
import kd.fi.ai.util.GLUtil;

public class AccSysUtil {
    private AccSysUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static AccountBookInfo getBookFromAccSys(long org, long bookType) {
        return (AccountBookInfo)ThreadCache.get((Object)ThreadCacheKey.getAccountBookKey(org, bookType), () -> {
            Long bookId = AccSysUtil.getBookIdFromCache(org, bookType);
            return bookId == null ? null : new AccountBookInfo(bookId);
        });
    }

    public static AccountBookInfo getBookFromAccSys(String orgNumber, String bookTypeNumber) {
        return (AccountBookInfo)ThreadCache.get((Object)ThreadCacheKey.getAccountBookKey(orgNumber, bookTypeNumber), () -> {
            Long bookId = AccSysUtil.getBookIdFromCache(orgNumber, bookTypeNumber);
            return bookId == null ? null : new AccountBookInfo(bookId);
        });
    }

    public static List<AccountBookInfo> getBookFromAccSys(Set<Long> orgSet, long bookType) {
        ArrayList<AccountBookInfo> result = new ArrayList<AccountBookInfo>();
        for (Long org : orgSet) {
            AccountBookInfo bookInfo = AccSysUtil.getBookFromAccSys(org, bookType);
            if (bookInfo == null) continue;
            result.add(bookInfo);
        }
        return result;
    }

    public static AccountBookInfo getDefaultBookFromAccSys(Long orgId) {
        return (AccountBookInfo)ThreadCache.get((Object)ThreadCacheKey.getDefAccountBookIdKey(orgId), () -> {
            Long bookId = AccSysUtil.getDefBookIdFromCache(orgId);
            return bookId == null ? null : new AccountBookInfo(bookId);
        });
    }

    public static List<Long> getAllBookFromAccSys(long orgId) {
        return (List)ThreadCache.get((Object)ThreadCacheKey.getAllBookIdKey(orgId), () -> {
            QFilter h = new QFilter("org", "=", (Object)orgId);
            DynamicObjectCollection coll = QueryServiceHelper.query((String)"gl_accountbook", (String)"id", (QFilter[])new QFilter[]{h}, (String)"bookstype.accounttype");
            ArrayList<Long> idList = new ArrayList<Long>();
            for (DynamicObject obj : coll) {
                idList.add(obj.getLong("id"));
            }
            return idList;
        });
    }

    public static DynamicObject loadSingleBook(Object orgId, Object bookTypeId, String sel) {
        Long bookId = AccSysUtil.getBookIdFromCache((Long)orgId, (Long)bookTypeId);
        return bookId == null ? null : BusinessDataServiceHelper.loadSingleFromCache((Object)bookId, (String)"gl_accountbook", (String)sel);
    }

    private static Long getBookIdFromCache(long org, long bookType) {
        return (Long)ThreadCache.get((Object)ThreadCacheKey.getBookIdKey(org, bookType), () -> {
            long result;
            String key = CacheKey.getKey(org, bookType);
            DistributeCache cache = CacheHelper.getDistributeCache(CacheModule.book);
            String bookIdStr = cache.get(key);
            if (StringUtils.isEmpty((String)bookIdStr)) {
                QFilter orgF = new QFilter("org", "=", (Object)org);
                QFilter bookTypeF = new QFilter("bookstype", "=", (Object)bookType);
                DynamicObject book = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)"id", (QFilter[])new QFilter[]{orgF, bookTypeF});
                if (book == null) {
                    return null;
                }
                result = book.getLong("id");
                cache.put(key, String.valueOf(result));
            } else {
                result = Long.parseLong(bookIdStr);
            }
            return result;
        });
    }

    private static Long getBookIdFromCache(String orgNumber, String bookTypeNumber) {
        return (Long)ThreadCache.get((Object)ThreadCacheKey.getBookIdKey(orgNumber, bookTypeNumber), () -> {
            long result;
            String key = orgNumber + "-" + bookTypeNumber;
            DistributeCache cache = CacheHelper.getDistributeCache(CacheModule.book);
            String bookIdStr = cache.get(key);
            if (StringUtils.isEmpty((String)bookIdStr)) {
                QFilter orgF = new QFilter("org.number", "=", (Object)orgNumber);
                QFilter bookTypeF = new QFilter("bookstype.number", "=", (Object)bookTypeNumber);
                DynamicObjectCollection book = QueryServiceHelper.query((String)"gl_accountbook", (String)"id", (QFilter[])new QFilter[]{orgF, bookTypeF});
                if (book.size() == 0) {
                    return null;
                }
                result = ((DynamicObject)book.get(0)).getLong("id");
                cache.put(key, String.valueOf(result));
            } else {
                result = Long.parseLong(bookIdStr);
            }
            return result;
        });
    }

    private static Long getDefBookIdFromCache(Long orgId) {
        return (Long)ThreadCache.get((Object)ThreadCacheKey.getDefBookIdKey(orgId), () -> {
            QFilter qf = new QFilter("org", "=", (Object)orgId);
            DynamicObjectCollection bookColl = QueryServiceHelper.query((String)"gl_accountbook", (String)"id", (QFilter[])qf.toArray(), (String)"bookstype.accounttype", (int)1);
            return bookColl == null || bookColl.size() <= 0 ? null : Long.valueOf(((DynamicObject)bookColl.get(0)).getLong("id"));
        });
    }

    public static boolean isBizUnit(long orgId) {
        QFilter qFilter = new QFilter("org", "=", (Object)orgId);
        DynamicObject dyn = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)"id,isbizunit", (QFilter[])new QFilter[]{qFilter});
        if (dyn == null) {
            return false;
        }
        return dyn.getBoolean("isbizunit");
    }

    public static List<ComboItem> getAcctOrgComboItem(String entityId, boolean isIncludeUnit, PermissonType permType) {
        LinkedHashSet<Long> orgSet = new LinkedHashSet<Long>();
        String appId = AppMetadataCache.getAppInfo((String)"iep").getId();
        HasPermOrgResult permOrgRs = PermissionServiceHelper.getAllPermOrgs((Long)ContextUtil.getUserId(), (String)appId, (String)entityId, (String)permType.getPermId());
        List permOrgs = new ArrayList();
        QFilter orgFilter1 = new QFilter("view.number", "=", (Object)"10");
        try (DataSet orgCol = QueryServiceHelper.queryDataSet((String)"kd.fi.ai.accsys.AccSysUtil", (String)"bos_org_structure", (String)"org", (QFilter[])new QFilter[]{orgFilter1}, null);){
            for (Row r : orgCol) {
                orgSet.add(r.getLong("org"));
            }
        }
        if (!permOrgRs.hasAllOrgPerm()) {
            permOrgs = permOrgRs.getHasPermOrgs();
            orgSet.retainAll(permOrgs);
        }
        QFilter orgFilter = new QFilter("id", "in", orgSet);
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        try (DataSet orgCol = QueryServiceHelper.queryDataSet((String)"kd.fi.ai.accsys.AccSysUtil", (String)"bos_org", (String)"id orgId,number,name orgname", (QFilter[])new QFilter[]{orgFilter}, (String)"number");){
            for (Row r : orgCol) {
                ComboItem c = new ComboItem();
                String orgPk = r.getString("orgId");
                c.setCaption(new LocaleString(r.getString("orgname")));
                c.setValue(orgPk);
                comboItems.add(c);
            }
        }
        return comboItems;
    }

    public static List<ComboItem> getBookTypeComboByOrg(long orgId) {
        ArrayList<ComboItem> result = new ArrayList<ComboItem>();
        DynamicObjectCollection query = QueryServiceHelper.query((String)"gl_accountbook", (String)"org,bookstype,bookstype.name btname", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("isbizunit", "=", (Object)"1")});
        for (DynamicObject dyn : query) {
            ComboItem item = new ComboItem();
            long bookstype = dyn.getLong("bookstype");
            String btname = dyn.getString("btname");
            item.setCaption(new LocaleString(btname));
            item.setValue(String.valueOf(bookstype));
            result.add(item);
        }
        return result;
    }

    public static QFilter getAcctOrgFilter(String entityId, boolean isIncludeUnit, PermissonType permType) {
        List<Long> orgIds = AccSysUtil.getAcctOrgPkList(entityId, isIncludeUnit, permType);
        return new QFilter("id", "in", orgIds);
    }

    public static long getAccountingOrg(String entityId, boolean isIncludeUnit, PermissonType permType) {
        List<Long> orgIds = AccSysUtil.getAcctOrgPkList(entityId, isIncludeUnit, permType);
        long orgId = 0L;
        if (!orgIds.isEmpty()) {
            HashSet<Long> orgIdSet = new HashSet<Long>(orgIds);
            Long curLoginOrg = RequestContext.get().getOrgId();
            orgId = orgIdSet.contains(curLoginOrg) ? curLoginOrg.longValue() : orgIds.get(0).longValue();
        }
        return orgId;
    }

    public static List<Long> getAcctOrgPkList(String entityId, boolean isIncludeUnit, PermissonType permType) {
        String appId = AppMetadataCache.getAppInfo((String)"iep").getId();
        HasPermOrgResult permOrgRs = PermissionServiceHelper.getAllPermOrgs((Long)ContextUtil.getUserId(), (String)appId, (String)entityId, (String)permType.getPermId());
        LinkedHashSet<Long> orgSet = new LinkedHashSet<Long>();
        Map<Long, Set<Long>> viewOrgMap = isIncludeUnit ? AccSysUtil.getViewOrgMap() : AccSysUtil.getMainViewOrgMap();
        for (Set<Long> orgs : viewOrgMap.values()) {
            orgSet.addAll(orgs);
        }
        List permOrgs = new ArrayList();
        if (!permOrgRs.hasAllOrgPerm()) {
            permOrgs = permOrgRs.getHasPermOrgs();
            orgSet.retainAll(permOrgs);
        }
        HashSet permChildOrg = new HashSet(orgSet);
        if (isIncludeUnit) {
            Map<Long, Set> filteredViewOrgMap = viewOrgMap.entrySet().stream().filter(x -> {
                Set value = (Set)x.getValue();
                value.retainAll(permChildOrg);
                return !value.isEmpty();
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            LinkedHashSet parentOrgs = new LinkedHashSet();
            try (DataSet orgStructureByViews = AccSysUtil.getOrgStructureByViews(filteredViewOrgMap.keySet());){
                for (Map.Entry<Long, Set> entry : filteredViewOrgMap.entrySet()) {
                    List<Object> rs = new LinkedList();
                    Set orgs = entry.getValue();
                    orgs.retainAll(orgSet);
                    if (!orgs.isEmpty()) {
                        try (DataSet orgDataSet = orgStructureByViews.copy().filter("view = " + entry.getKey());){
                            rs = AccSysUtil.getParentOrgId(orgDataSet, (Set<Long>)orgs, false);
                        }
                    }
                    parentOrgs.addAll(rs);
                }
            }
            if (!permOrgRs.hasAllOrgPerm()) {
                parentOrgs.retainAll(permOrgs);
            }
            parentOrgs.addAll(orgSet);
            orgSet = parentOrgs;
        }
        return new ArrayList<Long>(orgSet);
    }

    public static Long getMainViewByOrgAndBT(Long orgId, Long bookTypeId) {
        Map<Long, Map<Long, List<Long>>> mainViewOrgBTMap = AccSysUtil.getMainViewOrgBTMap();
        for (Map.Entry<Long, Map<Long, List<Long>>> entry : mainViewOrgBTMap.entrySet()) {
            Map<Long, List<Long>> orgBTMap = entry.getValue();
            for (Map.Entry<Long, List<Long>> listEntry : orgBTMap.entrySet()) {
                if (!listEntry.getKey().equals(orgId) || !listEntry.getValue().contains(bookTypeId)) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    public static Set<Long> getViewByOrg(Long orgId) {
        Map<Long, Set<Long>> viewOrgMap = AccSysUtil.getViewOrgMap();
        Map<Long, Set<Long>> statViewOrgMap = AccSysUtil.getStatViewOrgMap();
        LinkedHashSet<Long> viewList = new LinkedHashSet<Long>();
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter viewFilter = new QFilter("view", "in", viewOrgMap.keySet());
        DynamicObjectCollection orgStructure = QueryServiceHelper.query((String)"bos_org_structure", (String)"view,view.number number", (QFilter[])new QFilter[]{orgFilter, viewFilter});
        orgStructure.sort((v1, v2) -> {
            String num1 = v1.getString("number");
            if (num1 == null) {
                return -1;
            }
            String num2 = v2.getString("number");
            if (num2 == null) {
                return 1;
            }
            String[] split1 = num1.split(":");
            String[] split2 = num2.split(":");
            String splitNum1 = split1.length > 1 ? split1[1] : split1[0];
            String splitNum2 = split2.length > 1 ? split2[1] : split2[0];
            return splitNum1.compareTo(splitNum2);
        });
        for (DynamicObject dyn : orgStructure) {
            long view = dyn.getLong("view");
            Set<Long> orgs = statViewOrgMap.get(view);
            if (orgs != null && orgs.contains(orgId)) continue;
            viewList.add(view);
        }
        LinkedHashSet<Long> result = new LinkedHashSet<Long>();
        try (DataSet orgStructureByViews = AccSysUtil.getOrgStructureByViews(viewList);){
            for (Long view : viewList) {
                Set<Long> orgs = viewOrgMap.get(view);
                HashSet<Long> parentOrgId = new HashSet<Long>(AccSysUtil.getParentOrgId(orgStructureByViews.copy().filter("view = " + view), orgs, true));
                if (!parentOrgId.contains(orgId)) continue;
                result.add(view);
            }
        }
        return result;
    }

    private static DataSet getOrgStructureByViews(Collection<Long> views) {
        QFilter mainViewFilter = new QFilter("view", "in", views);
        return QueryServiceHelper.queryDataSet((String)"GLUtil.getParentOrgId", (String)"bos_org_structure", (String)"org,parent,view", (QFilter[])new QFilter[]{mainViewFilter}, null);
    }

    private static Map<Long, Set<Long>> getViewOrgMap() {
        Map<Long, Map<Long, List<Long>>> viewOrgBTMap = AccSysUtil.getViewOrgBTMap();
        HashMap<Long, Set<Long>> viewOrgMap = new HashMap<Long, Set<Long>>(viewOrgBTMap.size());
        for (Map.Entry<Long, Map<Long, List<Long>>> entry : viewOrgBTMap.entrySet()) {
            HashSet<Long> orgSet = new HashSet<Long>(entry.getValue().keySet());
            viewOrgMap.put(entry.getKey(), orgSet);
        }
        return viewOrgMap;
    }

    public static Map<Long, Map<Long, List<Long>>> getViewOrgBTMap() {
        Map<Long, Map<Long, List<Long>>> mainViewOrgBTMap = AccSysUtil.getMainViewOrgBTMap();
        Map<Long, Map<Long, List<Long>>> statViewOrgBTMap = AccSysUtil.getStatViewOrgBTMap();
        mainViewOrgBTMap.putAll(statViewOrgBTMap);
        return mainViewOrgBTMap;
    }

    public static Set<Long> getChildOrgsByView(Long org, Long view, String formId) {
        HashSet<Long> parent = new HashSet<Long>();
        parent.add(org);
        Set<Long> childOrgList = AccSysUtil.getChildOrgId("10", view, parent, true);
        HashSet<Long> orgViewSet = new HashSet<Long>();
        Map<Long, Set<Long>> viewOrgMap = AccSysUtil.getViewOrgMap();
        Set<Long> orgSet = viewOrgMap.get(view);
        if (orgSet != null) {
            orgViewSet.addAll(orgSet);
        }
        List<Long> permOrgList = AccSysUtil.getAcctOrgPkList(formId, false, PermissonType.VIEW);
        childOrgList.retainAll(orgViewSet);
        childOrgList.retainAll(permOrgList);
        return childOrgList;
    }

    public static Set<Long> getChildOrgId(String ovType, Long iOrgViewId, Set<Long> parentList, boolean includeParentSelf) {
        HashSet<Long> result = new HashSet<Long>();
        if (parentList == null || parentList.size() == 0) {
            return result;
        }
        if (includeParentSelf) {
            result.addAll(parentList);
        }
        QFilter treeTypeFilter = new QFilter("view.treetype", "=", (Object)ovType);
        QFilter mainViewFilter = new QFilter("view", "=", (Object)iOrgViewId);
        try (DataSet orgDataSet = QueryServiceHelper.queryDataSet((String)"GLUtil.getParentOrgId", (String)"bos_org_structure", (String)"org,parent", (QFilter[])new QFilter[]{treeTypeFilter, mainViewFilter}, null);){
            AccSysUtil.getChildOrgIdHelper(parentList, result, orgDataSet);
        }
        return result;
    }

    private static void getChildOrgIdHelper(Set<Long> parentList, Set<Long> result, DataSet orgDataSet) {
        HashSet<Long> childOrgId = new HashSet<Long>();
        String parentStr = parentList.toString().replace('[', '(').replace(']', ')');
        try (DataSet childOrgSet = orgDataSet.copy().filter("parent in " + parentStr);){
            for (Row row : childOrgSet) {
                Long org = row.getLong("org");
                if (org == null || org == 0L) continue;
                childOrgId.add(org);
            }
            if (childOrgId.size() > 0) {
                result.addAll(childOrgId);
                AccSysUtil.getChildOrgIdHelper(childOrgId, result, orgDataSet);
            }
        }
    }

    private static Map<Long, Set<Long>> getMainViewOrgMap() {
        Map<Long, Map<Long, List<Long>>> viewOrgBTMap = AccSysUtil.getMainViewOrgBTMap();
        HashMap<Long, Set<Long>> viewOrgMap = new HashMap<Long, Set<Long>>(viewOrgBTMap.size());
        for (Map.Entry<Long, Map<Long, List<Long>>> entry : viewOrgBTMap.entrySet()) {
            HashSet<Long> orgSet = new HashSet<Long>(entry.getValue().keySet());
            viewOrgMap.put(entry.getKey(), orgSet);
        }
        return viewOrgMap;
    }

    private static Map<Long, Set<Long>> getStatViewOrgMap() {
        Map<Long, Map<Long, List<Long>>> viewOrgBTMap = AccSysUtil.getStatViewOrgBTMap();
        HashMap<Long, Set<Long>> viewOrgMap = new HashMap<Long, Set<Long>>(viewOrgBTMap.size());
        for (Map.Entry<Long, Map<Long, List<Long>>> entry : viewOrgBTMap.entrySet()) {
            HashSet<Long> orgSet = new HashSet<Long>(entry.getValue().keySet());
            viewOrgMap.put(entry.getKey(), orgSet);
        }
        return viewOrgMap;
    }

    private static Map<Long, Map<Long, List<Long>>> getMainViewOrgBTMap() {
        return AccSysUtil.getViewOrgBTMapHelper(true);
    }

    private static Map<Long, Map<Long, List<Long>>> getStatViewOrgBTMap() {
        return AccSysUtil.getViewOrgBTMapHelper(false);
    }

    private static Map<Long, Map<Long, List<Long>>> getViewOrgBTMapHelper(boolean isMainView) {
        DistributeCache cache = CacheHelper.getDistributeCache(CacheModule.accSys);
        String str = cache.get(isMainView ? "accsys-mainvieworgbooktype-cache" : "accsys-statvieworgbooktype-cache");
        if (str != null) {
            Map map = (Map)GLUtil.fromSerializedString(str);
            return map;
        }
        HashMap<Long, Map<Long, List<Long>>> result = new HashMap<Long, Map<Long, List<Long>>>();
        QFilter[] bookQF = new QFilter[]{new QFilter("isbizunit", "=", (Object)"1")};
        QFilter[] viewQF = new QFilter[]{new QFilter("ismainview", "=", (Object)isMainView)};
        try (DataSet bookDataSet = QueryServiceHelper.queryDataSet((String)(AccSysUtil.class.getName() + ".getMainViewOrgBTMap#getBook"), (String)"gl_accountbook", (String)"bookstype,org,accountingsys", (QFilter[])bookQF, null);
             DataSet viewDataSet = QueryServiceHelper.queryDataSet((String)(AccSysUtil.class.getName() + ".getMainViewOrgBTMap#getView"), (String)"bd_accountingsysviewsch", (String)"id,accountingsys", (QFilter[])viewQF, null);
             DataSet finish = bookDataSet.join(viewDataSet, JoinType.INNER).on("accountingsys", "accountingsys").select(new String[]{"bookstype", "org"}, new String[]{"id"}).finish();){
            for (Row row : finish) {
                Map orgBookTypeMap;
                long mainView = row.getLong("id");
                long org = row.getLong("org");
                long bookType = row.getLong("bookstype");
                if (result.containsKey(mainView)) {
                    List<Long> bookTypeList;
                    orgBookTypeMap = (Map)result.get(mainView);
                    if (orgBookTypeMap.containsKey(org)) {
                        bookTypeList = (List)orgBookTypeMap.get(org);
                        bookTypeList.add(bookType);
                        orgBookTypeMap.put(org, bookTypeList);
                        result.put(mainView, orgBookTypeMap);
                        continue;
                    }
                    bookTypeList = new ArrayList<Long>();
                    bookTypeList.add(bookType);
                    orgBookTypeMap.put(org, bookTypeList);
                    result.put(mainView, orgBookTypeMap);
                    continue;
                }
                orgBookTypeMap = new HashMap();
                ArrayList<Long> bookTypes = new ArrayList<Long>();
                bookTypes.add(bookType);
                orgBookTypeMap.put(org, bookTypes);
                result.put(mainView, orgBookTypeMap);
            }
        }
        CacheHelper.getDistributeCache(CacheModule.accSys).put(isMainView ? "accsys-mainvieworgbooktype-cache" : "accsys-statvieworgbooktype-cache", GLUtil.toSerializedString(result));
        return result;
    }

    public static List<Long> getParentOrgId(DataSet orgDataSet, Set<Long> childList, boolean includeChildSelf) {
        LinkedList<Long> result = new LinkedList<Long>();
        if (childList == null || childList.isEmpty()) {
            return result;
        }
        AccSysUtil.getParentOrgIdHelper(childList, result, orgDataSet);
        if (includeChildSelf) {
            result.addAll(childList);
        }
        return result;
    }

    public static List<Long> getParentOrgId(Long iOrgViewId, Set<Long> childList, boolean includeChildSelf) {
        LinkedList<Long> result = new LinkedList<Long>();
        if (childList == null || childList.isEmpty()) {
            return result;
        }
        QFilter mainViewFilter = new QFilter("view", "=", (Object)iOrgViewId);
        try (DataSet orgDataSet = QueryServiceHelper.queryDataSet((String)"GLUtil.getParentOrgId", (String)"bos_org_structure", (String)"org, parent", (QFilter[])new QFilter[]{mainViewFilter}, null);){
            AccSysUtil.getParentOrgIdHelper(childList, result, orgDataSet);
            if (includeChildSelf) {
                result.addAll(childList);
            }
            LinkedList<Long> linkedList = result;
            return linkedList;
        }
    }

    private static void getParentOrgIdHelper(final Set<Long> childList, LinkedList<Long> result, DataSet orgDataSet) {
        LinkedHashSet<Long> parentOrgId = new LinkedHashSet<Long>();
        try (DataSet parentOrgSet = orgDataSet.copy().filter(new FilterFunction(){
            private static final long serialVersionUID = 5578416618246765024L;

            public boolean test(Row row) {
                return childList.contains(row.getLong("org"));
            }
        });){
            for (Row row : parentOrgSet) {
                Long parent = row.getLong("parent");
                if (parent == null || parent == 0L) continue;
                parentOrgId.add(parent);
            }
            if (!parentOrgId.isEmpty()) {
                for (Long pid : parentOrgId) {
                    if (result.contains(pid)) continue;
                    result.addFirst(pid);
                }
                AccSysUtil.getParentOrgIdHelper(parentOrgId, result, orgDataSet);
            }
        }
    }

    public static List<Long> getBookTypeDataPermission(List<Long> orgs) {
        QFilter permission = PermissionServiceHelper.getDataPermission((long)ContextUtil.getUserId(), null, (String)"bd_accountbookstype", orgs);
        if (null != permission) {
            ArrayList<Long> ids = new ArrayList<Long>(10);
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"AccSysUtil.getBookTypeCombo", (String)"bd_accountbookstype", (String)"id", (QFilter[])new QFilter[]{permission}, (String)"accounttype");){
                for (Row row : ds) {
                    ids.add(row.getLong("id"));
                }
            }
            return ids;
        }
        return null;
    }

    public static List<ComboItem> getBookTypeCombo(List<Long> orgs) {
        ArrayList<ComboItem> result = new ArrayList<ComboItem>(10);
        List<Long> bookTypeIds = AccSysUtil.getBookTypeDataPermission(orgs);
        QFilter org = new QFilter("org", "in", orgs);
        if (null != bookTypeIds) {
            org = org.and(new QFilter("bookstype", "in", bookTypeIds));
        }
        QFilter[] filter = new QFilter[]{org, new QFilter("isbizunit", "=", (Object)"1")};
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"kd.fi.gl.accsys.AccSysUtil.getBookTypeCombo", (String)"gl_accountbook", (String)"org,bookstype,bookstype.name btname", (QFilter[])filter, (String)"bookstype.accounttype").groupBy(new String[]{"bookstype", "btname"}).finish();){
            for (Row row : ds) {
                ComboItem item = new ComboItem();
                long bookstype = row.getLong("bookstype");
                String btname = row.getString("btname");
                item.setCaption(new LocaleString(btname));
                item.setValue(String.valueOf(bookstype));
                result.add(item);
            }
        }
        return result;
    }

    public static int getAllBookTypeCount() {
        DynamicObjectCollection book = QueryServiceHelper.query((String)"bd_accountbookstype", (String)"id", null);
        return book == null ? 0 : book.size();
    }

    public static long getCurPeriodAccountTableId(long orgId, long bookTypeId, long periodId) {
        return AccountRefUtils.getCurPeriodAccountTableId((long)orgId, (long)bookTypeId, (long)periodId);
    }

    public static Long getDefaultAcctOrg(List<Long> orgPkList) {
        HashSet<Long> orgPkSet = new HashSet<Long>(orgPkList);
        Long curLoginOrg = RequestContext.get().getOrgId();
        return orgPkSet.contains(curLoginOrg) ? curLoginOrg : (!orgPkList.isEmpty() ? orgPkList.get(0) : null);
    }
}

