/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.cache;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import kd.bos.ext.fi.ai.dap.cache.CacheKeyPrefix;
import kd.bos.ext.fi.ai.dap.cache.LocalCacheKey;
import kd.bos.fs.util.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.ai.VCHTemplate;
import kd.fi.v2.fah.cache.common.SimpleDataDistributeCacheService;

public class DapRedisCache {
    public static final String REDIS_CACHE_PREFIX = "REDIS|";
    private static final SimpleDataDistributeCacheService cacheService = SimpleDataDistributeCacheService.getInstance();
    private static Log log = LogFactory.getLog(DapRedisCache.class);
    private static ObjectMapper objectMapper = new ObjectMapper();

    public static void removeVchTemplateById(Long pk) {
        String redisKey = REDIS_CACHE_PREFIX + LocalCacheKey.getCacheKey((CacheKeyPrefix)CacheKeyPrefix.GL_ACCOUNT_BASEDATAFILED, (Object[])new Object[]{"VCHTemplate", pk}).toString();
        cacheService.remove(redisKey);
    }

    public static void removeVchTemplate(LocalCacheKey cacheKey) {
        String redisKey = REDIS_CACHE_PREFIX + cacheKey.toString();
        cacheService.remove(redisKey);
    }

    public static VCHTemplate getVchTemplateFromRedis(LocalCacheKey cacheKey) {
        String redisKey = REDIS_CACHE_PREFIX + cacheKey.toString();
        String cache = cacheService.get(redisKey, String.class);
        if (StringUtils.isNotEmpty((String)cache)) {
            try {
                return (VCHTemplate)objectMapper.readValue(cache, VCHTemplate.class);
            }
            catch (JsonProcessingException e) {
                log.error((Throwable)e);
            }
        }
        return null;
    }

    public static void updateVchTemplateRedisCache(LocalCacheKey cacheKey, VCHTemplate vchTemplate) {
        String redisKey = REDIS_CACHE_PREFIX + cacheKey.toString();
        try {
            cacheService.put(redisKey, (Object)objectMapper.writeValueAsString((Object)vchTemplate));
        }
        catch (JsonProcessingException e) {
            log.error((Throwable)e);
        }
    }
}

