/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.convert.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.fi.ai.convert.core.Converter;
import kd.fi.ai.convert.core.ConverterLookup;
import kd.fi.ai.convert.core.ConverterRegistry;

public class DefaultConverterLookup
implements ConverterLookup,
ConverterRegistry {
    private List<Converter> converterList = new ArrayList<Converter>();
    private transient Map typeToConverterMap = Collections.synchronizedMap(new HashMap());

    @Override
    public Converter lookupConverterForType(String type) {
        Converter cachedConverter = (Converter)this.typeToConverterMap.get(type);
        if (cachedConverter != null) {
            return cachedConverter;
        }
        for (Converter converter : this.converterList) {
            if (!converter.canConvert(type)) continue;
            this.typeToConverterMap.put(type, converter);
            return converter;
        }
        return null;
    }

    @Override
    public void registerConverter(Converter converter) {
        if (null != converter) {
            this.converterList.add(converter);
            Iterator iterator = Collections.synchronizedSet(this.typeToConverterMap.keySet()).iterator();
            while (iterator.hasNext()) {
                Class type = (Class)iterator.next();
                if (!converter.canConvert(converter.getType())) continue;
                iterator.remove();
            }
        }
    }
}

