/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.convert.core;

import java.io.InputStream;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.fi.ai.convert.core.Converter;
import kd.fi.ai.convert.core.DefaultConverterLookup;
import kd.fi.ai.convert.core.DefaultMarshaller;
import kd.fi.ai.convert.core.DefaultUnmarshaller;
import kd.fi.ai.convert.core.MarshallingContext;
import kd.fi.ai.convert.core.UnmarshallingContext;
import kd.fi.ai.util.ClassUtil;
import kd.fi.ai.util.IOUtils;

public class DefaultStream {
    private static final Log log = LogFactory.getLog(DefaultStream.class);
    public static final String CONVERT_ERROR_MESSAGE = "convert-error-message";
    public static final String NULL = "null";
    private MarshallingContext marshallingContext;
    private UnmarshallingContext unmarshallingContext;
    private DefaultConverterLookup defaultConverterLookup;
    private static DefaultStream defaultStream = null;

    public static DefaultStream getInstance() {
        if (null == defaultStream) {
            defaultStream = new DefaultStream();
        }
        return defaultStream;
    }

    private DefaultStream() {
        this.initContext();
        this.registerDefaultConverter();
    }

    private void initContext() {
        this.defaultConverterLookup = new DefaultConverterLookup();
        this.marshallingContext = new DefaultMarshaller(this.defaultConverterLookup);
        this.unmarshallingContext = new DefaultUnmarshaller(this.defaultConverterLookup);
    }

    private void registerDefaultConverter() {
        InputStream inputStream = null;
        try {
            inputStream = DefaultStream.class.getResourceAsStream("/default-converter.txt");
            String content = IOUtils.readFully(inputStream);
            String[] classes = content.split("\n");
            for (int i = 0; i < classes.length; ++i) {
                if (StringUtils.isEmpty((String)classes[i]) || classes[i].startsWith("#")) continue;
                String[] config = classes[i].trim().split("=");
                Object object = ClassUtil.newInstance(config[1]);
                if (null != object && object instanceof Converter) {
                    Converter converter = (Converter)object;
                    this.defaultConverterLookup.registerConverter(converter);
                    continue;
                }
                log.error("\u65e0\u6cd5\u6dfb\u52a0\u8f6c\u6362\u5668" + config[1]);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            IOUtils.closeCloseable(inputStream);
        }
    }

    public MarshallingContext getMarshallingContext() {
        return this.marshallingContext;
    }

    public UnmarshallingContext getUnmarshallingContext() {
        return this.unmarshallingContext;
    }

    public void registerConverter(Converter converter) {
        this.defaultConverterLookup.registerConverter(converter);
    }
}

