/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.convert.core;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.fi.ai.util.ThrowableHelper;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class JDomB9Utils {
    public static String getAttributeValue(Element element, String attributeName) {
        Attribute attribute = element.attribute(attributeName);
        if (null == attribute) {
            return null;
        }
        return attribute.getValue();
    }

    public static String getAttributeValueUnNull(Element element, String attributeName) {
        Attribute attribute = element.attribute(attributeName);
        if (null == attribute) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8282\u70b9\u201c%1$s\u201d\u4e0b\u672a\u5305\u542b\u5c5e\u6027\u201c%2$s\u201d\u3002", (String)"JDomB9Utils_0", (String)"fi-ai-common", (Object[])new Object[0]), element.getName(), attributeName));
        }
        return attribute.getValue();
    }

    public static Element getUnNullChildElement(Element parent, String childName) {
        Element child = parent.element(childName);
        if (null != child) {
            return child;
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8282\u70b9\u201c%1$s\u201d\u4e0b\u672a\u5305\u542b\u8282\u70b9\u201c%2$s\u201d\u3002", (String)"JDomB9Utils_4", (String)"fi-ai-common", (Object[])new Object[0]), parent.getName(), childName));
    }

    public static String getUnNullTextTrim(Element node) {
        String child = node.getTextTrim();
        if (null != child) {
            return child;
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8282\u70b9\u201c%s\u201d\u7684\u6587\u672c\u503c\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"JDomB9Utils_1", (String)"fi-ai-common", (Object[])new Object[0]), node.getName()));
    }

    public static String getUnNullChildText(Element parent, String childName) {
        String childText = parent.elementText(childName);
        if (null != childText) {
            return childText;
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8282\u70b9\u201c%1$s\u201d\u4e0b\u5b50\u8282\u70b9\u201c%2$s\u201d\u7684\u6587\u672c\u503c\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"JDomB9Utils_2", (String)"fi-ai-common", (Object[])new Object[0]), parent.getName(), childName));
    }

    public static String getUnNullChildTextTrim(Element parent, String childName) {
        return JDomB9Utils.getUnNullChildText(parent, childName).trim();
    }

    public static Element createRoot(String rootName) {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement(rootName);
        return root;
    }

    public static Element addChild(Element parent, String childName) {
        Element child = parent.addElement(childName);
        return child;
    }

    public static void addChild(Element parent, Element child) {
        parent.add(child);
    }

    public static Element addChild(Element parent, String childName, String childValue) {
        Element child = parent.addElement(childName);
        child.setText(childValue == null ? "" : childValue);
        return child;
    }

    public static String e2Str(Element element, String indent, String encoding, boolean newlines) {
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding(encoding);
        format.setIndent(indent);
        format.setNewlines(newlines);
        format.setExpandEmptyElements(true);
        format.setLineSeparator(newlines ? "\n" : "");
        StringWriter outWriter = new StringWriter();
        XMLWriter writer = new XMLWriter((Writer)outWriter, format);
        try {
            writer.write(element);
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return outWriter.toString();
    }

    public static String e2StrGBK(Element element) {
        return JDomB9Utils.e2Str(element, "    ", "GBK", true);
    }

    public static String e2StrUTF8(Element element) {
        return JDomB9Utils.e2Str(element, "    ", "UTF-8", true);
    }

    public static String doc2Str(Document document, String indent, String encoding, boolean newlines) {
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding(encoding);
        format.setIndent(indent);
        format.setNewlines(newlines);
        format.setExpandEmptyElements(true);
        format.setLineSeparator(newlines ? "\n" : "");
        StringWriter outWriter = new StringWriter();
        XMLWriter writer = new XMLWriter((Writer)outWriter, format);
        try {
            writer.write(document);
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return outWriter.toString();
    }

    public static String doc2StrGBK(Document document) {
        return JDomB9Utils.doc2Str(document, "    ", "GBK", true);
    }

    public static String doc2StrUTF8(Document document) {
        return JDomB9Utils.doc2Str(document, "    ", "UTF-8", true);
    }

    public static Document str2Doc(String content, String encoding) {
        try {
            if (null == content) {
                return null;
            }
            if (-1 != content.indexOf("<?")) {
                content = content.substring(content.indexOf("<?"));
            }
            if (-1 == content.indexOf("<?")) {
                content = "<?xml version=\"1.0\" encoding=\"" + encoding + "\" ?>\n" + content;
            }
            Document document = DocumentHelper.parseText((String)content);
            return document;
        }
        catch (Throwable e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b57\u7b26\u4e32\u8f6c\u6362XML\u65f6\u51fa\u9519\uff1a\u201c%s\u201d\u3002", (String)"JDomB9Utils_3", (String)"fi-ai-common", (Object[])new Object[0]), ThrowableHelper.toString(e)));
        }
    }

    public static Document str2DocGBK(String content) {
        return JDomB9Utils.str2Doc(content, "GBK");
    }

    public static Document str2DocUTF8(String content) {
        return JDomB9Utils.str2Doc(content, "UTF-8");
    }
}

