/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.convert.impl;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ai.convert.core.Converter;
import kd.fi.ai.convert.core.JDomB9Utils;
import kd.fi.ai.convert.core.MarshallingContext;
import kd.fi.ai.convert.core.UnmarshallingContext;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public abstract class AbstractConverter
implements Converter {
    protected Element root = null;

    @Override
    public Object marshal(String field, Object source, MarshallingContext context) {
        this.root = null;
        if (field != null) {
            this.root = DocumentHelper.createElement((String)field);
            this.root.addAttribute("type", this.getType());
        }
        return this.root;
    }

    protected Element getElementByName(List<Element> children, String name) {
        for (Element element : children) {
            if (!element.getName().equals(name)) continue;
            return element;
        }
        return null;
    }

    protected String getElementText(Element element) {
        return null != element ? element.getText() : null;
    }

    protected boolean getElementBoolean(Element element) {
        String text = null != element ? element.getText() : null;
        return text == null ? false : Boolean.parseBoolean(text);
    }

    protected String getElementTextByName(List<Element> children, String name) {
        return this.getElementText(this.getElementByName(children, name));
    }

    protected String getElementTextByName(Element element, String name) {
        return element.elementText(name);
    }

    protected <T> T getConvertObjectByName(Element element, String name, Class clazz) {
        String data = this.getElementTextByName(element, name);
        if (StringUtils.isEmpty((CharSequence)data)) {
            return null;
        }
        return (T)SerializationUtils.fromJsonString((String)data, (Class)clazz);
    }

    protected String getElementComboxByName(Element element, String name, UnmarshallingContext context) {
        Element child = element.element(name);
        if (child == null) {
            return "";
        }
        return (String)context.unmarshall("combo", child);
    }

    protected void addChild(Element root, String key, String value) {
        JDomB9Utils.addChild(root, key, value);
    }

    protected void addChild(Element root, String key, int value) {
        JDomB9Utils.addChild(root, key, String.valueOf(value));
    }

    protected void addChild(Element root, String key, boolean value) {
        JDomB9Utils.addChild(root, key, value ? "1" : "0");
    }

    protected void addChild(Element root, String key, Element value) {
        Element child = JDomB9Utils.addChild(root, key);
        JDomB9Utils.addChild(child, value);
    }

    public Object unmarshalBaseData(Object source, UnmarshallingContext context) {
        Element element = (Element)source;
        String type = element.elementText("type");
        String id = element.elementText("id");
        String number = element.elementText("number");
        String name = element.elementText("name");
        QFilter idFilter = new QFilter("id", "=", (Object)id);
        QFilter numberFilter = new QFilter("number", "=", (Object)number);
        idFilter.or(numberFilter);
        DynamicObject data = null;
        try {
            data = BusinessDataServiceHelper.loadSingleFromCache((String)type, (String)"id", (QFilter[])new QFilter[]{numberFilter});
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return data == null ? 0L : data.getLong("id");
    }

    protected void addChild(Element root, Element value) {
        JDomB9Utils.addChild(root, value);
    }

    public static String changeBooleanToString(Boolean value) {
        return value != false ? "1" : "0";
    }

    public static Boolean changeStringToBoolean(String value) {
        return "1".equals(value);
    }

    @Override
    public boolean canConvert(String type) {
        return this.getType().equals(type);
    }

    public String formatDate(Date date, String pattern) {
        if (null == date) {
            return null;
        }
        SimpleDateFormat format = null;
        format = StringUtils.isNotEmpty((CharSequence)pattern) ? new SimpleDateFormat(pattern) : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.format(date);
    }

    public Date formatDate(String date, String pattern) {
        if (StringUtils.isEmpty((CharSequence)date)) {
            return null;
        }
        SimpleDateFormat format = null;
        format = StringUtils.isNotEmpty((CharSequence)pattern) ? new SimpleDateFormat(pattern) : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ParsePosition pos = new ParsePosition(0);
        return format.parse(date, pos);
    }
}

