/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.convert.impl;

import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.fi.ai.VchExpireDate;
import kd.fi.ai.VchFormulaFilterSetRow;
import kd.fi.ai.VchTplExpression;
import kd.fi.ai.convert.core.MarshallingContext;
import kd.fi.ai.convert.core.UnmarshallingContext;
import kd.fi.ai.convert.impl.AbstractConverter;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class ExpireDateConverter
extends AbstractConverter {
    @Override
    public Object marshal(String field, Object source, MarshallingContext context) {
        super.marshal(field, source, context);
        if (source == null) {
            return this.root;
        }
        VchExpireDate expireDate = (VchExpireDate)source;
        this.addChild(this.root, "type", expireDate.getSourcetype());
        this.addChild(this.root, "name", expireDate.getDescriptionString());
        if ("fix".equalsIgnoreCase(expireDate.getSourcetype()) && expireDate.getConstDate() != null && StringUtils.isEmpty((CharSequence)expireDate.getExp())) {
            this.addChild(this.root, "date", this.formatDate(expireDate.getConstDate(), "yyyy-MM-dd"));
        } else {
            Element expireDateRows = DocumentHelper.createElement((String)"daterows");
            for (VchFormulaFilterSetRow row : expireDate.getItems()) {
                Element expireDateRow = DocumentHelper.createElement((String)"item");
                this.addChild(expireDateRow, "fieldexp", SerializationUtils.toJsonString((Object)row.getFieldExp()));
                this.addChild(expireDateRow, "filterset", SerializationUtils.toJsonString((Object)row.getFilterSet()));
                this.addChild(expireDateRows, expireDateRow);
            }
            this.addChild(this.root, expireDateRows);
        }
        return this.root;
    }

    @Override
    public Object unmarshal(Object source, UnmarshallingContext context) {
        VchExpireDate expireDate = new VchExpireDate();
        if (source == null) {
            return expireDate;
        }
        Element data = (Element)source;
        if (data.elements().size() == 0) {
            return expireDate;
        }
        String type = this.getElementText(data.element("type"));
        expireDate.setSourcetype(type);
        expireDate.setDateName(this.getElementText(data.element("name")));
        if ("fix".equalsIgnoreCase(type) && this.getElementText(data.element("date")) != null && StringUtils.isEmpty((CharSequence)this.getElementText(data.element("exp")))) {
            String date = this.getElementText(data.element("date"));
            expireDate.setConstDate(this.formatDate(date, "yyyy-MM-dd"));
        } else {
            Element daterows = data.element("daterows");
            List nodes = daterows.elements();
            for (Element node : nodes) {
                VchFormulaFilterSetRow row = new VchFormulaFilterSetRow();
                String fieldExpStr = node.elementText("fieldexp");
                VchTplExpression fieldExp = new VchTplExpression();
                if (StringUtils.isNotEmpty((CharSequence)fieldExpStr)) {
                    fieldExp = (VchTplExpression)SerializationUtils.fromJsonString((String)fieldExpStr, VchTplExpression.class);
                }
                row.setFieldExp(fieldExp);
                String filterSetStr = node.elementText("filterset");
                VchTplExpression filterSet = new VchTplExpression();
                if (StringUtils.isNotEmpty((CharSequence)filterSetStr)) {
                    filterSet = (VchTplExpression)SerializationUtils.fromJsonString((String)filterSetStr, VchTplExpression.class);
                }
                row.setFilterSet(filterSet);
                expireDate.getItems().add(row);
            }
        }
        return expireDate;
    }

    @Override
    public String getType() {
        return "expiredate";
    }
}

