/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.convert.impl;

import kd.bos.dataentity.entity.LocaleString;
import kd.bos.fs.util.StringUtils;
import kd.bos.lang.Lang;
import kd.fi.ai.convert.core.MarshallingContext;
import kd.fi.ai.convert.core.UnmarshallingContext;
import kd.fi.ai.convert.impl.AbstractConverter;
import org.dom4j.Element;

public class LocaleConverter
extends AbstractConverter {
    @Override
    public Object marshal(String field, Object source, MarshallingContext context) {
        super.marshal(field, source, context);
        if (source == null) {
            return this.root;
        }
        LocaleString value = (LocaleString)source;
        if (StringUtils.isNotEmpty((String)value.getLocaleValue_zh_CN())) {
            this.addChild(this.root, Lang.zh_CN.getLocale().toString(), value.getLocaleValue_zh_CN());
        }
        if (StringUtils.isNotEmpty((String)value.getLocaleValue_zh_TW())) {
            this.addChild(this.root, Lang.zh_TW.getLocale().toString(), value.getLocaleValue_zh_TW());
        }
        if (StringUtils.isNotEmpty((String)value.getLocaleValue_en())) {
            this.addChild(this.root, Lang.en_US.getLocale().toString(), value.getLocaleValue_en());
        }
        return this.root;
    }

    @Override
    public Object unmarshal(Object source, UnmarshallingContext context) {
        if (source == null) {
            return null;
        }
        LocaleString locale = new LocaleString();
        Element data = (Element)source;
        Element lang = null;
        for (Object ele : data.elements()) {
            lang = (Element)ele;
            locale.setItem(lang.getName(), (Object)this.getElementText(lang));
        }
        return locale;
    }

    @Override
    public String getType() {
        return "locale";
    }
}

