/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.convert.impl;

import java.util.ArrayList;
import java.util.List;
import kd.fi.ai.CommonAssistItem;
import kd.fi.ai.VchComAssistEntryInfo;
import kd.fi.ai.VchTplComAssist;
import kd.fi.ai.convert.core.MarshallingContext;
import kd.fi.ai.convert.core.UnmarshallingContext;
import kd.fi.ai.convert.impl.AbstractConverter;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class VchCommonAssistConverter
extends AbstractConverter {
    @Override
    public String getType() {
        return "commonassist";
    }

    @Override
    public Object marshal(String field, Object source, MarshallingContext context) {
        super.marshal(field, source, context);
        if (source == null) {
            return this.root;
        }
        VchTplComAssist vchTplComAssist = (VchTplComAssist)source;
        List<VchComAssistEntryInfo> itemClassMaps = vchTplComAssist.getItemClassMaps();
        if (itemClassMaps.isEmpty()) {
            return this.root;
        }
        this.marshalComAssistEntryInfo(itemClassMaps, context);
        return this.root;
    }

    private void marshalComAssistEntryInfo(List<VchComAssistEntryInfo> itemClassMaps, MarshallingContext context) {
        Element casstNodes = DocumentHelper.createElement((String)"comassistentryinfo");
        this.addChild(this.root, casstNodes);
        for (VchComAssistEntryInfo vca : itemClassMaps) {
            Element casstNode = DocumentHelper.createElement((String)"comassistentry");
            CommonAssistItem comAssist = vca.getComAssist();
            Element caiNode = DocumentHelper.createElement((String)"comassist");
            this.addChild(caiNode, "name", comAssist.getComassistname());
            this.addChild(caiNode, "number", comAssist.getComassistnumber());
            this.addChild(caiNode, "sourcetype", comAssist.getValuesourcetype());
            this.addChild(caiNode, "seq", comAssist.getSeq());
            this.addChild(caiNode, "valuesource", comAssist.getValuesource().toString());
            this.addChild(caiNode, (Element)context.marshall("isbalance", "boolean", comAssist.isIsbalance()));
            this.addChild(caiNode, (Element)context.marshall("isrequire", "boolean", comAssist.isIsrequire()));
            this.addChild(casstNode, caiNode);
            this.addChild(casstNode, "comassistdesc", vca.getComAssistdesc());
            this.addChild(casstNode, "comassistitem", vca.getComAssistItem());
            this.addChild(casstNode, "comassistitemdesc", vca.getComAssistItemdesc());
            this.addChild(casstNode, "comasst", vca.getComAsst());
            this.addChild(casstNode, "exp", vca.getExp());
            this.addChild(casstNode, "expdesc", vca.getExpdesc());
            this.addChild(casstNode, "type", vca.getType());
            this.addChild(casstNodes, casstNode);
        }
    }

    @Override
    public Object unmarshal(Object source, UnmarshallingContext context) {
        VchTplComAssist result = new VchTplComAssist();
        if (source == null) {
            return result;
        }
        Element data = (Element)source;
        if (data.elements().size() == 0) {
            return result;
        }
        Element comassistentryinfo = data.element("comassistentryinfo");
        ArrayList<VchComAssistEntryInfo> itemClassMaps = new ArrayList<VchComAssistEntryInfo>(8);
        if (comassistentryinfo != null) {
            List children = comassistentryinfo.elements();
            for (Element coa : children) {
                VchComAssistEntryInfo vcainfo = new VchComAssistEntryInfo();
                CommonAssistItem cai = new CommonAssistItem();
                Element comassist = coa.element("comassist");
                cai.setComassistname(comassist.elementText("name"));
                cai.setComassistnumber(comassist.elementText("number"));
                cai.setIsbalance((Boolean)context.unmarshall("boolean", comassist.element("isbalance")));
                cai.setIsrequire((Boolean)context.unmarshall("boolean", comassist.element("isrequire")));
                cai.setSeq(Integer.parseInt(comassist.elementText("seq")));
                cai.setValuesource(comassist.elementText("valuesource"));
                cai.setValuesourcetype(comassist.elementText("sourcetype"));
                vcainfo.setComAssist(cai);
                vcainfo.setComAssistdesc(coa.elementText("comassistdesc"));
                vcainfo.setComAssistItem(coa.elementText("comassistitem"));
                vcainfo.setComAssistItemdesc(coa.elementText("comassistitemdesc"));
                vcainfo.setComAsst(coa.elementText("comasst"));
                vcainfo.setExp(coa.elementText("exp"));
                vcainfo.setExpdesc(coa.elementText("expdesc"));
                vcainfo.setType(coa.elementText("type"));
                itemClassMaps.add(vcainfo);
            }
        }
        result.setItemClassMaps(itemClassMaps);
        return result;
    }
}

