/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.convert.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleValue;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.fi.ai.VCHTemplate;
import kd.fi.ai.VchTplEntryNewSortOption;
import kd.fi.ai.convert.core.MarshallingContext;
import kd.fi.ai.convert.core.UnmarshallingContext;
import kd.fi.ai.convert.impl.AbstractConverter;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class VchTemplateConverter
extends AbstractConverter {
    private static final String Key_FXml = "fxml";
    private static final String Key_FXmlLang = "fxmllang";
    private static final String TPL_HEAD = "tpl_head";
    private static final String TPL_GROUP = "tpl_group";
    private static final String[] NORMAL_TEXT = new String[]{"id", "number", "name"};
    private static final String[] NORMAL_COMBO = new String[]{"buildvchgen", "oper", "unoper"};
    private static final String[] NORMAL_BASEDATA = new String[]{"createorg", "fsourcebill", "eventclass"};

    @Override
    public Object marshal(String field, Object source, MarshallingContext context) {
        super.marshal(this.getType(), source, context);
        DynamicObject templateInfo = (DynamicObject)source;
        this.marshalHead(this.root, templateInfo, context);
        String toJson = templateInfo.getString(Key_FXml);
        ILocaleValue langJsons = (ILocaleValue)templateInfo.get(Key_FXmlLang);
        VCHTemplate vchTemplate = null;
        vchTemplate = VCHTemplate.deserializeFromString(toJson, (Map<String, String>)langJsons);
        String SortOptionStr = templateInfo.getString("newsortorder");
        if (StringUtils.isNotBlank((CharSequence)SortOptionStr)) {
            VchTplEntryNewSortOption newSortOption = (VchTplEntryNewSortOption)SerializationUtils.fromJsonString((String)SortOptionStr, VchTplEntryNewSortOption.class);
            vchTemplate.setEntryNewSortOption(newSortOption);
        }
        Element tempEle = DocumentHelper.createElement((String)"template");
        this.addChild(tempEle, (Element)context.marshall(TPL_HEAD, TPL_HEAD, vchTemplate));
        this.addChild(tempEle, (Element)context.marshall(TPL_GROUP, TPL_GROUP, vchTemplate));
        this.addChild(this.root, tempEle);
        return this.root;
    }

    @Override
    public Object unmarshal(Object source, UnmarshallingContext context) {
        List sortOrderList;
        MainEntityType vchTemplateConfigsType = EntityMetadataCache.getDataEntityType((String)this.getType());
        DynamicObject vchTemplate = new DynamicObject((DynamicObjectType)vchTemplateConfigsType);
        Element data = (Element)source;
        List children = data.elements();
        this.unmarshalHead(children, vchTemplate, context);
        Element tempEle = this.getElementByName(children, "template");
        List temps = tempEle.elements();
        Element tempHead = this.getElementByName(temps, TPL_HEAD);
        String number = vchTemplate.getString("number");
        OrmLocaleValue name = (OrmLocaleValue)vchTemplate.get("name");
        if (StringUtils.isBlank((CharSequence)number) || name.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7f16\u7801\u6216\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"VchTemplateConverter_01", (String)"fi-ai-common", (Object[])new Object[0]));
        }
        if (tempHead.element("newsortorder") != null && !(sortOrderList = tempHead.element("newsortorder").content()).isEmpty()) {
            StringBuilder sortOrderStr = new StringBuilder();
            sortOrderList.forEach(v -> sortOrderStr.append(v.getText()));
            if (StringUtils.isNotBlank((CharSequence)sortOrderStr)) {
                VchTplEntryNewSortOption newSortOption = (VchTplEntryNewSortOption)SerializationUtils.fromJsonString((String)sortOrderStr.toString(), VchTplEntryNewSortOption.class);
                vchTemplate.set("newsortorder", (Object)SerializationUtils.toJsonString((Object)newSortOption));
            }
        }
        VCHTemplate vchTemp = (VCHTemplate)context.unmarshall(TPL_HEAD, tempHead);
        DynamicObjectCollection booktypes = vchTemplate.getDynamicObjectCollection("booktype");
        if (null != booktypes && !booktypes.isEmpty()) {
            ArrayList<Long> booktypeids = new ArrayList<Long>(booktypes.size());
            for (DynamicObject dyn : booktypes) {
                booktypeids.add(dyn.getLong("fbasedataid"));
            }
            vchTemp.setBookTypeIds(booktypeids);
        }
        List bizGroups = (List)context.unmarshall(TPL_GROUP, this.getElementByName(temps, TPL_GROUP));
        vchTemp.setBizGroups(bizGroups);
        if (context.get("eventclass") != null) {
            vchTemp.setEventClassId(Long.parseLong(context.get("eventclass").toString()));
        }
        Map<String, String> jsonDatas = vchTemp.serializeToString();
        vchTemplate.set(Key_FXml, (Object)jsonDatas.get("json"));
        vchTemplate.set("faccttableid", (Object)vchTemp.getAcctTableId());
        vchTemplate.set("creator", (Object)Long.parseLong(RequestContext.get().getUserId()));
        vchTemplate.set("createtime", (Object)new Date());
        vchTemplate.set("enable", (Object)1);
        vchTemplate.set("status", (Object)"C");
        return vchTemplate;
    }

    private void unmarshalHead(List<Element> children, DynamicObject vchTemplate, UnmarshallingContext context) {
        this.unmarshalNormalString(children, vchTemplate);
        this.unmarshalNormalBaseData(children, vchTemplate, context);
        this.unmarshalNormalMultiBaseData(children, vchTemplate, context);
        this.unmarshalCombo(children, vchTemplate, context);
    }

    private void marshalHead(Element root, DynamicObject templateInfo, MarshallingContext context) {
        this.marshalNormalString(root, templateInfo);
        this.marshalNormalBaseData(root, templateInfo, context);
        this.marshalNormalMultiBaseData(root, templateInfo, context);
        this.marshalCombo(root, templateInfo, context);
    }

    private void marshalNormalString(Element root, DynamicObject templateInfo) {
        for (String field : NORMAL_TEXT) {
            this.addChild(root, field, templateInfo.getString(field));
        }
    }

    private void unmarshalNormalString(List<Element> children, DynamicObject vchTemplate) {
        for (String field : NORMAL_TEXT) {
            vchTemplate.set(field, (Object)this.getElementTextByName(children, field));
        }
    }

    private void marshalNormalBaseData(Element root, DynamicObject templateInfo, MarshallingContext context) {
        for (String field : NORMAL_BASEDATA) {
            Element ele = (Element)context.marshall(field, "basedata", templateInfo.getDynamicObject(field));
            this.addChild(root, ele);
        }
    }

    private void marshalNormalMultiBaseData(Element root, DynamicObject templateInfo, MarshallingContext context) {
        Element ele = (Element)context.marshall("booktype", "multibasedata", templateInfo.getDynamicObjectCollection("booktype"));
        this.addChild(root, ele);
    }

    private void unmarshalNormalBaseData(List<Element> children, DynamicObject vchTemplate, UnmarshallingContext context) {
        for (String field : NORMAL_BASEDATA) {
            vchTemplate.set(field, context.unmarshall("basedata", this.getElementByName(children, field)));
            if (!"eventclass".equals(field)) continue;
            context.put(field, context.unmarshall("basedata", this.getElementByName(children, field)));
        }
    }

    private void unmarshalNormalMultiBaseData(List<Element> children, DynamicObject vchTemplate, UnmarshallingContext context) {
        DynamicObjectCollection coll = vchTemplate.getDynamicObjectCollection("booktype");
        if (coll == null || coll.getDynamicObjectType() == null) {
            return;
        }
        List bookids = (List)context.unmarshall("multibasedata", this.getElementByName(children, "booktype"));
        if (bookids != null) {
            DynamicObjectType dynamicObjectType = coll.getDynamicObjectType();
            for (Long id : bookids) {
                DynamicObject mulBaseRow = new DynamicObject(dynamicObjectType);
                mulBaseRow.set("fbasedataid", (Object)id);
                coll.add((Object)mulBaseRow);
            }
            vchTemplate.set("booktype", (Object)coll);
        }
    }

    private void marshalCombo(Element root, DynamicObject templateInfo, MarshallingContext context) {
        for (String field : NORMAL_COMBO) {
            this.addChild(root, (Element)context.marshall(field, "combo", templateInfo.getString(field)));
        }
    }

    private void unmarshalCombo(List<Element> children, DynamicObject vchTemplate, UnmarshallingContext context) {
        for (String field : NORMAL_COMBO) {
            vchTemplate.set(field, context.unmarshall("combo", this.getElementByName(children, field)));
        }
    }

    @Override
    public String getType() {
        return "ai_vchtemplate";
    }
}

