/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.convert.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.util.StringUtils;
import kd.fi.ai.VchExpireDate;
import kd.fi.ai.VchTplAccts;
import kd.fi.ai.VchTplAsst;
import kd.fi.ai.VchTplCashflow;
import kd.fi.ai.VchTplComAssist;
import kd.fi.ai.VchTplDcs;
import kd.fi.ai.VchTplEntry;
import kd.fi.ai.VchTplExpression;
import kd.fi.ai.VchTplMainAsst;
import kd.fi.ai.VchTplMeasureUnit;
import kd.fi.ai.convert.core.MarshallingContext;
import kd.fi.ai.convert.core.UnmarshallingContext;
import kd.fi.ai.convert.impl.AbstractConverter;
import org.dom4j.Element;

public class VchTplEntryConverter
extends AbstractConverter {
    @Override
    public Object marshal(String field, Object source, MarshallingContext context) {
        super.marshal(field, source, context);
        VchTplEntry entry = (VchTplEntry)source;
        if (entry == null) {
            return this.root;
        }
        this.marshalText(this.root, entry, context);
        this.marshalLocale(this.root, entry, context);
        this.marshalAcct(this.root, entry, context);
        this.marshalMeasureunit(this.root, entry, context);
        this.marshalAsst(this.root, entry, context);
        this.marshalMainAsst(this.root, entry, context);
        this.marshalExpireDate(this.root, entry, context);
        this.marshalBoolean(this.root, entry, context);
        this.marshalCashflow(this.root, entry, context);
        this.marshalCommonAssist(this.root, entry, context);
        return this.root;
    }

    @Override
    public Object unmarshal(Object source, UnmarshallingContext context) {
        List datas = (List)source;
        ArrayList<VchTplEntry> entrys = new ArrayList<VchTplEntry>(datas.size());
        VchTplEntry entry = null;
        for (Element data : datas) {
            entry = new VchTplEntry();
            this.unmarshalText(data, entry, context);
            this.unmarshalLocale(data, entry, context);
            this.ummarshalBoolean(data, entry, context);
            this.unmarshalAcct(data, entry, context);
            this.unmarshalMeasureunit(data, entry, context);
            this.unmarshalAsst(data, entry, context);
            this.unmarshalMainAsst(data, entry, context);
            this.unmarshalExpireDate(data, entry, context);
            this.unmarshalCashflow(data, entry, context);
            this.unmarshalCommonAssist(data, entry, context);
            entry.setId(UUID.randomUUID().toString());
            entrys.add(entry);
        }
        return entrys;
    }

    private void marshalText(Element root, VchTplEntry entry, MarshallingContext context) {
        this.addChild(root, "id", entry.getId());
        this.addChild(root, "seq", entry.getSeq());
        this.addChild(root, "fdatascope", SerializationUtils.toJsonString((Object)entry.getDataScope()));
        this.addChild(root, "dc", SerializationUtils.toJsonString((Object)entry.getDcs()));
        this.addChild(root, "oriCurrencySet", entry.getOriCurrencySet());
        this.addChild(root, "rateSet", entry.getRateSet());
        this.addChild(root, "rateNew", entry.getRateNew());
        this.addChild(root, "rateDesc", entry.getRateDesc());
        this.addChild(root, "extVchTplEntryField", entry.getExtVchTplEntryFieldJson());
        this.addChild(root, "belongsource", entry.getBelongSource());
        this.addChild(root, "belongsources", entry.getBelongSources());
    }

    private void unmarshalText(Element root, VchTplEntry entry, UnmarshallingContext context) {
        String dc;
        entry.setSeq(Integer.parseInt(this.getElementText(root.element("seq"))));
        String datascope = this.getElementText(root.element("fdatascope"));
        if (StringUtils.isNotEmpty((String)datascope)) {
            entry.setDataScope((VchTplExpression)SerializationUtils.fromJsonString((String)datascope, VchTplExpression.class));
        }
        if (StringUtils.isNotEmpty((String)(dc = this.getElementText(root.element("dc"))))) {
            entry.setDcs((VchTplDcs)SerializationUtils.fromJsonString((String)dc, VchTplDcs.class));
        }
        entry.setOriCurrencySet(this.getElementText(root.element("oriCurrencySet")));
        entry.setRateSet(this.getElementText(root.element("rateSet")));
        entry.setRateNew(this.getElementText(root.element("rateNew")));
        entry.setRateDesc(this.getElementText(root.element("rateDesc")));
        entry.setExtVchTplEntryFieldJson(this.getElementText(root.element("extVchTplEntryField")));
        entry.setBelongSource(this.getElementText(root.element("belongsource")));
        entry.setBelongSources(this.getElementText(root.element("belongsources")));
    }

    private void marshalLocale(Element root, VchTplEntry entry, MarshallingContext context) {
        this.addChild(root, "oriAmount", entry.getOriAmountSet());
        this.addChild(root, (Element)context.marshall("oriAmountDesc", "locale", entry.getOriAmountDesc()));
        this.addChild(root, "localAmount", entry.getLocalAmountSet());
        this.addChild(root, (Element)context.marshall("localAmountDesc", "locale", entry.getLocalAmountDesc()));
        this.addChild(root, "explanation", entry.getExplanationSet());
        this.addChild(root, (Element)context.marshall("explanationDesc", "locale", entry.getExplanationDesc()));
        this.addChild(root, "businessNum", entry.getBusinessNumSet());
        this.addChild(root, (Element)context.marshall("businessNumDesc", "locale", entry.getBusinessNumDesc()));
        this.addChild(root, "quantity", entry.getQuantitySet());
        this.addChild(root, (Element)context.marshall("quantityDesc", "locale", entry.getQuantityDesc()));
        this.addChild(root, "price", entry.getPriceSet());
        this.addChild(root, (Element)context.marshall("priceDesc", "locale", entry.getPriceDesc()));
    }

    private void unmarshalLocale(Element root, VchTplEntry entry, UnmarshallingContext context) {
        entry.setOriAmountSet(this.getElementText(root.element("oriAmount")));
        Object orgAmount = context.unmarshall("locale", root.element("oriAmountDesc"));
        entry.setOriAmountDesc(orgAmount == null ? null : (LocaleString)orgAmount);
        entry.setLocalAmountSet(this.getElementText(root.element("localAmount")));
        Object localAmount = context.unmarshall("locale", root.element("localAmountDesc"));
        entry.setLocalAmountDesc(localAmount == null ? null : (LocaleString)localAmount);
        entry.setExplanationSet(this.getElementText(root.element("explanation")));
        Object desc = context.unmarshall("locale", root.element("explanationDesc"));
        entry.setExplanationDesc(desc == null ? null : (LocaleString)desc);
        entry.setBusinessNumSet(this.getElementText(root.element("businessNum")));
        Object businessNumdesc = context.unmarshall("locale", root.element("businessNumDesc"));
        entry.setBusinessNumDesc(businessNumdesc == null ? null : (LocaleString)businessNumdesc);
        entry.setQuantitySet(this.getElementText(root.element("quantity")));
        Object quant = context.unmarshall("locale", root.element("quantityDesc"));
        entry.setQuantityDesc(quant == null ? null : (LocaleString)quant);
        entry.setPriceSet(this.getElementText(root.element("price")));
        Object price = context.unmarshall("locale", root.element("priceDesc"));
        entry.setPriceDesc(price == null ? null : (LocaleString)price);
    }

    private void marshalBoolean(Element root, VchTplEntry entry, MarshallingContext context) {
        this.addChild(root, (Element)context.marshall("needMerge", "boolean", entry.isNeedMerge()));
        this.addChild(root, (Element)context.marshall("autobal", "boolean", entry.isAutoBal()));
        this.addChild(root, (Element)context.marshall("canChargeAgainst", "boolean", entry.isCanChargeAgainst()));
        this.addChild(root, (Element)context.marshall("isuse", "boolean", entry.getIsuse()));
    }

    private void ummarshalBoolean(Element root, VchTplEntry entry, UnmarshallingContext context) {
        entry.setNeedMerge((Boolean)context.unmarshall("boolean", root.element("needMerge")));
        entry.setAutoBal((Boolean)context.unmarshall("boolean", root.element("autobal")));
        entry.setCanChargeAgainst((Boolean)context.unmarshall("boolean", root.element("canChargeAgainst")));
        entry.setIsuse((Boolean)context.unmarshall("boolean", root.element("isuse")));
    }

    private void marshalAcct(Element root, VchTplEntry entry, MarshallingContext context) {
        this.addChild(root, (Element)context.marshall("acct", "bd_accountview", entry.getAcctsSet()));
    }

    private void unmarshalAcct(Element root, VchTplEntry entry, UnmarshallingContext context) {
        Object accts = context.unmarshall("bd_accountview", root.element("acct"));
        entry.setAcctsSet(accts == null ? null : (VchTplAccts)accts);
        context.put("acct", accts);
    }

    private void marshalMeasureunit(Element root, VchTplEntry entry, MarshallingContext context) {
        this.addChild(root, (Element)context.marshall("measureunit", "bd_measureunits", entry.getMeasureunit()));
    }

    private void unmarshalMeasureunit(Element root, VchTplEntry entry, UnmarshallingContext context) {
        Object accts = context.unmarshall("bd_measureunits", root.element("measureunit"));
        entry.setMeasureunit(accts == null ? null : (VchTplMeasureUnit)accts);
    }

    private void marshalAsst(Element root, VchTplEntry entry, MarshallingContext context) {
        this.addChild(root, (Element)context.marshall("acctAsst", "bd_accountasst", entry.getAsst()));
    }

    private void unmarshalAsst(Element root, VchTplEntry entry, UnmarshallingContext context) {
        Object accts = context.unmarshall("bd_accountasst", root.element("acctAsst"));
        VchTplAccts acct = (VchTplAccts)context.get("acct");
        if (acct == null || StringUtils.isBlank((String)acct.getAcctName())) {
            entry.setAsst(null);
        } else {
            entry.setAsst(accts == null || acct == null ? null : (VchTplAsst)accts);
        }
    }

    private void marshalMainAsst(Element root, VchTplEntry entry, MarshallingContext context) {
        this.addChild(root, (Element)context.marshall("mainAsst", "bd_vchmainasst", entry.getMainAsst()));
    }

    private void unmarshalMainAsst(Element root, VchTplEntry entry, UnmarshallingContext context) {
        Object accts = context.unmarshall("bd_vchmainasst", root.element("mainAsst"));
        entry.setMainAsst(accts == null ? null : (VchTplMainAsst)accts);
    }

    private void marshalExpireDate(Element root, VchTplEntry entry, MarshallingContext context) {
        this.addChild(root, (Element)context.marshall("expiredate", "expiredate", entry.getExpireDate()));
    }

    private void unmarshalExpireDate(Element root, VchTplEntry entry, UnmarshallingContext context) {
        Object expiredate = context.unmarshall("expiredate", root.element("expiredate"));
        entry.setExpireDate(expiredate == null ? null : (VchExpireDate)expiredate);
    }

    private void marshalCashflow(Element root, VchTplEntry entry, MarshallingContext context) {
        this.addChild(root, (Element)context.marshall("cashflow", "cashflow", entry.getCashflow()));
    }

    private void unmarshalCashflow(Element root, VchTplEntry entry, UnmarshallingContext context) {
        Object cashFlow = context.unmarshall("cashflow", root.element("cashflow"));
        entry.setCashflow(cashFlow == null ? null : (VchTplCashflow)cashFlow);
    }

    private void marshalCommonAssist(Element root, VchTplEntry entry, MarshallingContext context) {
        this.addChild(root, (Element)context.marshall("commonassist", "commonassist", entry.getComassist()));
    }

    private void unmarshalCommonAssist(Element root, VchTplEntry entry, UnmarshallingContext context) {
        Object commonAssist = context.unmarshall("commonassist", root.element("commonassist"));
        entry.setComassist(commonAssist == null ? null : (VchTplComAssist)commonAssist);
    }

    @Override
    public String getType() {
        return "tpl_entry";
    }
}

