/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.convert.impl;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.fi.ai.VCHTemplate;
import kd.fi.ai.VchExpireDate;
import kd.fi.ai.VchTplCreator;
import kd.fi.ai.VchTplEntryMergeOption;
import kd.fi.ai.VchTplExpression;
import kd.fi.ai.VchTplVoucherTypes;
import kd.fi.ai.builder.GLVoucherUnionType;
import kd.fi.ai.builder.VCHEntryOrder;
import kd.fi.ai.convert.core.MarshallingContext;
import kd.fi.ai.convert.core.UnmarshallingContext;
import kd.fi.ai.convert.impl.AbstractConverter;
import org.dom4j.Element;

public class VchTplHeadConverter
extends AbstractConverter {
    @Override
    public Object marshal(String field, Object source, MarshallingContext context) {
        super.marshal(field, source, context);
        VCHTemplate vchTemplate = (VCHTemplate)source;
        this.marshalText(this.root, vchTemplate, context);
        this.marshalCombo(this.root, vchTemplate, context);
        this.marshalExpireDate(this.root, vchTemplate, context);
        this.marshalEnum(this.root, vchTemplate, context);
        this.marshalBaseDataId(this.root, vchTemplate, context);
        this.marshalVchtype(this.root, vchTemplate, context);
        this.marshalVchCreator(this.root, vchTemplate, context);
        return this.root;
    }

    private void marshalVchCreator(Element root, VCHTemplate vchTemplate, MarshallingContext context) {
        this.addChild(root, (Element)context.marshall("fcreator", "vchcreator", vchTemplate.getCreatorSet()));
    }

    @Override
    public Object unmarshal(Object source, UnmarshallingContext context) {
        VCHTemplate vchTemplate = new VCHTemplate();
        Element data = (Element)source;
        this.unmarshalText(data, vchTemplate, context);
        this.unmarshalCombo(data, vchTemplate, context);
        this.unmarshalExpireDate(data, vchTemplate, context);
        this.unmarshalEnum(data, vchTemplate, context);
        this.unmarshalBaseDataId(data, vchTemplate, context);
        this.unmarshalVchtype(data, vchTemplate, context);
        this.unmarshalVchCreator(data, vchTemplate, context);
        context.put("vchTemplate", vchTemplate);
        return vchTemplate;
    }

    private void unmarshalVchCreator(Element data, VCHTemplate vchTemplate, UnmarshallingContext context) {
        Object vchCreator = context.unmarshall("vchcreator", data.element("fcreator"));
        vchTemplate.setCreatorSet((VchTplCreator)vchCreator);
    }

    private void marshalText(Element root, VCHTemplate vchTemplate, MarshallingContext context) {
        this.addChild(root, (Element)context.marshall("description", "locale", vchTemplate.getDescription()));
        this.addChild(root, "filterSet", vchTemplate.getFilterSet() == null ? "" : SerializationUtils.toJsonString((Object)vchTemplate.getFilterSet()));
        this.addChild(root, "freference", vchTemplate.getReferenceSet());
        this.addChild(root, "sourceBill", vchTemplate.getSourceBill());
        this.addChild(root, "fmatchfieldkey", vchTemplate.getUnionFieldKeys());
        this.addChild(root, "fmatchfieldname", vchTemplate.getUnionFieldValue());
        this.addChild(root, "freferencedesc", vchTemplate.getReferencedescSet());
        this.addChild(root, "payer", vchTemplate.getPayer());
        this.addChild(root, "paymentStatus", vchTemplate.getPaymentstatus());
        this.addChild(root, "relationshipSourcebill", vchTemplate.getRelationshipSourcebill());
        this.addChild(root, "entrymergeoption", vchTemplate.getEntryMergeOption() == null ? "" : SerializationUtils.toJsonString((Object)vchTemplate.getEntryMergeOption()));
        this.addChild(root, "extVchTplField", vchTemplate.getExtVchTplFieldJson());
        this.addChild(root, "relationbills", vchTemplate.getRelationshipSourcebillcol() == null ? "" : SerializationUtils.toJsonString(vchTemplate.getRelationshipSourcebillcol()));
        this.addChild(root, "recommoninfo", vchTemplate.getSourceAndTargetFieldcol() == null ? "" : SerializationUtils.toJsonString(vchTemplate.getSourceAndTargetFieldcol()));
        this.addChild(root, "newsortorder", vchTemplate.getEntryNewSortOption() == null ? "" : SerializationUtils.toJsonString((Object)vchTemplate.getEntryNewSortOption()));
    }

    private void unmarshalText(Element data, VCHTemplate vchTemplate, UnmarshallingContext context) {
        Object desc = context.unmarshall("locale", data.element("description"));
        vchTemplate.setDescription(desc == null ? null : (LocaleString)desc);
        vchTemplate.setFilterSet((VchTplExpression)this.getConvertObjectByName(data, "filterSet", VchTplExpression.class));
        vchTemplate.setReferenceSet(this.getElementTextByName(data, "freference"));
        vchTemplate.setReferencedescSet(this.getElementTextByName(data, "freferencedesc"));
        vchTemplate.setSourceBill(this.getElementTextByName(data, "sourceBill"));
        vchTemplate.setUnionFieldKeys(this.getElementTextByName(data, "fmatchfieldkey"));
        vchTemplate.setUnionFieldValue(this.getElementTextByName(data, "fmatchfieldname"));
        vchTemplate.setPayer(this.getElementTextByName(data, "payer"));
        vchTemplate.setPaymentstatus(this.getElementTextByName(data, "paymentStatus"));
        vchTemplate.setEntryMergeOption((VchTplEntryMergeOption)this.getConvertObjectByName(data, "entrymergeoption", VchTplEntryMergeOption.class));
        vchTemplate.setExtVchTplFieldJson(this.getElementTextByName(data, "extVchTplField"));
        vchTemplate.setRelationshipSourcebill(this.getElementTextByName(data, "relationshipSourcebill"));
        vchTemplate.setRelationshipSourcebillcol((List)this.getConvertObjectByName(data, "relationbills", List.class));
        vchTemplate.setSourceAndTargetFieldcol((Map)this.getConvertObjectByName(data, "recommoninfo", Map.class));
    }

    private void marshalCombo(Element data, VCHTemplate vchTemplate, MarshallingContext context) {
        this.addChild(this.root, (Element)context.marshall("facctorgid", "combo", vchTemplate.getAcctOrgSet()));
        this.addChild(this.root, (Element)context.marshall("attachment", "combo", vchTemplate.getAttachment()));
        this.addChild(this.root, (Element)context.marshall("fvoucherdate", "combo", vchTemplate.getVchDateSet()));
        this.addChild(this.root, (Element)context.marshall("fbizdate", "combo", vchTemplate.getBizDateSet()));
    }

    private void marshalExpireDate(Element data, VCHTemplate vchTemplate, MarshallingContext context) {
        this.addChild(this.root, (Element)context.marshall("fvoucherdate2", "expiredate", vchTemplate.getVchDateSet2()));
        this.addChild(this.root, (Element)context.marshall("fbizdate2", "expiredate", vchTemplate.getBizDateSet2()));
    }

    private void unmarshalCombo(Element data, VCHTemplate vchTemplate, UnmarshallingContext context) {
        vchTemplate.setAcctOrgSet(this.getElementComboxByName(data, "facctorgid", context));
        vchTemplate.setVchDateSet(this.getElementComboxByName(data, "fvoucherdate", context));
        vchTemplate.setAttachment(this.getElementComboxByName(data, "attachment", context));
        vchTemplate.setBizDateSet(this.getElementComboxByName(data, "fbizdate", context));
    }

    private void unmarshalExpireDate(Element data, VCHTemplate vchTemplate, UnmarshallingContext context) {
        Object expiredate = context.unmarshall("expiredate", data.element("fvoucherdate2"));
        if (expiredate != null) {
            vchTemplate.setVchDateSet2((VchExpireDate)expiredate);
        } else {
            vchTemplate.setVchDateSet2(this.buildExpireDate(this.getElementComboxByName(data, "fvoucherdate", context)));
        }
        expiredate = context.unmarshall("expiredate", data.element("fbizdate2"));
        if (expiredate != null) {
            vchTemplate.setBizDateSet2((VchExpireDate)expiredate);
        } else {
            vchTemplate.setBizDateSet2(this.buildExpireDate(this.getElementComboxByName(data, "fbizdate", context)));
        }
    }

    private VchExpireDate buildExpireDate(String dateName) {
        VchExpireDate box = new VchExpireDate();
        if (dateName.equals("newdate") || dateName.equals("lastdate")) {
            box.setSourcetype("fix");
        } else {
            box.setDateName(dateName);
            box.setSourcetype("exp");
        }
        box.setExp(dateName);
        return box;
    }

    private void marshalEnum(Element root, VCHTemplate vchTemplate, MarshallingContext context) {
        this.addChild(root, (Element)context.marshall("funiontype", "enum", (Object)vchTemplate.getUnionType()));
        this.addChild(root, (Element)context.marshall("fentryorder", "enum", (Object)vchTemplate.getEntryOrder()));
    }

    private void unmarshalEnum(Element data, VCHTemplate vchTemplate, UnmarshallingContext context) {
        Object unionType = context.unmarshall("enum", data.element("funiontype"));
        vchTemplate.setUnionType(unionType == null ? null : (GLVoucherUnionType)((Object)unionType));
        Object orderType = context.unmarshall("enum", data.element("fentryorder"));
        vchTemplate.setEntryOrder(orderType == null ? null : (VCHEntryOrder)((Object)orderType));
    }

    private void marshalBaseDataId(Element root, VCHTemplate vchTemplate, MarshallingContext context) {
        this.addChild(root, (Element)context.marshall("accountTable", "bd_accounttable", vchTemplate.getAcctTableId()));
    }

    private void unmarshalBaseDataId(Element data, VCHTemplate vchTemplate, UnmarshallingContext context) {
        vchTemplate.setAcctTableId((Long)context.unmarshall("bd_accounttable", data.element("accountTable")));
    }

    private void marshalVchtype(Element root, VCHTemplate vchTemplate, MarshallingContext context) {
        this.addChild(root, (Element)context.marshall("fvchtype", "vouchertypes", vchTemplate.getVchTypesSet()));
    }

    private void unmarshalVchtype(Element data, VCHTemplate vchTemplate, UnmarshallingContext context) {
        Object vouchertypes = context.unmarshall("vouchertypes", data.element("fvchtype"));
        vchTemplate.setVchTypesSet(vouchertypes == null ? null : (VchTplVoucherTypes)vouchertypes);
    }

    @Override
    public String getType() {
        return "tpl_head";
    }
}

