/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.convert.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.ai.VCHTemplate;
import kd.fi.ai.VchTplExpression;
import kd.fi.ai.VchTplVoucherType;
import kd.fi.ai.VchTplVoucherTypes;
import kd.fi.ai.convert.core.MarshallingContext;
import kd.fi.ai.convert.core.UnmarshallingContext;
import kd.fi.ai.convert.impl.AbstractConverter;
import kd.fi.ai.util.DapFileUtil;
import kd.fi.v2.fah.dao.sys.SysBasePropDataDaoImpl;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class VchTypesConverter
extends AbstractConverter {
    private static final Log log = LogFactory.getLog(VchTypesConverter.class);

    @Override
    public Object marshal(String field, Object source, MarshallingContext context) {
        super.marshal(field, source, context);
        if (source == null) {
            return this.root;
        }
        VchTplVoucherTypes voucherTypes = (VchTplVoucherTypes)source;
        List<VchTplVoucherType> items = voucherTypes.getItems();
        if (items.size() > 0) {
            this.marshalVchTypes(items);
        }
        return this.root;
    }

    private void marshalVchTypes(List<VchTplVoucherType> items) {
        Element vchtypeNodes = DocumentHelper.createElement((String)"vchtypes");
        this.addChild(this.root, vchtypeNodes);
        for (VchTplVoucherType item : items) {
            Element vchtypeNode = DocumentHelper.createElement((String)"vchtype");
            if (StringUtils.isNotEmpty((String)item.getVchGrpNumber())) {
                this.addChild(vchtypeNode, "number", item.getVchGrpNumber());
            } else {
                DynamicObject dyn = BusinessDataServiceHelper.loadSingle((Object)item.getVchGrpId(), (String)"gl_vouchertype");
                if (dyn != null) {
                    this.addChild(vchtypeNode, "number", dyn.getString("number"));
                }
            }
            this.addChild(vchtypeNode, "filterSet", SerializationUtils.toJsonString((Object)item.getFilterSet()));
            this.addChild(vchtypeNodes, vchtypeNode);
        }
    }

    @Override
    public Object unmarshal(Object source, UnmarshallingContext context) {
        VchTplVoucherTypes voucherTypes = new VchTplVoucherTypes();
        if (source == null) {
            return voucherTypes;
        }
        Element data = (Element)source;
        if (data.elements().size() == 0) {
            return voucherTypes;
        }
        VCHTemplate vchTemplate = (VCHTemplate)context.get("vchTemplate");
        Element vchtypes = data.element("vchtypes");
        List nodes = vchtypes.elements();
        HashMap<String, String> map = new HashMap<String, String>(nodes.size());
        ArrayList<String> numbers = new ArrayList<String>(nodes.size());
        for (Element node : nodes) {
            numbers.add(node.elementText("number"));
            map.put(node.elementText("number"), node.elementText("filterSet"));
        }
        QFilter filter = new QFilter("number", "in", numbers);
        Map<Object, DynamicObject> dyns = SysBasePropDataDaoImpl.queryBaseDataMap("gl_vouchertype", DapFileUtil.getOrgId(), "id,number,name", filter);
        log.info("--DAP--vouchertype:number:" + numbers + ";DapFileUtil.getOrgId:" + DapFileUtil.getOrgId() + ";dyn:" + dyns.size());
        HashMap<String, Long> numberIdMap = new HashMap<String, Long>(dyns.size());
        HashMap<String, String> numberNameMap = new HashMap<String, String>(dyns.size());
        for (Map.Entry<Object, DynamicObject> entry : dyns.entrySet()) {
            DynamicObject dyn = entry.getValue();
            numberIdMap.put(dyn.getString("number"), dyn.getLong("id"));
            numberNameMap.put(dyn.getString("number"), dyn.getString("name"));
        }
        for (String number : numbers) {
            if (!numberIdMap.containsKey(number)) continue;
            VchTplVoucherType voucherType = new VchTplVoucherType();
            voucherType.setVchGrpId((Long)numberIdMap.get(number));
            voucherType.setVchGrpNumber(number);
            voucherType.setVchGrpName(new LocaleString((String)numberNameMap.get(number)));
            voucherType.setFilterSet((VchTplExpression)SerializationUtils.fromJsonString((String)((String)map.get(number)), VchTplExpression.class));
            voucherTypes.getItems().add(voucherType);
        }
        log.info("--DAP--voucherTypes:" + voucherTypes.getItems().size());
        return voucherTypes;
    }

    @Override
    public String getType() {
        return "vouchertypes";
    }
}

