/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.dap;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.ext.fi.ai.dap.cache.CacheKeyPrefix;
import kd.bos.ext.fi.ai.dap.cache.DapLocalCache4H;
import kd.bos.ext.fi.ai.dap.cache.LocalCacheKey;
import kd.bos.ext.fi.gl.closeperiod.BookRegisterService;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ai.AppBookConfig;
import org.apache.commons.lang3.StringUtils;

public class AppBizBookConfigCache {
    private static AppBizBookConfigCache instance = new AppBizBookConfigCache();
    private static final String AppBookConfigContainer = "fi-ai-AppBookConfig";
    private static final String BookOnOrgCache = "fi-ai-BookOnOrgCache";

    public static AppBizBookConfigCache getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AppBookConfig get(String appNum) {
        LocalCacheKey cacheKey = LocalCacheKey.getCacheKey((CacheKeyPrefix)CacheKeyPrefix.GENERATE_VOUCHER_INFO, (Object[])new Object[]{AppBookConfigContainer});
        HashMap<String, AppBookConfig> container = (HashMap<String, AppBookConfig>)DapLocalCache4H.get((LocalCacheKey)cacheKey, Map.class);
        Class<AppBizBookConfigCache> clazz = AppBizBookConfigCache.class;
        synchronized (AppBizBookConfigCache.class) {
            if (container == null) {
                container = new HashMap<String, AppBookConfig>(8);
                DapLocalCache4H.put((LocalCacheKey)cacheKey, container);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (container.isEmpty()) {
                DynamicObjectCollection bookregs = QueryServiceHelper.query((String)"bd_accountbookregister", (String)"bizapp,bookentity,orgfieldonbookentity,booktypefieldonbookentity", (QFilter[])new QFilter[]{new QFilter("bookentity", "is not null", null)});
                for (DynamicObject brg : bookregs) {
                    MainEntityType bookEntityType;
                    DynamicProperty btypeProp;
                    String app = brg.getString("bizapp");
                    if ("gl".equalsIgnoreCase(app)) continue;
                    String bookentity = brg.getString("bookentity");
                    String bookorg = brg.getString("orgfieldonbookentity");
                    String booktypefieldid = brg.getString("booktypefieldonbookentity");
                    String bookTypeEntity = null;
                    if (StringUtils.isNotBlank((CharSequence)booktypefieldid) && (btypeProp = (bookEntityType = EntityMetadataCache.getDataEntityType((String)bookentity)).getProperty(booktypefieldid)) instanceof BasedataProp) {
                        BasedataProp bbp = (BasedataProp)btypeProp;
                        bookTypeEntity = bbp.getBaseEntityId();
                    }
                    AppBookConfig acfg = new AppBookConfig(app, bookentity, bookTypeEntity, null, bookorg, booktypefieldid);
                    container.put(app, acfg);
                }
            }
            return (AppBookConfig)container.get(appNum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBookOnOrg(String appNum) {
        LocalCacheKey cacheKey = LocalCacheKey.getCacheKey((CacheKeyPrefix)CacheKeyPrefix.GENERATE_VOUCHER_INFO, (Object[])new Object[]{BookOnOrgCache});
        HashMap<String, Boolean> bookOnOrgCache = (HashMap<String, Boolean>)DapLocalCache4H.get((LocalCacheKey)cacheKey, Map.class);
        Class<AppBizBookConfigCache> clazz = AppBizBookConfigCache.class;
        synchronized (AppBizBookConfigCache.class) {
            if (bookOnOrgCache == null) {
                bookOnOrgCache = new HashMap<String, Boolean>(8);
                DapLocalCache4H.put((LocalCacheKey)cacheKey, bookOnOrgCache);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (!bookOnOrgCache.containsKey(appNum)) {
                boolean bookOnOrg = BookRegisterService.isBookOnOrg((String)appNum);
                bookOnOrgCache.put(appNum, bookOnOrg);
                return bookOnOrg;
            }
            return (Boolean)bookOnOrgCache.get(appNum);
        }
    }

    public static void clearCache() {
        Map bookOnOrgCache;
        Map container = (Map)DapLocalCache4H.get((LocalCacheKey)LocalCacheKey.getCacheKey((CacheKeyPrefix)CacheKeyPrefix.GENERATE_VOUCHER_INFO, (Object[])new Object[]{AppBookConfigContainer}), Map.class);
        if (container != null) {
            container.clear();
        }
        if ((bookOnOrgCache = (Map)DapLocalCache4H.get((LocalCacheKey)LocalCacheKey.getCacheKey((CacheKeyPrefix)CacheKeyPrefix.GENERATE_VOUCHER_INFO, (Object[])new Object[]{BookOnOrgCache}), Map.class)) != null) {
            bookOnOrgCache.clear();
        }
    }
}

