/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.dap;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kd.bos.algo.DataSet;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.fi.ai.AbstractVchTplItemMap;
import kd.fi.ai.VCHTemplate;
import kd.fi.ai.VchExpireDate;
import kd.fi.ai.VchFormulaFilterSetRow;
import kd.fi.ai.VchFormulaFilterset;
import kd.fi.ai.VchTplAcccounts;
import kd.fi.ai.VchTplAccount;
import kd.fi.ai.VchTplAccts;
import kd.fi.ai.VchTplAgrs;
import kd.fi.ai.VchTplAgrss;
import kd.fi.ai.VchTplAsst;
import kd.fi.ai.VchTplBizGroup;
import kd.fi.ai.VchTplCashflow;
import kd.fi.ai.VchTplCashflowConst;
import kd.fi.ai.VchTplDc;
import kd.fi.ai.VchTplDcs;
import kd.fi.ai.VchTplEntry;
import kd.fi.ai.VchTplExpression;
import kd.fi.ai.VchTplMainAsst;
import kd.fi.ai.VchTplSuppcfitem;
import kd.fi.ai.VchTplVoucherType;
import kd.fi.ai.VchTplVoucherTypes;
import kd.fi.bd.util.DebugTrace;
import kd.fi.v2.fah.optimizor.FahOptimizeControlPanel;

public class DapCacheMultiLangProcessUtil {
    private static final Log log = LogFactory.getLog(DapCacheMultiLangProcessUtil.class);

    public static VCHTemplate processTemplateLang(VCHTemplate tp) {
        log.info("before processTemplateLang, billNo: {}, VCHTemplate: {}", (Object)tp.getBillNo(), (Object)DapCacheMultiLangProcessUtil.toJsonStringWithTryCatch(tp));
        if (!DapCacheMultiLangProcessUtil.supportMultiLangForVchTemplateFilter()) {
            return tp;
        }
        long start = System.currentTimeMillis();
        DapCacheMultiLangProcessUtil.processVchTplHeadLang(tp);
        String entityNumber = tp.getSourceBill();
        List<VchTplBizGroup> bizGroups = tp.getBizGroups();
        for (VchTplBizGroup vbg : bizGroups) {
            List<VchTplEntry> vtes = vbg.getVchEntrys();
            for (VchTplEntry vt : vtes) {
                String entryBillEntity = entityNumber;
                if (StringUtils.isNotBlank((CharSequence)vt.getBelongSources())) {
                    entryBillEntity = vt.getBelongSources();
                }
                DapCacheMultiLangProcessUtil.processVchTplEntryLang(entryBillEntity, vt);
            }
        }
        long end = System.currentTimeMillis();
        log.info("after processTemplateLang, billNo: {}, cost: {} ms, VCHTemplate: {}", new Object[]{tp.getBillNo(), end - start, DapCacheMultiLangProcessUtil.toJsonStringWithTryCatch(tp)});
        return tp;
    }

    private static void processVchTplHeadLang(VCHTemplate tp) {
        String entityNumber = tp.getSourceBill();
        VchTplExpression vte = tp.getFilterSet();
        DapCacheMultiLangProcessUtil.processVchTplExpressionLang(entityNumber, vte);
        VchExpireDate vchDateSet2 = tp.getVchDateSet2();
        List<VchFormulaFilterSetRow> vchDateItems = DapCacheMultiLangProcessUtil.checkNullObject(vchDateSet2, VchFormulaFilterset::getItems);
        for (VchFormulaFilterSetRow vchDateItem : vchDateItems) {
            VchTplExpression filterSet = vchDateItem.getFilterSet();
            DapCacheMultiLangProcessUtil.processVchTplExpressionLang(entityNumber, filterSet);
        }
        VchExpireDate bizDateSet2 = tp.getBizDateSet2();
        List<VchFormulaFilterSetRow> bizDateItems = DapCacheMultiLangProcessUtil.checkNullObject(bizDateSet2, VchFormulaFilterset::getItems);
        for (VchFormulaFilterSetRow bizDateItem : bizDateItems) {
            VchTplExpression filterSet = bizDateItem.getFilterSet();
            DapCacheMultiLangProcessUtil.processVchTplExpressionLang(entityNumber, filterSet);
        }
        VchTplVoucherTypes vchTypesSet = tp.getVchTypesSet();
        List<VchTplVoucherType> vchTypesSetItems = DapCacheMultiLangProcessUtil.checkNullObject(vchTypesSet, VchTplVoucherTypes::getItems);
        for (VchTplVoucherType vchTypeItem : vchTypesSetItems) {
            VchTplExpression filterSet = vchTypeItem.getFilterSet();
            DapCacheMultiLangProcessUtil.processVchTplExpressionLang(entityNumber, filterSet);
        }
    }

    private static void processVchTplEntryLang(String entryBillEntity, VchTplEntry vchTplEntry) {
        VchTplExpression filterSet;
        VchTplExpression veFilter = vchTplEntry.getDataScope();
        DapCacheMultiLangProcessUtil.processVchTplExpressionLang(entryBillEntity, veFilter);
        VchTplAccts acctsSet = vchTplEntry.getAcctsSet();
        VchTplAcccounts vchTplAcccounts = DapCacheMultiLangProcessUtil.checkNullObject1(acctsSet, VchTplAccts::getVchTplAcccounts, null);
        List<VchTplAccount> acctItems = DapCacheMultiLangProcessUtil.checkNullObject(vchTplAcccounts, VchTplAcccounts::getItems);
        for (VchTplAccount acctItem : acctItems) {
            VchTplExpression filterSet2 = acctItem.getFilterSet();
            DapCacheMultiLangProcessUtil.processVchTplExpressionLang(entryBillEntity, filterSet2);
        }
        VchTplAsst asst = vchTplEntry.getAsst();
        List<AbstractVchTplItemMap> asstItemClassMaps = DapCacheMultiLangProcessUtil.checkNullObject(asst, VchTplAsst::getItemClassMaps);
        for (AbstractVchTplItemMap asstItemClassMap : asstItemClassMaps) {
            VchTplAgrss vchTplAgrss = asstItemClassMap.getVchTplAgrss();
            List<VchTplAgrs> asstItems = DapCacheMultiLangProcessUtil.checkNullObject(vchTplAgrss, VchTplAgrss::getItems);
            for (VchTplAgrs asstItem : asstItems) {
                filterSet = asstItem.getFilterSet();
                DapCacheMultiLangProcessUtil.processVchTplExpressionLang(entryBillEntity, filterSet);
            }
        }
        VchExpireDate expireDate = vchTplEntry.getExpireDate();
        List<VchFormulaFilterSetRow> expireDateItems = DapCacheMultiLangProcessUtil.checkNullObject(expireDate, VchFormulaFilterset::getItems);
        for (VchFormulaFilterSetRow expireDateItem : expireDateItems) {
            VchTplExpression filterSet3 = expireDateItem.getFilterSet();
            DapCacheMultiLangProcessUtil.processVchTplExpressionLang(entryBillEntity, filterSet3);
        }
        VchTplCashflow cashFlow = vchTplEntry.getCashflow();
        List<Object> cashFlowItems = DapCacheMultiLangProcessUtil.checkNullObject(cashFlow, VchTplCashflow::getVchFixData);
        for (Object cashFlowItem : cashFlowItems) {
            filterSet = ((VchTplCashflowConst)cashFlowItem).getFilterSet();
            DapCacheMultiLangProcessUtil.processVchTplExpressionLang(entryBillEntity, filterSet);
        }
        List<VchTplSuppcfitem> suppCashFlowItems = DapCacheMultiLangProcessUtil.checkNullObject(cashFlow, VchTplCashflow::getVchFixSuppcfData);
        for (VchTplSuppcfitem suppCashFlowItem : suppCashFlowItems) {
            VchTplExpression filterSet4 = suppCashFlowItem.getFilterSet();
            DapCacheMultiLangProcessUtil.processVchTplExpressionLang(entryBillEntity, filterSet4);
        }
        VchTplMainAsst mainAsst = vchTplEntry.getMainAsst();
        List<AbstractVchTplItemMap> mainAsstItemClassMaps = DapCacheMultiLangProcessUtil.checkNullObject(mainAsst, VchTplMainAsst::getItemClassMaps);
        for (AbstractVchTplItemMap mainAsstItemClassMap : mainAsstItemClassMaps) {
            VchTplAgrss vchTplAgrss = mainAsstItemClassMap.getVchTplAgrss();
            List<VchTplAgrs> mainAsstItems = DapCacheMultiLangProcessUtil.checkNullObject(vchTplAgrss, VchTplAgrss::getItems);
            for (VchTplAgrs mainAsstItem : mainAsstItems) {
                VchTplExpression filterSet5 = mainAsstItem.getFilterSet();
                DapCacheMultiLangProcessUtil.processVchTplExpressionLang(entryBillEntity, filterSet5);
            }
        }
        VchTplDcs dcs = vchTplEntry.getDcs();
        List<VchTplDc> dcItems = DapCacheMultiLangProcessUtil.checkNullObject(dcs, VchTplDcs::getItems);
        for (VchTplDc dcItem : dcItems) {
            VchTplExpression filterSet6 = dcItem.getFilterSet();
            DapCacheMultiLangProcessUtil.processVchTplExpressionLang(entryBillEntity, filterSet6);
        }
    }

    private static <P, T> List<T> checkNullObject(P src1, Function<P, List<T>> src2Func) {
        return DapCacheMultiLangProcessUtil.checkNullObject1(src1, src2Func, Collections.emptyList());
    }

    private static <P, R> R checkNullObject1(P src1, Function<P, R> src2Func, R defaultValue) {
        if (src1 == null) {
            return defaultValue;
        }
        R result = src2Func.apply(src1);
        if (null == result) {
            return defaultValue;
        }
        return result;
    }

    private static void processVchTplExpressionLang(String entityNumber, VchTplExpression vte) {
        if (entityNumber == null) {
            return;
        }
        if (vte == null) {
            return;
        }
        FilterCondition fc = vte.getFilterCondition();
        if (fc == null) {
            return;
        }
        DapCacheMultiLangProcessUtil.processFilterConditionLang(entityNumber, fc);
    }

    private static String toJsonStringWithTryCatch(Object obj) {
        if (!DebugTrace.enable()) {
            return "log big object close, DebugTrace.enable=false";
        }
        try {
            String jsonString = JSON.toJSONString((Object)obj);
            return jsonString.length() > 10000 ? jsonString.substring(0, 10000) : jsonString;
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    private static void processFilterConditionLang(String entityNumber, FilterCondition fc) {
        MainEntityType entityType;
        log.info("before processFilterConditionLang, entityNumber: {}, FilterCondition: {}", (Object)entityNumber, (Object)DapCacheMultiLangProcessUtil.toJsonStringWithTryCatch(fc));
        if (entityNumber.endsWith("-voucher")) {
            entityNumber = "gl_voucher";
        }
        if ((entityType = EntityMetadataCache.getDataEntityType((String)entityNumber)) == null) {
            return;
        }
        List filterRows = fc.getFilterRow();
        HashMap<Integer, List<BasedataEntityType>> baseEntityTypeListInFilterMap = new HashMap<Integer, List<BasedataEntityType>>(8);
        int index1 = -1;
        for (SimpleFilterRow sfw : filterRows) {
            ++index1;
            CompareTypeEnum ct = CompareTypeEnum.createCompareTypeEnum((String)sfw.getCompareType());
            String fieldName = sfw.getFieldName();
            String[] propArray = fieldName.split("\\.");
            if (!DapCacheMultiLangProcessUtil.isSupportCompareType(ct) && !DapCacheMultiLangProcessUtil.isSupportCompareTypeBaseDataType(ct)) continue;
            DapCacheMultiLangProcessUtil.collectBaseDataType(baseEntityTypeListInFilterMap, entityType, propArray, sfw, index1);
        }
        int index2 = -1;
        for (SimpleFilterRow sfw : filterRows) {
            Collection<Object> baseDataPkList;
            BasedataEntityType baseEntityType;
            BasedataEntityType baseEntityTypeMultiLangProp;
            String fieldName;
            String[] propArray;
            ++index2;
            CompareTypeEnum ct = CompareTypeEnum.createCompareTypeEnum((String)sfw.getCompareType());
            List values = sfw.getValue();
            if (CollectionUtils.isEmpty((Collection)values) || (propArray = (fieldName = sfw.getFieldName()).split("\\.")).length <= 1) continue;
            String lastFieldName = propArray[propArray.length - 1];
            if (!DapCacheMultiLangProcessUtil.isSupportCompareType(ct) || null == (baseEntityTypeMultiLangProp = DapCacheMultiLangProcessUtil.filterMultiLangProp(baseEntityType = DapCacheMultiLangProcessUtil.readBaseDataEntity(entityType, propArray, baseEntityTypeListInFilterMap, index2), lastFieldName)) || CollectionUtils.isEmpty(baseDataPkList = DapCacheMultiLangProcessUtil.queryBaseDataPkList(baseEntityTypeMultiLangProp, lastFieldName, values))) continue;
            String newFieldName = DapCacheMultiLangProcessUtil.getNewFieldName(propArray, baseEntityTypeMultiLangProp.getPrimaryKey().getName());
            sfw.setFieldName(newFieldName);
            DapCacheMultiLangProcessUtil.replaceCompareType(sfw, ct);
            DapCacheMultiLangProcessUtil.replaceFilterValueToId(values, baseDataPkList);
        }
        log.info("after processFilterConditionLang, entityNumber: {}, FilterCondition: {}", (Object)entityNumber, (Object)DapCacheMultiLangProcessUtil.toJsonStringWithTryCatch(fc));
    }

    private static void replaceCompareType(SimpleFilterRow sfw, CompareTypeEnum ct) {
        String newTypeId = sfw.getCompareType();
        switch (ct) {
            case EQUAL: {
                newTypeId = CompareTypeEnum.IN.getId();
                break;
            }
            case NOTEQUAL: {
                newTypeId = CompareTypeEnum.NOTIN.getId();
                break;
            }
            case ORGEQUAL: {
                newTypeId = CompareTypeEnum.ORGIN.getId();
                break;
            }
            case ORGNOTEQUAL: {
                newTypeId = CompareTypeEnum.ORGNOTIN.getId();
                break;
            }
            case ITEMCLASSEQUALS: {
                newTypeId = CompareTypeEnum.ITEMCLASSIN.getId();
                break;
            }
            case ITEMCLASSNOTEQUALS: {
                newTypeId = CompareTypeEnum.ITEMCLASSNOTIN.getId();
            }
        }
        sfw.setCompareType(newTypeId);
    }

    private static void replaceFilterValueToId(List<FilterValue> values, Collection<Object> baseDataPkList) {
        if (CollectionUtils.isNotEmpty(baseDataPkList)) {
            values.clear();
            for (Object pk : baseDataPkList) {
                FilterValue idFilterValue = new FilterValue();
                idFilterValue.setId(Uuid16.create().toString());
                idFilterValue.setValue((Object)pk.toString());
                values.add(idFilterValue);
            }
        }
        log.info("after replaceFilterValueToId, baseDataPkList.size: {}, values.size: {}, values: {}", new Object[]{baseDataPkList.size(), values.size(), DapCacheMultiLangProcessUtil.toJsonStringWithTryCatch(values)});
    }

    private static String getNewFieldName(String[] propArray, String pkField) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < propArray.length - 1; ++i) {
            stringBuilder.append(propArray[i]).append(".");
        }
        stringBuilder.append(pkField);
        return stringBuilder.toString();
    }

    private static boolean isSupportCompareTypeBaseDataType(CompareTypeEnum ct) {
        return CompareTypeEnum.CHECKBOXIN.equals((Object)ct) || CompareTypeEnum.CHECKBOXNOTIN.equals((Object)ct) || CompareTypeEnum.CHECKBOXEQUAL.equals((Object)ct) || CompareTypeEnum.CHECKBOXNOTEQUAL.equals((Object)ct);
    }

    private static boolean isSupportCompareType(CompareTypeEnum ct) {
        return CompareTypeEnum.IN.equals((Object)ct) || CompareTypeEnum.NOTIN.equals((Object)ct) || CompareTypeEnum.EQUAL.equals((Object)ct) || CompareTypeEnum.NOTEQUAL.equals((Object)ct) || CompareTypeEnum.ORGIN.equals((Object)ct) || CompareTypeEnum.ORGNOTIN.equals((Object)ct) || CompareTypeEnum.ORGEQUAL.equals((Object)ct) || CompareTypeEnum.ORGNOTEQUAL.equals((Object)ct) || CompareTypeEnum.ITEMCLASSIN.equals((Object)ct) || CompareTypeEnum.ITEMCLASSNOTIN.equals((Object)ct) || CompareTypeEnum.ITEMCLASSEQUALS.equals((Object)ct) || CompareTypeEnum.ITEMCLASSNOTEQUALS.equals((Object)ct);
    }

    private static void collectBaseDataType(Map<Integer, List<BasedataEntityType>> baseEntityTypeListInFilterMap, MainEntityType entityType, String[] propArray, SimpleFilterRow sfw, int index1) {
        if (DapCacheMultiLangProcessUtil.isBaseDataTypeFilter(entityType, propArray)) {
            List values = sfw.getValue();
            List baseDataTypeList = baseEntityTypeListInFilterMap.computeIfAbsent(index1, k -> new ArrayList(8));
            for (FilterValue fv : values) {
                Object value = fv.getValue();
                if (!(value instanceof String)) continue;
                try {
                    BasedataEntityType baseDataType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)((String)value));
                    baseDataTypeList.add(baseDataType);
                }
                catch (Exception e) {
                    log.error("processFilterConditionLang EntityMetadataCache.getDataEntityType baseDataType: {}, err: ", value, (Object)e);
                }
            }
        }
    }

    private static boolean isBaseDataTypeFilter(MainEntityType entityType, String[] propArray) {
        MainEntityType entity = entityType;
        for (int i = 0; i < propArray.length; ++i) {
            IDataEntityProperty p = (IDataEntityProperty)entity.getAllFields().get(propArray[i]);
            if (!(p instanceof BasedataProp)) {
                return p instanceof ItemClassTypeProp && i == propArray.length - 1;
            }
            BasedataProp bp = (BasedataProp)p;
            entity = EntityMetadataCache.getDataEntityType((String)bp.getBaseEntityId());
        }
        return false;
    }

    private static Collection<Object> queryBaseDataPkList(BasedataEntityType baseEntityType, String lastFieldName, List<FilterValue> values) {
        HashSet<Object> pkList = new HashSet<Object>(values.size());
        Object[] valuesArray = values.stream().map(FilterValue::getValue).toArray();
        String tableName_L = baseEntityType.getAlias() + "_L";
        String fieldName = baseEntityType.getProperty(lastFieldName).getAlias();
        SqlBuilder sqlBuilder = new SqlBuilder();
        String dbRouteKey = baseEntityType.getDBRouteKey();
        sqlBuilder.append(" select fid from ", new Object[0]).append(tableName_L, new Object[0]);
        sqlBuilder.append(" where ", new Object[0]).appendIn(fieldName, valuesArray);
        try (DataSet dataSet = DB.queryDataSet((String)"DapCache.queryBaseDataPkList", (DBRoute)DBRoute.of((String)dbRouteKey), (SqlBuilder)sqlBuilder);){
            while (dataSet.hasNext()) {
                pkList.add(dataSet.next().get("fid"));
            }
        }
        return pkList;
    }

    private static BasedataEntityType readBaseDataEntity(MainEntityType entityType, String[] propArray, Map<Integer, List<BasedataEntityType>> baseEntityTypeListInFilterMap, int index2) {
        MainEntityType entity = entityType;
        for (int i = 0; i < propArray.length - 1; ++i) {
            IDataEntityProperty p = (IDataEntityProperty)entity.getAllFields().get(propArray[i]);
            if (!(p instanceof BasedataProp)) continue;
            BasedataProp bp = (BasedataProp)p;
            if (i == propArray.length - 2) {
                BasedataEntityType baseEntityType;
                if (p instanceof ItemClassProp) {
                    baseEntityType = DapCacheMultiLangProcessUtil.matchBaseDataType(baseEntityTypeListInFilterMap, index2);
                    if (null == baseEntityType) {
                        baseEntityType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)bp.getBaseEntityId());
                    }
                } else {
                    baseEntityType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)bp.getBaseEntityId());
                }
                return baseEntityType;
            }
            entity = EntityMetadataCache.getDataEntityType((String)bp.getBaseEntityId());
        }
        return null;
    }

    private static BasedataEntityType matchBaseDataType(Map<Integer, List<BasedataEntityType>> baseEntityTypeListInFilterMap, int index2) {
        for (int i = index2 - 1; i >= 0; --i) {
            List<BasedataEntityType> baseDataEntityTypes = baseEntityTypeListInFilterMap.get(i);
            if (!CollectionUtils.isNotEmpty(baseDataEntityTypes)) continue;
            return baseDataEntityTypes.get(0);
        }
        return null;
    }

    private static BasedataEntityType filterMultiLangProp(BasedataEntityType baseEntityType, String lastFieldName) {
        if (null == baseEntityType) {
            return null;
        }
        if (baseEntityType.getProperty(lastFieldName) instanceof MuliLangTextProp) {
            return baseEntityType;
        }
        return null;
    }

    private static boolean supportMultiLangForVchTemplateFilter() {
        boolean supportMultiLangFilter = (Boolean)ThreadCache.get((Object)"supportMultiLangForVchTemplateFilter", FahOptimizeControlPanel::supportMultiLangForVchTemplateFilter);
        log.info("supportMultiLangForVchTemplateFilter: {}", (Object)supportMultiLangFilter);
        return supportMultiLangFilter;
    }
}

