/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.dap;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.fi.ai.DapBuildVoucherCommonUtil;
import kd.bos.ext.fi.ai.Voucher;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ai.dap.DapCache;

public class DapWriteAndBlackOpSetUtil {
    private static Log logger = LogFactory.getLog(DapWriteAndBlackOpSetUtil.class);
    public static final String NEEDBUILDOPS = "needbuildops";
    public static final String NOTBUILDOPS = "notbuildops";

    public static Boolean registerDapWriteAndBlackOpService(Boolean isopen, String billtype) {
        return DapBuildVoucherCommonUtil.registerDapWriteAndBlackOpService((Boolean)isopen, (String)billtype);
    }

    public static Boolean createDapTableToBill(String billtype) {
        return DapBuildVoucherCommonUtil.createDapTableToBill((String)billtype);
    }

    public static Map<String, String> getBuildVoucherOptFromBill(String billtype) {
        return DapBuildVoucherCommonUtil.getBuildVoucherOptFromBill((String)billtype);
    }

    public static Map<String, Set<Long>> splitReloperAndBilltype(String billtype, Set<Long> billIds) {
        HashMap<String, Set<Long>> result = new HashMap<String, Set<Long>>(16);
        if (billtype == null || billIds == null || billIds.isEmpty()) {
            return result;
        }
        HashSet<Long> billids = new HashSet<Long>(billIds);
        Map<String, String> buildVoucherOptFromBill = DapWriteAndBlackOpSetUtil.getBuildVoucherOptFromBill(billtype);
        String oper = DapCache.getDapConfigCache(billtype).getOper();
        oper = StringUtils.isEmpty((CharSequence)oper) ? "audit" : oper;
        String mainoper = buildVoucherOptFromBill.size() == 1 ? buildVoucherOptFromBill.entrySet().iterator().next().getKey() : oper;
        Set ids = result.computeIfAbsent(mainoper, v -> new HashSet(16));
        ids.addAll(billids);
        return result;
    }

    public static void preCheckBillidsToReoper(Set<Long> sourcebillIds, String reoper, String billtype, Long booktype, Long org) {
        Map<String, String> buildVoucherOptFromBill = DapWriteAndBlackOpSetUtil.getBuildVoucherOptFromBill(billtype);
        if (buildVoucherOptFromBill.isEmpty()) {
            return;
        }
        QFilter Fi = new QFilter("sourcebillid", "in", sourcebillIds);
        QFilter Ft = new QFilter("billtype", "=", (Object)billtype);
        QFilter Fb = new QFilter("booktype", "=", (Object)booktype);
        QFilter Fr = new QFilter("reoper", "=", (Object)reoper);
        QFilter Fo = new QFilter("org", "=", (Object)org);
        try (DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.ai.mservice.service.GenerateVoucherProcess", (String)"ai_daptracker", (String)"sourcebillid", (QFilter[])new QFilter[]{Fi, Ft, Fb, Fr, Fo}, null);){
            for (Row row : queryDataSet) {
                sourcebillIds.remove(row.getLong("sourcebillid"));
            }
        }
    }

    public static void insertReOperToMap(Map<Long, Voucher> needInCol, String reoper) {
        for (Map.Entry<Long, Voucher> ni : needInCol.entrySet()) {
            ni.getValue().setReoper(reoper);
        }
    }
}

