/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.event;

import java.io.IOException;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.JSONUtils;
import kd.fi.ai.enums.EventPagingEnum;
import kd.fi.ai.event.AiEventData;
import kd.fi.ai.event.DataSource;
import kd.fi.ai.event.EventClassMetaFromNewModel;
import kd.fi.ai.event.PkEntryPkPair;
import kd.fi.ai.util.AiEventMetaUtil;

public abstract class AbstractDataSource
implements DataSource {
    private static final int BATCH_COUNT = 2000;
    private static ThreadLocal<Map<Object, Map<Object, Object>>> thLocal = new ThreadLocal();
    private static Map<String, DataType> fieldTypeMap = new HashMap<String, DataType>();

    protected abstract DataSet queryEventData(String var1, Set<Object> var2, String var3);

    protected abstract DataSet queryEventPartition(Object var1);

    protected abstract List<Object> getEvtEntryIdList(Object var1);

    protected abstract DataSet getEvtEntryDataSet(Object var1);

    @Override
    public List<Object> batchEvtEntry(Object eventClassId, Set<Object> eventPkList) {
        ArrayList<Object> rs = new ArrayList<Object>();
        ArrayList<PkEntryPkPair> pagEvt = new ArrayList<PkEntryPkPair>();
        try (DataSet set = this.queryEventData("id", eventPkList, "id, entrycount,paging");){
            int count = 0;
            HashSet<Long> evtIdSet = new HashSet<Long>();
            for (Row row : set) {
                Long evtPk = row.getLong("id");
                if (EventPagingEnum.COMMIT.getStatus().equals(row.getString("paging"))) {
                    pagEvt.add(new PkEntryPkPair(evtPk, null));
                    List<Object> enPkList = this.getEvtEntryIdList(evtPk);
                    for (Object enPk : enPkList) {
                        pagEvt.add(new PkEntryPkPair(evtPk, enPk));
                    }
                    continue;
                }
                evtIdSet.add(evtPk);
                if ((count += row.getInteger("entrycount").intValue()) <= 2000) continue;
                rs.add(evtIdSet);
                count = 0;
                evtIdSet = new HashSet();
            }
            if (!evtIdSet.isEmpty()) {
                rs.add(evtIdSet);
            }
        }
        if (!pagEvt.isEmpty()) {
            rs.addAll(pagEvt);
        }
        return rs;
    }

    @Override
    public DynamicObjectCollection getEventObjectCollection(Object eventClassId, Object pageIds, String selector) {
        if (pageIds instanceof Set) {
            try (DataSet ds = this.getEventData(eventClassId, selector, "id", (Set)pageIds);){
                DynamicObjectCollection dynamicObjectCollection = ORM.create().toPlainDynamicObjectCollection(ds);
                return dynamicObjectCollection;
            }
        }
        if (pageIds instanceof PkEntryPkPair) {
            PkEntryPkPair pair = (PkEntryPkPair)pageIds;
            if (pair.getEntryPk() == null) {
                HashSet<Object> evtPkSet = new HashSet<Object>();
                evtPkSet.add(pair.getPk());
                try (DataSet ds = this.getEventData(eventClassId, selector, "id", evtPkSet);){
                    DynamicObjectCollection dynamicObjectCollection = ORM.create().toPlainDynamicObjectCollection(ds);
                    return dynamicObjectCollection;
                }
            }
            try (DataSet pagDataSet = this.getEntryDataSet(pair.getEntryPk(), pair.getPk(), eventClassId, selector);){
                DynamicObjectCollection dynamicObjectCollection = ORM.create().toPlainDynamicObjectCollection(pagDataSet);
                return dynamicObjectCollection;
            }
        }
        return null;
    }

    @Override
    public DataSet getEventData(Object eventClassId, String selector, Set<Object> eventPkSet) {
        return this.getEventData(eventClassId, selector, "id", eventPkSet);
    }

    private DataSet getEventData(Object eventClassId, String selector, String filterFieldName, Set<Object> valueSet) {
        Entry entry = this.getEntity(eventClassId, selector);
        List<Field> fieldList = this.getFieldList(eventClassId, selector);
        HashMap<BaseDataProp, Set<Object>> baseDataMap = new HashMap<BaseDataProp, Set<Object>>();
        ArrayList<Object[]> valList = new ArrayList<Object[]>();
        DataSet rs = this.queryEventData(filterFieldName, valueSet, "id,number,org,data_tag");
        Object object = null;
        try {
            for (Row row : rs) {
                Map ev;
                try {
                    ev = (Map)JSONUtils.cast((String)row.getString("data_tag"), Map.class);
                    ev.put("id", row.getLong("id"));
                    ev.put("org", row.getLong("org"));
                    ev.put("number", row.getString("number"));
                }
                catch (IOException e) {
                    throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
                }
                Object[] rowData = new Object[fieldList.size()];
                valList.add(rowData);
                this.createData(entry, ev, valList, rowData, baseDataMap, 0);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (rs != null) {
                if (object != null) {
                    try {
                        rs.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    rs.close();
                }
            }
        }
        DataSet billDataSet = Algo.create((String)AiEventMetaUtil.class.getName()).createDataSet(valList.iterator(), new RowMeta(fieldList.toArray(new Field[0])));
        for (Map.Entry entry2 : baseDataMap.entrySet()) {
            if (((BaseDataProp)entry2.getKey()).getSelectors().isEmpty()) continue;
            DataSet baseData = this.getBaseData((BaseDataProp)entry2.getKey(), (Set)entry2.getValue());
            billDataSet = billDataSet.leftJoin(baseData).on(((BaseDataProp)entry2.getKey()).getPath(), ((BaseDataProp)entry2.getKey()).getName() + "number").select(this.getSelectors((BaseDataProp)entry2.getKey(), billDataSet.getRowMeta()), this.getSelectors((BaseDataProp)entry2.getKey())).finish();
        }
        return billDataSet;
    }

    @Override
    public DataSet getEventData(Object eventClassId, String selector, List<AiEventData> eventData) {
        Entry entry = this.getEntity(eventClassId, selector);
        List<Field> fieldList = this.getFieldList(eventClassId, selector);
        HashMap<BaseDataProp, Set<Object>> baseDataMap = new HashMap<BaseDataProp, Set<Object>>();
        ArrayList<Object[]> valList = new ArrayList<Object[]>();
        DataSet rs = this.createAiEventDataSet(eventData);
        Object object = null;
        try {
            for (Row row : rs) {
                Map ev;
                try {
                    ev = (Map)JSONUtils.cast((String)row.getString("data_tag"), Map.class);
                    ev.put("id", row.getLong("id"));
                    ev.put("org", row.getLong("org"));
                    ev.put("number", row.getString("number"));
                }
                catch (IOException e) {
                    throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
                }
                Object[] rowData = new Object[fieldList.size()];
                valList.add(rowData);
                this.createData(entry, ev, valList, rowData, baseDataMap, 0);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (rs != null) {
                if (object != null) {
                    try {
                        rs.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    rs.close();
                }
            }
        }
        DataSet billDataSet = Algo.create((String)AiEventMetaUtil.class.getName()).createDataSet(valList.iterator(), new RowMeta(fieldList.toArray(new Field[0])));
        for (Map.Entry entry2 : baseDataMap.entrySet()) {
            if (((BaseDataProp)entry2.getKey()).getSelectors().isEmpty()) continue;
            DataSet baseData = this.getBaseData((BaseDataProp)entry2.getKey(), (Set)entry2.getValue());
            billDataSet = billDataSet.leftJoin(baseData).on(((BaseDataProp)entry2.getKey()).getPath(), ((BaseDataProp)entry2.getKey()).getName() + "number").select(this.getSelectors((BaseDataProp)entry2.getKey(), billDataSet.getRowMeta()), this.getSelectors((BaseDataProp)entry2.getKey())).finish();
        }
        return billDataSet;
    }

    private DataSet createAiEventDataSet(List<AiEventData> eventData) {
        List eventDataList = eventData.stream().map(mapper -> mapper.toObjectArray()).collect(Collectors.toList());
        return Algo.create((String)(AiEventMetaUtil.class.getName() + "createAiEventDataSet")).createDataSet(eventDataList.iterator(), ORM.create().createRowMeta("ai_event", "id,number,org,data_tag"));
    }

    protected DataSet getEntryData(Row evtPageRow, Object eventId, Object eventClassId, String selector) {
        ArrayList<Object[]> valList = new ArrayList<Object[]>();
        HashMap<BaseDataProp, Set<Object>> baseDataMap = new HashMap<BaseDataProp, Set<Object>>();
        List<Field> fieldList = this.getFieldList(eventClassId, selector);
        Object[] rowData = new Object[fieldList.size()];
        valList.add(rowData);
        Entry entity = this.getEntity(eventClassId, selector);
        try {
            List rows = (List)JSONUtils.cast((String)evtPageRow.getString("entrydata_tag"), List.class);
            Map<String, Object> evtHeadData = this.getEventHead(eventClassId, eventId);
            this.createEvtPageData(entity, evtHeadData, valList, rowData, baseDataMap, 0, evtPageRow.getString("entryname"), rows);
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
        DataSet pageDataSet = Algo.create((String)AiEventMetaUtil.class.getName()).createDataSet(valList.iterator(), new RowMeta(fieldList.toArray(new Field[0])));
        for (Map.Entry entry : baseDataMap.entrySet()) {
            if (((BaseDataProp)entry.getKey()).getSelectors().isEmpty()) continue;
            pageDataSet = pageDataSet.leftJoin(this.getBaseData((BaseDataProp)entry.getKey(), (Set)entry.getValue())).on(((BaseDataProp)entry.getKey()).getPath(), ((BaseDataProp)entry.getKey()).getName() + "number").select(this.getSelectors((BaseDataProp)entry.getKey(), pageDataSet.getRowMeta()), this.getSelectors((BaseDataProp)entry.getKey())).finish();
        }
        return pageDataSet;
    }

    private List<Field> getFieldList(Object eventClassId, String selector) {
        List<Field> fieldList;
        String key;
        Map<Object, Object> evtMap;
        Map<Object, Map<Object, Object>> threadMap = thLocal.get();
        if (threadMap == null) {
            threadMap = new HashMap<Object, Map<Object, Object>>();
            thLocal.set(threadMap);
        }
        if ((evtMap = threadMap.get(key = eventClassId + selector)) == null) {
            evtMap = new HashMap<Object, Object>();
            threadMap.put(key, evtMap);
        }
        if ((fieldList = (List<Field>)evtMap.get("fieldList")) == null) {
            Map<String, FieldType> eventClassMeta = this.getEventClassMeta(eventClassId);
            Entry entity = this.createEntry(selector, eventClassMeta);
            evtMap.put("entity", entity);
            fieldList = this.createFields(entity);
            evtMap.put("fieldList", fieldList);
        }
        return fieldList;
    }

    private Entry getEntity(Object eventClassId, String selector) {
        Entry entry;
        String key;
        Map<Object, Object> evtMap;
        Map<Object, Map<Object, Object>> threadMap = thLocal.get();
        if (threadMap == null) {
            threadMap = new HashMap<Object, Map<Object, Object>>();
            thLocal.set(threadMap);
        }
        if ((evtMap = threadMap.get(key = eventClassId + selector)) == null) {
            evtMap = new HashMap<Object, Object>();
            threadMap.put(key, evtMap);
        }
        if ((entry = (Entry)evtMap.get("entity")) == null) {
            Map<String, FieldType> eventClassMeta = this.getEventClassMeta(eventClassId);
            entry = this.createEntry(selector, eventClassMeta);
            evtMap.put("entity", entry);
            List<Field> fieldList = this.createFields(entry);
            evtMap.put("fieldList", fieldList);
        }
        return entry;
    }

    private Map<String, Object> getEventHead(Object eventClassId, Object evtPk) {
        Map eventHead;
        String key;
        Map<Object, Object> evtMap;
        Map<Object, Map<Object, Object>> threadMap = thLocal.get();
        if (threadMap == null) {
            threadMap = new HashMap<Object, Map<Object, Object>>();
            thLocal.set(threadMap);
        }
        if ((evtMap = threadMap.get(key = eventClassId + "" + evtPk)) == null) {
            evtMap = new HashMap<Object, Object>();
            threadMap.put(key, evtMap);
        }
        if ((eventHead = (Map)evtMap.get(evtPk)) == null) {
            block21: {
                HashSet<Object> idSet = new HashSet<Object>();
                idSet.add(evtPk);
                Throwable throwable = null;
                try (DataSet rs = this.queryEventData("id", idSet, "id,number,org,paging,data_tag");){
                    Iterator iterator = rs.iterator();
                    if (!iterator.hasNext()) break block21;
                    Row row = (Row)iterator.next();
                    try {
                        Map ev = (Map)JSONUtils.cast((String)row.getString("data_tag"), Map.class);
                        ev.put("id", row.getLong("id"));
                        ev.put("org", row.getLong("org"));
                        ev.put("number", row.getString("number"));
                        if (EventPagingEnum.COMMIT.getStatus().equals(row.getString("paging"))) {
                            evtMap.put(evtPk, ev);
                        }
                        Map map = ev;
                        return map;
                    }
                    catch (IOException e) {
                        try {
                            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            throw throwable3;
                        }
                    }
                }
            }
            return null;
        }
        return eventHead;
    }

    protected DataSet sumDataSet(DataSet billDataSet, String[] groupFields, String[] sumFields, Map<String, String> fldAlias, String entryPkProp) {
        ArrayList<String> selectors = new ArrayList<String>(groupFields.length + sumFields.length);
        for (String gf : groupFields) {
            selectors.add(fldAlias.get(gf));
        }
        GroupbyDataSet gbDataSet = billDataSet.groupBy(groupFields);
        for (String sf : sumFields) {
            gbDataSet.sum(sf);
            selectors.add(fldAlias.get(sf));
        }
        selectors.add("0l " + entryPkProp);
        return gbDataSet.finish().select(selectors.toArray(new String[selectors.size()]));
    }

    protected DataSet sumEntryDataSet(DataSet billDataSet, DataSet entryDataSet, String[] groupFields, String[] sumFields, Map<String, String> fldAlias, String entryPkProp) {
        billDataSet = billDataSet.union(entryDataSet);
        ArrayList<String> selectors = new ArrayList<String>(groupFields.length + sumFields.length);
        for (String gf : groupFields) {
            selectors.add(fldAlias.get(gf));
        }
        GroupbyDataSet gbDataSet = billDataSet.groupBy(selectors.toArray(new String[0]));
        for (String sf : sumFields) {
            String fieldName = fldAlias.get(sf);
            gbDataSet.sum(fieldName);
            selectors.add(fieldName);
        }
        selectors.add("0l " + entryPkProp);
        return gbDataSet.finish().select(selectors.toArray(new String[selectors.size()]));
    }

    private List<Field> createFields(Entry entity) {
        LinkedHashSet<Field> fieldSet = new LinkedHashSet<Field>();
        for (Prop f : entity.getProps()) {
            Field field;
            if (f instanceof BaseDataProp) {
                field = new Field(f.getAlias(), (DataType)DataType.LongType);
                fieldSet.add(field);
                continue;
            }
            if (f instanceof Entry) {
                fieldSet.addAll(this.createFields((Entry)f));
                continue;
            }
            field = new Field(f.getAlias(), f.getDataType());
            fieldSet.add(field);
        }
        return new ArrayList<Field>(fieldSet);
    }

    private Map<String, FieldType> getEventClassMeta(Object eventClassId) {
        Map<String, FieldType> newModelFieldMap = EventClassMetaFromNewModel.getEventClassMeta(eventClassId);
        if (null != newModelFieldMap) {
            return newModelFieldMap;
        }
        DynamicObject eventClassObj = this.getEventClassObj(eventClassId);
        DynamicObjectCollection fieldEntries = eventClassObj.getDynamicObjectCollection("fieldentryentity");
        HashMap<String, FieldType> fieldMap = new HashMap<String, FieldType>();
        for (DynamicObject field : fieldEntries) {
            String name = field.getString("fieldname");
            String type = field.getString("fieldtype");
            FieldType fieldType = new FieldType(type);
            if (type.equals("basedata")) {
                fieldType.setBaseDataEntityId((String)field.getDynamicObject("refobj").getPkValue());
            } else if (type.equals("assistant")) {
                fieldType.setBaseDataEntityId("bos_assistantdata_detail");
                fieldType.setAsstGrpId(field.getDynamicObject("assistant").getPkValue());
            } else if (type.equals("entry")) {
                DynamicObjectCollection entries = field.getDynamicObjectCollection("entryentity");
                HashMap<String, FieldType> efMap = new HashMap<String, FieldType>();
                for (DynamicObject ef : entries) {
                    String et = ef.getString("entryfieldtype");
                    String en = ef.getString("entryfieldname");
                    FieldType eft = new FieldType(et);
                    if (et.equals("basedata")) {
                        eft.setBaseDataEntityId((String)ef.getDynamicObject("entryrefobj").getPkValue());
                    } else if (et.equals("assistant")) {
                        eft.setBaseDataEntityId("bos_assistantdata_detail");
                        eft.setAsstGrpId(ef.getDynamicObject("entryassistant").getPkValue());
                    }
                    efMap.put(en, eft);
                }
                fieldType.setEntryFieldMap(efMap);
            }
            fieldMap.put(name, fieldType);
        }
        fieldMap.put("id", new FieldType("long"));
        FieldType orgField = new FieldType("org");
        orgField.setBaseDataEntityId("bos_org");
        fieldMap.put("org", orgField);
        fieldMap.put("number", new FieldType("txt"));
        return fieldMap;
    }

    protected DataSet getEntryDataSet(Object evtEntryPk, Object evtPk, Object eventClassId, String selector) {
        try (DataSet ds = this.getEvtEntryDataSet(evtEntryPk);){
            if (ds.hasNext()) {
                Row row = ds.next();
                DataSet dataSet = this.getEntryData(row, evtPk, eventClassId, selector);
                return dataSet;
            }
        }
        return null;
    }

    private DynamicObject getEventClassObj(Object eventClassId) {
        String selectFields = "number,name,fieldentryentity.fieldname, fieldentryentity.fieldalias,fieldentryentity.fieldtype,fieldentryentity.refobj,fieldentryentity.eventclass,fieldentryentity.assistant,entryentity.entryfieldname,entryentity.entryfieldalias,entryentity.entryfieldtype,entryentity.entryrefobj,entryentity.subentrydata,entryentity.entryassistant";
        return BusinessDataServiceHelper.loadSingleFromCache((Object)eventClassId, (String)"ai_eventclass", (String)selectFields);
    }

    private String[] getSelectors(BaseDataProp prop, RowMeta meta) {
        ArrayList<String> sels = new ArrayList<String>();
        for (int i = 0; i < meta.getFieldCount(); ++i) {
            Field field = meta.getField(i);
            if (field.getName().equals(prop.getPath())) continue;
            sels.add(field.getName());
        }
        return sels.toArray(new String[0]);
    }

    private String[] getSelectors(BaseDataProp prop) {
        ArrayList<String> sels = new ArrayList<String>(10);
        for (String sel : prop.getSelectors()) {
            String[] s = sel.split(" ");
            sels.add(s[s.length - 1]);
        }
        return sels.toArray(new String[0]);
    }

    private Entry createEntry(String selector, Map<String, FieldType> eventClassMeta) {
        String[] sels;
        Entry entry = new Entry(null);
        for (String s : sels = selector.split(",")) {
            String[] sa = (s = s.trim()).split(" ");
            if (sa.length == 1) {
                s = s + " " + s;
            }
            this.createFieldTree(entry, null, s, eventClassMeta);
        }
        return entry;
    }

    private void createFieldTree(Entry entry, String pSelector, String selector, Map<String, FieldType> eventClassMeta) {
        String[] sa = selector.split(" ");
        String[] fs = sa[0].split("\\.");
        String key = fs[0];
        pSelector = pSelector == null ? key : pSelector + "." + key;
        FieldType fieldType = eventClassMeta.get(key);
        if (fieldType == null) {
            return;
        }
        if (fieldType.getType().equals("entry")) {
            Entry e = entry.getEntry(key);
            int commIndex = sa[0].indexOf(46);
            String subSel = commIndex == -1 ? selector : selector.substring(commIndex + 1);
            this.createFieldTree(e, pSelector, subSel, fieldType.getEntryFieldMap());
        } else {
            String[] strs = selector.split(" ");
            boolean isBizOrgField = fieldType.getType().equals("org");
            if (isBizOrgField || fieldType.getType().equals("basedata") || fieldType.getType().equals("assistant")) {
                int commIndex;
                BaseDataProp bfs = null;
                bfs = (BaseDataProp)entry.getProps(pSelector);
                if (bfs == null) {
                    if (fs.length == 1) {
                        pSelector = sa[1];
                    }
                    bfs = new BaseDataProp(key, pSelector, fieldType.getBaseDataEntityId());
                    bfs.setBizOrg(isBizOrgField);
                    if (fieldType.getType().equals("assistant")) {
                        bfs.setAsstGrpId(fieldType.getAsstGrpId());
                    }
                    entry.addProp(bfs);
                }
                String subSel = (commIndex = sa[0].indexOf(46)) == -1 ? "id " + strs[1] : selector.substring(commIndex + 1);
                bfs.addSelector(subSel);
            } else {
                Prop prop = new Prop(key, strs[1], this.getDataType(fieldType));
                entry.addProp(prop);
            }
        }
    }

    private int createData(Entry entry, Map<String, ?> ev, List<Object[]> valList, Object[] rowData, Map<BaseDataProp, Set<Object>> baseDataMap, int index) {
        HashMap<Integer, Object> headDataMap = null;
        for (Prop f : entry.getProps()) {
            Object val = ev.get(f.getName());
            if (f instanceof Entry) {
                List v = (List)val;
                if (v != null) {
                    int ind = index;
                    for (int i = 0; i < v.size(); ++i) {
                        Map r = (Map)v.get(i);
                        if (i != 0) {
                            valList.add((Object[])rowData.clone());
                        }
                        index = this.createData((Entry)f, r, valList, rowData, baseDataMap, ind);
                    }
                } else {
                    index += ((Entry)f).getProps().size();
                }
                headDataMap = new HashMap<Integer, Object>();
                continue;
            }
            if (f instanceof BaseDataProp) {
                if (headDataMap != null) {
                    headDataMap.put(index, val);
                }
                rowData[index++] = val;
                if (StringUtils.isBlank(val)) continue;
                BaseDataProp p = (BaseDataProp)f;
                Set sels = baseDataMap.computeIfAbsent(p, key -> new HashSet());
                sels.add(val);
                continue;
            }
            Object value = this.parseValue(f, val);
            if (headDataMap != null) {
                headDataMap.put(index, value);
            }
            rowData[index++] = value;
        }
        if (headDataMap != null && !headDataMap.isEmpty()) {
            for (Object[] row : valList) {
                for (Map.Entry e : headDataMap.entrySet()) {
                    if (row[(Integer)e.getKey()] != null) continue;
                    row[((Integer)e.getKey()).intValue()] = e.getValue();
                }
            }
        }
        return index;
    }

    private int createEvtPageData(Entry selMap, Map<String, ?> ev, List<Object[]> valList, Object[] rowData, Map<BaseDataProp, Set<Object>> baseDataMap, int index, String entryKey, List<Map<String, Object>> entryData) {
        HashMap headDataMap = null;
        for (Prop prop : selMap.getProps()) {
            if (entryKey.equals(prop.getName())) {
                if (entryData == null) continue;
                int ind = index;
                for (int i = 0; i < entryData.size(); ++i) {
                    Map<String, Object> r = entryData.get(i);
                    if (i != 0) {
                        valList.add((Object[])rowData.clone());
                    }
                    index = this.createEvtPageData((Entry)prop, r, valList, rowData, baseDataMap, ind, entryKey, entryData);
                }
                headDataMap = new HashMap();
                continue;
            }
            Object val = ev.get(prop.getName());
            if (prop instanceof BaseDataProp) {
                if (headDataMap != null) {
                    headDataMap.put(index, val);
                }
                rowData[index++] = val;
                BaseDataProp p = (BaseDataProp)prop;
                Set sels = baseDataMap.computeIfAbsent(p, key -> new HashSet());
                sels.add(val);
                continue;
            }
            val = this.parseValue(prop, val);
            if (headDataMap != null) {
                headDataMap.put(index, val);
            }
            rowData[index++] = val;
        }
        if (headDataMap != null) {
            for (Object[] row : valList) {
                for (Map.Entry entry : headDataMap.entrySet()) {
                    row[((Integer)entry.getKey()).intValue()] = entry.getValue();
                }
            }
        }
        return index;
    }

    private Object parseValue(Prop field, Object val) {
        if (StringUtils.isBlank((Object)val)) {
            return null;
        }
        if (field.getDataType().equals((Object)DataType.BigDecimalType)) {
            if (StringUtils.isEmpty((CharSequence)val.toString())) {
                return null;
            }
            return new BigDecimal(val.toString());
        }
        if (field.getDataType().equals((Object)DataType.DateType)) {
            try {
                return new SimpleDateFormat("yyyy-MM-dd").parse(val.toString());
            }
            catch (ParseException e) {
                try {
                    return new SimpleDateFormat("yyyy/MM/dd").parse(val.toString());
                }
                catch (ParseException e1) {
                    throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
                }
            }
        }
        return val;
    }

    private DataType getDataType(FieldType fieldType) {
        return fieldTypeMap.get(fieldType.getType());
    }

    private DataSet getBaseData(BaseDataProp prop, Set<Object> numbers) {
        String selector = null;
        if (prop.getSelectors().isEmpty()) {
            selector = "id";
        } else {
            StringBuilder sels = new StringBuilder();
            for (String sel : prop.getSelectors()) {
                if (sels.length() > 0) {
                    sels.append(',');
                }
                sels.append(sel);
            }
            selector = sels.toString();
        }
        String idField = "id";
        selector = selector + ", " + idField + " " + prop.getName() + "number";
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        QFilter qfilter = new QFilter(idField, "in", numbers);
        qFilters.add(qfilter);
        if ("ai_eventclass".equals(prop.getEntityNumber())) {
            return this.getEventData(prop.getEventClassId(), selector, idField, numbers);
        }
        if (prop.getEntityNumber().equals("bos_assistantdata_detail")) {
            qFilters.add(new QFilter("group", "=", prop.getAsstGrpId()));
            return QueryServiceHelper.queryDataSet((String)AiEventMetaUtil.class.getName(), (String)prop.getEntityNumber(), (String)selector, (QFilter[])qFilters.toArray(new QFilter[0]), null);
        }
        return QueryServiceHelper.queryDataSet((String)AiEventMetaUtil.class.getName(), (String)prop.getEntityNumber(), (String)selector, (QFilter[])qFilters.toArray(new QFilter[0]), null);
    }

    static {
        fieldTypeMap.put("basedata", (DataType)DataType.StringType);
        fieldTypeMap.put("event", (DataType)DataType.StringType);
        fieldTypeMap.put("txt", (DataType)DataType.StringType);
        fieldTypeMap.put("number", (DataType)DataType.BigDecimalType);
        fieldTypeMap.put("date", (DataType)DataType.DateType);
        fieldTypeMap.put("boolean", (DataType)DataType.BooleanType);
        fieldTypeMap.put("long", (DataType)DataType.LongType);
        fieldTypeMap.put("int", (DataType)DataType.IntegerType);
        fieldTypeMap.put("assistant", (DataType)DataType.StringType);
    }

    class Entry
    extends Prop {
        private List<Prop> props;

        Entry(String name) {
            super(name, null, null);
            this.props = new ArrayList<Prop>();
        }

        private void addProp(Prop prop) {
            this.props.add(prop);
        }

        private List<Prop> getProps() {
            return this.props;
        }

        private Prop getProps(String propName) {
            for (Prop prop : this.props) {
                if (propName == null || !propName.equals(prop.alias)) continue;
                return prop;
            }
            return null;
        }

        private Entry getEntry(String name) {
            Entry e1 = new Entry(name);
            Entry e2 = null;
            for (Prop p : this.props) {
                if (!p.equals(e1)) continue;
                e2 = (Entry)p;
                break;
            }
            if (e2 == null) {
                this.addProp(e1);
                return e1;
            }
            return e2;
        }
    }

    class Prop {
        private String name;
        private DataType dataType;
        private String alias;

        Prop(String name, String alias, DataType dataType) {
            this.name = name;
            this.alias = alias;
            this.dataType = dataType;
        }

        public String getName() {
            return this.name;
        }

        protected DataType getDataType() {
            return this.dataType;
        }

        protected String getAlias() {
            return this.alias;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.alias == null ? 0 : this.alias.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Prop other = (Prop)obj;
            if (this.alias == null ? other.alias != null : !this.alias.equals(other.alias)) {
                return false;
            }
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }
    }

    class BaseDataProp
    extends Prop {
        private String path;
        private String entityNumber;
        private Object eventClassId;
        private Object asstGrpId;
        private boolean isBizOrg;
        private List<String> selectors;

        BaseDataProp(String name, String path, String entityNumber) {
            super(name, path, null);
            this.isBizOrg = false;
            this.selectors = new ArrayList<String>();
            this.path = path;
            this.entityNumber = entityNumber;
        }

        private String getEntityNumber() {
            return this.entityNumber;
        }

        private String getPath() {
            return this.path;
        }

        private boolean isBizOrg() {
            return this.isBizOrg;
        }

        private void setBizOrg(boolean isBizOrg) {
            this.isBizOrg = isBizOrg;
        }

        private Object getEventClassId() {
            return this.eventClassId;
        }

        public void setEventClassId(Object eventClassId) {
            this.eventClassId = eventClassId;
        }

        private Object getAsstGrpId() {
            return this.asstGrpId;
        }

        private void setAsstGrpId(Object asstGrpId) {
            this.asstGrpId = asstGrpId;
        }

        private void addSelector(String selector) {
            this.selectors.add(selector);
        }

        private List<String> getSelectors() {
            return this.selectors;
        }
    }

    static class FieldType {
        public static final String TYPE_TXT = "txt";
        public static final String TYPE_NUM = "number";
        public static final String TYPE_DATE = "date";
        public static final String TYPE_BASEDATA = "basedata";
        public static final String TYPE_ORG = "org";
        public static final String TYPE_ENTRY = "entry";
        public static final String TYPE_EVENT = "event";
        public static final String TYPE_BOOL = "boolean";
        public static final String TYPE_LONG = "long";
        public static final String TYPE_INT = "int";
        public static final String TYPE_ASSISTANT = "assistant";
        private String type;
        private String baseDataEntityId;
        private Object asstGrpId;
        private Map<String, FieldType> entryFieldMap;

        FieldType(String type) {
            this.type = type;
        }

        void setBaseDataEntityId(String baseDataEntityId) {
            this.baseDataEntityId = baseDataEntityId;
        }

        private Object getAsstGrpId() {
            return this.asstGrpId;
        }

        void setAsstGrpId(Object asstGrpId) {
            this.asstGrpId = asstGrpId;
        }

        private String getType() {
            return this.type;
        }

        private String getBaseDataEntityId() {
            return this.baseDataEntityId;
        }

        Map<String, FieldType> getEntryFieldMap() {
            return this.entryFieldMap;
        }

        void setEntryFieldMap(Map<String, FieldType> entryFieldMap) {
            this.entryFieldMap = entryFieldMap;
        }
    }
}

