/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.event;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ai.event.dto.AiEventBlockDto;
import kd.fi.ai.util.DapBuildVoucherCommonUtil;
import kd.fi.v2.fah.constant.enums.AppVersionEnum;
import kd.fi.v2.fah.dao.biz.ExtDataModelHelper;
import kd.fi.v2.fah.dao.datamodel.DataModelDaoImpl;

public class AiEventUtil {
    private static final String ENTITY_AI_EVENTTRACKER = "ai_daptracker";

    public static DynamicObjectCollection queryDapRelationById(Long id) {
        ExtDataModelHelper.ModelIdAndBillType modelIdAndBillType = ExtDataModelHelper.queryModelIdAndBillType(id);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("billtype.number", "=", (Object)modelIdAndBillType.getBillType()));
        qFilters.add(new QFilter("sourcebillid", "=", (Object)id));
        DynamicObjectCollection dyn = QueryServiceHelper.query((String)ENTITY_AI_EVENTTRACKER, (String)"sourcebillid,voucherid,org", (QFilter[])qFilters.toArray(new QFilter[0]));
        return dyn;
    }

    public static DynamicObjectCollection queryDapRelationByIds(Map<String, List<Long>> billTypeGroup) {
        QFilter qFilter = QFilter.of((String)"1!=1", (Object[])new Object[0]);
        for (Map.Entry<String, List<Long>> billTypeIds : billTypeGroup.entrySet()) {
            qFilter.or(new QFilter("billtype.id", "=", (Object)billTypeIds.getKey())).and("sourcebillid", "in", billTypeIds.getValue());
        }
        DynamicObjectCollection dyn = QueryServiceHelper.query((String)ENTITY_AI_EVENTTRACKER, (String)"sourcebillid,voucherid", (QFilter[])qFilter.toArray());
        return dyn;
    }

    public static boolean queryIsExistDapRelation(Long id) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("billtype.number", "=", (Object)"ai_event"));
        qFilters.add(new QFilter("sourcebillid", "=", (Object)id));
        DynamicObjectCollection dyn = QueryServiceHelper.query((String)ENTITY_AI_EVENTTRACKER, (String)"voucherid", (QFilter[])qFilters.toArray(new QFilter[0]));
        return dyn != null && !dyn.isEmpty();
    }

    public static boolean saveEventBlock(List<AiEventBlockDto> blockDtoList) {
        if (blockDtoList == null || blockDtoList.isEmpty()) {
            return false;
        }
        DynamicObject[] entities = new DynamicObject[blockDtoList.size()];
        for (int i = 0; i < blockDtoList.size(); ++i) {
            AiEventBlockDto dto = blockDtoList.get(i);
            DynamicObject dyEventBlock = BusinessDataServiceHelper.newDynamicObject((String)"ai_eventblock");
            dyEventBlock.set("eventclass", (Object)dto.getEventClassId());
            dyEventBlock.set("fieldname", (Object)dto.getFieldName());
            dyEventBlock.set("fieldvalue", (Object)dto.getFieldValue());
            dyEventBlock.set("eventid", (Object)dto.getEventId());
            dyEventBlock.set("textfield", (Object)dto.getPreStatus());
            entities[i] = dyEventBlock;
        }
        Object[] ret = SaveServiceHelper.save((DynamicObject[])entities);
        return ret != null && ret.length > 0;
    }

    public static String checkEventIfBlock(Set<Long> selectPks) {
        if (selectPks == null || selectPks.isEmpty()) {
            return null;
        }
        QFilter idFilter = new QFilter("eventid", "in", selectPks);
        DynamicObject eventBlock = QueryServiceHelper.queryOne((String)"ai_eventblock", (String)"textfield", (QFilter[])new QFilter[]{idFilter});
        if (eventBlock == null) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)eventBlock.getString("textfield"))) {
            return "oldData";
        }
        return eventBlock.getString("textfield");
    }

    public static Map<Long, Long> getEventBlockEventInfo(List<Object> pkIds) {
        if (pkIds == null || pkIds.isEmpty()) {
            return null;
        }
        QFilter[] filters = AiEventUtil.getEventBlockFilter(pkIds);
        if (filters == null || filters.length == 0) {
            return null;
        }
        try (DataSet dsData = QueryServiceHelper.queryDataSet((String)"AiEventUtil.getEventBlockIds", (String)"ai_eventblock", (String)"id,eventid", (QFilter[])filters, null);){
            Iterator iter = dsData.iterator();
            HashMap<Long, Long> ret = new HashMap<Long, Long>();
            while (iter != null && iter.hasNext()) {
                Row row = (Row)iter.next();
                ret.put(row.getLong("id"), row.getLong("eventid"));
            }
            HashMap<Long, Long> hashMap = ret;
            return hashMap;
        }
    }

    private static QFilter[] getEventBlockFilter(List<Object> pkIds) {
        String selectFields = "eventclassid,fieldname,fieldvalue";
        QFilter filter = new QFilter("eventid", "in", pkIds);
        try (DataSet dsData = QueryServiceHelper.queryDataSet((String)"AiEventUtil.getEventBlockFilter", (String)"ai_event_index", (String)selectFields, (QFilter[])new QFilter[]{filter}, null);){
            QFilter[] qFilterArray;
            Iterator iter = dsData.iterator();
            HashMap<String, List> fiterMap = new HashMap<String, List>();
            while (iter != null && iter.hasNext()) {
                Row row = (Row)iter.next();
                String filterKey = row.getString("eventclassid") + ":" + row.getString("fieldname");
                fiterMap.computeIfAbsent(filterKey, p -> new ArrayList()).add(row.getString("fieldvalue"));
            }
            QFilter allFilter = null;
            for (Map.Entry ety : fiterMap.entrySet()) {
                String[] evtClsNameArr = StringUtils.split((String)((String)ety.getKey()), (String)":");
                String evtClsName = evtClsNameArr[0];
                String evtClsFieldName = evtClsNameArr[1];
                QFilter evtClassIdFilter = new QFilter("eventclass", "=", (Object)Long.valueOf(evtClsName));
                QFilter fildNameFilter = new QFilter("fieldname", "=", (Object)evtClsFieldName);
                QFilter fildValueFilter = new QFilter("fieldvalue", "in", ety.getValue());
                QFilter singleFilter = evtClassIdFilter.and(fildNameFilter).and(fildValueFilter);
                if (allFilter == null) {
                    allFilter = singleFilter;
                    continue;
                }
                allFilter.or(singleFilter);
            }
            if (allFilter != null) {
                qFilterArray = allFilter.toArray();
                return qFilterArray;
            }
            qFilterArray = null;
            return qFilterArray;
        }
    }

    public static boolean deleteEventBlock(Set<Long> pkIds) {
        if (pkIds == null || pkIds.isEmpty()) {
            return false;
        }
        QFilter idFilter = new QFilter("id", "in", pkIds);
        int ret = DeleteServiceHelper.delete((String)"ai_eventblock", (QFilter[])new QFilter[]{idFilter});
        return ret > 0;
    }

    public static CRCondition getFilterCondition(String filter) {
        if (filter != null && filter.length() > 0) {
            CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)filter, CRCondition.class);
            return condition;
        }
        return null;
    }

    public static String getFilterExpression(String desc, MainEntityType entityType) {
        CRCondition condition = AiEventUtil.getFilterCondition(desc);
        String expression = null;
        if (condition != null) {
            expression = condition.getExpression();
            if (condition.getFilterCondition() != null) {
                expression = condition.buildFullFormula(entityType);
            }
        }
        return expression;
    }

    private static Map<Long, Long> getEventBlockEventInfoNew(Long modelMasterId, String modelNum, List<Object> pkIds) {
        if (pkIds == null || pkIds.isEmpty() || StringUtils.isEmpty((CharSequence)modelNum)) {
            return null;
        }
        QFilter[] filters = AiEventUtil.getEventBlockFilterNew(modelMasterId, modelNum, pkIds);
        if (filters == null || filters.length == 0) {
            return null;
        }
        try (DataSet dsData = QueryServiceHelper.queryDataSet((String)"AiEventUtil.getEventBlockIds", (String)"ai_eventblock", (String)"id,eventid", (QFilter[])filters, null);){
            Iterator iter = dsData.iterator();
            HashMap<Long, Long> ret = new HashMap<Long, Long>();
            while (iter != null && iter.hasNext()) {
                Row row = (Row)iter.next();
                ret.put(row.getLong("id"), row.getLong("eventid"));
            }
            HashMap<Long, Long> hashMap = ret;
            return hashMap;
        }
    }

    private static QFilter[] getEventBlockFilterNew(Long modelMasterId, String modelNum, List<Object> pkIds) {
        DynamicObject[] relations = DataModelDaoImpl.getModelRelationsAsPreModel(modelMasterId);
        if (null == relations || 0 == relations.length) {
            return null;
        }
        Set<String> preFieldSet = AiEventUtil.getPreFieldSet(relations);
        SqlBuilder sqlBuilder = AiEventUtil.createSql(modelNum, preFieldSet, pkIds);
        HashMap<String, Set> fieldValuesMap = new HashMap<String, Set>(preFieldSet.size());
        try (DataSet dataSet = DB.queryDataSet((String)"AiEventUtil.getEventBlockFilterNew", (DBRoute)DBRoute.of((String)"ai"), (SqlBuilder)sqlBuilder);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                for (String string : preFieldSet) {
                    fieldValuesMap.computeIfAbsent(string, k -> new HashSet(pkIds.size())).add(row.getString(string));
                }
            }
        }
        LinkedList<QFilter> allFilters = new LinkedList<QFilter>();
        QFilter evtClassIdFilter = new QFilter("eventclass", "=", (Object)modelMasterId);
        allFilters.add(evtClassIdFilter);
        QFilter fieldFilter = null;
        for (Map.Entry entry : fieldValuesMap.entrySet()) {
            String field = (String)entry.getKey();
            Set values = (Set)entry.getValue();
            QFilter fildNameFilter = new QFilter("fieldname", "=", (Object)field);
            QFilter fildValueFilter = new QFilter("fieldvalue", "in", (Object)values);
            if (fieldFilter == null) {
                fieldFilter = fildNameFilter.and(fildValueFilter);
                allFilters.add(fieldFilter);
                continue;
            }
            fieldFilter.or(fildNameFilter.and(fildValueFilter));
        }
        return allFilters.toArray(new QFilter[0]);
    }

    private static SqlBuilder createSql(String modelNum, Set<String> preFieldSet, List<Object> pkIds) {
        String tableName = DataModelDaoImpl.getTableName(modelNum);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fid", new Object[0]);
        for (String preField : preFieldSet) {
            sqlBuilder.append(",f" + preField, new Object[0]).append(preField, new Object[0]);
        }
        sqlBuilder.append("from", new Object[0]).append(tableName, new Object[0]).appendIn("where fid", pkIds);
        return sqlBuilder;
    }

    private static Set<String> getPreFieldSet(DynamicObject[] relations) {
        HashSet<String> preFieldSet = new HashSet<String>(relations.length);
        for (DynamicObject relation : relations) {
            preFieldSet.add(relation.getString("predatafield"));
        }
        return preFieldSet;
    }

    public static Map<Long, Long> getEventBlockEventInfoV2(Map<String, List<Long>> srcBillMap) {
        HashMap<Long, Long> blockEventMapNew = new HashMap<Long, Long>(8);
        for (Map.Entry<String, List<Long>> entry : srcBillMap.entrySet()) {
            String srcBillType = entry.getKey();
            List<Long> srcBillIds = entry.getValue();
            String modelNum = srcBillType.replaceFirst("fah_e_", "");
            DynamicObject model = DataModelDaoImpl.queryDataModelByNumberCommon(modelNum);
            Map<Long, Long> blockEventMap = AiEventUtil.getEventBlockEventInfoV2Inner(model, Arrays.asList(srcBillIds.toArray()));
            if (null == blockEventMap || blockEventMap.size() <= 0) continue;
            blockEventMapNew.putAll(blockEventMap);
        }
        return blockEventMapNew;
    }

    public static Map<Long, Long> getEventBlockEventInfoV2(Long modelMasterId, List<Object> pkIds) {
        DynamicObject model = DataModelDaoImpl.queryDataModelById(modelMasterId);
        return AiEventUtil.getEventBlockEventInfoV2Inner(model, pkIds);
    }

    private static Map<Long, Long> getEventBlockEventInfoV2Inner(DynamicObject model, List<Object> pkIds) {
        if (String.valueOf(AppVersionEnum.NEW_APP.getCode()).equals(model.get("appversion"))) {
            return AiEventUtil.getEventBlockEventInfoNew(model.getLong("masterid"), model.getString("number"), pkIds);
        }
        return AiEventUtil.getEventBlockEventInfo(pkIds);
    }

    public static void updateHasVoucher(List<Long> ids, boolean value) {
        if (ids == null || ids.isEmpty()) {
            return;
        }
        if (ids.size() > 1998) {
            List<List<Long>> prtIds = DapBuildVoucherCommonUtil.splitbatch(ids, 999);
            for (List<Long> pIds : prtIds) {
                SqlBuilder sqlBuilder = new SqlBuilder();
                sqlBuilder.append("update t_ai_event set fhasvoucher=? where ", new Object[]{value}).appendIn(" fid ", new ArrayList<Long>(pIds));
                DB.execute((DBRoute)DBRoute.of((String)"ai"), (SqlBuilder)sqlBuilder);
            }
        } else {
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append("update t_ai_event set fhasvoucher=? where ", new Object[]{value}).appendIn(" fid ", new ArrayList<Long>(ids));
            DB.execute((DBRoute)DBRoute.of((String)"ai"), (SqlBuilder)sqlBuilder);
        }
    }
}

