/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.event;

import java.util.HashMap;
import java.util.Map;
import kd.fi.ai.event.AbstractDataSource;
import kd.fi.v2.fah.constant.enums.DataValueTypeEnum;
import kd.fi.v2.fah.constant.enums.DefaultDataFieldGroupEnum;
import kd.fi.v2.fah.context.ExtDataSaveCtxHelper;
import kd.fi.v2.fah.dao.biz.ExtDataModelHelper;
import kd.fi.v2.fah.models.modeling.impl.DataModelCfg;
import kd.fi.v2.fah.models.modeling.impl.DataModelFieldCfg;
import kd.fi.v2.fah.models.modeling.impl.DataModelFieldCollection;
import kd.fi.v2.fah.storage.impl.BaseMutableArrayMapStorage;

public class EventClassMetaFromNewModel {
    public static Map<String, AbstractDataSource.FieldType> getEventClassMeta(Object eventClassId) {
        if (ExtDataModelHelper.checkNewModelFromCache((Long)eventClassId)) {
            DataModelCfg modelCfg = ExtDataSaveCtxHelper.getExtDataSaveCtx().getModelCfg();
            return EventClassMetaFromNewModel.getEventClassMetaV1(modelCfg);
        }
        return null;
    }

    private static Map<String, AbstractDataSource.FieldType> getEventClassMetaV1(DataModelCfg modelCfg) {
        HashMap<String, AbstractDataSource.FieldType> headFieldMap = new HashMap<String, AbstractDataSource.FieldType>(8);
        for (DataModelFieldCollection d : (BaseMutableArrayMapStorage)modelCfg.getCollections()) {
            String[] splits = d.getNumber().split("\\|");
            if (DefaultDataFieldGroupEnum.ENTRY.getKey().equals(splits[0]) && splits.length > 1) {
                AbstractDataSource.FieldType entryFieldType = new AbstractDataSource.FieldType("entry");
                HashMap<String, AbstractDataSource.FieldType> efMap = new HashMap<String, AbstractDataSource.FieldType>(8);
                entryFieldType.setEntryFieldMap(efMap);
                Map<String, AbstractDataSource.FieldType> parentFieldMap = EventClassMetaFromNewModel.getParentFieldMap(d, headFieldMap);
                parentFieldMap.put(splits[splits.length - 1], entryFieldType);
                EventClassMetaFromNewModel.transToFieldType(efMap, d);
                continue;
            }
            if (!DefaultDataFieldGroupEnum.HEAD.getKey().equals(splits[0]) || splits.length <= 1) continue;
            EventClassMetaFromNewModel.transToFieldType(headFieldMap, d);
        }
        headFieldMap.put("id", new AbstractDataSource.FieldType("long"));
        AbstractDataSource.FieldType orgField = new AbstractDataSource.FieldType("org");
        orgField.setBaseDataEntityId("bos_org");
        headFieldMap.put("org", orgField);
        headFieldMap.put("number", new AbstractDataSource.FieldType("txt"));
        return headFieldMap;
    }

    private static void transToFieldType(Map<String, AbstractDataSource.FieldType> fieldMap, DataModelFieldCollection fieldCollection) {
        for (DataModelFieldCfg f : (BaseMutableArrayMapStorage)fieldCollection.getCollections()) {
            AbstractDataSource.FieldType fieldType = EventClassMetaFromNewModel.getFieldType(f);
            fieldMap.put(f.getItemKey(), fieldType);
        }
    }

    private static Map<String, AbstractDataSource.FieldType> getParentFieldMap(DataModelFieldCollection fieldCollection, Map<String, AbstractDataSource.FieldType> headFieldMap) {
        String[] split;
        if (fieldCollection.getGroupLevel() == 1) {
            return headFieldMap;
        }
        DataModelFieldCollection parentFieldCollection = fieldCollection.getParentGroup();
        if (null == parentFieldCollection) {
            throw new RuntimeException("not found parent entry group!");
        }
        Map<String, AbstractDataSource.FieldType> parentFieldMap = EventClassMetaFromNewModel.getParentFieldMap(parentFieldCollection, headFieldMap);
        AbstractDataSource.FieldType fieldType = parentFieldMap.computeIfAbsent((split = parentFieldCollection.getNumber().split("\\|"))[split.length - 1], k -> new AbstractDataSource.FieldType("entry"));
        if (null == fieldType.getEntryFieldMap()) {
            fieldType.setEntryFieldMap(new HashMap<String, AbstractDataSource.FieldType>(8));
        }
        return fieldType.getEntryFieldMap();
    }

    private static AbstractDataSource.FieldType getFieldType(DataModelFieldCfg fieldCfg) {
        String type = EventClassMetaFromNewModel.transType(fieldCfg.getDataType());
        AbstractDataSource.FieldType fieldType = new AbstractDataSource.FieldType(type);
        if (fieldCfg.getDataType() == DataValueTypeEnum.BaseProp) {
            fieldType.setBaseDataEntityId(fieldCfg.getRefBaseProp());
        } else if (fieldCfg.getDataType() == DataValueTypeEnum.AssistProp) {
            fieldType.setBaseDataEntityId("bos_assistantdata_detail");
            fieldType.setAsstGrpId(fieldCfg.getRefAssistProp());
        }
        return fieldType;
    }

    private static String transType(DataValueTypeEnum dataType) {
        String type;
        switch (dataType) {
            case BaseProp: {
                type = "basedata";
                break;
            }
            case AssistProp: {
                type = "assistant";
                break;
            }
            case Date: {
                type = "date";
                break;
            }
            case Bool: {
                type = "boolean";
                break;
            }
            case Decimal: {
                type = "number";
                break;
            }
            case Int: {
                type = "int";
                break;
            }
            case String: {
                type = "txt";
                break;
            }
            default: {
                type = "txt";
            }
        }
        return type;
    }
}

