/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.function;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.form.IFormView;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.func.AbstractFuncParamPlugIn;
import kd.fi.ai.util.DapUtil;

public class GetFlexAssValuePlugin
extends AbstractFuncParamPlugIn {
    private static final String FlexProp = "flexprop";
    public static final String ASSTYPE_KEY = "asstypekey";

    public void afterCreateNewData(EventObject e) {
        Long assTypeKey = this.getAssTypeKey();
        if (assTypeKey != 0L) {
            this.getModel().setValue("asstype", (Object)assTypeKey);
        }
        MainEntityType entityType = DapUtil.getEntityTypeByNumber(this.getEntityNumber());
        List<ComboItem> flexItems = this.buildFlexPropComboItems(entityType);
        ComboEdit flexEditor = (ComboEdit)this.getView().getControl(FlexProp);
        flexEditor.setComboItems(flexItems);
        if (flexItems.size() > 1) {
            this.getModel().setValue(FlexProp, (Object)flexItems.get(1).getValue());
        }
    }

    public Boolean checkSetting(StringBuilder msgBuilder) {
        DynamicObject assTypeObj = (DynamicObject)this.getModel().getValue("asstype");
        if (assTypeObj == null) {
            msgBuilder.append(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ef4\u5ea6\u3002", (String)"GetFlexAssValuePlugin_0", (String)"fi-ai-common", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        String flexProp = (String)this.getModel().getValue(FlexProp);
        if (flexProp == null) {
            msgBuilder.append(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f39\u6027\u57df\u5c5e\u6027\u3002", (String)"GetFlexAssValuePlugin_1", (String)"fi-ai-common", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public String getSetting() {
        DynamicObject assTypeObj = (DynamicObject)this.getModel().getValue("asstype");
        String flexprop = (String)this.getModel().getValue(FlexProp);
        String setting = String.format("%s('%s', %s)", this.getFuncId(), assTypeObj.getString("flexfield"), flexprop + ".value");
        return setting;
    }

    protected String getEntityNumber() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return null;
        }
        Object entityNumber = parentView.getFormShowParameter().getCustomParam("entitynumber");
        if (entityNumber == null) {
            return null;
        }
        return String.valueOf(entityNumber);
    }

    protected Long getAssTypeKey() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return 0L;
        }
        if ((parentView = parentView.getParentView()) == null) {
            return 0L;
        }
        Object assTypeKey = parentView.getFormShowParameter().getCustomParam(ASSTYPE_KEY);
        if (assTypeKey == null) {
            return 0L;
        }
        return (Long)assTypeKey;
    }

    private List<ComboItem> buildFlexPropComboItems(MainEntityType srcMainEntityType) {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        ComboItem blankItem = new ComboItem();
        blankItem.setValue("");
        blankItem.setCaption(new LocaleString());
        items.add(blankItem);
        this.searchBDField((EntityType)srcMainEntityType, items, null, null, true, true, true);
        return items;
    }

    private void searchBDField(EntityType entityType, List<ComboItem> items, String parentName, String parentKey, boolean searchEntry, boolean searchSubEntry, boolean searchBD) {
        for (IDataEntityProperty prop : entityType.getProperties()) {
            String parentNameSub;
            String parentKeySub;
            if (prop instanceof SubEntryProp) {
                if (!searchSubEntry || parentKey == null) continue;
                parentKeySub = parentKey + "." + prop.getName();
                parentNameSub = parentName + "." + prop.getDisplayName().toString();
                this.searchBDField((EntityType)((SubEntryProp)prop).getItemType(), items, parentNameSub, parentKeySub, false, false, searchBD);
                continue;
            }
            if (searchEntry && prop instanceof EntryProp) {
                parentKeySub = (parentKey == null ? "" : parentKey + ".") + prop.getName();
                parentNameSub = (parentName == null ? "" : parentName + ".") + prop.getDisplayName().toString();
                this.searchBDField((EntityType)((EntryProp)prop).getItemType(), items, parentNameSub, parentKeySub, false, searchSubEntry, searchBD);
                continue;
            }
            if (prop instanceof FlexProp) {
                parentKeySub = (parentKey == null ? "" : parentKey + ".") + prop.getName();
                parentNameSub = (parentName == null ? entityType.getDisplayName().toString() : parentName) + "." + prop.getDisplayName().toString();
                ComboItem item = new ComboItem();
                item.setValue(parentKeySub);
                item.setCaption(new LocaleString(parentNameSub));
                items.add(item);
                continue;
            }
            if (!searchBD || !(prop instanceof BasedataProp)) continue;
            parentKeySub = (parentKey == null ? "" : parentKey + ".") + prop.getName();
            parentNameSub = (parentName == null ? entityType.getDisplayName().toString() : parentName) + "." + prop.getDisplayName().toString();
            this.searchBDField((EntityType)EntityMetadataCache.getDataEntityType((String)((BasedataProp)prop).getBaseEntityId()), items, parentNameSub, parentKeySub, false, false, false);
        }
    }
}

