/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.function;

import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.func.AbstractFuncParamPlugIn;
import kd.bos.form.plugin.IFormPlugin;
import kd.fi.ai.ExpressionType;
import kd.fi.ai.util.EntityFieldTreeOption;
import kd.fi.ai.util.EntityFieldTreeResult;
import kd.fi.ai.util.EntityTreeUtil;

public class GetMappingBaseDataPlugIn
extends AbstractFuncParamPlugIn {
    private static final String SrcID = "srcid";
    private static final String SRCIDVALUE = "srcidvalue";
    private static final String DestEntityKey = "destentitykey";
    private static final String PropertyName = "propertyname";
    private static final String MappingID = "mapping";
    private static final String MULSRCENTITYKEY = "mulsrcentitykey";
    private static final String MULSRCENTITYVALUE = "mulsrcentityvalue";
    private static final String AI_FUNC_MAPPINGDATA_MUL = "ai_func_mappingdata_mul";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{SrcID, PropertyName});
    }

    public void propertyChanged(PropertyChangedArgs args) {
        IDataEntityProperty property = args.getProperty();
        if (MappingID.equals(property.getName())) {
            ChangeData[] changeSet = args.getChangeSet();
            DynamicObject dynamic = (DynamicObject)changeSet[0].getNewValue();
            this.getModel().setValue(MULSRCENTITYKEY, dynamic.get("factorvalue"));
            this.getModel().setValue(MULSRCENTITYVALUE, dynamic.get("factorname"));
            this.getModel().setValue(DestEntityKey, dynamic.get("destbasedata.number"));
            this.getModel().setValue(SrcID, (Object)"");
            this.getModel().setValue(SRCIDVALUE, (Object)"");
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equalsIgnoreCase((CharSequence)source.getKey(), (CharSequence)SrcID)) {
            IDataModel model = this.getModel();
            String mulsrcentitykey = (String)model.getValue(MULSRCENTITYKEY);
            if (StringUtils.isEmpty((CharSequence)mulsrcentitykey)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6620\u5c04\u5173\u7cfb\u3002", (String)"GetMappingBaseDataPlugIn_4", (String)"fi-ai-common", (Object[])new Object[0]));
                return;
            }
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId(AI_FUNC_MAPPINGDATA_MUL);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCustomParam(MULSRCENTITYKEY, model.getValue(MULSRCENTITYKEY));
            showParameter.setCustomParam(MULSRCENTITYVALUE, model.getValue(MULSRCENTITYVALUE));
            showParameter.setCustomParam(SRCIDVALUE, model.getValue(SRCIDVALUE));
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SrcID));
            this.getView().showForm(showParameter);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)source.getKey(), (CharSequence)PropertyName)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("botp_selectfield");
            DynamicObject sourceEntity = (DynamicObject)this.getModel().getValue(DestEntityKey);
            if (sourceEntity != null) {
                MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)sourceEntity.getPkValue().toString());
                EntityFieldTreeResult result = this.getEntityFieldTreeResult(mainType);
                TreeNode tree = EntityTreeUtil.buildBillTree(result.getNodes());
                String treeJson = SerializationUtils.toJsonString((Object)tree);
                showParameter.getCustomParams().put("treenodes", treeJson);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, PropertyName));
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(showParameter);
            }
        }
    }

    private EntityFieldTreeResult getEntityFieldTreeResult(MainEntityType mainType) {
        EntityFieldTreeOption option = EntityFieldTreeOption.create();
        option.setEntityType((IDataEntityType)mainType);
        option.setReadEntryEntity(false);
        option.setExprType(ExpressionType.Condition);
        option.setIncludeID(true);
        EntityFieldTreeResult result = EntityTreeUtil.getEntityFieldNodes(option);
        return result;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)SrcID)) {
            String returnData = (String)closedCallBackEvent.getReturnData();
            this.getModel().setValue(SRCIDVALUE, (Object)returnData);
            String srcid = this.getSrcId(returnData);
            this.getModel().setValue(SrcID, (Object)srcid);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)PropertyName)) {
            this.getModel().setValue(PropertyName, closedCallBackEvent.getReturnData());
        }
    }

    private String getSrcId(String returnData) {
        StringBuilder builder = new StringBuilder();
        String mulsrcentitykey = (String)this.getModel().getValue(MULSRCENTITYKEY);
        String mulsrcentityvalue = (String)this.getModel().getValue(MULSRCENTITYVALUE);
        if (StringUtils.isNotEmpty((CharSequence)returnData) && StringUtils.isNotEmpty((CharSequence)mulsrcentitykey) && StringUtils.isNotEmpty((CharSequence)mulsrcentityvalue)) {
            Map map = (Map)SerializationUtils.fromJsonString((String)returnData, Map.class);
            String[] keys = mulsrcentitykey.split(",");
            String[] values = mulsrcentityvalue.split(",");
            int length = keys.length;
            for (int i = 0; i < length; ++i) {
                String key = keys[i];
                String value = values[i];
                builder.append(value).append(":").append((String)map.get(key)).append("\uff0c");
            }
            if (builder.length() > 0) {
                return builder.substring(0, builder.length() - 1);
            }
        }
        return builder.toString();
    }

    public Boolean checkSetting(StringBuilder msgBuilder) {
        Object mappingKey = this.getModel().getValue(MappingID);
        if (mappingKey == null) {
            msgBuilder.append(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6620\u5c04\u5173\u7cfb\u5b9e\u4f53\u6807\u8bc6\u3002", (String)"GetMappingBaseDataPlugIn_0", (String)"fi-ai-common", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        String srcID = (String)this.getModel().getValue(SrcID);
        if (StringUtils.isBlank((CharSequence)srcID)) {
            msgBuilder.append(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6765\u6e90ID\u5c5e\u6027\u3002", (String)"GetMappingBaseDataPlugIn_1", (String)"fi-ai-common", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        Object destEntityKey = this.getModel().getValue(DestEntityKey);
        if (destEntityKey == null) {
            msgBuilder.append(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76ee\u6807\u57fa\u7840\u8d44\u6599\u5b9e\u4f53\u6807\u8bc6\u3002", (String)"GetMappingBaseDataPlugIn_2", (String)"fi-ai-common", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        String propertyname = (String)this.getModel().getValue(PropertyName);
        if (StringUtils.isBlank((CharSequence)propertyname)) {
            msgBuilder.append(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76ee\u6807\u57fa\u7840\u8d44\u6599\u53d6\u503c\u5c5e\u6027\u3002", (String)"GetMappingBaseDataPlugIn_3", (String)"fi-ai-common", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public String getSetting() {
        DynamicObject sourceEntity = (DynamicObject)this.getModel().getValue(DestEntityKey);
        String sourceEntityName = sourceEntity.getString("number");
        String propertyname = (String)this.getModel().getValue(PropertyName);
        DynamicObject mapping = (DynamicObject)this.getModel().getValue(MappingID);
        String mappingid = "";
        if (mapping != null) {
            mappingid = mapping.getString("id");
        }
        String srcidvalue = (String)this.getModel().getValue(SRCIDVALUE);
        Map map = (Map)SerializationUtils.fromJsonString((String)srcidvalue, Map.class);
        StringBuilder builder = new StringBuilder();
        String setting = "";
        String currentEntityName = "";
        String currentBillID = "";
        int row = 0;
        for (Map.Entry entry : map.entrySet()) {
            currentEntityName = (String)entry.getKey();
            currentBillID = (String)entry.getValue();
            if (row < 1) {
                setting = String.format("%s('%s', %s, '%s', '%s', '%s'", this.getFuncId(), currentEntityName, currentBillID, sourceEntityName, propertyname, mappingid);
                builder.append(setting);
            } else {
                builder.append(",'").append(currentEntityName).append("',").append(currentBillID);
            }
            ++row;
        }
        builder.append(")");
        return builder.toString();
    }
}

