/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.function;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.func.AbstractFuncParamPlugIn;
import kd.bos.form.plugin.IFormPlugin;
import kd.fi.ai.ExpressionType;
import kd.fi.ai.util.DapUtil;
import kd.fi.ai.util.EntityFieldTreeOption;
import kd.fi.ai.util.EntityFieldTreeResult;
import kd.fi.ai.util.EntityTreeUtil;

public class GetMappingSrcMulPlugIn
extends AbstractFuncParamPlugIn {
    private static final String ENTRYSRCID = "entrysrcid";
    private static final String MULSRCENTITYKEY = "mulsrcentitykey";
    private static final String MULSRCENTITYVALUE = "mulsrcentityvalue";
    private static final String SRCIDVALUE = "srcidvalue";
    private static final String ENTRYSRCKEY = "entrysrckey";
    private static final String ENTRYSRCVALUE = "entrysrcvalue";
    private static final String ENTRYENTITY = "entryentity";
    private static final String BTNOK = "btnok";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{ENTRYSRCID, BTNOK});
    }

    public void afterCreateNewData(EventObject e) {
        String mulKey = (String)this.getView().getFormShowParameter().getCustomParam(MULSRCENTITYKEY);
        String mulValue = (String)this.getView().getFormShowParameter().getCustomParam(MULSRCENTITYVALUE);
        String srcidvalue = (String)this.getView().getFormShowParameter().getCustomParam(SRCIDVALUE);
        if (StringUtils.isBlank((CharSequence)mulKey) || StringUtils.isBlank((CharSequence)mulValue)) {
            return;
        }
        String[] mulKeys = mulKey.split(",");
        String[] mulValues = mulValue.split(",");
        int length = mulKeys.length;
        Map map = new HashMap(length);
        if (StringUtils.isNotBlank((CharSequence)srcidvalue)) {
            map = (Map)SerializationUtils.fromJsonString((String)srcidvalue, Map.class);
        }
        DynamicObjectCollection entries = this.getModel().getEntryEntity(ENTRYENTITY);
        entries.clear();
        for (int i = 0; i < length; ++i) {
            DynamicObject row = entries.addNew();
            row.set("seq", (Object)(i + 1));
            row.set(ENTRYSRCKEY, (Object)mulKeys[i]);
            row.set(ENTRYSRCVALUE, (Object)mulValues[i]);
            row.set(ENTRYSRCID, map.get(mulKeys[i]));
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)ENTRYSRCID)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("botp_selectfield");
            MainEntityType mainType = DapUtil.getEntityTypeByNumber(this.getEntityNumber());
            EntityFieldTreeResult result = this.getEntityFieldTreeResult(mainType);
            TreeNode tree = EntityTreeUtil.buildBillTree(result.getNodes());
            String treeJson = SerializationUtils.toJsonString((Object)tree);
            showParameter.getCustomParams().put("treenodes", treeJson);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ENTRYSRCID));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParameter);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)BTNOK)) {
            DynamicObjectCollection entries = this.getModel().getEntryEntity(ENTRYENTITY);
            int size = entries.size();
            HashMap<String, String> map = new HashMap<String, String>(size);
            for (DynamicObject row : entries) {
                String entrysrcid = (String)row.get(ENTRYSRCID);
                if (StringUtils.isEmpty((CharSequence)entrysrcid)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6765\u6e90ID\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GetMappingSrcMulPlugIn_0", (String)"fi-ai-common", (Object[])new Object[0]));
                    return;
                }
                map.put((String)row.get(ENTRYSRCKEY), entrysrcid);
            }
            this.getView().returnDataToParent((Object)SerializationUtils.toJsonString(map));
            this.getView().close();
        }
    }

    private EntityFieldTreeResult getEntityFieldTreeResult(MainEntityType mainType) {
        EntityFieldTreeOption option = EntityFieldTreeOption.create();
        option.setEntityType((IDataEntityType)mainType);
        option.setReadEntryEntity(false);
        option.setExprType(ExpressionType.Condition);
        option.setIncludeID(true);
        EntityFieldTreeResult result = EntityTreeUtil.getEntityFieldNodes(option);
        return result;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String returnStr = (String)closedCallBackEvent.getReturnData();
        if (StringUtils.isBlank((CharSequence)returnStr)) {
            return;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)ENTRYSRCID)) {
            IDataModel model = this.getModel();
            int index = model.getEntryCurrentRowIndex(ENTRYENTITY);
            model.setValue(ENTRYSRCID, (Object)returnStr, index);
        }
    }
}

