/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.function;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.botp.ConvertDataService;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.formula.ExpressionContext;
import kd.bos.entity.function.BOSUDFunction;
import kd.bos.ext.fi.ai.relation.BOTPRelationShip;
import kd.bos.ext.fi.ai.relation.IGetBillRelationShip;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ai.function.Function;
import kd.fi.ai.function.IBatchFunctionHandler;

public class GetSourceBillPropertyValue
implements BOSUDFunction,
IBatchFunctionHandler {
    private static Log log = LogFactory.getLog(GetSourceBillPropertyValue.class);
    private ExpressionContext expContext;

    public GetSourceBillPropertyValue() {
    }

    public GetSourceBillPropertyValue(ExpressionContext expContext) {
        this.expContext = expContext;
    }

    public BOSUDFunction getInstance(ExpressionContext expContext) {
        return new GetSourceBillPropertyValue(expContext);
    }

    public Object call(Object ... arg) {
        String currentEntityName = (String)arg[0];
        long currentBillId = Long.parseLong(arg[1].toString());
        String sourceEntityName = (String)arg[2];
        if (arg[3] == null) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u5355\u636e\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GetSourceBillPropertyValue_0", (String)"fi-ai-common", (Object[])new Object[0]));
        }
        if (!(arg[3] instanceof String)) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u5355\u636e\u5c5e\u6027\u5e94\u914d\u7f6e\u4e3a\u5b57\u7b26\u7c7b\u578b\u3002", (String)"GetSourceBillPropertyValue_1", (String)"fi-ai-common", (Object[])new Object[0]));
        }
        String propertyName = (String)arg[3];
        String key = currentEntityName + "-" + currentBillId + "-" + sourceEntityName + "-" + propertyName;
        if (arg.length > 7) {
            Object bookTypeId = arg[5];
            int rownum = (Integer)arg[6];
            String entrydc = (String)arg[7];
            key = key + "-" + bookTypeId + "-" + rownum + "-" + entrydc;
        }
        log.info("arg:" + arg);
        Object retValue = null;
        retValue = ThreadCache.get((Object)key, () -> {
            ConvertDataService tableService = new ConvertDataService();
            TableDefine sourceTable = tableService.loadTableDefine(sourceEntityName, sourceEntityName);
            Object retvalue = this.getUpStreamPropperyValue(currentEntityName, currentBillId, sourceEntityName, propertyName, sourceTable, arg);
            return retvalue;
        });
        return retValue;
    }

    private Object getUpStreamPropperyValue(String currentEntityName, long currentBillId, String sourceEntityName, String propertyName, TableDefine sourceTable, Object ... arg) {
        Collection billRelation = null;
        try {
            Long id = Long.parseLong(arg[arg.length - 1] + "");
            if (arg.length > 7) {
                id = Long.parseLong(arg[4] + "");
            }
            DynamicObject plugin = null;
            if (ThreadCache.exists((Object)("GetSourceBillPropertyValue-" + id))) {
                plugin = (DynamicObject)ThreadCache.get((Object)("GetSourceBillPropertyValue-" + id));
            } else {
                plugin = QueryServiceHelper.queryOne((String)"ai_relationregister", (String)"relationshipplugin", (QFilter[])new QFilter("id", "=", (Object)id).toArray());
                ThreadCache.put((Object)("GetSourceBillPropertyValue-" + id), (Object)plugin);
            }
            if (plugin != null) {
                try {
                    Object obj = Class.forName(plugin.getString("relationshipplugin").trim()).newInstance();
                    IGetBillRelationShip relation = (IGetBillRelationShip)obj;
                    billRelation = relation.getBillRelation(currentEntityName, Long.valueOf(currentBillId), sourceEntityName);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    log.debug(e.getMessage());
                }
            } else {
                BOTPRelationShip relation = new BOTPRelationShip();
                billRelation = relation.getBillRelation(currentEntityName, Long.valueOf(currentBillId), sourceEntityName);
            }
        }
        catch (Exception e) {
            BOTPRelationShip relation = new BOTPRelationShip();
            billRelation = relation.getBillRelation(currentEntityName, Long.valueOf(currentBillId), sourceEntityName);
        }
        if (billRelation != null && !billRelation.isEmpty()) {
            return this.queryResult(billRelation.iterator().next(), sourceEntityName, propertyName, arg);
        }
        return null;
    }

    protected Object queryResult(Object id, String entityName, String select, Object ... arg) {
        DynamicObject srcObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)entityName, (String)select);
        if (srcObject != null) {
            Object result = srcObject.get(select);
            if (result != null) {
                return result;
            }
            srcObject = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)entityName);
            return srcObject.get(select);
        }
        return null;
    }

    public String getName() {
        return "GetSourceBillPropertyValue";
    }

    public ExpressionContext getExpContext() {
        return this.expContext;
    }

    public Map<Function, Object> execute(Set<Function> args) {
        HashMap<String, Function> functionMap = new HashMap<String, Function>();
        HashMap<String, List<Object>> keyAndbillids = new HashMap<String, List<Object>>();
        args.forEach(fun -> {
            String key = "";
            List param = fun.getParams();
            long currentBillId = Long.parseLong(param.get(1).toString());
            String currentEntityName = (String)param.get(0);
            String sourceEntityName = (String)param.get(2);
            if (param.get(3) == null) {
                throw new RuntimeException(ResManager.loadKDString((String)"\u5355\u636e\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GetSourceBillPropertyValue_0", (String)"fi-ai-common", (Object[])new Object[0]));
            }
            if (!(param.get(3) instanceof String)) {
                throw new RuntimeException(ResManager.loadKDString((String)"\u5355\u636e\u5c5e\u6027\u5e94\u914d\u7f6e\u4e3a\u5b57\u7b26\u7c7b\u578b\u3002", (String)"GetSourceBillPropertyValue_1", (String)"fi-ai-common", (Object[])new Object[0]));
            }
            String pluginId = "";
            if (param.size() > 4) {
                pluginId = param.get(4) + "";
            }
            key = currentEntityName + "@" + sourceEntityName + "@" + param.get(3) + "@" + pluginId;
            if (param.size() > 7) {
                Object bookTypeId = param.get(5);
                int rownum = (Integer)param.get(6);
                String entrydc = (String)param.get(7);
                key = key + "@" + bookTypeId + "@" + rownum + "@" + entrydc;
            }
            String tmpkey = currentEntityName + "@" + sourceEntityName + "@" + param.get(3) + "@" + pluginId;
            if (param.size() > 7) {
                Object bookTypeId = param.get(5);
                int rownum = (Integer)param.get(6);
                String entrydc = (String)param.get(7);
                tmpkey = tmpkey + "@" + bookTypeId + "@" + rownum + "@" + entrydc;
            }
            if (keyAndbillids.containsKey(tmpkey)) {
                ((List)keyAndbillids.get(tmpkey)).add(currentBillId);
            } else {
                ArrayList<Long> billIds = new ArrayList<Long>();
                billIds.add(currentBillId);
                keyAndbillids.put(tmpkey, billIds);
            }
            functionMap.put(tmpkey + "@" + currentBillId, (Function)fun);
        });
        return this.getBatchUpStreamPropperyValue(keyAndbillids, functionMap);
    }

    private Map<Function, Object> getBatchUpStreamPropperyValue(Map<String, List<Object>> keyAndbillids, Map<String, Function> functionMap) {
        HashMap<Function, Object> result = new HashMap<Function, Object>();
        for (Map.Entry<String, List<Object>> entry : keyAndbillids.entrySet()) {
            BOTPRelationShip relation;
            Map billRelation = null;
            String key = entry.getKey();
            List<Object> billids = entry.getValue();
            String[] arg = key.split("@");
            Long id = 0L;
            if (arg.length > 3 && !StringUtils.isEmpty((CharSequence)arg[3])) {
                id = Long.parseLong(arg[3]);
            }
            DynamicObject plugin = null;
            String sourceEntityName = arg[0];
            String targetEntityName = arg[1];
            try {
                if (ThreadCache.exists((Object)("GetSourceBillPropertyValue-" + id))) {
                    plugin = (DynamicObject)ThreadCache.get((Object)("GetSourceBillPropertyValue-" + id));
                } else {
                    plugin = QueryServiceHelper.queryOne((String)"ai_relationregister", (String)"relationshipplugin", (QFilter[])new QFilter("id", "=", (Object)id).toArray());
                    ThreadCache.put((Object)("GetSourceBillPropertyValue-" + id), (Object)plugin);
                }
                if (plugin != null) {
                    try {
                        Object obj = Class.forName(plugin.getString("relationshipplugin").trim()).newInstance();
                        relation = (IGetBillRelationShip)obj;
                        billRelation = relation.getBillRelation(sourceEntityName, billids, targetEntityName);
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                        log.debug(e.getMessage());
                    }
                } else {
                    BOTPRelationShip relation2 = new BOTPRelationShip();
                    billRelation = relation2.getBillRelation(sourceEntityName, billids, targetEntityName);
                }
            }
            catch (Exception e) {
                relation = new BOTPRelationShip();
                billRelation = relation.getBillRelation(sourceEntityName, billids, targetEntityName);
            }
            if (billRelation == null || billRelation.isEmpty()) continue;
            result.putAll(this.queryBatchResult(billRelation, functionMap, key));
        }
        return result;
    }

    protected Map<Function, Object> queryBatchResult(Map<Object, Collection<Long>> billRelation, Map<String, Function> functionMap, String key) {
        HashMap<Function, Object> result = new HashMap<Function, Object>(100);
        String[] args = key.split("\\@");
        String entityName = args[1];
        HashMap<Long, Long> targetBillAndSrcBillMap = new HashMap<Long, Long>();
        for (Map.Entry<Object, Collection<Long>> entry : billRelation.entrySet()) {
            Long targetBillid = Long.parseLong(entry.getKey() + "");
            Collection<Long> srcBillIds = entry.getValue();
            if (srcBillIds == null || srcBillIds.isEmpty()) continue;
            targetBillAndSrcBillMap.put(targetBillid, srcBillIds.iterator().next());
        }
        Map objectmap = BusinessDataServiceHelper.loadFromCache((Object[])targetBillAndSrcBillMap.values().toArray(new Object[0]), (String)entityName);
        String select = args[2];
        for (Map.Entry<String, Function> entry : functionMap.entrySet()) {
            String[] arg = entry.getKey().split("\\@");
            Long id = Long.parseLong(arg[arg.length - 1]);
            DynamicObject dyn = (DynamicObject)objectmap.get(targetBillAndSrcBillMap.get(id));
            Object value = null;
            if (dyn != null) {
                value = dyn.get(select);
            }
            if (!entry.getKey().startsWith(key)) continue;
            result.put(entry.getValue(), value);
        }
        return result;
    }
}

