/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.ai.CommonAssistItem;
import org.apache.commons.collections4.ListUtils;

public class AiCommonFieldUtils {
    private static final String algoKey = AiCommonFieldUtils.class.getName();
    private static Log logger = LogFactory.getLog(AiCommonFieldUtils.class);
    public static String wait_merge_voucher = "waitMergeVoucher";
    public static String has_save_voucher = "hasSaveVoucher";
    public static String has_save_bizvoucher = "hasSaveBizVoucher";

    public static List<ComboItem> returnComboItem(DynamicObjectCollection datas, String propValue) {
        ArrayList<ComboItem> result = new ArrayList<ComboItem>();
        for (DynamicObject tar : datas) {
            ComboItem item = new ComboItem();
            DynamicObject data = tar.getDynamicObject("fbasedataid");
            if (data == null) continue;
            item.setValue(data.get(propValue).toString());
            item.setCaption(new LocaleString(data.getString("name")));
            result.add(item);
        }
        return result;
    }

    public static List<ComboItem> returnComboItemWithVoucher(DynamicObjectCollection datas, String propValue) {
        ArrayList<ComboItem> result = new ArrayList<ComboItem>();
        for (DynamicObject tar : datas) {
            ComboItem item = new ComboItem();
            DynamicObject data = tar.getDynamicObject("fbasedataid");
            if (data == null) continue;
            item.setValue(data.get(propValue).toString());
            item.setCaption(new LocaleString(data.getString("name")));
            result.add(item);
            ComboItem itema = new ComboItem();
            itema.setValue(AiCommonFieldUtils.getRebillEntityKey(data.get(propValue).toString()));
            String name = ResManager.loadKDString((String)"\u51ed\u8bc1", (String)"AiCommonFieldUtils_0", (String)"fi-ai-common", (Object[])new Object[0]);
            itema.setCaption(new LocaleString(data.getString("name") + "." + name));
            result.add(itema);
        }
        return result;
    }

    public static List<String> getNotEntityBillId(Boolean isext) {
        String qs = "select fnumber from t_meta_formdesign where fmodeltype = 'BillFormModel'";
        if (isext.booleanValue()) {
            qs = qs + " and fmasterid = ' '";
        }
        ArrayList<String> allEntityNumber = new ArrayList<String>(16);
        try (DataSet DataSet2 = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.of((String)"sys.meta"), (String)qs);){
            for (Row next : DataSet2) {
                allEntityNumber.add(next.getString("fnumber"));
            }
        }
        List partition = ListUtils.partition(allEntityNumber, (int)1000);
        HashSet<String> needDelEntityName = new HashSet<String>(16);
        for (List ename : partition) {
            SqlBuilder sbd = new SqlBuilder();
            sbd.append("select fnumber from t_meta_entity where", new Object[0]).appendIn("fnumber", ename.toArray());
            AiCommonFieldUtils.ai_query(sbd, needDelEntityName);
        }
        allEntityNumber.removeAll(needDelEntityName);
        return allEntityNumber;
    }

    private static void ai_query(SqlBuilder sbd, Set<String> needDelEntityName) {
        try (DataSet queryDataSet = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.of((String)"sys.meta"), (SqlBuilder)sbd);){
            Iterator iterator = queryDataSet.iterator();
            while (iterator.hasNext()) {
                needDelEntityName.add(((Row)iterator.next()).getString("fnumber"));
            }
        }
    }

    public static Map<Long, List<Long>> checkNeedBuildVoucherBillStatus(Map<Long, Set<Long>> batchSecondCol, List<String> billtypes) {
        return AiCommonFieldUtils.checkNeedBuildVoucherBillStatus(batchSecondCol, billtypes, 0L);
    }

    public static Map<Long, List<Long>> checkNeedBuildVoucherBillStatus(Map<Long, Set<Long>> batchSecondCol, List<String> billtypes, Long booktype) {
        return AiCommonFieldUtils.checkNeedBuildVoucherBillStatus(batchSecondCol, billtypes, booktype, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Long, List<Long>> checkNeedBuildVoucherBillStatus(Map<Long, Set<Long>> batchSecondCol, List<String> billtypes, Long booktype, boolean filterVouchered) {
        if (batchSecondCol == null || billtypes == null || batchSecondCol.isEmpty() || billtypes.isEmpty()) {
            return new HashMap<Long, List<Long>>();
        }
        QFilter typeQF = new QFilter("billtype", "in", billtypes);
        HashSet qfcol = new HashSet();
        if (filterVouchered) {
            batchSecondCol.values().forEach(v -> {
                if (v != null) {
                    qfcol.addAll(v);
                }
            });
            QFilter sourcebillidsQF = new QFilter("sourcebillid", "in", qfcol);
            QFilter bookTypeQF = new QFilter("booktype", "=", (Object)booktype);
            try (DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"ai_daptracker", (String)"sourcebillid", (QFilter[])new QFilter[]{sourcebillidsQF, typeQF, bookTypeQF}, null);){
                for (Row next : queryDataSet) {
                    Object object = next.get("sourcebillid");
                    batchSecondCol.entrySet().stream().forEach(v -> {
                        if (v.getValue() != null) {
                            ((Set)v.getValue()).remove(object);
                        }
                    });
                }
            }
        }
        qfcol.clear();
        batchSecondCol.values().forEach(v -> {
            if (v != null) {
                qfcol.addAll(v);
            }
        });
        QFilter idsQF = new QFilter("id", "in", qfcol);
        ArrayList<String> billstatuscol = new ArrayList<String>(2);
        billstatuscol.add("A");
        billstatuscol.add("B");
        QFilter statusQF = new QFilter("billstatus", "in", billstatuscol);
        for (String billtype : billtypes) {
            if (billtype.contains("fa_lease_contract")) {
                statusQF = new QFilter("status", "in", billstatuscol);
            }
            Set<Long> checkbills = AiCommonFieldUtils.checkbills(new QFilter[]{idsQF, statusQF}, billtype);
            batchSecondCol.entrySet().stream().forEach(v -> {
                if (v.getValue() != null) {
                    ((Set)v.getValue()).removeAll(checkbills);
                }
            });
        }
        HashMap<Long, List<Long>> result = new HashMap(batchSecondCol.size());
        result = batchSecondCol.entrySet().stream().collect(Collectors.toMap(v -> (Long)v.getKey(), v -> v.getValue() != null ? new ArrayList((Collection)v.getValue()) : new ArrayList()));
        return result;
    }

    private static Set<Long> checkbills(QFilter[] QFCol, String billtype) {
        HashSet<Long> result = new HashSet<Long>();
        if (StringUtils.isBlank((CharSequence)billtype)) {
            return result;
        }
        try (DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)billtype, (String)"id", (QFilter[])QFCol, null);){
            for (Row next : queryDataSet) {
                result.add(next.getLong("id"));
            }
        }
        return result;
    }

    public static Map<String, Set<Long>> multiRelationGroupMap(Map<Object, List<Long>> secondBillId, List<String> relationshipSourcebillcol) {
        if (secondBillId == null || relationshipSourcebillcol == null || secondBillId.isEmpty() || relationshipSourcebillcol.isEmpty()) {
            return new HashMap<String, Set<Long>>();
        }
        ArrayList ids = new ArrayList(16);
        secondBillId.entrySet().stream().forEach(v -> {
            if (v.getValue() != null) {
                ids.addAll((Collection)v.getValue());
            }
        });
        HashMap<String, Set<Long>> result = new HashMap<String, Set<Long>>(16);
        relationshipSourcebillcol.stream().forEach(v -> result.put((String)v, AiCommonFieldUtils.parseHasBillId(v, ids)));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<Long> parseHasBillId(String billname, List<Long> ids) {
        HashSet<Long> result = new HashSet<Long>();
        try (DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.ai.mservice.builder.singletaskaction.SaveBookTasksResult", (String)billname, (String)"id", (QFilter[])new QFilter("id", "in", ids).toArray(), null);){
            for (Row row : queryDataSet) {
                result.add(row.getLong("id"));
            }
        }
        return result;
    }

    public static Long getRootOrgId() {
        return OrgUnitServiceHelper.getRootOrgId();
    }

    public static String getRebillEntityName(String rebillEntityName) {
        String billtype = rebillEntityName;
        if (rebillEntityName.contains("-")) {
            String[] split = rebillEntityName.split("-");
            billtype = split[0];
        }
        return billtype;
    }

    public static String getRebillVoucherName(String rebillEntityName) {
        String billtype = rebillEntityName;
        if (rebillEntityName.contains("-")) {
            billtype = "gl_voucher";
        }
        return billtype;
    }

    public static String getRebillEntityKey(String entityName) {
        String billtype = entityName + "-voucher";
        return billtype;
    }

    public static Map<Long, List<Long>> getBuildVchIds(String billtype, List<Long> sids) {
        HashMap<Long, List<Long>> result = new HashMap<Long, List<Long>>();
        try (DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.ai.util.AiCommonFieldUtils", (String)"ai_daptracker", (String)"sourcebillid,voucherid", (QFilter[])new QFilter[]{new QFilter("billtype", "=", (Object)billtype), new QFilter("sourcebillid", "in", sids)}, null);){
            for (Row row : queryDataSet) {
                Long sid = row.getLong("sourcebillid");
                Long vid = row.getLong("voucherid");
                result.computeIfAbsent(sid, m -> new ArrayList()).add(vid);
            }
        }
        return result;
    }

    public static List<CommonAssistItem> getComAssist(Long accttableId) {
        String key = "DAPGetComAssist" + accttableId;
        LinkedList<CommonAssistItem> result = new LinkedList();
        if (ThreadCache.exists((Object)key)) {
            result = (List)ThreadCache.get((Object)key);
        } else {
            DynamicObject acctTable = BusinessDataServiceHelper.loadSingleFromCache((Object)accttableId, (String)"bd_accounttable");
            if (acctTable == null) {
                return result;
            }
            DynamicObjectCollection comassistentry = acctTable.getDynamicObjectCollection("comassistentry");
            for (DynamicObject cas : comassistentry) {
                String number = cas.getString("comassistnumber");
                String name = cas.getString("comassistname");
                String valuesourcetype = cas.getString("valuesourcetype");
                Boolean isbalance = cas.getBoolean("isbalance");
                Boolean isrequire = cas.getBoolean("isrequire");
                int seq = cas.getInt("seq");
                String entrityName = "";
                if (valuesourcetype.equals("1")) {
                    DynamicObject valuesource = cas.getDynamicObject("valuesource");
                    entrityName = valuesource.getPkValue().toString();
                } else {
                    DynamicObject assistantvaluesource = cas.getDynamicObject("assistantvaluesource");
                    entrityName = assistantvaluesource.getPkValue().toString();
                }
                CommonAssistItem data = new CommonAssistItem(valuesourcetype, number, name, entrityName, isbalance, isrequire, seq);
                result.add(data);
            }
            ThreadCache.put((Object)key, result);
        }
        return result;
    }
}

