/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.util;

import java.util.List;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.AssistantProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.CurrencyProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.UnitProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.ai.AiEventClassDataColumn;
import kd.fi.ai.SubEnteyEntity;
import kd.fi.ai.cache.AiEntityMetadataLocalCache;
import kd.fi.ai.cache.CacheKey;
import kd.fi.ai.enums.AiFiledTypeEnum;
import kd.fi.ai.event.AiEventProp;
import kd.fi.v2.fah.dao.datamodel.DataModelDaoImpl;

public class AiEventMetaUtil {
    public static final String ENTITY_BOSORG = "bos_org";
    public static final String DEFAULT_ORG = "org";

    public static MainEntityType getEntityType(Object eventPK) {
        MainEntityType entityType;
        String cacheKey;
        String eventEntityNum = DataModelDaoImpl.getTableNameByIdCached((Long)eventPK);
        if (null != eventEntityNum) {
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)eventEntityNum);
            return AiEventMetaUtil.loadBaseDataRefProp(dataEntityType);
        }
        LocalMemoryCache localCache = AiEntityMetadataLocalCache.getLocalCache();
        Object cahceResult = localCache.get(cacheKey = CacheKey.getKey("ai-eventclass-cache", eventPK));
        if (null != cahceResult) {
            entityType = (MainEntityType)cahceResult;
        } else {
            QFilter filter = new QFilter("id", "=", eventPK);
            String selectFields = "number,name,fieldentryentity.fieldname, fieldentryentity.fieldalias,fieldentryentity.fieldtype,fieldentryentity.refobj,fieldentryentity.eventclass,fieldentryentity.assistant,entryentity.entryfieldname,entryentity.entryfieldalias,entryentity.entryfieldtype,entryentity.entryrefobj,entryentity.entryassistant";
            DynamicObject dyEventClass = BusinessDataServiceHelper.loadSingleFromCache((String)"ai_eventclass", (String)selectFields, (QFilter[])new QFilter[]{filter});
            if (dyEventClass == null) {
                return null;
            }
            entityType = AiEventMetaUtil.getEntityTypeForDyn(dyEventClass);
        }
        return entityType;
    }

    private static MainEntityType loadBaseDataRefProp(MainEntityType dataEntityType) {
        if (dataEntityType == null) {
            return null;
        }
        for (IDataEntityProperty prop : dataEntityType.getProperties()) {
            if (prop instanceof BasedataProp) {
                ((BasedataProp)prop).setComplexType((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)((BasedataProp)prop).getBaseEntityId()));
                continue;
            }
            if (!(prop instanceof EntryProp)) continue;
            for (IDataEntityProperty entryProp : ((EntryProp)prop).getDynamicCollectionItemPropertyType().getProperties()) {
                if (entryProp instanceof BasedataProp) {
                    ((BasedataProp)entryProp).setComplexType((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)((BasedataProp)entryProp).getBaseEntityId()));
                    continue;
                }
                if (!(entryProp instanceof EntryProp)) continue;
                for (IDataEntityProperty subEntryProp : ((EntryProp)entryProp).getDynamicCollectionItemPropertyType().getProperties()) {
                    if (!(subEntryProp instanceof BasedataProp)) continue;
                    ((BasedataProp)subEntryProp).setComplexType((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)((BasedataProp)subEntryProp).getBaseEntityId()));
                }
            }
        }
        return dataEntityType;
    }

    public static MainEntityType getEntityTypeForDyn(DynamicObject dyEventClass) {
        MainEntityType entityType = new MainEntityType();
        DynamicObjectCollection fieldEntries = dyEventClass.getDynamicObjectCollection("fieldentryentity");
        if (fieldEntries == null || fieldEntries.isEmpty()) {
            return null;
        }
        String number = dyEventClass.getString("number");
        String displayName = dyEventClass.getString("name");
        AiEventMetaUtil.initMetaEntityBaseInfo(entityType, number, displayName);
        AiEventMetaUtil.registerMissingProperty(entityType, fieldEntries);
        AiEventMetaUtil.endInitMetaEntityBaseInfo(entityType);
        return entityType;
    }

    private static void initMetaEntityBaseInfo(MainEntityType entityType, String number, String displayName) {
        entityType.setName(number);
        entityType.setAppId("ai");
        entityType.setDisplayName(new LocaleString(displayName));
        entityType.setDbIgnore(true);
        LongProp idProp = new LongProp();
        idProp.setAlias("fid");
        idProp.setName("id");
        entityType.addProperty((DynamicProperty)idProp);
    }

    private static void endInitMetaEntityBaseInfo(MainEntityType entityType) {
        DataEntityPropertyCollection properties = entityType.getProperties();
        IDataEntityProperty defalutOrgProp = (IDataEntityProperty)properties.get((Object)DEFAULT_ORG);
        if (defalutOrgProp == null) {
            OrgProp orgProp = new OrgProp();
            MainEntityType orgType = EntityMetadataCache.getDataEntityType((String)ENTITY_BOSORG);
            orgProp.setComplexType((IDataEntityType)orgType);
            orgProp.setBaseEntityId(ENTITY_BOSORG);
            orgProp.setRefIdPropName("org_Id");
            LongProp idProp = new LongProp();
            idProp.setName("org_Id");
            orgProp.setRefIdProp((IDataEntityProperty)idProp);
            orgProp.setAlias("fid");
            orgProp.setName(DEFAULT_ORG);
            orgProp.setDisplayName(new LocaleString(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u5143", (String)"AiEventMetaUtil_0", (String)"fi-ai-common", (Object[])new Object[0])));
            entityType.addProperty((DynamicProperty)orgProp);
        }
    }

    private static void registerMissingProperty(MainEntityType entityType, DynamicObjectCollection fieldEntries) {
        DynamicProperty prop = null;
        for (DynamicObject dyField : fieldEntries) {
            String fieldName = dyField.getString("fieldname");
            String aliasName = dyField.getString("fieldalias");
            String fieldType = dyField.getString("fieldtype");
            DynamicObject refObj = dyField.getDynamicObject("refobj");
            DynamicObject eventClass = dyField.getDynamicObject("eventclass");
            DynamicObject assistant = dyField.getDynamicObject("assistant");
            if (AiFiledTypeEnum.AI_ENTRY.getValue().equals(fieldType)) {
                DynamicObjectCollection dySubEnties = dyField.getDynamicObjectCollection("entryentity");
                if (dySubEnties == null || dySubEnties.isEmpty()) continue;
                EntryType entryType = AiEventMetaUtil.createEntryType(dySubEnties, fieldName, new LocaleString(aliasName));
                entryType.setAlias("t_ai_xxx");
                EntryProp entryProp = new EntryProp(fieldName, (DynamicObjectType)entryType);
                entryProp.setDisplayName(new LocaleString(aliasName));
                entryProp.setKeyFieldId("entryid");
                entityType.addProperty((DynamicProperty)entryProp);
                continue;
            }
            AiEventClassDataColumn column = new AiEventClassDataColumn(fieldName, aliasName, fieldType, refObj, "", eventClass, assistant);
            prop = AiEventMetaUtil.createProperty(column);
            if (null == prop) continue;
            if (prop instanceof BasedataProp) {
                prop.setAlias("f" + column.getFieldName() + "id");
            } else {
                prop.setAlias("f" + column.getFieldName());
            }
            prop.setName(column.getFieldName());
            prop.setDisplayName(new LocaleString(column.getFieldAlias()));
            prop.setDbIgnore(true);
            entityType.addProperty(prop);
            if (!(prop instanceof BasedataProp)) continue;
            DynamicProperty refIdProp = (DynamicProperty)((BasedataProp)prop).getRefIdProp();
            refIdProp.setName(prop.getName() + "_Id");
            entityType.addProperty(refIdProp);
        }
    }

    private static DynamicProperty createProperty(AiEventClassDataColumn column) {
        Object prop = null;
        String fieldType = column.getFieldType();
        if (AiFiledTypeEnum.AI_TXT.getValue().equals(fieldType)) {
            prop = new TextProp();
        } else if (AiFiledTypeEnum.AI_NUMBER.getValue().equals(fieldType)) {
            prop = new DecimalProp();
        } else if (AiFiledTypeEnum.AI_DATE.getValue().equals(fieldType)) {
            prop = new DateProp();
        } else if (AiFiledTypeEnum.AI_BASEDATA.getValue().equals(fieldType)) {
            BasedataProp bdp = new BasedataProp();
            if ("bd_measureunits".equalsIgnoreCase(column.getFieldName())) {
                bdp = new UnitProp();
            } else if ("bd_currency".equalsIgnoreCase(column.getFieldName())) {
                bdp = new CurrencyProp();
            }
            AiEventMetaUtil.initBasedataProp(bdp, column);
            prop = bdp;
        } else if (AiFiledTypeEnum.AI_ASSISTANT.getValue().equals(fieldType)) {
            AssistantProp atp = new AssistantProp();
            AiEventMetaUtil.initAssistantProp(atp, column);
            prop = atp;
        } else if (AiFiledTypeEnum.AI_BOOLEAN.getValue().equals(fieldType)) {
            prop = new BooleanProp();
        } else if (AiFiledTypeEnum.AI_EVENT.getValue().equals(fieldType)) {
            AiEventProp bdp = new AiEventProp();
            AiEventMetaUtil.initEventProp(bdp, column);
            prop = bdp;
        }
        return prop;
    }

    private static EntryType createEntryType(DynamicObjectCollection dyEnties, String fieldName, LocaleString displayName) {
        EntryType entryType = new EntryType();
        entryType.setName(fieldName);
        entryType.setDisplayName(displayName);
        LongProp entryPkIdProp = new LongProp();
        entryPkIdProp.setAlias("fentryid");
        entryPkIdProp.setName("id");
        entryPkIdProp.isPrimaryKey();
        entryType.addProperty((DynamicProperty)entryPkIdProp);
        String subEntryData = "";
        DynamicProperty prop = null;
        AiEventClassDataColumn column = null;
        for (DynamicObject dyField : dyEnties) {
            String subFieldName = dyField.getString("entryfieldname");
            String subAliasName = dyField.getString("entryfieldalias");
            String subFieldType = dyField.getString("entryfieldtype");
            DynamicObject subRefObj = dyField.getDynamicObject("entryrefobj");
            DynamicObject entryassistant = dyField.getDynamicObject("entryassistant");
            column = new AiEventClassDataColumn(subFieldName, subAliasName, subFieldType, subRefObj, entryassistant);
            if (AiFiledTypeEnum.AI_ENTRY.getValue().equals(subFieldType)) {
                List subEntities;
                if (!StringUtils.isNotEmpty((String)subEntryData) || (subEntities = SerializationUtils.fromJsonStringToList((String)subEntryData, SubEnteyEntity.class)) == null || subEntities.isEmpty()) continue;
                EntryType subEntryType = AiEventMetaUtil.createSubEntryType(subEntities, subFieldName, new LocaleString(subAliasName));
                EntryProp subEntryProp = new EntryProp(subFieldName, (DynamicObjectType)subEntryType);
                subEntryProp.setDisplayName(new LocaleString(subAliasName));
                continue;
            }
            prop = AiEventMetaUtil.createProperty(column);
            if (null == prop) continue;
            if (prop instanceof BasedataProp) {
                prop.setAlias("f" + column.getFieldName() + "id");
            } else {
                prop.setAlias("f" + column.getFieldName());
            }
            prop.setName(column.getFieldName());
            prop.setDisplayName(new LocaleString(column.getFieldAlias()));
            entryType.addProperty(prop);
            if (!(prop instanceof BasedataProp)) continue;
            DynamicProperty refIdProp = (DynamicProperty)((BasedataProp)prop).getRefIdProp();
            refIdProp.setName(prop.getName() + "_Id");
            entryType.addProperty(refIdProp);
        }
        return entryType;
    }

    private static EntryType createSubEntryType(List<SubEnteyEntity> subEntities, String fieldName, LocaleString displayName) {
        EntryType et = new EntryType();
        et.setName(fieldName);
        et.setDisplayName(displayName);
        DynamicObject dySubRefObj = null;
        DynamicProperty prop = null;
        AiEventClassDataColumn column = null;
        for (SubEnteyEntity objField : subEntities) {
            String subFieldName = objField.getEntryfieldname();
            String subAliasName = objField.getFieldsubalias();
            String subFieldType = objField.getFieldsubtype();
            String subRefObj = objField.getRefobjsub();
            if (StringUtils.isNotEmpty((String)subRefObj)) {
                dySubRefObj = (DynamicObject)SerializationUtils.fromJsonString((String)subRefObj, EntityMetadataCache.getDataEntityType((String)"bos_objecttype").getClass());
            }
            if (null == (prop = AiEventMetaUtil.createProperty(column = new AiEventClassDataColumn(subFieldName, subAliasName, subFieldType, dySubRefObj, dySubRefObj)))) continue;
            if (prop instanceof BasedataProp) {
                prop.setAlias("f" + column.getFieldName() + "id");
            } else {
                prop.setAlias("f" + column.getFieldName());
            }
            prop.setName(column.getFieldName());
            prop.setDisplayName(new LocaleString(column.getFieldAlias()));
            et.addProperty(prop);
            if (!(prop instanceof BasedataProp)) continue;
            DynamicProperty refIdProp = (DynamicProperty)((BasedataProp)prop).getRefIdProp();
            refIdProp.setName(prop.getName() + "_Id");
            et.addProperty(refIdProp);
        }
        return et;
    }

    private static void initAssistantProp(AssistantProp p, AiEventClassDataColumn col) {
        DynamicObject dynAssistant = col.getAssistant();
        String pkValue = dynAssistant.getString("id");
        String typeId = dynAssistant.getString("number");
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"bos_assistantdata_detail");
        p.setComplexType((IDataEntityType)entityType);
        p.setBaseEntityId("bos_assistantdata_detail");
        p.setAsstTypeId(typeId);
        p.setName(pkValue);
        Object idProp = null;
        idProp = entityType.getPrimaryKey() instanceof LongProp ? new LongProp() : new VarcharProp();
        idProp.setDbIgnore(true);
        p.setRefIdProp((IDataEntityProperty)idProp);
        p.setDisplayProp(col.getFieldAlias());
        p.setAsstParentId(pkValue);
        p.setAsstTypeId(pkValue);
    }

    private static void initBasedataProp(BasedataProp p, AiEventClassDataColumn col) {
        String entryId = col.getRefObj().getString("number");
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entryId);
        p.setComplexType((IDataEntityType)entityType);
        p.setBaseEntityId(entryId);
        Object idProp = null;
        idProp = entityType.getPrimaryKey() instanceof LongProp ? new LongProp() : new VarcharProp();
        idProp.setDbIgnore(true);
        p.setRefIdProp((IDataEntityProperty)idProp);
        p.setDisplayProp(col.getFieldAlias());
    }

    private static void initEventProp(AiEventProp p, AiEventClassDataColumn col) {
        DynamicObject dyEventClass = col.getEventClass();
        String entryId = dyEventClass.getString("number");
        Object pkValue = dyEventClass.getPkValue();
        MainEntityType entityType = AiEventMetaUtil.getEntityType(pkValue);
        p.setComplexType((IDataEntityType)entityType);
        p.setBaseEntityId(entryId);
        Object idProp = null;
        idProp = entityType != null && entityType.getPrimaryKey() instanceof LongProp ? new LongProp() : new VarcharProp();
        p.setRefIdProp((IDataEntityProperty)idProp);
        p.setDisplayProp(col.getFieldAlias());
        p.setEventClassPk(pkValue);
    }
}

