/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.util;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.fi.ai.accsys.AccSysUtil;
import kd.fi.ai.enums.PermissonType;
import kd.fi.ai.enums.ZeroAmountSysParamEnum;
import kd.fi.ai.mservice.builder.buildresult.BizVoucher;
import kd.fi.ai.mservice.builder.buildresult.GLVoucher;
import kd.fi.ai.mservice.builder.buildresult.GLVoucherEntry;
import kd.fi.ai.util.DateUtil;

public class DapBuildVoucherCommonUtil {
    private static final String ISBIZVOUCHER = "isbizvoucher";
    private static final String BIZVOUCHERDATE = "bizvoucherdate";
    private static Log logger = LogFactory.getLog(DapBuildVoucherCommonUtil.class);

    public static Boolean getEnableBizVoucherSystemParam(Long orgId) {
        Object isbizvoucher = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)new AppParam("83bfebc8000017ac", "10", orgId, Long.valueOf(0L)), (String)ISBIZVOUCHER);
        return isbizvoucher != null ? (Boolean)isbizvoucher : false;
    }

    public static Boolean getEnableBizVoucherSystemParam() {
        return kd.bos.ext.fi.ai.DapBuildVoucherCommonUtil.getEnableBizVoucherSystemParam();
    }

    public static List<Long> getPermissionOpenOrgList() {
        List<Long> acctOrgPkList = AccSysUtil.getAcctOrgPkList("ai_bizvoucher", true, PermissonType.VIEW);
        logger.info("xxx acctOrgPkList result\uff1a{}", acctOrgPkList);
        return acctOrgPkList;
    }

    @Deprecated
    public static Date getDateBizVoucherSystemParam(Long orgId) {
        Object bizvoucherdate = SystemParamServiceHelper.getSystemParameter(null, (String)"83bfebc8000017ac", (String)"10", (Long)orgId, (String)BIZVOUCHERDATE);
        if (null != bizvoucherdate) {
            Date bizDate = (Date)bizvoucherdate;
            return bizDate;
        }
        return null;
    }

    public static Date getBizVoucherDateSystemParam(Collection<Long> orgIds) {
        Map paramMap = SystemParamServiceHelper.loadBatchAppParameterByOrgFromCache((AppParam)new AppParam("83bfebc8000017ac", "10", Long.valueOf(0L), Long.valueOf(0L)), new ArrayList<Long>(orgIds));
        ArrayList bizEnableDate = new ArrayList(orgIds.size());
        paramMap.forEach((orgId, param) -> {
            Date bizDate = DapBuildVoucherCommonUtil.parseBizDateFromParam(param);
            if (bizDate != null) {
                bizEnableDate.add(bizDate);
            }
        });
        Date bizDate = new Date();
        if (!bizEnableDate.isEmpty()) {
            Collections.sort(bizEnableDate);
            bizDate = (Date)bizEnableDate.get(0);
        }
        return bizDate;
    }

    private static Date parseBizDateFromParam(Map<String, Object> param) {
        boolean isBizVoucher = (Boolean)param.getOrDefault(ISBIZVOUCHER, Boolean.FALSE);
        Date bizDate = null;
        if (isBizVoucher) {
            Object bizVchDate = param.get(BIZVOUCHERDATE);
            if (bizVchDate instanceof String) {
                try {
                    bizDate = DateUtil.getLongFormat().parse((String)bizVchDate);
                }
                catch (ParseException e) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u7cfb\u7edf\u53c2\u6570\u201c\u4e1a\u52a1\u51ed\u8bc1\u542f\u7528\u65f6\u95f4\u201d\u89e3\u6790\u51fa\u9519\u3002", (String)"DapBuildVoucherCommonUtil_0", (String)"fi-ai-common", (Object[])new Object[0]));
                }
            } else if (bizVchDate instanceof Date) {
                bizDate = (Date)bizVchDate;
            }
        }
        return bizDate;
    }

    public static String getBillNoFormBill(String billtype) {
        if ("ai_event".equals(billtype)) {
            return "number";
        }
        String billno = "billno";
        String dapKey = "dap_billno_" + billtype;
        if (ThreadCache.exists((Object)dapKey)) {
            billno = (String)ThreadCache.get((Object)dapKey);
        } else {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)billtype);
            if (dataEntityType != null) {
                BillEntityType bnt = (BillEntityType)dataEntityType;
                billno = bnt.getBillNo();
            }
            ThreadCache.put((Object)dapKey, (Object)billno);
        }
        return billno;
    }

    public static Map<String, String> getBaseDataProp(String basedataType) {
        HashMap<String, String> propCol = new HashMap(8);
        String dapKey = "dap_bsaedataprop_" + basedataType;
        if (ThreadCache.exists((Object)dapKey)) {
            String info = (String)ThreadCache.get((Object)dapKey);
            propCol = (Map)SerializationUtils.fromJsonString((String)info, Map.class);
        } else {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)basedataType);
            if (dataEntityType != null) {
                BasedataEntityType bnt = (BasedataEntityType)dataEntityType;
                String numberProperty = bnt.getNumberProperty();
                String nameProperty = bnt.getNameProperty();
                propCol.put("number", numberProperty);
                propCol.put("name", nameProperty);
            }
            ThreadCache.put((Object)dapKey, (Object)SerializationUtils.toJsonString(propCol));
        }
        return propCol;
    }

    public static boolean getSystemParamsForZeroAmount(Long orgId) {
        Object loadAppParameterFromCache;
        String dapKey = "zeroamount" + orgId;
        boolean zeroAmount = false;
        zeroAmount = ThreadCache.exists((Object)dapKey) ? (Boolean)ThreadCache.get((Object)dapKey) : (loadAppParameterFromCache = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)new AppParam("83bfebc8000017ac", "10", orgId, Long.valueOf(0L)), (String)"zeroamount")) != null && (Boolean)loadAppParameterFromCache != false;
        return zeroAmount;
    }

    public static void delZeroAmountRows(GLVoucher glVoucher) {
        BigDecimal zero = new BigDecimal(Integer.toString(0));
        int rowCount = glVoucher.getEntryRows().size();
        for (int i = rowCount - 1; i >= 0; --i) {
            boolean isAmount;
            GLVoucherEntry row = glVoucher.getEntryRows().get(i);
            boolean bl = isAmount = row.getLocalDebit().compareTo(zero) == 0 && row.getLocalCredit().compareTo(zero) == 0;
            if (!isAmount) continue;
            glVoucher.getEntryRows().remove(i);
        }
    }

    public static void delZeroAmountNonZeroQuantityRows(GLVoucher glVoucher) {
        BigDecimal zero = new BigDecimal(Integer.toString(0));
        int rowCount = glVoucher.getEntryRows().size();
        for (int i = rowCount - 1; i >= 0; --i) {
            boolean isQty;
            GLVoucherEntry row = glVoucher.getEntryRows().get(i);
            boolean isAmount = row.getLocalDebit().compareTo(zero) == 0 && row.getLocalCredit().compareTo(zero) == 0;
            boolean bl = isQty = row.getQty().compareTo(BigDecimal.ZERO) == 0;
            if (!isAmount || !isQty) continue;
            glVoucher.getEntryRows().remove(i);
        }
    }

    public static void dealZeroAmountEntry(GLVoucher glVoucher, ZeroAmountSysParamEnum dealParam) {
        switch (dealParam) {
            case ALWAYS_NOT_GENERATE: {
                DapBuildVoucherCommonUtil.delZeroAmountRows(glVoucher);
                break;
            }
            case ALWAYS_GENERATE: {
                break;
            }
            case ZERO_AMOUNT_NON_ZERO_QUANTITY: {
                DapBuildVoucherCommonUtil.delZeroAmountNonZeroQuantityRows(glVoucher);
            }
        }
    }

    public static String getCustomKey(BizVoucher bizvoucher, Map<String, Map<String, Object>> customKey, String oper) {
        String result = "";
        if (customKey.isEmpty()) {
            return result;
        }
        String dapKey = bizvoucher.getSourceBill() + "-" + bizvoucher.getSourceBillId();
        if (customKey.get(dapKey) != null && !customKey.get(dapKey).isEmpty()) {
            Object ckParam;
            Map<String, Object> params = customKey.get(dapKey);
            Object voucherParam = params.get("voucher");
            if (voucherParam != null) {
                List vp = (List)voucherParam;
                for (String pam : vp) {
                    String bizVoucherParam = DapBuildVoucherCommonUtil.getBizVoucherParam(bizvoucher, pam, oper);
                    params.put(pam, bizVoucherParam);
                }
            }
            if ((ckParam = params.get("customuniquekey")) != null) {
                List customuniquekey = (List)ckParam;
                int size = customuniquekey.size();
                HashMap<String, String> customuniquekeyMap = new HashMap<String, String>(size);
                for (String c : customuniquekey) {
                    String[] split = c.split("-");
                    customuniquekeyMap.put(split[0], split[1]);
                }
                StringBuilder sbf = new StringBuilder();
                for (int i = 1; i <= size; ++i) {
                    String param = (String)customuniquekeyMap.get(String.valueOf(i));
                    String paramValue = params.get(param) != null ? params.get(param).toString() : "";
                    sbf.append(paramValue);
                }
                result = sbf.length() > 0 ? sbf.toString() : "";
            }
        }
        return result;
    }

    private static String getBizVoucherParam(BizVoucher bizvoucher, String param, String oper) {
        Object result = "";
        switch (param) {
            case "uuid": {
                result = UUID.randomUUID().toString();
                break;
            }
            case "vchtemplate": {
                result = bizvoucher.getTemplateId();
                break;
            }
            case "oper": {
                result = oper;
                break;
            }
            case "billno": {
                result = "";
                break;
            }
            case "org": {
                result = bizvoucher.getOrgId();
                break;
            }
            case "book": {
                result = bizvoucher.getBookId();
                break;
            }
            case "vouchertype": {
                result = bizvoucher.getVchTypeId();
                break;
            }
            case "period": {
                result = bizvoucher.getPeriodId();
                break;
            }
            case "vdescription": {
                result = bizvoucher.getVdescription();
                break;
            }
            case "bizdate": {
                result = bizvoucher.getBizDate();
                break;
            }
            case "bookeddate": {
                result = bizvoucher.getBookedDate();
                break;
            }
            case "description": {
                result = bizvoucher.getDescription();
                break;
            }
            case "attachment": {
                result = bizvoucher.getAttachment();
                break;
            }
            case "creator": {
                result = bizvoucher.getCreatorId();
            }
        }
        return result != null ? result.toString() : "";
    }

    public static Set<String> getAllCustomKeyForTask(Set<Long> srcIds, String billtype) {
        HashSet<String> result = new HashSet<String>(8);
        try (DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.ai.util.DapBuildVoucherCommonUtil", (String)"ai_daptracker", (String)"billtype,customkey,reoper,org,org.id,booktype,booktype.id,sourcebillid", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", srcIds), new QFilter("billtype", "=", (Object)billtype)}, null);){
            for (Row row : queryDataSet) {
                String dck = DapBuildVoucherCommonUtil.getParseDulipyCustomKey(row.getString("billtype"), row.getLong("sourcebillid"), row.getLong("booktype.id"), row.getLong("org.id"), row.getString("reoper"), row.getString("customkey"));
                result.add(dck);
            }
        }
        return result;
    }

    public static String getParseDulipyCustomKey(String billtype, Long billId, Long booktypeId, Long orgId, String reoper, String customkey) {
        String result = billtype + "-" + billId + "-" + reoper + "-" + booktypeId + "-" + orgId + "-" + customkey;
        return result;
    }

    public static List<Set<Long>> splitSet(Set<Long> ids, int batchSize) {
        ArrayList<Set<Long>> result = new ArrayList<Set<Long>>(8);
        int i = 0;
        HashSet<Long> data = new HashSet<Long>(batchSize);
        for (Long id : ids) {
            data.add(id);
            if (++i % batchSize != 0 && i != ids.size()) continue;
            result.add(new HashSet(data));
            data.clear();
        }
        return result;
    }

    public static List<Collection<Long>> splitCollection(Collection<Long> ids, int batchSize) {
        ArrayList<Collection<Long>> result = new ArrayList<Collection<Long>>(8);
        if (ids.size() < batchSize) {
            result.add(ids);
            return result;
        }
        int i = 0;
        HashSet<Long> data = new HashSet<Long>(batchSize);
        for (Long id : ids) {
            data.add(id);
            if (++i % batchSize != 0 && i != ids.size()) continue;
            result.add(new HashSet(data));
            data.clear();
        }
        return result;
    }

    public static Boolean getAiSystemParamToOpenMappingType(String cacheKey) {
        boolean result = false;
        String dapKey = "ai_sysparam_usemappingtype_cache" + cacheKey;
        if (ThreadCache.exists((Object)dapKey)) {
            result = (Boolean)ThreadCache.get((Object)dapKey);
        } else {
            String sql = "select fvalue from t_ai_sysparam where fkey = 'isusemappingtype';";
            try (DataSet queryDataSet = DB.queryDataSet((String)"kd.bos.ext.fi.ai.operate.BuildVoucher", (DBRoute)DBRoute.of((String)"fi"), (String)sql);){
                Iterator iterator = queryDataSet.iterator();
                while (iterator.hasNext()) {
                    int value = ((Row)iterator.next()).getInteger("fvalue");
                    result = 1 == value;
                }
            }
            ThreadCache.put((Object)dapKey, (Object)result);
        }
        return result;
    }

    public static <T> List<List<T>> splitbatch(List<T> billids, int batchSize) {
        ArrayList<List<T>> result = new ArrayList<List<T>>(16);
        int MaxSize = billids.size();
        if (MaxSize <= batchSize) {
            result.add(billids);
        } else {
            int rowindex = 0;
            do {
                int firstIndex = rowindex;
                rowindex = (rowindex += batchSize) > MaxSize ? MaxSize : rowindex;
                List<T> subList = billids.subList(firstIndex, rowindex);
                result.add(subList);
            } while (rowindex != MaxSize);
        }
        return result;
    }
}

