/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;

public class DateUtil {
    private static final Map<String, ThreadLocal<SimpleDateFormat>> map = new HashMap<String, ThreadLocal<SimpleDateFormat>>();
    private static final String SHORT = "yyyy-MM-dd";
    private static final String SHORT2 = "yyyy/MM/dd";
    private static final String LONG = "yyyy-MM-dd HH:mm:ss";
    private static final String LONG2 = "yyyy/MM/dd HH:mm:ss";
    private static final String MILLIS = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String LATEST_VERSION_DATE = "2999-12-31";

    public static SimpleDateFormat getShortFormat() {
        return map.get(SHORT).get();
    }

    public static SimpleDateFormat getShort2Format() {
        return map.get(SHORT2).get();
    }

    public static SimpleDateFormat getLongFormat() {
        return map.get(LONG).get();
    }

    public static SimpleDateFormat getLong2Format() {
        return map.get(LONG2).get();
    }

    public static SimpleDateFormat getMillisFormat() {
        return map.get(MILLIS).get();
    }

    public static Date getCurrentDay0hour() {
        Calendar cal = Calendar.getInstance();
        cal.set(5, cal.get(5) + 1);
        cal.set(5, cal.get(5) - 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date date = cal.getTime();
        return date;
    }

    public static Date getNextDay0hour() {
        Calendar cal = Calendar.getInstance();
        cal.set(5, cal.get(5) + 1);
        cal.set(5, cal.get(5));
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date date = cal.getTime();
        return date;
    }

    public static int getDay(Date d) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        return cal.get(5);
    }

    public static Date getDateFormat(Date date, boolean isStart) {
        String dateStr = DateUtil.getShortFormat().format(date);
        String suffix = " 00:00:00";
        if (!isStart) {
            suffix = " 23:59:59";
        }
        try {
            return DateUtil.getLongFormat().parse(dateStr + suffix);
        }
        catch (ParseException e) {
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
    }

    public static boolean isSameDay(Date date, Date anotherDate) {
        SimpleDateFormat shortFormat = DateUtil.getShortFormat();
        String dateStr = shortFormat.format(date);
        String anotherDateStr = shortFormat.format(anotherDate);
        return dateStr.equals(anotherDateStr);
    }

    public static int getShortOfYear(Date date, Date anotherDate) {
        Calendar dateCal = Calendar.getInstance();
        dateCal.setTime(date);
        int dateYear = dateCal.get(1);
        Calendar anotherDateCal = Calendar.getInstance();
        anotherDateCal.setTime(anotherDate);
        int anotherDateYear = anotherDateCal.get(1);
        return dateYear - anotherDateYear;
    }

    public static int getShortOfMonth(Date date, Date anotherDate) {
        Calendar dateCal = Calendar.getInstance();
        dateCal.setTime(date);
        int dateMonth = dateCal.get(2);
        Calendar anotherDateCal = Calendar.getInstance();
        anotherDateCal.setTime(anotherDate);
        int anotherDateMonth = anotherDateCal.get(2);
        return dateMonth - anotherDateMonth;
    }

    public static int getDateOfWeek(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.setFirstDayOfWeek(1);
        return cal.get(7);
    }

    public static String getHour(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int hour = cal.get(11);
        return hour + ":00";
    }

    public static int getHourOfDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(11);
    }

    public static int getMinuteOfHour(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(12);
    }

    public static Date getCurrentDayStart(Date curDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(curDate);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date date = cal.getTime();
        return date;
    }

    public static Date getCurrentDayEnd(Date curDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(curDate);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        Date date = cal.getTime();
        return date;
    }

    public static Date addMonth(Date date, int imonth) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        cd.add(2, imonth);
        return cd.getTime();
    }

    public static Date addDay(Date date, int iday) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        cd.add(5, iday);
        return cd.getTime();
    }

    public static int getMonthDiff(Date d1, Date d2) {
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(d1);
        c2.setTime(d2);
        int year1 = c1.get(1);
        int year2 = c2.get(1);
        int month1 = c1.get(2);
        int month2 = c2.get(2);
        int day1 = c1.get(5);
        int day2 = c2.get(5);
        int yearInterval = year1 - year2;
        if (month1 < month2 || month1 == month2 && day1 < day2) {
            --yearInterval;
        }
        int monthInterval = month1 + 12 - month2;
        if (day1 < day2) {
            --monthInterval;
        }
        int monthsDiff = Math.abs(yearInterval * 12 + (monthInterval %= 12));
        return monthsDiff;
    }

    public static boolean isAffective(Date bizDate, Date effectDate, Date expireDate) {
        try {
            if (effectDate == null) {
                effectDate = DateUtil.getShortFormat().parse("1900-01-01");
            }
            if (expireDate == null) {
                expireDate = DateUtil.getShortFormat().parse("2999-01-01");
            }
            return bizDate.getTime() >= effectDate.getTime() && bizDate.getTime() <= expireDate.getTime();
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static Date getEndDate() {
        try {
            SimpleDateFormat dt = new SimpleDateFormat(SHORT);
            return dt.parse(LATEST_VERSION_DATE);
        }
        catch (ParseException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7248\u672c\u5316\u7ed3\u675f\u65e5\u671f\u89e3\u6790\u5f02\u5e38\u3002", (String)"DateUtil_0", (String)"fi-ai-common", (Object[])new Object[0]));
        }
    }

    public static void main(String[] args) {
    }

    public static Date dateTruncate_YYYY_MM_DD(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    static {
        map.put(SHORT, ThreadLocal.withInitial(() -> new SimpleDateFormat(SHORT)));
        map.put(SHORT2, ThreadLocal.withInitial(() -> new SimpleDateFormat(SHORT2)));
        map.put(LONG, ThreadLocal.withInitial(() -> new SimpleDateFormat(LONG)));
        map.put(LONG2, ThreadLocal.withInitial(() -> new SimpleDateFormat(LONG2)));
        map.put(MILLIS, ThreadLocal.withInitial(() -> new SimpleDateFormat(MILLIS)));
    }
}

