/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.JsonSubEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.property.AssistantProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ExceptionUtils;
import kd.fi.ai.enums.FieldNodeStatusEnum;
import kd.fi.ai.util.EntityFieldNodeHandle;
import kd.fi.ai.util.EntityFieldTreeOption;
import kd.fi.ai.util.EntityFieldTreeResult;
import kd.fi.v2.fah.utils.FahEntityMetaHelper;
import kd.fi.v2.fah.utils.StringUtils;
import kd.fi.v2.fah.utils.TreeBuildUtils;

public class EntityTreeUtil {
    private static Log logger = LogFactory.getLog(EntityTreeUtil.class);
    private static final String noDeleteNodeType = "1";

    public static List<ComboItem> getEntityFieldComboItems(Map<String, Object> param) {
        LinkedList<ComboItem> comboItems = new LinkedList<ComboItem>();
        MainEntityType srcMainET = (MainEntityType)param.get("entityType");
        Map allEntities = srcMainET.getAllEntities();
        Class fieldClassType = (Class)param.get("dataType");
        String entryNumber = param.get("entryNumber") != null ? (String)param.get("entryNumber") : null;
        String basePropType = param.get("basePropType") != null ? (String)param.get("basePropType") : null;
        String getBasePropNumName = (String)param.get("getBasePropNumName");
        boolean isBaseProp = fieldClassType == BasedataProp.class;
        boolean isAssistantProp = fieldClassType == AssistantProp.class;
        String preFixName = "";
        HashSet<String> needentryNumber = EntityTreeUtil.getEntryNumberSet(entryNumber, allEntities);
        for (EntityType entityType : allEntities.values()) {
            if (entityType instanceof SubEntryType) {
                if (entryNumber == null || !needentryNumber.contains(entityType.getName())) continue;
                preFixName = entityType.getParent().getDisplayName().toString() + "." + entityType.getDisplayName().toString();
            } else if (entityType instanceof EntryType) {
                if (entryNumber == null || !needentryNumber.contains(entityType.getName())) continue;
                preFixName = entityType.getDisplayName().toString();
            }
            for (IDataEntityProperty property : entityType.getFields().values()) {
                ComboItem comboItem;
                if (property == null) continue;
                if (fieldClassType == null) {
                    comboItem = new ComboItem(new LocaleString(EntityTreeUtil.getFullString(preFixName, property.getDisplayName().getLocaleValue())), property.getName());
                    comboItems.add(comboItem);
                    if (!"true".equals(getBasePropNumName) || property instanceof FlexProp || !(property instanceof BasedataProp)) continue;
                    BasedataProp bdProp = (BasedataProp)property;
                    if (null != bdProp.getNumbProp()) {
                        comboItem = new ComboItem(new LocaleString(EntityTreeUtil.getFullString(preFixName, EntityTreeUtil.getFullString(property.getDisplayName().getLocaleValue(), bdProp.getNumbProp().getDisplayName().getLocaleValue()))), EntityTreeUtil.getFullString(property.getName(), bdProp.getNumberProp()));
                        comboItems.add(comboItem);
                    }
                    if (null == bdProp.getDispProp()) continue;
                    comboItem = new ComboItem(new LocaleString(EntityTreeUtil.getFullString(preFixName, EntityTreeUtil.getFullString(property.getDisplayName().getLocaleValue(), bdProp.getDispProp().getDisplayName().getLocaleValue()))), EntityTreeUtil.getFullString(property.getName(), bdProp.getDisplayProp()));
                    comboItems.add(comboItem);
                    continue;
                }
                if (isBaseProp && property instanceof BasedataProp && EntityTreeUtil.isBaseTypeEquals(basePropType, property)) {
                    comboItem = new ComboItem(new LocaleString(EntityTreeUtil.getFullString(preFixName, property.getDisplayName().getLocaleValue())), property.getName());
                    comboItems.add(comboItem);
                    continue;
                }
                if (isAssistantProp && property instanceof AssistantProp && EntityTreeUtil.isAssistTypeEquals(basePropType, property)) {
                    comboItem = new ComboItem(new LocaleString(EntityTreeUtil.getFullString(preFixName, property.getDisplayName().getLocaleValue())), property.getName());
                    comboItems.add(comboItem);
                    continue;
                }
                if (fieldClassType == BigDecimal.class && (property.getPropertyType() == fieldClassType || property.getPropertyType() == Integer.class)) {
                    comboItem = new ComboItem(new LocaleString(EntityTreeUtil.getFullString(preFixName, property.getDisplayName().getLocaleValue())), property.getName());
                    comboItems.add(comboItem);
                    continue;
                }
                if (property.getPropertyType() != fieldClassType) continue;
                comboItem = new ComboItem(new LocaleString(EntityTreeUtil.getFullString(preFixName, property.getDisplayName().getLocaleValue())), property.getName());
                comboItems.add(comboItem);
            }
        }
        return comboItems;
    }

    private static boolean isBaseTypeEquals(String basePropType, IDataEntityProperty property) {
        if (basePropType != null && property != null) {
            return basePropType.equals(((BasedataProp)property).getBaseEntityId());
        }
        return false;
    }

    private static boolean isAssistTypeEquals(String basePropType, IDataEntityProperty property) {
        if (basePropType != null && property != null) {
            return basePropType.equals(((AssistantProp)property).getAsstTypeId());
        }
        return false;
    }

    public static TreeNode getEntityFieldNodes(Map<String, Object> param) {
        MainEntityType srcMainET = EntityMetadataCache.getDataEntityType((String)((String)param.get("entityType")));
        TreeNode rootNode = new TreeNode("", srcMainET.getName(), srcMainET.getDisplayName().toString());
        rootNode.setDisabled(true);
        rootNode.setColor("#000000");
        Class<?> fieldClassType = null;
        String dataType = null;
        try {
            dataType = (String)param.get("dataType");
            if (!kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)dataType)) {
                fieldClassType = Class.forName(dataType);
            }
        }
        catch (ClassNotFoundException e) {
            logger.error("Class<{}> not find, err: {}", (Object)dataType, (Object)ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        String entryNumber = param.get("entryNumber") != null ? (String)param.get("entryNumber") : null;
        String basePropType = param.get("basePropType") != null ? (String)param.get("basePropType") : null;
        String preFixNumber = "";
        String preFixName = "";
        TreeNode parentNode = null;
        int maxLevel = param.get("maxLevel") == null ? 4 : (Integer)param.get("maxLevel");
        HashSet<String> filterField = null;
        if (param.get("filterField") != null) {
            filterField = new HashSet<String>((Collection)param.get("filterField"));
        }
        boolean needFilterOrg = false;
        if (!StringUtils.isEmpty(param.get("needOrg"))) {
            needFilterOrg = "true".equalsIgnoreCase((String)param.get("needOrg"));
        }
        for (EntityType entityType : TreeBuildUtils.getAllEntities((EntityType)srcMainET, entryNumber)) {
            TreeNode node = new TreeNode();
            node.setDisabled(true);
            node.setColor("#000000");
            node.setParentid(rootNode.getId());
            node.setId(entityType.getName());
            if (entityType instanceof MainEntityType) {
                node.setId("headField");
                node.setText(ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"EntityTreeUtil_3", (String)"fi-ai-common", (Object[])new Object[0]));
                parentNode = node;
                rootNode.addChild(node);
            } else if (entityType instanceof SubEntryType) {
                preFixName = EntityTreeUtil.getFullString(entityType.getParent().getDisplayName().getLocaleValue(), entityType.getDisplayName().getLocaleValue());
                node.setText(preFixName);
                parentNode = node;
                rootNode.addChild(node);
            } else if (entityType instanceof EntryType) {
                preFixName = entityType.getDisplayName().getLocaleValue();
                node.setText(preFixName);
                parentNode = node;
                rootNode.addChild(node);
            }
            String searchText = (String)param.get("SearchText");
            EntityTreeUtil.getBaseFieldNodes(parentNode, parentNode, entityType, preFixNumber, preFixName, 0, maxLevel, filterField, fieldClassType, basePropType, searchText, needFilterOrg);
            if (node.getChildren() != null && !node.getChildren().isEmpty()) continue;
            rootNode.deleteChildNode(node.getId());
        }
        return rootNode;
    }

    private static FieldNodeStatusEnum getBaseNodeStatus(boolean isLastLevel, IDataEntityProperty property, String searchText, HashSet<String> filterField, Class<?> fieldClassType, String basePropType, boolean isNeedFilterOrg) {
        String name = property.getDisplayName().getLocaleValue();
        String baseEntityId = ((BasedataProp)property).getBaseEntityId();
        if (isLastLevel) {
            if (!kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)searchText) && !name.contains(searchText)) {
                return FieldNodeStatusEnum.NO_NEED_NODE;
            }
            if (filterField == null || filterField.isEmpty()) {
                if (isNeedFilterOrg) {
                    if (property instanceof AssistantProp || FahEntityMetaHelper.isOrgTplBaseData(baseEntityId)) {
                        return FieldNodeStatusEnum.NO_NEED_NODE;
                    }
                    return FieldNodeStatusEnum.NEED_NODE;
                }
                if (fieldClassType == null || property instanceof AssistantProp && Objects.equals(((AssistantProp)property).getAsstTypeId(), basePropType) || Objects.equals(baseEntityId, basePropType)) {
                    return FieldNodeStatusEnum.NEED_NODE;
                }
            } else if (filterField.contains(property.getClass().getName())) {
                return FieldNodeStatusEnum.NEED_NODE;
            }
            return FieldNodeStatusEnum.NO_NEED_NODE;
        }
        if (filterField == null || filterField.isEmpty()) {
            if (isNeedFilterOrg) {
                if (property instanceof AssistantProp || FahEntityMetaHelper.isOrgTplBaseData(baseEntityId)) {
                    return FieldNodeStatusEnum.DISABLED_NODE;
                }
                return FieldNodeStatusEnum.NEED_NODE;
            }
            if (fieldClassType == null || property instanceof AssistantProp && Objects.equals(((AssistantProp)property).getAsstTypeId(), basePropType) || Objects.equals(baseEntityId, basePropType)) {
                return FieldNodeStatusEnum.NEED_NODE;
            }
            return FieldNodeStatusEnum.DISABLED_NODE;
        }
        if (filterField.contains(property.getClass().getName())) {
            return FieldNodeStatusEnum.NEED_NODE;
        }
        return FieldNodeStatusEnum.DISABLED_NODE;
    }

    private static FieldNodeStatusEnum getNodeStatus(IDataEntityProperty property, String searchText, HashSet<String> filterField, Class<?> fieldClassType, boolean isNeedFilterOrg, int currentLevel) {
        String name = property.getDisplayName().getLocaleValue();
        if (!kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)searchText) && !name.contains(searchText)) {
            return FieldNodeStatusEnum.NO_NEED_NODE;
        }
        if (isNeedFilterOrg) {
            IDataEntityType parent = property.getParent();
            if (currentLevel == 0 || parent instanceof BasedataEntityType && !FahEntityMetaHelper.isOrgTplBaseData(parent.getName())) {
                return FieldNodeStatusEnum.NEED_NODE;
            }
            return FieldNodeStatusEnum.NO_NEED_NODE;
        }
        if (fieldClassType == null) {
            return FieldNodeStatusEnum.NEED_NODE;
        }
        if (filterField == null || filterField.isEmpty() ? (fieldClassType == Boolean.class ? property.getPropertyType() == Boolean.TYPE || property.getPropertyType() == Boolean.class : property.getPropertyType() == fieldClassType || fieldClassType == BigDecimal.class && property.getPropertyType() == Integer.class) : filterField.contains(property.getClass().getName())) {
            return FieldNodeStatusEnum.NEED_NODE;
        }
        return FieldNodeStatusEnum.NO_NEED_NODE;
    }

    private static void getBaseFieldNodes(TreeNode parentNode, TreeNode node, EntityType entityType, String preFixNumber, String preFixName, int currentLevel, int maxLevel, HashSet<String> filterField, Class<?> fieldClassType, String basePropType, String searchText, boolean isNeedFilterOrg) {
        block10: for (IDataEntityProperty property : entityType.getFields().values()) {
            FieldNodeStatusEnum nodeStatus;
            if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)property.getAlias()) || property.getParent() instanceof JsonSubEntryType) continue;
            String number = EntityTreeUtil.getFullString(node.getId(), property.getName());
            String name = property.getDisplayName().getLocaleValue();
            String longName = EntityTreeUtil.getFullString(preFixName, name);
            TreeNode treeNode = new TreeNode(node.getId(), number, name);
            treeNode.setLongText(longName);
            if (property instanceof BasedataProp && !(property instanceof FlexProp)) {
                nodeStatus = EntityTreeUtil.getBaseNodeStatus(currentLevel == maxLevel, property, searchText, filterField, fieldClassType, basePropType, isNeedFilterOrg);
                switch (nodeStatus) {
                    case NEED_NODE: {
                        treeNode.setType(noDeleteNodeType);
                        break;
                    }
                    case NO_NEED_NODE: {
                        continue block10;
                    }
                    case DISABLED_NODE: {
                        treeNode.setDisabled(true);
                        treeNode.setColor("#000000");
                    }
                }
                if (!kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)searchText) && !name.contains(searchText)) {
                    treeNode.setType(null);
                }
                node.addChild(treeNode);
                if (currentLevel >= maxLevel) continue;
                EntityTreeUtil.getBaseFieldNodes(node, treeNode, (EntityType)EntityMetadataCache.getDataEntityType((String)((BasedataProp)property).getBaseEntityId()), number, longName, currentLevel + 1, maxLevel, filterField, fieldClassType, basePropType, searchText, isNeedFilterOrg);
                continue;
            }
            nodeStatus = EntityTreeUtil.getNodeStatus(property, searchText, filterField, fieldClassType, isNeedFilterOrg, currentLevel);
            switch (nodeStatus) {
                case NEED_NODE: {
                    treeNode.setType(noDeleteNodeType);
                    break;
                }
                case NO_NEED_NODE: {
                    continue block10;
                }
                case DISABLED_NODE: {
                    treeNode.setDisabled(true);
                    treeNode.setColor("#000000");
                }
            }
            node.addChild(treeNode);
        }
        if (node.getChildren() == null || node.getChildren().isEmpty()) {
            if (!noDeleteNodeType.equals(node.getType())) {
                parentNode.deleteChildNode(node.getId());
            } else {
                node.setChildren(null);
            }
        }
    }

    public static HashSet<String> getEntryNumberSet(String entryNumber, Map<String, EntityType> allEntities) {
        HashSet<String> needentryNumber = new HashSet<String>(2);
        if (entryNumber != null) {
            EntityType filterEntityType = allEntities.get(entryNumber);
            if (filterEntityType instanceof SubEntryType) {
                needentryNumber.add(filterEntityType.getName());
                needentryNumber.add(filterEntityType.getParent().getName());
            } else if (filterEntityType instanceof EntryType) {
                needentryNumber.add(filterEntityType.getName());
            }
        }
        return needentryNumber;
    }

    private static boolean notCrossEntry(MainEntityType mainEntityType, EntityType entityType, String entryNumber) {
        EntityType filterEntityType = (EntityType)mainEntityType.getAllEntities().get(entryNumber);
        if (filterEntityType instanceof SubEntryType) {
            if (entityType instanceof SubEntryType) {
                return entityType.getName().equals(entryNumber);
            }
            if (entityType instanceof EntryType) {
                return entityType.getName().equals(filterEntityType.getParent().getName());
            }
        } else {
            if (filterEntityType instanceof EntryType) {
                if (entityType instanceof SubEntryType) {
                    return entityType.getParent().getName().equals(entryNumber);
                }
                return entityType.getName().equals(entryNumber);
            }
            return false;
        }
        return false;
    }

    private static List<String> generateEntryNums(Map<String, EntityType> allEntities, String entryNumber) {
        ArrayList<String> result = new ArrayList<String>();
        for (EntityType entityType : allEntities.values()) {
            if (!entityType.getName().equals(entryNumber)) continue;
        }
        return result;
    }

    public static String getFullString(String prefix, String str) {
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)prefix)) {
            return str;
        }
        return prefix + '.' + str;
    }

    public static EntityFieldTreeResult getEntityFieldNodes(EntityFieldTreeOption option) {
        EntityFieldNodeHandle handle = new EntityFieldNodeHandle(option);
        return handle.getNodes();
    }

    public static EntityFieldTreeResult getEntitySimNodes(EntityFieldTreeOption option) {
        EntityFieldNodeHandle handle = new EntityFieldNodeHandle(option);
        return handle.getSimNodes();
    }

    public static EntityFieldTreeResult getEntitySimLevelNodes(EntityFieldTreeOption option) {
        EntityFieldNodeHandle handle = new EntityFieldNodeHandle(option);
        return handle.getSimLevelNodes();
    }

    public static List<String> buildEntryTree(List<TreeNode> fieldNodes) {
        TreeNode root = null;
        for (TreeNode node : fieldNodes) {
            if (!kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)node.getParentid())) continue;
            root = node;
        }
        ArrayList<String> idLists = new ArrayList<String>();
        if (root != null) {
            List list = root.getChildren();
            for (int i = list.size() - 1; i >= 0; --i) {
                if (((TreeNode)list.get(i)).getId().contains("Dapfield_firstdate") || ((TreeNode)list.get(i)).getId().contains("Dapfield_lastdate") || ((TreeNode)list.get(i)).getId().contains("Dapfield_newdate") || ((TreeNode)list.get(i)).getId().contains("name$version")) continue;
                idLists.add(((TreeNode)list.get(i)).getId());
            }
        }
        return idLists;
    }

    public static TreeNode buildBillTree(List<TreeNode> fieldNodes) {
        TreeNode root = null;
        HashMap<String, TreeNode> nodeMap = new HashMap<String, TreeNode>();
        for (TreeNode node : fieldNodes) {
            if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)node.getParentid())) {
                root = node;
            }
            if (!kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)node.getId())) continue;
            nodeMap.put(node.getId(), node);
        }
        for (TreeNode node : fieldNodes) {
            TreeNode parentNode = root;
            if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)node.getParentid()) && nodeMap.containsKey(node.getParentid())) {
                parentNode = (TreeNode)nodeMap.get(node.getParentid());
            }
            if (parentNode == null || node.getId() == parentNode.getId()) continue;
            parentNode.addChild(node);
        }
        if (root == null) {
            root = new TreeNode("", "0", ResManager.loadKDString((String)"\u5355\u636e\u5b57\u6bb5\u5217\u8868", (String)"EntityTreeUtil_0", (String)"fi-ai-common", (Object[])new Object[0]));
        }
        root.setIsOpened(true);
        return root;
    }
}

