/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class EventVchTemplateUtil {
    public static List<Long> getTemplate(Long orgId, String billId) {
        DynamicObject billDyn = QueryServiceHelper.queryOne((String)"bos_entityobject", (String)"bizappid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)billId)});
        Set<Long> allAssignSourceOrgs = EventVchTemplateUtil.getAllAssignSourceOrgid(orgId, billDyn.getString("bizappid"));
        QFilter sourceBillIdF = new QFilter("fsourcebill", "=", (Object)billId);
        DynamicObject dapConfig = BusinessDataServiceHelper.loadSingleFromCache((String)"ai_dapconfig", (String)"parentbill.id", (QFilter[])new QFilter("billentity.id", "=", (Object)billId).toArray());
        if (dapConfig != null && StringUtils.isNotEmpty((CharSequence)dapConfig.getString("parentbill.id"))) {
            sourceBillIdF.or(new QFilter("fsourcebill", "=", (Object)dapConfig.getString("parentbill.id")));
        }
        QFilter orgF = new QFilter("createorg", "in", allAssignSourceOrgs);
        DynamicObjectCollection vchTemplateIds = QueryServiceHelper.query((String)"ai_vchtemplate", (String)"id", (QFilter[])new QFilter[]{sourceBillIdF, orgF});
        HashSet<Long> templateIds = new HashSet<Long>();
        for (DynamicObject dyn : vchTemplateIds) {
            templateIds.add(dyn.getLong("id"));
        }
        Collection<Long> list = EventVchTemplateUtil.getBaseAssign(orgId);
        if (list != null) {
            templateIds.addAll(list);
        }
        return new ArrayList<Long>(templateIds);
    }

    private static Collection<Long> getBaseAssign(Long orgId) {
        QFilter filter = BaseDataServiceHelper.getBaseDataIdInFilter((String)"ai_vchtemplate", (Long)orgId);
        Collection list = (Collection)filter.getValue();
        return list;
    }

    public static List<Long> getTemplateByBills(Long orgId, List<String> billIds) {
        DynamicObjectCollection bills = QueryServiceHelper.query((String)"bos_entityobject", (String)"bizappid,id", (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)});
        HashMap<String, ArrayList<String>> appBillMap = new HashMap<String, ArrayList<String>>();
        for (Object bill : bills) {
            String string = bill.getString("id");
            String appid = bill.getString("bizappid");
            ArrayList<String> list = (ArrayList<String>)appBillMap.get(appid);
            if (list == null) {
                list = new ArrayList<String>();
                list.add(string);
                appBillMap.put(appid, list);
                continue;
            }
            list.add(string);
        }
        HashSet<Long> templateIds = new HashSet<Long>();
        for (Map.Entry entry : appBillMap.entrySet()) {
            Set<Long> allAssignSourceOrgs = EventVchTemplateUtil.getAllAssignSourceOrgid(orgId, (String)entry.getKey());
            QFilter eventClassF = new QFilter("fsourcebill", "in", entry.getValue());
            QFilter orgF = new QFilter("createorg", "in", allAssignSourceOrgs);
            DynamicObjectCollection vchTemplateIds = QueryServiceHelper.query((String)"ai_vchtemplate", (String)"id", (QFilter[])new QFilter[]{eventClassF, orgF});
            for (DynamicObject dyn : vchTemplateIds) {
                templateIds.add(dyn.getLong("id"));
            }
        }
        Collection<Long> list = EventVchTemplateUtil.getBaseAssign(orgId);
        if (list != null) {
            templateIds.addAll(list);
        }
        return new ArrayList<Long>(templateIds);
    }

    public static List<Long> getTemplate(Long orgId, Long eventClass) {
        DynamicObject eventClassDyn = QueryServiceHelper.queryOne((String)"ai_eventclass", (String)"group", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)eventClass)});
        Set<Long> allAssignSourceOrgs = EventVchTemplateUtil.getAllAssignSourceOrgid(orgId, eventClassDyn.getLong("group"));
        QFilter eventClassF = new QFilter("eventclass", "=", (Object)eventClass);
        QFilter orgF = new QFilter("createorg", "in", allAssignSourceOrgs);
        DynamicObjectCollection vchTemplateIds = QueryServiceHelper.query((String)"ai_vchtemplate", (String)"id", (QFilter[])new QFilter[]{eventClassF, orgF});
        ArrayList<Long> templateIds = new ArrayList<Long>();
        for (DynamicObject dyn : vchTemplateIds) {
            templateIds.add(dyn.getLong("id"));
        }
        Collection<Long> list = EventVchTemplateUtil.getBaseAssign(orgId);
        if (list != null) {
            templateIds.addAll(list);
        }
        return new ArrayList<Long>(templateIds);
    }

    public static List<Long> getTemplate(Long orgId, List<Long> eventClasses) {
        DynamicObjectCollection eventClassDyns = QueryServiceHelper.query((String)"ai_eventclass", (String)"group,id", (QFilter[])new QFilter[]{new QFilter("id", "in", eventClasses)});
        HashMap<Long, ArrayList<Long>> eventGroupClass = new HashMap<Long, ArrayList<Long>>();
        for (Object eventClass : eventClassDyns) {
            long l = eventClass.getLong("id");
            long evevtGroupId = eventClass.getLong("group");
            ArrayList<Long> list = (ArrayList<Long>)eventGroupClass.get(evevtGroupId);
            if (list == null) {
                list = new ArrayList<Long>();
                list.add(l);
                eventGroupClass.put(evevtGroupId, list);
                continue;
            }
            list.add(l);
        }
        HashSet<Long> templateIds = new HashSet<Long>();
        for (Map.Entry entry : eventGroupClass.entrySet()) {
            Set<Long> allAssignSourceOrgs = EventVchTemplateUtil.getAllAssignSourceOrgid(orgId, (Long)entry.getKey());
            QFilter eventClassF = new QFilter("eventclass", "in", entry.getValue());
            QFilter orgF = new QFilter("createorg", "in", allAssignSourceOrgs);
            DynamicObjectCollection vchTemplateIds = QueryServiceHelper.query((String)"ai_vchtemplate", (String)"id", (QFilter[])new QFilter[]{eventClassF, orgF});
            for (DynamicObject dyn : vchTemplateIds) {
                templateIds.add(dyn.getLong("id"));
            }
        }
        Collection<Long> list = EventVchTemplateUtil.getBaseAssign(orgId);
        if (list != null) {
            templateIds.addAll(list);
        }
        return new ArrayList<Long>(templateIds);
    }

    public static Set<Long> getAllAssignSourceOrgid(Long orgId, Long eventGroupId) {
        HashSet<Long> orgList = new HashSet<Long>();
        QFilter eventGroupF = new QFilter("eventgroup", "=", (Object)eventGroupId);
        QFilter useOrgF = new QFilter("useorg", "=", (Object)orgId);
        orgList.add(orgId);
        DynamicObject dyn = QueryServiceHelper.queryOne((String)"ai_eventgroup_assign", (String)"createorg", (QFilter[])new QFilter[]{eventGroupF, useOrgF});
        if (dyn != null) {
            orgList.add(dyn.getLong("createorg"));
            orgList.addAll(EventVchTemplateUtil.getAllAssignSourceOrgid((Long)dyn.getLong("createorg"), eventGroupId));
        }
        return orgList;
    }

    public static Set<Long> getAllAssignSourceOrgid(Long orgId, String appId) {
        HashSet<Long> orgList = new HashSet<Long>();
        QFilter eventGroupF = new QFilter("app", "=", (Object)appId);
        QFilter useOrgF = new QFilter("useorg", "=", (Object)orgId);
        orgList.add(orgId);
        DynamicObject dyn = QueryServiceHelper.queryOne((String)"ai_eventgroup_assign", (String)"createorg", (QFilter[])new QFilter[]{eventGroupF, useOrgF});
        if (dyn != null) {
            orgList.add(dyn.getLong("createorg"));
            orgList.addAll(EventVchTemplateUtil.getAllAssignSourceOrgid((Long)dyn.getLong("createorg"), appId));
        }
        return orgList;
    }
}

