/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.util;

import kd.bos.cache.ThreadCache;
import kd.bos.ext.fi.ai.dap.cache.CacheKeyPrefix;
import kd.bos.ext.fi.ai.dap.cache.DapLocalCache4H;
import kd.bos.ext.fi.ai.dap.cache.LocalCacheKey;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.Expr;
import kd.bos.formula.excel.ExprUtil;

public class FormulaEngineUtil {
    public static final String FORMULAENGINE_PARSEFORMULA = "FormulaEngine.parseFormula:";

    public static String[] extractVariablesFromCache(String formula, boolean flag) {
        int length;
        if (!flag) {
            return FormulaEngine.extractVariables((String)formula);
        }
        LocalCacheKey cacheKey = LocalCacheKey.getCacheKey((CacheKeyPrefix)CacheKeyPrefix.VCHTEMPALTE, (Object[])new Object[]{"UtilExtractVariables", formula});
        String[] amtVars = (String[])DapLocalCache4H.get((LocalCacheKey)cacheKey, String[].class);
        if (null != amtVars && (length = amtVars.length) > 0) {
            String[] copyVariables = new String[length];
            System.arraycopy(amtVars, 0, copyVariables, 0, length);
            return copyVariables;
        }
        amtVars = FormulaEngine.extractVariables((String)formula);
        DapLocalCache4H.put((LocalCacheKey)cacheKey, (Object)amtVars);
        return amtVars;
    }

    public static Expr parseFormulaFromCache(String formula, boolean flag) {
        if (!flag) {
            return FormulaEngineUtil.getExpr(formula);
        }
        LocalCacheKey cacheKey = LocalCacheKey.getCacheKey((CacheKeyPrefix)CacheKeyPrefix.VCHTEMPALTE, (Object[])new Object[]{"UtilParseFormula", formula});
        Expr expr = (Expr)DapLocalCache4H.get((LocalCacheKey)cacheKey, Expr.class);
        if (null != expr) {
            return ExprUtil.cloneExpr(expr);
        }
        expr = FormulaEngine.parseFormula((String)formula);
        DapLocalCache4H.put((LocalCacheKey)cacheKey, (Object)expr);
        return expr;
    }

    private static Expr getExpr(String formula) {
        Object c = ThreadCache.get((Object)(FORMULAENGINE_PARSEFORMULA + formula));
        if (c != null) {
            return (Expr)c;
        }
        try {
            Expr ec = FormulaEngine.parseFormula((String)formula);
            ThreadCache.put((Object)(FORMULAENGINE_PARSEFORMULA + formula), (Object)ec);
            return ec;
        }
        catch (Throwable exp) {
            ThreadCache.put((Object)(FORMULAENGINE_PARSEFORMULA + formula), (Object)FormulaEngine.parseFormula((String)"''"));
            throw exp;
        }
    }
}

