/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.util;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import kd.bos.dataentity.resource.ResManager;
import org.apache.commons.io.FilenameUtils;

public class IOUtils {
    private static final int ByteBuffer_Size = 4096;
    private static final Charset Default_Charset = StandardCharsets.UTF_8;

    public static void writeInt(OutputStream out, int len) throws IOException {
        byte[] lengthBytes = new byte[]{(byte)(len >>> 24 & 0xFF), (byte)(len >>> 16 & 0xFF), (byte)(len >>> 8 & 0xFF), (byte)(len >>> 0 & 0xFF)};
        out.write(lengthBytes);
    }

    public static void write(byte[] data, OutputStream output) throws IOException {
        if (data != null) {
            output.write(data);
            output.flush();
        }
    }

    public static String readFully(InputStream inputStream, Charset charsetName) {
        StringWriter stringWriter = new StringWriter();
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader(inputStream, charsetName);
            IOUtils.copyLarge(inputStreamReader, stringWriter);
            String string = stringWriter.toString();
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u8bfb\u53d6\u5185\u5bb9\u5931\u8d25, \u539f\u56e0\uff1a\u201c%s\u201d\u3002", (String)"IOUtils_0", (String)"fi-ai-common", (Object[])new Object[0]), e.getMessage()), e);
        }
        finally {
            IOUtils.closeCloseable(stringWriter);
            IOUtils.closeCloseable(inputStreamReader);
        }
    }

    public static String readFully(InputStream inputStream) {
        return IOUtils.readFully(inputStream, Default_Charset);
    }

    public static long copyLarge(InputStream input, OutputStream output) throws IOException {
        int length;
        byte[] buffer = new byte[4096];
        long count = 0L;
        while (-1 != (length = input.read(buffer))) {
            output.write(buffer, 0, length);
            count += (long)length;
        }
        return count;
    }

    public static long copyLarge(Reader input, Writer output) throws IOException {
        int length;
        char[] buffer = new char[4096];
        long count = 0L;
        while (-1 != (length = input.read(buffer))) {
            output.write(buffer, 0, length);
            count += (long)length;
        }
        return count;
    }

    public static void closeCloseable(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static byte[] readFileAsByteArray(String fileName) {
        byte[] byArray;
        ByteArrayOutputStream baos = null;
        FileInputStream is = null;
        try {
            baos = new ByteArrayOutputStream();
            is = new FileInputStream(FilenameUtils.getFullPath((String)fileName) + FilenameUtils.getName((String)fileName));
            IOUtils.copyLarge(is, baos);
            byArray = baos.toByteArray();
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeCloseable(is);
                IOUtils.closeCloseable(baos);
                throw throwable;
            }
        }
        IOUtils.closeCloseable(is);
        IOUtils.closeCloseable(baos);
        return byArray;
    }

    public static void writeToFile(byte[] data, String fileName) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(new File(FilenameUtils.getFullPath((String)fileName), FilenameUtils.getName((String)fileName)));
            fos.write(data);
            fos.flush();
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeCloseable(fos);
                throw throwable;
            }
        }
        IOUtils.closeCloseable(fos);
    }

    public static long inputStreamToFile(InputStream srcInputStream, File outputFile) throws IOException {
        if (srcInputStream == null || outputFile == null) {
            throw new IllegalArgumentException("Source InputStream or Temp Output File cannot be null!");
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(outputFile);){
            long l = IOUtils.copyLarge(srcInputStream, fileOutputStream);
            return l;
        }
    }
}

