/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class PresetCashItemUtil {
    public static final String ROOTKEY = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";
    public static final String MAINITEM = "mainitem";
    public static final String SUPPITEM = "suppitem";
    public static final String FILTERKEY = "filterkey";
    public static final String PRESETIDS = "presetids";
    public static final String CREATEORG = "createorg";
    public static final String ISLEAF = "isleaf";
    public static final String ID = "id";
    public static final String CASHFLOWITEM_ENTITY = "gl_cashflowitem";
    public static final String ACCOUNT_ENTITY = "bd_accountview";
    public static final String ASSIST_ENTRY = "checkitementry";
    public static final String ASSIST_ITEM = "asstactitem";
    public static final String LONGNUMBER = "longnumber";
    public static final String ASSGRP = "assgrp";
    public static final String MASTER_ITEM = "1";
    public static final String SCHEDULE_ITEM = "2";
    public static final String SUPPLEMENTARY_ITEM = "3";

    private PresetCashItemUtil() {
    }

    public static List<Long> getAllSuperiorOrgIds(Object useorgId, boolean isIncludeCurOrg) {
        long orgid = Long.parseLong(String.valueOf(useorgId));
        HashSet<Long> ids = new HashSet<Long>(PresetCashItemUtil.getAllSuperiorOrgIdsOrderByLevel(orgid));
        if (isIncludeCurOrg) {
            ids.add(orgid);
        } else if (ids.contains(orgid)) {
            ids.removeIf(id -> id == orgid);
        }
        return new ArrayList<Long>(ids);
    }

    private static List<Long> getAllSuperiorOrgIdsOrderByLevel(long orgid) {
        ArrayList<Long> ids = new ArrayList<Long>();
        if (orgid == 0L) {
            return ids;
        }
        QFilter f2 = new QFilter("view.number", "=", (Object)"10");
        QFilter f3 = new QFilter("org", "=", (Object)orgid);
        String longNumber = null;
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)PresetCashItemUtil.class.getName(), (String)"bos_org_structure", (String)LONGNUMBER, (QFilter[])new QFilter[]{f2, f3}, null);){
            if (ds.hasNext()) {
                Row row = ds.next();
                longNumber = row.getString(LONGNUMBER);
            }
        }
        if (longNumber == null || StringUtils.isBlank(longNumber) || longNumber.indexOf("!") == 0) {
            return ids;
        }
        String[] numbers = StringUtils.substringBeforeLast((String)longNumber, (String)"!").split("!");
        QFilter numberFilter = new QFilter("org.number", "in", (Object)numbers);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)PresetCashItemUtil.class.getName(), (String)"bos_org_structure", (String)"org", (QFilter[])new QFilter[]{f2, numberFilter}, (String)"level");){
            while (ds.hasNext()) {
                Row row = ds.next();
                ids.add(row.getLong("org"));
            }
        }
        return ids;
    }
}

