/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.util;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ExceptionUtils;
import kd.fi.v2.fah.constant.FAHCommonConstant;

public class VchTemplateUtils {
    private static final String querySql = "select fid,fnumber from t_ai_vchtemplate where fnumber in ('AP001','AP002','AP003','AP004','AP005','AP006','AP007','AP008','AR001','AR002','AR003','AR004','AR005','AR006','AR007','AR008','CH001','CH002','CH003','CH004','CH005','CH006','CH007','CH008','CH009','CH010','CH011','CH012','CH013','CH014','CH015','CH016','CH017','CH018','CH019','CH020','CH021','CH022','CN001','CN002','CN003','CN004','CN005','CN006','CN007','CN008','CN009','CN010','CN011','CN012','CN013','FYHS001','FYHS002','FYHS003','FYHS004','FYHS005','FYHS006','FYHS007','FYHS008','GDZC001','GDZC002','GDZC003''GDZC004','GDZC005','GDZC006','GDZC007','GDZC008','PJ001')";
    private static final String updateSql = "update t_ai_vchtemplate set fid = ? where fnumber = ?";
    private static final String insertSql = "insert into T_AI_VCHTEMPLATE_BAKID(FID,FNEWID) VALUES(?,?)";
    private static final String update_temreport_sql = "update t_ai_newbuildreporthead set fvchtemplateid = ? where fopdate >= ? and fvchtemplateid = ?";
    private static final Log logger = LogFactory.getLog(VchTemplateUtils.class);

    public static Boolean exceteChangeData(Boolean isUpdate) {
        Boolean result = true;
        HashMap<String, Long> oldNumberAndIds = new HashMap<String, Long>(68);
        try (DataSet queryDataSet = DB.queryDataSet((String)"kd.fi.ai.formplugin.AiVchTemplateIdChange", (DBRoute)FAHCommonConstant.AI, (String)querySql);){
            for (Row row : queryDataSet) {
                oldNumberAndIds.put(row.getString("fnumber"), row.getLong("fid"));
            }
        }
        Map<String, Long> newNumberAndIds = VchTemplateUtils.getTemplateNumberAndNewIds();
        HashSet notSameNumber = new HashSet();
        oldNumberAndIds.entrySet().forEach(data -> {
            Long oId = (Long)newNumberAndIds.get(data.getKey());
            if (oId != null && !oId.equals(data.getValue())) {
                notSameNumber.add(data.getKey());
            }
        });
        if (notSameNumber.isEmpty()) {
            return result;
        }
        ArrayList<Object[]> params_update = new ArrayList<Object[]>(notSameNumber.size());
        ArrayList<Object[]> params_insert = new ArrayList<Object[]>(notSameNumber.size());
        for (String number : notSameNumber) {
            params_update.add(new Object[]{newNumberAndIds.get(number), number});
            params_insert.add(new Object[]{oldNumberAndIds.get(number), newNumberAndIds.get(number)});
        }
        ArrayList<Object[]> params_updateTemReport = new ArrayList<Object[]>();
        if (isUpdate.booleanValue()) {
            Calendar calender = Calendar.getInstance();
            calender.add(2, -1);
            Date datatime = new Date(calender.getTimeInMillis());
            for (String number : notSameNumber) {
                params_updateTemReport.add(new Object[]{newNumberAndIds.get(number), datatime, oldNumberAndIds.get(number)});
            }
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                DB.executeBatch((DBRoute)FAHCommonConstant.AI, (String)updateSql, params_update);
                DB.executeBatch((DBRoute)FAHCommonConstant.AI, (String)insertSql, params_insert);
            }
            catch (Exception e) {
                h.markRollback();
                result = false;
                logger.info("--FAH--exceteChangeData:{}", (Object)ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
        }
        if (isUpdate.booleanValue()) {
            h = TX.requiresNew();
            var9_13 = null;
            try {
                try {
                    if (isUpdate.booleanValue()) {
                        DB.executeBatch((DBRoute)DBRoute.of((String)"log"), (String)update_temreport_sql, params_updateTemReport);
                    }
                }
                catch (Exception e) {
                    h.markRollback();
                    result = false;
                    logger.info("--FAH--exceteChangeData:{}", (Object)ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                }
            }
            catch (Throwable throwable) {
                var9_13 = throwable;
                throw throwable;
            }
            finally {
                if (h != null) {
                    if (var9_13 != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable) {
                            var9_13.addSuppressed(throwable);
                        }
                    } else {
                        h.close();
                    }
                }
            }
        }
        return result;
    }

    private static Map<String, Long> getTemplateNumberAndNewIds() {
        HashMap<String, Long> result = new HashMap<String, Long>(68);
        result.put("AP001", 2043649981046738944L);
        result.put("AP002", 2043649982808346624L);
        result.put("AP003", 2043649960561758208L);
        result.put("AP004", 2043649900851646464L);
        result.put("AP005", 2043649934196363264L);
        result.put("AP006", 2043649952181538816L);
        result.put("AP007", 2043649970913300480L);
        result.put("AP008", 2043649919054925824L);
        result.put("AR001", 1539110930695093248L);
        result.put("AR002", 1540492552518511616L);
        result.put("AR003", 2043649964940611584L);
        result.put("AR004", 2043649966140182528L);
        result.put("AR005", 2043649967155204096L);
        result.put("AR006", 2043649915179388928L);
        result.put("AR007", 2043649922880131072L);
        result.put("AR008", 2043649968010842112L);
        result.put("CH001", 2043649951166517248L);
        result.put("CH002", 2043649904869789696L);
        result.put("CH003", 2043649954010255360L);
        result.put("CH004", 2043649954958168064L);
        result.put("CH005", 2043649961836826624L);
        result.put("CH006", 2043649190932135936L);
        result.put("CH007", 2043649955864137728L);
        result.put("CH008", 2043649956845604864L);
        result.put("CH009", 2043649976038739968L);
        result.put("CH010", 2043649977959731200L);
        result.put("CH011", 2043649958590435328L);
        result.put("CH012", 2043649945579704320L);
        result.put("CH013", 2043649953154617344L);
        result.put("CH014", 2043649950067609600L);
        result.put("CH015", 2043649963061563392L);
        result.put("CH016", 2043649985375260672L);
        result.put("CH017", 2043649896623788032L);
        result.put("CH018", 2043649941083410432L);
        result.put("CH019", 2043649943826485248L);
        result.put("CH020", 2043649984368627712L);
        result.put("CH021", 2043649982036594688L);
        result.put("CH022", 2043649902999130112L);
        result.put("CN001", 2043649932971626496L);
        result.put("CN002", 2043649931377790976L);
        result.put("CN003", 2043649970158325760L);
        result.put("CN004", 2043649972658130944L);
        result.put("CN005", 2043649974293909504L);
        result.put("CN006", 2043649959714508800L);
        result.put("CN007", 2043649968950366208L);
        result.put("CN008", 2043649925740646400L);
        result.put("CN009", 2043649983613652992L);
        result.put("CN010", 2043649977053761536L);
        result.put("CN011", 2043649948230504448L);
        result.put("CN012", 2043649971802492928L);
        result.put("CN013", 2043649975199879168L);
        result.put("FYHS001", 2043649949153251328L);
        result.put("FYHS002", 2043649929532297216L);
        result.put("FYHS003", 2012435549620999168L);
        result.put("FYHS004", 2043649939917393920L);
        result.put("FYHS005", 2043649986860044288L);
        result.put("FYHS006", 2043649942484307968L);
        result.put("FYHS007", 2012435551265166336L);
        result.put("FYHS008", 2043649980132380672L);
        result.put("GDZC001", 2043649978916032512L);
        result.put("GDZC002", 2043649916932608000L);
        result.put("GDZC003", 2043649916932606800L);
        result.put("GDZC004", 2043649916932606900L);
        result.put("GDZC005", 2043649907101159424L);
        result.put("GDZC006", 2043649909215088640L);
        result.put("GDZC007", 2043649935244939264L);
        result.put("GDZC008", 2043649928332726272L);
        result.put("PJ001", 2043649936528396288L);
        return result;
    }
}

